/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.Node;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.impl.AbstractParse;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class FileParse
extends AbstractParse {
    @Override
    public Node parse(Node node, Node parentNode, String resource) {
        FlowsNode flowNodes = BeanUtil.tranferBean(node, FlowsNode.class);
        return flowNodes;
    }

    @Override
    public void resolveChildrenNode(Node currentNode, Node childrenNode) {
        FlowsNode flowsNode = (FlowsNode)currentNode;
        FlowsNode childrenFlowsNode = (FlowsNode)childrenNode;
        for (FlowNode flowNode : childrenFlowsNode.getFlowNodes()) {
            if (flowNode.getVersion() == null) {
                flowNode.setVersion("0");
            }
            FlowNode flowNodeResult = flowsNode.getFlow(flowNode.getName(), flowNode.getVersion());
            if (flowNode.getEnable().booleanValue()) {
                FlowNode enableFlow = flowsNode.getEnableFlow(flowNode.getName());
                if (enableFlow != null && currentNode.getResource().equals(enableFlow.getResource())) {
                    throw new BizException("[flow][" + flowNode.getName() + "] \u5df2\u7ecf\u8d85\u8fc7\u4e24\u4e2a\u4e3a\u6fc0\u6d3b\u7684\u6d41\u7a0b\uff0c\u68c0\u67e5\u6587\u4ef6[" + flowNode.getResource() + "]");
                }
                flowsNode.addEnableFlow(flowNode.getName(), flowNode);
            }
            if (flowNodeResult != null && !flowNodeResult.getResource().equals(flowNode.getResource())) {
                throw new BizException("[flow][" + flowNode.getName() + "][" + flowNodeResult.getVersion() + "] \u5df2\u7ecf\u5728\u6587\u4ef6[" + flowNodeResult.getResource() + "]\u5b58\u5728\uff0c\u68c0\u67e5\u6587\u4ef6[" + flowNode.getResource() + "]");
            }
            flowsNode.addFlow(flowNode.getName(), flowNode);
        }
    }

    @Override
    public void afterParse(Node currentNode) {
        FlowsNode flowsNode = (FlowsNode)currentNode;
        List noVersionList = flowsNode.getFlowNodes().stream().filter(flowNode -> flowNode.getVersion().equals("0")).collect(Collectors.toList());
        for (FlowNode flowNode2 : noVersionList) {
            FlowNode enableFlow = flowsNode.getEnableFlow(flowNode2.getName());
            if (enableFlow != null) continue;
            flowNode2.setEnable(true);
            flowsNode.addEnableFlow(flowNode2.getName(), flowNode2);
        }
    }

    @Override
    public String getParseName() {
        return "file";
    }
}

