/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ImportNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.Node;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.IParseEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.XmlParseNote;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.impl.AbstractParse;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImportParse
extends AbstractParse {
    private Logger logger = LoggerFactory.getLogger(ImportParse.class);
    @Resource
    private IParseEngine parseEngine;

    @Override
    public Node parse(Node node, Node parentNode, String resource) {
        ImportNode importNode = BeanUtil.tranferBean(node, ImportNode.class);
        importNode.setFileName(node.getAttr("resource"));
        return importNode;
    }

    @Override
    public void afterParse(Node currentNode) {
        ImportNode importNode = (ImportNode)currentNode;
        this.logger.info("\u6587\u4ef6" + importNode.getResource() + "\u89e3\u6790<import resource=" + importNode.getFileName() + ">");
        if (importNode.getResource().equals(importNode.getFileName())) {
            throw new BizException("\u81ea\u5df1\u4e0d\u80fd\u5bfc\u5165\u81ea\u5df1" + importNode.getFileName());
        }
        XmlParseNote xmlParseNote = new XmlParseNote(importNode.getFileName(), this.parseEngine);
        FlowsNode flowsNode = (FlowsNode)xmlParseNote.pareNote();
        for (FlowNode flowNode : flowsNode.getFlowNodes()) {
            importNode.addFlow(flowNode.getName(), flowNode);
        }
    }

    @Override
    public void checkNode(Node currentNode) {
        super.checkNode(currentNode);
    }

    @Override
    public String getParseName() {
        return "import";
    }
}

