/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.refresh;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.refresh.PublishMQDesc;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"springBeanUtil"})
public class PublishPostBean
implements BeanPostProcessor {
    private Logger logger = LoggerFactory.getLogger(PublishPostBean.class);
    @Autowired
    private TopicRegistryVo topicRegistryVo;
    @Autowired
    private MessageRegistryVo registryVo;
    @Autowired
    private ICommonsMqService commonsMqService;
    @Value(value="${server.port:0}")
    private int port;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IMessageProcessor) {
            PublishMQDesc mqDesc = bean.getClass().getAnnotation(PublishMQDesc.class);
            if (null == mqDesc) {
                return bean;
            }
            String topic = mqDesc.topic();
            String ipPort = "";
            try {
                ipPort = String.format("%s_%d", InetAddress.getLocalHost().toString(), this.port);
                StringBuilder sb = new StringBuilder();
                for (char item : ipPort.toCharArray()) {
                    if (item == '_') {
                        sb.append(item);
                        continue;
                    }
                    if (item >= '0' && item <= '9') {
                        sb.append(item);
                        continue;
                    }
                    if (item >= 'A' && item <= 'Z') {
                        sb.append(item);
                        continue;
                    }
                    if (item >= 'a' && item <= 'z') {
                        sb.append(item);
                        continue;
                    }
                    sb.append("_");
                }
                ipPort = sb.toString();
            }
            catch (UnknownHostException e) {
                this.logger.warn("\u89e3\u6790\u672c\u673a\u57df\u540d\u5730\u5740\u5f02\u5e38\uff1a", (Throwable)e);
            }
            String consumer = CommonsMqHelper.parseConsumer((MessageRegistryVo)this.registryVo, (String)ipPort, (String)ipPort);
            String tag = mqDesc.tag();
            String msgType = mqDesc.msgType();
            if (StringUtils.isBlank((CharSequence)topic)) {
                topic = "single".equals(msgType) ? this.topicRegistryVo.getSingleTopic() : this.topicRegistryVo.getPublishTopic();
            }
            CommonsMqHelper.addProcessor((String)topic, (String)consumer, (String)tag, (String)msgType, (IMessageProcessor)((IMessageProcessor)bean));
            Set consumers = CommonsMqHelper.processMap.keySet();
            if (!consumers.isEmpty()) {
                consumers.forEach(consumerx -> {
                    this.logger.info("\u5f00\u59cb\u76d1\u542c\uff1aconsumer: {}, processors:{}", consumerx, (Object)JSON.toJSONString(CommonsMqHelper.processMap.get(consumerx)));
                    this.commonsMqService.start(consumerx);
                });
            }
        }
        return bean;
    }
}

