/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.trade.api.constants.BooleanEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryRedistributeReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.DadaDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.DeliveryAssignBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderDeliveryConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RecDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RedistributePartnerDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RejectDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.UnDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CheckDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryStatusBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ActionNodeComponent
@Service(value="deliveryFlowAction")
public class DeliveryFlowAction {
    private static Logger logger = LoggerFactory.getLogger(DeliveryFlowAction.class);
    @Resource
    private IDeliveryService deliveryService;
    @Resource
    private IDeliveryRouterService deliveryRouterService;
    @Resource
    OrderDeliveryDas orderDeliveryDas;
    @Resource
    OrderDas orderDas;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private ITradeItemService tradeItemService;

    public RecDeliveryStoreBo receive(RecDeliveryStoreBo recDeliveryStoreBo) {
        return this.deliveryService.receive(recDeliveryStoreBo);
    }

    public RedistributePartnerDeliveryStoreBo redistribute(RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo) {
        return this.deliveryService.redistribute(redistributePartnerDeliveryStoreBo);
    }

    public DadaDeliveryBo handleDadaNotify(DadaDeliveryBo dadaDeliveryNotifyBo) {
        return this.deliveryService.handleDadaNotify(dadaDeliveryNotifyBo);
    }

    public DadaDeliveryBo addDadaOrder(DadaDeliveryBo dadaDeliveryBo) {
        return this.deliveryService.addDadaOrder(dadaDeliveryBo);
    }

    public DadaDeliveryBo retryDadaAddOrder(DadaDeliveryBo dadaDeliveryBo) {
        return this.deliveryService.retryDadaAddOrder(dadaDeliveryBo);
    }

    public DadaDeliveryBo handleDadaMessage(DadaDeliveryBo dadaDeliveryMessageBo) {
        return this.deliveryService.handleDadaMessage(dadaDeliveryMessageBo);
    }

    public DadaDeliveryBo cancelDadaOrder(DadaDeliveryBo dadaDeliveryBo) {
        OrderDeliveryEo orderDeliveryEo = dadaDeliveryBo.getOrderDeliveryEo();
        if ("TRUE".equals((dadaDeliveryBo = this.deliveryService.cancelDadaOrder(dadaDeliveryBo)).getUnDelivery())) {
            dadaDeliveryBo.setFormalCancelResult("unDelivery");
        }
        return dadaDeliveryBo;
    }

    public RedistributePartnerDeliveryStoreBo isRecreateDadaOrder(RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo) {
        DeliveryRedistributeReqDto deliveryRedistributeReqDto = redistributePartnerDeliveryStoreBo.getDeliveryRedistributeReqDto();
        OrderDeliveryEo orderDeliveryEo = redistributePartnerDeliveryStoreBo.getOrderDeliveryEo();
        String partnerDeliveryStatus = orderDeliveryEo.getPartnerDeliveryStatus();
        if (deliveryRedistributeReqDto != null) {
            redistributePartnerDeliveryStoreBo.setRedistribute(ShippingChannelEnum.DADA.getCode() == deliveryRedistributeReqDto.getShippingCompanyCode().intValue() && StringUtils.isNotBlank((CharSequence)partnerDeliveryStatus) ? "TRUE" : "FALSE");
        } else {
            redistributePartnerDeliveryStoreBo.setRedistribute("FALSE");
        }
        return redistributePartnerDeliveryStoreBo;
    }

    public RedistributePartnerDeliveryStoreBo cancelSelfOrder(RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo) {
        OrderDeliveryEo orderDeliveryEo = redistributePartnerDeliveryStoreBo.getOrderDeliveryEo();
        if ("TRUE".equals(redistributePartnerDeliveryStoreBo.getUnDelivery())) {
            redistributePartnerDeliveryStoreBo.setCancelSelfOrderResult("unDelivery");
        } else {
            redistributePartnerDeliveryStoreBo.setCancelSelfOrderResult("success");
        }
        return redistributePartnerDeliveryStoreBo;
    }

    public RedistributePartnerDeliveryStoreBo createSelfOrder(RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo) {
        OrderDeliveryEo orderDeliveryEo = redistributePartnerDeliveryStoreBo.getOrderDeliveryEo();
        orderDeliveryEo.setShippingCompanyCode(String.valueOf(ShippingChannelEnum.SELF.getCode()));
        orderDeliveryEo.setShippingCompany(ShippingChannelEnum.SELF.getName());
        orderDeliveryEo.setExpressCode(DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + RandomStringUtils.random((int)4, (String)"0123456789"));
        return redistributePartnerDeliveryStoreBo;
    }

    public RedistributePartnerDeliveryStoreBo checkDeliveryShippingChannel(RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo) {
        OrderDeliveryEo orderDeliveryEo = redistributePartnerDeliveryStoreBo.getOrderDeliveryEo();
        DeliveryRedistributeReqDto deliveryRedistributeReqDto = redistributePartnerDeliveryStoreBo.getDeliveryRedistributeReqDto();
        Integer shippingCompanyCode = deliveryRedistributeReqDto.getShippingCompanyCode();
        redistributePartnerDeliveryStoreBo.setShippingCompanyCode(shippingCompanyCode);
        ShippingChannelEnum shippingChannelEnum = ShippingChannelEnum.getByCode((Integer)shippingCompanyCode);
        if (shippingChannelEnum != null) {
            orderDeliveryEo.setShippingCompanyCode(String.valueOf(shippingCompanyCode));
            orderDeliveryEo.setShippingCompany(shippingChannelEnum.getName());
        }
        return redistributePartnerDeliveryStoreBo;
    }

    public DadaDeliveryBo confirmDadaOrderAbnormal(DadaDeliveryBo dadaDeliveryBo) {
        return this.deliveryService.confirmDadaOrderAbnormal(dadaDeliveryBo);
    }

    public void sendMessageToInv(OrderDeliveryStatusBo orderDeliveryBo) {
        this.deliveryService.sendMessageToInv(orderDeliveryBo);
    }

    public RejectDeliveryStoreBo reject(RejectDeliveryStoreBo recDeliveryStoreBo) {
        return this.deliveryService.reject(recDeliveryStoreBo);
    }

    public UnDeliveryStoreBo unableDeliver(UnDeliveryStoreBo unDeliveryStoreBo) {
        return this.deliveryService.unableDeliver(unDeliveryStoreBo);
    }

    public UnDeliveryStoreBo checkDeliveryShippingCompany(UnDeliveryStoreBo unDeliveryStoreBo) {
        unDeliveryStoreBo.setShippingCompanyCode(unDeliveryStoreBo.getOrderDeliveryEo().getShippingCompanyCode());
        return unDeliveryStoreBo;
    }

    public RejectDeliveryStoreBo checkFirstReject(RejectDeliveryStoreBo orderDeliveryBo) {
        if (orderDeliveryBo.getFailCount() == 0) {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u8def\u7531\u3002", (Object)orderDeliveryBo.getDeliveryNo());
            orderDeliveryBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryBo.getPreWarehouseCode() + "-" + orderDeliveryBo.getPreWarehouseName() + "\uff09\u65e0\u6cd5\u53d1\u8d27\uff0c\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u8def\u7531\u3002");
            orderDeliveryBo.setIfFirstReject(BooleanEnum.TRUE.getCode());
        } else {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u975e\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\uff0c\u62d2\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\u6b21\u6570\uff1a{}\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002", (Object)orderDeliveryBo.getDeliveryNo(), (Object)orderDeliveryBo.getFailCount());
            orderDeliveryBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryBo.getPreWarehouseCode() + "-" + orderDeliveryBo.getPreWarehouseName() + "\uff09\u65e0\u6cd5\u53d1\u8d27\uff0c\u975e\u7b2c\u4e00\u6b21\u95e8\u5e97\u62d2\u6216\u8005\u65e0\u6cd5\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            orderDeliveryBo.setIfFirstReject(BooleanEnum.FALSE.getCode());
        }
        return orderDeliveryBo;
    }

    public UnDeliveryStoreBo checkFirstUnableDeliver(UnDeliveryStoreBo orderDeliveryBo) {
        if (orderDeliveryBo.getFailCount() == 0) {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u65e0\u6cd5\u53d1\u8d27\uff0c\u7b2c\u4e00\u6b21\u65e0\u6cd5\u53d1\u8d27\uff0c\u66f4\u65b0\u4e3a\u5f85\u8def\u7531\u3002", (Object)orderDeliveryBo.getOrderDeliveryEo().getDeliveryNo());
            orderDeliveryBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryBo.getPreWarehouseCode() + "-" + orderDeliveryBo.getPreWarehouseName() + "\uff09\u65e0\u6cd5\u53d1\u8d27\uff0c\u7b2c\u4e00\u6b21\u65e0\u6cd5\u53d1\u8d27\u6b21\u6570\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u8def\u7531\u3002");
            orderDeliveryBo.setIfFirstUnableDeliver(BooleanEnum.TRUE.getCode());
        } else {
            logger.info("\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u65e0\u6cd5\u53d1\u8d27\uff0c\u975e\u7b2c\u4e00\u6b21\u65e0\u6cd5\u53d1\u8d27\u6216\u62d2\u5355\uff0c\u6b21\u6570\uff1a{}\uff0c\u66f4\u65b0\u4e3a\u5904\u7406\u3002", (Object)orderDeliveryBo.getOrderDeliveryEo().getDeliveryNo(), (Object)orderDeliveryBo.getFailCount());
            orderDeliveryBo.setOptDesc("\u95e8\u5e97\uff08" + orderDeliveryBo.getPreWarehouseCode() + "-" + orderDeliveryBo.getPreWarehouseName() + "\uff09\u65e0\u6cd5\u53d1\u8d27\uff0c\u975e\u7b2c\u4e00\u6b21\u65e0\u6cd5\u53d1\u8d27\u6216\u62d2\u5355\uff0c\u6b21\u6570\uff1a" + orderDeliveryBo.getFailCount() + "\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            orderDeliveryBo.setIfFirstUnableDeliver(BooleanEnum.FALSE.getCode());
        }
        return orderDeliveryBo;
    }

    public DeliveryAssignBo assign(DeliveryAssignBo deliveryAssignReqDto) {
        return this.deliveryService.assign(deliveryAssignReqDto);
    }

    public OrderDeliveryStatusBo reRouterDelivery(OrderDeliveryStatusBo orderDeliveryBo) {
        return this.deliveryRouterService.reRouterDelivery(orderDeliveryBo);
    }

    @ActionNode(entity=OrderDeliveryEo.class, name="\u786e\u8ba4\u6536\u8d27")
    @Transactional
    public OrderDeliveryConfirmBo confirm(OrderDeliveryConfirmBo orderDeliveryBo) {
        orderDeliveryBo.getOrderDeliveryEo().setReceiveTime(new Date());
        return this.deliveryService.confirm(orderDeliveryBo);
    }

    @ActionNode(entity=OrderDeliveryEo.class, name="\u5224\u65ad\u662f\u5426\u5168\u90e8\u53d1\u8d27")
    @Transactional
    public CheckDeliveryBo checkDelivery(DeliveryStoreBo deliveryStoreBo) {
        OrderEo orderEoResp;
        CheckDeliveryBo checkDeliveryBo = new CheckDeliveryBo();
        boolean flag = true;
        String result = "part";
        String orderNo = deliveryStoreBo.getOrderDeliveryEo().getOrderNo();
        if (StringUtils.isNotEmpty((CharSequence)orderNo) && null != (orderEoResp = this.orderDas.findByOrderNo(orderNo))) {
            String orderTradeStatus = orderEoResp.getOrderTradeStatus();
            if (OrderBizStatusTobEnum.ALL_DELIVERY.getCode().equals(orderTradeStatus) || OrderBizStatusTobEnum.PART_CONFIRM.getCode().equals(orderTradeStatus) || OrderBizStatusTobEnum.CONFIRM.getCode().equals(orderTradeStatus)) {
                checkDeliveryBo.setResult("default");
                return checkDeliveryBo;
            }
        }
        checkDeliveryBo.setOrderNo(orderNo);
        List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(orderNo);
        if (CollectionUtils.isNotEmpty(tradeItemEos)) {
            List deliveryNos;
            Map<String, List<TradeItemEo>> tradeItemMap = tradeItemEos.stream().collect(Collectors.groupingBy(StdTradeItemEo::getSkuSerial));
            OrderDeliveryEo queryEo = OrderDeliveryEo.newInstance();
            queryEo.setOrderNo(orderNo);
            List orderDeliveryEos = this.orderDeliveryDas.select((BaseEo)queryEo);
            if (CollectionUtils.isNotEmpty((Collection)orderDeliveryEos) && CollectionUtils.isNotEmpty(deliveryNos = orderDeliveryEos.stream().filter(bean -> "DELIVERED".equals(bean.getDeliveryStatus())).map(StdOrderDeliveryEo::getDeliveryNo).collect(Collectors.toList()))) {
                Map<String, List<DeliveryItemEo>> deliveryItemMap;
                DeliveryItemEo deliveryItemSelect = DeliveryItemEo.newInstance();
                ArrayList<SqlFilter> deliveryItemSqlFilters = new ArrayList<SqlFilter>();
                deliveryItemSqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
                deliveryItemSelect.setSqlFilters(deliveryItemSqlFilters);
                List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
                if (CollectionUtils.isNotEmpty((Collection)deliveryItemEos) && null != (deliveryItemMap = deliveryItemEos.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getSkuSerial)))) {
                    for (Map.Entry<String, List<TradeItemEo>> tradeItemList : tradeItemMap.entrySet()) {
                        String key = tradeItemList.getKey();
                        List<TradeItemEo> value = tradeItemList.getValue();
                        List<DeliveryItemEo> deliverySkuItemEos = deliveryItemMap.get(key);
                        if (CollectionUtils.isEmpty(deliverySkuItemEos)) {
                            flag = false;
                            break;
                        }
                        Integer buyNum = value.stream().map(StdTradeItemEo::getItemNum).reduce(Integer::sum).orElse(0);
                        Integer deliveredNum = deliverySkuItemEos.stream().map(StdDeliveryItemEo::getItemNum).reduce(Integer::sum).orElse(0);
                        if (0 != buyNum && 0 != deliveredNum && buyNum == deliveredNum) continue;
                        flag = false;
                        break;
                    }
                }
            }
        }
        if (flag) {
            result = "all";
        }
        checkDeliveryBo.setResult(result);
        return checkDeliveryBo;
    }

    public OrderDeliveryCreateBo ifNeedRoute(OrderDeliveryCreateBo orderDeliveryBo) {
        Boolean ifNeedRoute = this.deliveryRouterService.checkIfNeedRoute(orderDeliveryBo);
        orderDeliveryBo.setIfNeedRoute(ifNeedRoute != false ? BooleanEnum.TRUE.getCode() : BooleanEnum.FALSE.getCode());
        return orderDeliveryBo;
    }

    public OrderDeliveryCreateBo ifNeedReceive(OrderDeliveryCreateBo orderDeliveryBo) {
        Boolean ifNeedReceive = this.deliveryRouterService.checkIfNeedReceive(orderDeliveryBo);
        orderDeliveryBo.setIfNeedReceive(ifNeedReceive != false ? BooleanEnum.TRUE.getCode() : BooleanEnum.FALSE.getCode());
        return orderDeliveryBo;
    }

    public OrderDeliveryBo cancel(OrderDeliveryBo orderDeliveryBo) {
        String orderNo = orderDeliveryBo.getOrderDeliveryEo().getOrderNo();
        orderDeliveryBo.setOrderNo(orderNo);
        return orderDeliveryBo;
    }

    @ActionNode(entity=OrderDeliveryEo.class, name="\u5224\u65ad\u662f\u5426\u5168\u90e8\u7b7e\u6536")
    public OrderDeliveryConfirmBo checkConfirm(OrderDeliveryConfirmBo orderDeliveryBo) {
        List deliveryNos;
        String orderNo = orderDeliveryBo.getOrderNo();
        orderDeliveryBo.setResult("FALSE");
        TradeItemEo queryTradeItemEo = TradeItemEo.newInstance();
        queryTradeItemEo.setTradeNo(orderNo);
        List tradeItemEos = this.tradeItemDas.select((BaseEo)queryTradeItemEo);
        Map<String, List<TradeItemEo>> tradeItemMap = tradeItemEos.stream().collect(Collectors.groupingBy(StdTradeItemEo::getSkuSerial));
        OrderDeliveryEo queryEo = OrderDeliveryEo.newInstance();
        queryEo.setOrderNo(orderNo);
        List orderDeliveryEos = this.orderDeliveryDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)orderDeliveryEos) && CollectionUtils.isNotEmpty(deliveryNos = orderDeliveryEos.stream().filter(bean -> "SIGNED".equals(bean.getDeliveryStatus())).map(StdOrderDeliveryEo::getDeliveryNo).collect(Collectors.toList()))) {
            orderDeliveryBo.setResult("TRUE");
            DeliveryItemEo queryDeliveryItemEo = DeliveryItemEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"delivery_no", deliveryNos));
            queryDeliveryItemEo.setSqlFilters(sqlFilters);
            List deliveryItemEos = this.deliveryItemDas.select((BaseEo)queryDeliveryItemEo);
            Map<String, List<DeliveryItemEo>> listMap = deliveryItemEos.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getSkuSerial));
            for (Map.Entry<String, List<TradeItemEo>> tradeItemList : tradeItemMap.entrySet()) {
                String key = tradeItemList.getKey();
                List<TradeItemEo> value = tradeItemList.getValue();
                List<DeliveryItemEo> deliveryItemEoList = listMap.get(key);
                if (CollectionUtils.isEmpty(deliveryItemEoList)) {
                    orderDeliveryBo.setResult("FALSE");
                    break;
                }
                Integer payNum = value.stream().map(StdTradeItemEo::getItemNum).reduce(Integer::sum).orElse(0);
                Integer deliveryNum = deliveryItemEoList.stream().map(StdDeliveryItemEo::getItemNum).reduce(Integer::sum).orElse(0);
                if (payNum.intValue() == deliveryNum.intValue()) continue;
                orderDeliveryBo.setResult("FALSE");
                break;
            }
        }
        return orderDeliveryBo;
    }
}

