/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryStoreReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.DeliveryOrderDelivedEvent;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IDeliveryRecordActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryStoreBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryRecordFlowAction")
@ActionNodeComponent
public class DeliveryRecordFlowAction {
    private static Logger logger = LoggerFactory.getLogger(DeliveryRecordFlowAction.class);
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @CubeResource
    private IDeliveryRecordActionExtPt deliveryRecordActionExtPt;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;

    @ActionNode(entity=OrderDeliveryEo.class, name="\u53d1\u8d27")
    @Transactional(rollbackFor={Exception.class})
    public DeliveryStoreBo deliverGoods(DeliveryStoreBo deliveryStoreBo) {
        DeliveryStoreReqDto deliveryStoreReqDto = deliveryStoreBo.getDeliveryStoreReqDto();
        deliveryStoreReqDto = (DeliveryStoreReqDto)EoUtil.transformExtFieldsToDto((BaseVo)deliveryStoreReqDto, (Class)this.deliveryRecordActionExtPt.getDtoClass());
        deliveryStoreBo.setDeliveryStoreReqDto(deliveryStoreReqDto);
        deliveryStoreBo = this.validate(deliveryStoreBo);
        deliveryStoreBo = this.packBo(deliveryStoreBo, deliveryStoreReqDto);
        deliveryStoreBo = this.save(deliveryStoreBo, deliveryStoreReqDto);
        return this.postProcessor(deliveryStoreBo, deliveryStoreReqDto);
    }

    @ActionNode(entity=OrderDeliveryEo.class, name="\u5df2\u53d1\u8d27\u901a\u77e5\u8ba2\u5355")
    @Transactional(rollbackFor={Exception.class})
    public DeliveryOrderDelivedEvent deliverNotifyOrder(DeliveryStoreBo deliveryStoreBo) {
        DeliveryOrderDelivedEvent deliveryOrderDelivedEvent = new DeliveryOrderDelivedEvent();
        deliveryOrderDelivedEvent.setOrderNo(deliveryStoreBo.getOrderNo());
        return deliveryOrderDelivedEvent;
    }

    private DeliveryStoreBo postProcessor(DeliveryStoreBo deliveryStoreBo, DeliveryStoreReqDto deliveryStoreReqDto) {
        this.deliveryRecordActionExtPt.postProcessor(deliveryStoreBo, deliveryStoreReqDto);
        deliveryStoreBo.setSuccFlag(Boolean.valueOf(true));
        return deliveryStoreBo;
    }

    private DeliveryStoreBo save(DeliveryStoreBo deliveryStoreBo, DeliveryStoreReqDto deliveryStoreReqDto) {
        if (deliveryStoreBo.ifNoUseFlow()) {
            this.orderDeliveryDas.updateSelective((BaseEo)deliveryStoreBo.getOrderDeliveryEo());
        }
        return this.deliveryRecordActionExtPt.save(deliveryStoreBo, deliveryStoreReqDto);
    }

    private DeliveryStoreBo packBo(DeliveryStoreBo deliveryStoreBo, DeliveryStoreReqDto deliveryStoreReqDto) {
        deliveryStoreBo.setPreStatus(deliveryStoreBo.getOrderDeliveryEo().getDeliveryStatus());
        OrderDeliveryEo orderDeliveryEo = deliveryStoreBo.getOrderDeliveryEo();
        orderDeliveryEo.setId(orderDeliveryEo.getId());
        orderDeliveryEo.setFlowDefId(orderDeliveryEo.getFlowDefId());
        orderDeliveryEo.setPrintData(deliveryStoreReqDto.getPrintData());
        orderDeliveryEo.setShippingCompanyCode(deliveryStoreReqDto.getShippingCompanyCode());
        orderDeliveryEo.setShippingCompany(deliveryStoreReqDto.getShippingCompany());
        orderDeliveryEo.setExpressCode(deliveryStoreReqDto.getExpressCode());
        orderDeliveryEo.setDeliveryTime(new Date());
        orderDeliveryEo.setCancelType(null);
        orderDeliveryEo.setCancelTime(null);
        orderDeliveryEo.setCancelDesc(null);
        return this.deliveryRecordActionExtPt.packBo(deliveryStoreBo, deliveryStoreReqDto);
    }

    private DeliveryStoreBo validate(DeliveryStoreBo deliveryStoreBo) {
        return this.deliveryRecordActionExtPt.validate(deliveryStoreBo);
    }

    public DeliveryStoreBo checkDeliverFinished(DeliveryStoreBo deliveryStoreBo) {
        if (!ShippingTypeEnum.PICKUP.getType().equals(deliveryStoreBo.getOrderDeliveryEo().getShippingType())) {
            deliveryStoreBo.setIfFinish("TRUE");
        } else {
            int deliveredNum;
            int totalItemNum = deliveryStoreBo.getDeliveryItemEos().stream().mapToInt(StdDeliveryItemEo::getItemNum).sum();
            String ifFinish = totalItemNum == (deliveredNum = deliveryStoreBo.getDeliveryItemEos().stream().mapToInt(DeliveryItemEo::getDeliveredNum).sum()) ? "TRUE" : "FALSE";
            deliveryStoreBo.setIfFinish(ifFinish);
        }
        return deliveryStoreBo;
    }

    public DeliveryStoreBo checkOrderDeliverFinished(DeliveryStoreBo deliveryStoreBo) {
        if (ShippingTypeEnum.PICKUP.getType().equals(deliveryStoreBo.getOrderDeliveryEo().getShippingType())) {
            deliveryStoreBo.setOrderFinish(deliveryStoreBo.getIfFinish());
        } else {
            RefDeliveryOrderEo refDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
            refDeliveryOrderEo.setDeliveryNo(deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
            List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderEo);
            String orderNo = ((RefDeliveryOrderEo)refDeliveryOrders.get(0)).getOrderNo();
            RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
            refDeliveryOrderSelect.setOrderNo(orderNo);
            List refDeliveryOrderEos = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
            List deliveryNos = refDeliveryOrderEos.stream().map(StdRefDeliveryOrderEo::getDeliveryNo).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(deliveryNos)) {
                logger.error("\u627e\u4e0d\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f,orderNo:{}", (Object)orderNo);
                throw new BizException("\u627e\u4e0d\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
            }
            OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"deliveryNo", deliveryNos));
            orderDeliverySelect.setSqlFilters(sqlFilters);
            List orderDeliverys = this.orderDeliveryDas.select((BaseEo)orderDeliverySelect);
            if (CollectionUtils.isEmpty((Collection)orderDeliverys)) {
                logger.error("\u627e\u4e0d\u53d1\u8d27\u5355\u4fe1\u606f,orderNo:{}", (Object)orderNo);
                throw new BizException("\u627e\u4e0d\u53d1\u8d27\u5355\u4fe1\u606f");
            }
            for (OrderDeliveryEo orderDeliveryEo : orderDeliverys) {
                if (StringUtils.isNotEmpty((CharSequence)orderDeliveryEo.getParentDeliveryNo()) && "0".equals(orderDeliveryEo.getParentDeliveryNo()) || DeliveryStatusEnum.DELIVERED.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) continue;
                logger.info("\u8ba2\u5355\uff1a{}\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\uff1a{}\u72b6\u6001\u4e3a\u975e\u5df2\u53d1\u8d27\u72b6\u6001\uff0c\u6807\u8bb0\u8ba2\u5355\u4e3a\u90e8\u5206\u53d1\u8d27\u72b6\u6001\uff1a{}", new Object[]{orderNo, orderDeliveryEo.getDeliveryNo(), "PARTIALSHIPMENT"});
                deliveryStoreBo.setOrderFinish("FALSE");
                return deliveryStoreBo;
            }
            deliveryStoreBo.setOrderFinish("TRUE");
        }
        return deliveryStoreBo;
    }
}

