/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ActionResult;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.IPointCashOutApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.eval.api.vo.EvalInitMsgVo;
import com.dtyunxi.yundt.cube.center.eval.api.vo.EvalInitVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.delivery.ITcbjDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.activity.CombinedPackageEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.GenerateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSettingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.config.MiniProgramMerchantProperties;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ActivityJoinBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.CreateOrderDeliveryOrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderDeliveryCompleteBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayResult;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayedEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.enums.ActivityTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderAddressService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderCouponService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPromotionCalculationService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.imkevent.FirstPurchaseEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.service.imkevent.PaidOrderEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ContextUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelOrderBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CloseOrderBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderAuditBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderRefactorBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.IGroupActivityAggApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderFlowAction")
@ActionNodeComponent
public class OrderFlowAction {
    private static Logger logger = LoggerFactory.getLogger(OrderFlowAction.class);
    @Resource(name="orderServiceImpl")
    private IOrderService orderService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IExtlOrderActivityService extlOrderActivityService;
    @Autowired
    private IOrderCouponService orderCouponService;
    @Resource
    private ICouponExtQueryApi couponExtQueryApi;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private ITcbjReciptApi iTcbjReciptApi;
    @Resource
    private ITcbjDeliveryApi tcbjDeliveryApi;
    @Resource
    private IDeliveryService deliveryService;
    @Resource
    private MiniProgramMerchantProperties miniProgramMerchantProperties;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private IOrderAddressService orderAddressService;
    @Resource
    private OrderAddressDas orderAddressDas;
    @Resource
    private IPromotionCalculationService promotionCalculationService;
    @Resource
    private FirstPurchaseEvent firstPurchaseEvent;
    @Resource
    private PaidOrderEvent paidOrderEvent;
    @CubeResource
    IOrderCreateActionExtPt orderCreateActionExtPt;
    @Resource
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Resource
    private IPointCashOutApi pointCashOutApi;
    @Resource
    private IContext context;
    @Resource
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private Environment environment;
    @Resource
    IAfterSalesService afterSalesService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IGroupActivityAggApi groupActivityAggApi;
    @Autowired
    private ICsDeliveryNoticeOrderApi csDeliveryNoticeOrderApi;

    @ActionNode(entity=OrderEo.class, name="\u662f\u5426\u9700\u8981\u652f\u4ed8")
    @FlowActionNode(entity=OrderEo.class, name="\u662f\u5426\u9700\u8981\u652f\u4ed8")
    public String isNeedPay(OrderBo orderBo) {
        if (this.orderActivityService.useExchangeCoupon(orderBo.getOrderEo().getOrderNo())) {
            logger.info("\u8ba2\u5355\uff1a{}\u4f7f\u7528\u5151\u6362\u5238\uff0c0\u5143\u652f\u4ed8!", (Object)orderBo.getOrderEo().getOrderNo());
            orderBo.getOrderEo().setPayTime(new Date());
            this.modifyPayTime(orderBo.getOrderEo());
            return "FALSE";
        }
        logger.info("\u662f\u5426\u9700\u8981\u652f\u4ed8,\u91d1\u989d:{},\u4e0e0\u6bd4\u8f83{}", (Object)orderBo.getOrderEo().getPayAmount(), (Object)orderBo.getOrderEo().getPayAmount().compareTo(BigDecimal.ZERO));
        if (!this.isPureIntegral(orderBo.getOrderEo()) && orderBo.getOrderEo().getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            logger.info("0\u5143\u652f\u4ed8!");
            orderBo.getOrderEo().setPayTime(new Date());
            this.modifyPayTime(orderBo.getOrderEo());
            return "FALSE";
        }
        return "TRUE";
    }

    private void modifyPayTime(OrderEo orderEo) {
        if (null != orderEo.getId()) {
            Date time = new Date();
            OrderEo orderUpdate = new OrderEo();
            orderUpdate.setId(orderEo.getId());
            orderUpdate.setPayTime(time);
            this.orderDas.updateSelective((BaseEo)orderUpdate);
            logger.info("\u8ba2\u5355:{}\uff0c0\u5143\u652f\u4ed8\u66f4\u65b0\u652f\u4ed8\u65f6\u95f4", (Object)orderEo.getOrderNo());
        }
    }

    @FlowActionNode(entity=OrderEo.class, name="\u662f\u5426\u53d1\u8d77\u7eaf\u79ef\u5206\u652f\u4ed8")
    public PayMethodBo isNeedIntegralPay(OrderBo orderBo) {
        PayMethodBo payMethodBo = new PayMethodBo();
        payMethodBo.setOrderEo(orderBo.getOrderEo());
        OrderEo orderEo = orderBo.getOrderEo();
        try {
            boolean pureIntegral = this.isPureIntegral(orderEo);
            if (pureIntegral) {
                PayMethodReqDto payMethodReqDto = new PayMethodReqDto();
                payMethodReqDto.setOrderNo(orderEo.getOrderNo());
                payMethodReqDto.setPayMethod(PayTypeEnum.INTEGRAL.getCode());
                payMethodReqDto.setIsDefined("2");
                payMethodReqDto.setAppId(this.miniProgramMerchantProperties.getAppId());
                payMethodReqDto.setAppName(this.miniProgramMerchantProperties.getAppName());
                payMethodReqDto.setStoreId(this.miniProgramMerchantProperties.getStoreId());
                payMethodReqDto.setInstanceId(orderBo.getOrderEo().getInstanceId());
                payMethodReqDto.setTenantId(orderBo.getOrderEo().getTenantId());
                payMethodReqDto.setUserId(orderBo.getOrderEo().getUserId());
                payMethodBo.setPayMethodReqDto(payMethodReqDto);
                payMethodBo.setIfIntegralPay("TRUE");
            }
        }
        catch (Exception e) {
            logger.info("\u7eaf\u79ef\u5206\u8ba2\u5355\u81ea\u52a8\u53d1\u8d77\u652f\u4ed8\u5931\u8d25, orderNo={}: " + e.getMessage(), (Object)orderEo.getOrderNo(), (Object)e);
        }
        return payMethodBo;
    }

    private boolean isPureIntegral(OrderEo orderEo) {
        BigDecimal payAmount = orderEo.getPayAmount();
        Integer integral = orderEo.getIntegral();
        Integer busType = orderEo.getBusType();
        logger.info("payAmount:{},integral:{},busType:{}", new Object[]{payAmount, integral, busType});
        return ItemBusTypeEnum.INTEGRAL.getType().equals(busType) && payAmount != null && payAmount.compareTo(BigDecimal.ZERO) == 0 && integral != null && integral > 0;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u5168\u90e8\u652f\u4ed8")
    @Transactional
    public OrderPayResult payOrder(OrderPayedEvent payedEvent) {
        logger.info("\u8ba2\u5355{}\u63a5\u53d7\u5230\u652f\u4ed8\u901a\u77e5", (Object)payedEvent.getOrderEo().getOrderNo());
        OrderPayResult payResult = new OrderPayResult();
        OrderEo orderEo = payedEvent.getOrderEo();
        orderEo.setPayTime(payedEvent.getFinishTime());
        payResult.setOrderPayedEvent(payedEvent);
        payResult.setOrderEo(orderEo);
        payResult.setAuditType(orderEo.getAuditType());
        logger.info("\u53d1\u9001\u652f\u4ed8\u5b8c\u6210\u7684\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)orderEo.getOrderNo()));
        MessageVo messageVo = new MessageVo();
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("orderNo", orderEo.getOrderNo());
        mapParam.put("userId", this.context.userId());
        messageVo.setData((Object)JSON.toJSONString(mapParam));
        this.commonsMqService.sendSingleMessage("YUNDT_CUBE_CENTER_TRADE_PAY_SUCCESS_TOPIC", (Object)messageVo);
        String result = payedEvent.getResult();
        if ("all".equals(result)) {
            this.updateOutOrderStatus(orderEo.getOrderNo());
        }
        return payResult;
    }

    private void updateOutOrderStatus(String preOrderNo) {
        logger.info("updateOutOrderStatus==>\u652f\u4ed8\u6210\u529f\u540e\uff0c\u901a\u77e5\u5e93\u5b58\u4e2d\u5fc3\uff0c\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001,preOrderNo:{}", (Object)preOrderNo);
        try {
            this.csDeliveryNoticeOrderApi.updateOrderStatus(preOrderNo, CsDocumentActionEnum.SUCCESS_PAY.getCode());
        }
        catch (Exception e) {
            logger.error("updateOutOrderStatus==>\u64cd\u4f5c\u5f02\u5e38,e:{}", (Throwable)e);
        }
    }

    private void sendTcbj(OrderEo orderEo) {
        try {
            ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
            attrs.add(OrderQueryEnum.ADDRESS);
            attrs.add(OrderQueryEnum.ITEM);
            OrderDetailRespDto orderDto = this.orderService.getDetail(orderEo.getOrderNo(), StringUtils.join(attrs, (String)","));
            logger.info("------------>\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)orderDto));
            OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
            if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
                orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
            }
            TcbjNotiGenReqDto tcbjNotiGenReqDto = new TcbjNotiGenReqDto();
            tcbjNotiGenReqDto.setPreNo(orderDto.getOrderNo());
            tcbjNotiGenReqDto.setAddress(orderDelivery.getAddress());
            tcbjNotiGenReqDto.setPlanTime(orderDto.getPlaceTime().toString());
            tcbjNotiGenReqDto.setReciveName(orderDelivery.getDeliveryName());
            tcbjNotiGenReqDto.setRecivePhone(orderDelivery.getDeliveryMobile());
            tcbjNotiGenReqDto.setWarehouseCode(orderDto.getWarehouseCode());
            ArrayList<TcbjNotiGenItemReqDto> notiGenItemReqDtos = new ArrayList<TcbjNotiGenItemReqDto>();
            for (TradeItemRespDto item : orderDto.getOrderItems()) {
                TcbjNotiGenItemReqDto dto = new TcbjNotiGenItemReqDto();
                dto.setBatch(item.getBatchNo());
                dto.setCargoCode(item.getCargoSerial());
                dto.setNum(item.getItemNum());
                if (CombinedPackageEnum.YES.getType().equals(item.getIsCombinedPackage())) {
                    dto.setActivityId(item.getCombinedPackageActivityId());
                    dto.setCombinationFlag(item.getIsCombinedPackage());
                }
                dto.setType(item.getGift());
                dto.setTradeOrderItemId(item.getId());
                notiGenItemReqDtos.add(dto);
            }
            tcbjNotiGenReqDto.setNotiGenItemReqDtos(notiGenItemReqDtos);
            tcbjNotiGenReqDto.setType(Integer.valueOf(101));
            logger.info("\u652f\u4ed8\u6210\u529f\u901a\u77e5\u8bf7\u6c42\u53c2\u6570,tcbjProOccupyReqDto----:" + JSONObject.toJSONString((Object)tcbjNotiGenReqDto));
            logger.info("[\u5b8c\u5168\u652f\u4ed8\u8ba2\u5355\u53f7" + orderDto.getOrderNo() + "],tcbjProOccupyReqDto----:" + JSONObject.toJSONString((Object)tcbjNotiGenReqDto));
        }
        catch (Exception e) {
            logger.info("\u652f\u4ed8\u6210\u529f\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)orderEo.getOrderNo()));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            e.printStackTrace();
        }
    }

    @FlowActionNode(entity=OrderEo.class, name="\u652f\u4ed8\u5e76\u63a8\u9001\u6d88\u606f")
    @Transactional
    public OrderPayResult payOrderBBC(OrderPayedEvent payedEvent) {
        String result;
        OrderPayResult orderPayResult = this.payOrder(payedEvent);
        this.marketOrderTradeStatusProducer.sendOrderPaySuccessMessageToMarket(payedEvent.getOrderEo(), payedEvent.getPayNo());
        boolean pureIntegral = this.isPureIntegral(payedEvent.getOrderEo());
        if (!pureIntegral) {
            this.firstPurchaseEvent.triggerEvent(payedEvent.getOrderEo());
            this.paidOrderEvent.triggerEvent(payedEvent.getOrderEo());
        }
        if ("TRUE".equals(result = this.isGroupOrder(orderPayResult.getOrderEo()))) {
            ActivityJoinBo activityJoinBo = new ActivityJoinBo();
            activityJoinBo.setOrderEo(payedEvent.getOrderEo());
            activityJoinBo.setNeedJoinGroupActivity(true);
            this.joinGroupActivity(activityJoinBo);
        }
        return orderPayResult;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u90e8\u5206\u652f\u4ed8")
    @Transactional
    public OrderPayResult payOrderForPart(OrderPayedEvent payedEvent) {
        logger.info("\u8ba2\u5355\u90e8\u5206\u652f\u4ed8{}", (Object)payedEvent.getOrderEo().getOrderNo());
        OrderPayResult payResult = new OrderPayResult();
        OrderEo orderEo = payedEvent.getOrderEo();
        orderEo.setPayTime(payedEvent.getFinishTime());
        payResult.setOrderPayedEvent(payedEvent);
        payResult.setOrderEo(orderEo);
        return payResult;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u662f\u5426\u9700\u8981\u5ba1\u6838\u8ba2\u5355")
    @Transactional
    public String isNeedAudit(OrderBo orderBo) {
        OrderEo orderEo = orderBo.getOrderEo();
        if (orderEo.getAuditType().equals(0)) {
            return "FALSE";
        }
        return "TRUE";
    }

    private OrderSettingReqDto.OrderAuditInterceptSettingDto getOrderAuditInterceptSettingDto() {
        String ORDER_SETTING = "ORDER_SETTING";
        String ORDER_AUDIT_INTERCEPT_SETTING = "ORDER_AUDIT_INTERCEPT_SETTING";
        OrderSettingReqDto.OrderAuditInterceptSettingDto orderAuditInterceptSettingDto = this.getSettingDto(ORDER_SETTING, ORDER_AUDIT_INTERCEPT_SETTING, OrderSettingReqDto.OrderAuditInterceptSettingDto.class);
        return orderAuditInterceptSettingDto;
    }

    private <T> T getSettingDto(String groupCode, String code, Class<T> clazz) {
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, groupCode, code).getData();
        if (dictDto == null) {
            return null;
        }
        return (T)JSONObject.parseObject((String)dictDto.getValue(), clazz);
    }

    @FlowActionNode(entity=OrderEo.class, name="\u662f\u5426\u62fc\u56e2\u8ba2\u5355")
    public String isGroupOrder(OrderEo orderEo) {
        try {
            if (OrderBizTypeEnum.GROUPORDER.getType().toString().equals(orderEo.getBizType())) {
                return "TRUE";
            }
            return "FALSE";
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "fail";
        }
    }

    @Transactional
    public OrderRefactorBo completeOrder(OrderRefactorBo orderBo) {
        return this.orderCreateActionExtPt.completeOrder(orderBo);
    }

    @FlowActionNode(entity=OrderEo.class, name="\u552e\u540e\u5b8c\u6210")
    public OrderBo finishOrder(OrderBo orderBo) {
        orderBo.getOrderEo().setEndTime(new Date());
        if (this.afterSalesService.checkOrderReturnFinish(orderBo.getOrderEo().getOrderNo())) {
            logger.info("\u8ba2\u5355\uff1a{}\u5168\u90e8\u9000\u6b3e\u5df2\u5b8c\u6210\uff0c\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u5173\u95ed\uff01", (Object)orderBo.getOrderEo().getOrderNo());
            orderBo.setToStatus("CLOSED");
        } else {
            logger.info("\u8ba2\u5355\uff1a{}\u5168\u90e8\u9000\u6b3e\u672a\u5b8c\u6210\uff0c\u8ba2\u5355\u72b6\u6001\u4e0d\u53d8\uff01", (Object)orderBo.getOrderEo().getOrderNo());
            orderBo.setToStatus(orderBo.getOrderEo().getOrderTradeStatus());
        }
        return orderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u751f\u6210\u53d1\u8d27\u5355")
    public CreateOrderDeliveryOrderBo createDeliveryOrder(CreateOrderDeliveryOrderBo createOrderDeliveryOrderBo) {
        logger.info("===\u751f\u6210\u53d1\u8d27\u5355\u6d41\u7a0b===");
        logger.info("\u8ba2\u5355\uff1a{}\u5f00\u59cb\u751f\u6210\u53d1\u8d27\u5355\u4fe1\u606f\uff0c waitDeliveryBo\uff1a{}", (Object)createOrderDeliveryOrderBo.getOrderEo().getOrderNo(), JSON.toJSON((Object)((Object)createOrderDeliveryOrderBo)));
        GenerateOrderReqDto generateOrderReqDto = new GenerateOrderReqDto();
        Boolean createDeliveryOrder = this.orderService.isCreateDeliveryOrder(createOrderDeliveryOrderBo.getOrderEo());
        if (!createDeliveryOrder.booleanValue()) {
            logger.info("\u865a\u62df\u5546\u54c1\u4e0d\u751f\u6210\u53d1\u8d27\u5355\uff01");
            return createOrderDeliveryOrderBo;
        }
        ArrayList<String> orderNos = new ArrayList<String>();
        orderNos.add(createOrderDeliveryOrderBo.getOrderEo().getOrderNo());
        generateOrderReqDto.setOrderNos(orderNos);
        generateOrderReqDto.setDeliveryPlanCycleDtoList(createOrderDeliveryOrderBo.getDeliveryPlanCycleDtoList());
        this.create(generateOrderReqDto);
        return createOrderDeliveryOrderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u786e\u8ba4\u53d1\u8d27")
    public OrderBo deliveryOrderConfirm(OrderBo orderBo) {
        return orderBo;
    }

    @Transactional
    public String create(GenerateOrderReqDto generateOrderReqDto) {
        generateOrderReqDto.setAppKey(ContextUtil.getInstanceId());
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${GENERATE_DELIVERY_TOPIC:GENERATE_DELIVERY_TOPIC}"), "GENERATE_DELIVERY_TAG", (Object)generateOrderReqDto);
        logger.info("\u53d1\u9001\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355MQ\u6d88\u606f\u5b8c\u6bd5\uff0cgenerateOrderReqDto\uff1a{}", JSON.toJSON((Object)generateOrderReqDto));
        return "succ";
    }

    @FlowActionNode(entity=OrderEo.class, name="\u62fc\u56e2\u662f\u5426\u6210\u56e2", nextForProperty="result", results={@ActionResult(code="default", desc="\u9ed8\u8ba4"), @ActionResult(code="group_activity", desc="\u62fc\u56e2\u6d3b\u52a8")})
    public OrderBo groupActivitySuccess(OrderBo orderBo) {
        String result = "FALSE";
        if (!"TRUE".equals(this.isGroupOrder(orderBo.getOrderEo()))) {
            logger.info("{}\u4e0d\u662f\u62fc\u56e2\u8ba2\u5355", (Object)orderBo.getOrderEo().getOrderNo());
            result = "default";
            orderBo.setResult(result);
            return orderBo;
        }
        RestResponse restResponse = this.groupActivityAggApi.queryGroupSuccess(orderBo.getOrderEo().getOrderNo());
        try {
            RestResponseHelper.checkOrThrow((RestResponse)restResponse);
            Integer value = (Integer)RestResponseHelper.extractData((RestResponse)restResponse);
            logger.info("{}\u62fc\u56e2\u72b6\u6001{}", (Object)orderBo.getOrderEo().getOrderNo(), (Object)value);
            if (Objects.equals(1, value)) {
                result = "TRUE";
            }
        }
        catch (BizException e) {
            logger.error("\u68c0\u67e5\u62fc\u56e2\u662f\u5426\u6210\u529f\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        orderBo.setResult(result);
        return orderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u6d3b\u52a8\u53c2\u4e0e\u6210\u529f", nextForProperty="result", results={@ActionResult(code="default", desc="\u9ed8\u8ba4"), @ActionResult(code="success", desc="\u62fc\u56e2\u6d3b\u52a8")})
    @Transactional
    public ActivityJoinBo joinActivityAction(ActivityJoinBo activityJoinBo) {
        OrderEo orderEo = activityJoinBo.getOrderEo();
        OrderReqDto orderBo = this.orderActivityService.getActivityOrder(orderEo);
        if (this.isGroupOrder(activityJoinBo.getOrderEo()).equals("TRUE")) {
            logger.info("{}\u62fc\u56e2\u6d3b\u52a8,\u4e0d\u518d\u53c2\u4e0e", (Object)activityJoinBo.getOrderEo().getOrderNo());
        } else {
            this.extlOrderActivityService.successJoinActivity(orderEo, orderBo);
        }
        String bizResult = null;
        if (!activityJoinBo.isNeedJoinGroupActivity() && orderBo.getActivity() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderBo.getActivity().getActivityList())) {
            for (OrderActivityInfoReqDto orderActivityInfoReqDto : orderBo.getActivity().getActivityList()) {
                ActivityTypeEnum activityTypeEnum = ActivityTypeEnum.getByValue(orderActivityInfoReqDto.getType());
                if (!ActivityTypeEnum.GROUP_ACTIVITY.equals((Object)activityTypeEnum)) continue;
                bizResult = "group_activity";
                break;
            }
        }
        if (bizResult == null) {
            bizResult = "default";
        }
        activityJoinBo.setResult(bizResult);
        return activityJoinBo;
    }

    public void joinGroupActivity(ActivityJoinBo activityJoinBo) {
        logger.info("{}\u53c2\u4e0e\u62fc\u56e2\u6d3b\u52a8", (Object)activityJoinBo.getOrderEo().getOrderNo());
        OrderEo orderEo = activityJoinBo.getOrderEo();
        OrderReqDto orderBo = this.orderActivityService.getActivityOrder(orderEo);
        this.extlOrderActivityService.successJoinActivity(orderEo, orderBo);
    }

    private void rollbackVirStorage(OrderEo orderEo) {
        this.orderService.rollbackOrderStock(orderEo);
    }

    @FlowActionNode(entity=OrderEo.class, name="\u53d6\u6d88\u8ba2\u5355")
    public CancelOrderBo cancelOrder(CancelOrderBo cancelOrderBo) {
        return this.orderCreateActionExtPt.cancelOrder(cancelOrderBo);
    }

    @FlowActionNode(entity=OrderAuditBo.class, name="\u5173\u95ed\u8ba2\u5355")
    public OrderAuditBo doCloseOrder(OrderAuditBo orderAuditBo) {
        logger.info("\u6267\u884c\u8ba2\u5355\u5173\u95ed\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)orderAuditBo));
        OrderAuditReqDto orderAuditReqDto = orderAuditBo.getOrderAuditReqDto();
        String tradeNo = orderAuditReqDto.getTradeNo();
        Set<String> orderNos = this.orderService.validateCancel(tradeNo);
        CancelReqDto cancelReq = new CancelReqDto();
        cancelReq.setTradeNo(tradeNo);
        cancelReq.setTenantId(this.context.tenantId());
        cancelReq.setInstanceId(this.context.instanceId());
        if (!CollectionUtils.isEmpty(orderNos)) {
            for (String orderNo : orderNos) {
                CloseOrderBo closeOrderBo = new CloseOrderBo();
                closeOrderBo.setCancelReqDto(cancelReq);
                closeOrderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), orderNo);
                closeOrderBo.setToStatus("CLOSED");
                cancelReq.setTradeNo(orderNo);
                this.closeOrder(closeOrderBo);
            }
        }
        CloseOrderBo closeOrderBo = new CloseOrderBo();
        closeOrderBo.setCancelReqDto(cancelReq);
        closeOrderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), tradeNo);
        closeOrderBo.setToStatus("CLOSED");
        cancelReq.setTradeNo(tradeNo);
        this.closeOrder(closeOrderBo);
        return orderAuditBo;
    }

    public CloseOrderBo closeOrder(CloseOrderBo closeOrderBo) {
        return this.orderCreateActionExtPt.closeOrder(closeOrderBo);
    }

    @FlowActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u7b7e\u6536")
    public OrderBo receiptOrder(OrderBo orderBo) {
        OrderEo orderEo = orderBo.getOrderEo();
        orderEo.setReceiveTime(new Date());
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setOrderNo(orderEo.getOrderNo());
        this.deliveryService.confirmByOrderNo(orderEo.getOrderNo());
        this.sendMsg2Eval(orderEo.getOrderNo());
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u5168\u90e8\u7b7e\u6536")
    public OrderBo receiptAllOrder(OrderBo orderBo) {
        orderBo.getOrderEo().setReceiveTime(new Date());
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u90e8\u5206\u7b7e\u6536")
    public OrderBo receiptPartOrder(OrderBo orderBo) {
        return orderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u5df2\u53d1\u8d27")
    public OrderBo deliveryOrder(OrderDeliveryCompleteBo orderBo) {
        if (orderBo.getOrderDeliveryExtReqDto() != null) {
            orderBo.getOrderEo().setDeliveryInfo(orderBo.getOrderDeliveryExtReqDto().getDeliveryInfo());
        }
        orderBo.getOrderEo().setDeliveryTime(new Date());
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u53d1\u8d77\u652f\u4ed8")
    public PayMethodBo createPay(PayMethodBo payMethodBo) {
        logger.info("\u8ba2\u5355\u53f7{}\u53d1\u8d77\u652f\u4ed8", (Object)payMethodBo.getOrderEo().getOrderNo());
        return payMethodBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u90e8\u5206\u51fa\u5e93")
    public OrderBo outStorageForPart(OrderBo orderBo) {
        orderBo.getOrderEo().setUpdateTime(new Date());
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u5168\u90e8\u51fa\u5e93")
    public OrderBo outStorageForAll(OrderBo orderBo) {
        orderBo.getOrderEo().setUpdateTime(new Date());
        return orderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u90e8\u5206\u53d1\u8d27")
    public OrderBo deliveryForPart(OrderBo orderBo) {
        orderBo.getOrderEo().setUpdateTime(new Date());
        return orderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u90e8\u5206\u53d1\u8d27")
    public OrderBo partialShippingOrder(OrderBo orderBo) {
        orderBo.getOrderEo().setDeliveryTime(new Date());
        return orderBo;
    }

    @FlowActionNode(entity=OrderEo.class, name="\u53d6\u6d88\u53d1\u8d27\u5355\u540e\u5904\u7406\u8ba2\u5355")
    public OrderBo handelOrderAfterCancelDelivery(OrderBo orderBo) {
        if (ShippingTypeEnum.PICKUP.getType().equals(orderBo.getShippingType())) {
            logger.info("\u81ea\u63d0\u53d1\u8d27\u5355\u53d6\u6d88\u540e\uff0c\u76f4\u63a5\u53d6\u6d88\u8ba2\u5355\u2026\u2026");
        } else {
            String toStatus = this.deliveryService.getOrderStatusByDeliver(orderBo.getOrderEo().getOrderNo());
            orderBo.setToStatus(toStatus);
        }
        orderBo.getOrderEo().setUpdateTime(new Date());
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u5224\u65ad\u662f\u5426\u90e8\u5206\u53d1\u8d27")
    public OrderBo checkIsPartDelivery(OrderBo orderBo) {
        List orderDeliveryEos;
        String orderNo = orderBo.getOrderEo().getOrderNo();
        List existDeliveries = this.orderDeliveryDas.queryByOrderNo(orderNo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)existDeliveries) && org.apache.commons.collections.CollectionUtils.isNotEmpty(orderDeliveryEos = existDeliveries.stream().filter(bean -> "DELIVERED".equals(bean.getDeliveryStatus())).collect(Collectors.toList()))) {
            orderBo.setResult("TRUE");
        }
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u4fc3\u9500\u8ba1\u7b97")
    public OrderCreateBo promotionCalculation(OrderCreateBo orderBo) {
        this.promotionCalculationService.handleFullGiftActivity(orderBo);
        return orderBo;
    }

    private void sendMsg2Eval(String orderNo) {
        logger.info("\u8fdb\u5165\u521d\u59cb\u5316\u8bc4\u4ef7\u6d88\u606f\u53d1\u9001\u7684\u65b9\u6cd5\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo);
        try {
            List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(orderNo);
            logger.info("\u67e5\u8be2\u4ea4\u6613\u5546\u54c1\uff0ctradeItemEos\uff1a{}", (Object)JSON.toJSONString(tradeItemEos));
            List evalInitVos = tradeItemEos.stream().map(tradeItemEo -> {
                List itemSkuList;
                ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(Long.parseLong(tradeItemEo.getShopId()))));
                EvalInitVo evalInitVo = new EvalInitVo();
                String mediaPath = null;
                String attr = null;
                ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)JSON.parseObject((String)tradeItemEo.getItemDetail(), ItemDetailRespDto.class);
                List itemMediasList = itemDetailRespDto.getItemMediasList();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemMediasList)) {
                    mediaPath = ((ItemMediasRespDto)itemMediasList.get(0)).getPath1();
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemSkuList = itemDetailRespDto.getItemSkuList()))) {
                    for (ItemSkuRespDto itemSkuRespDto : itemSkuList) {
                        if (!tradeItemEo.getSkuSerial().equals(String.valueOf(itemSkuRespDto.getId()))) continue;
                        attr = itemSkuRespDto.getAttr();
                    }
                }
                evalInitVo.setEvalSbjTypeCode("item");
                evalInitVo.setEvalOrderId(tradeItemEo.getTradeNo());
                evalInitVo.setEvalItemId(tradeItemEo.getItemSerial());
                evalInitVo.setEvalSkuId(tradeItemEo.getSkuSerial());
                evalInitVo.setEvalShopId(tradeItemEo.getShopId());
                evalInitVo.setEvalSubName(tradeItemEo.getItemName());
                evalInitVo.setEvalSubMedia(mediaPath);
                evalInitVo.setEvalItemCode(tradeItemEo.getItemCode());
                evalInitVo.setEvalItemProp(attr);
                evalInitVo.setEvalShopName(shopBaseDto.getName());
                evalInitVo.setOrganizationId(shopBaseDto.getOrganizationId());
                evalInitVo.setUserId(String.valueOf(this.context.userId()));
                evalInitVo.setInstanceId(this.context.instanceId());
                evalInitVo.setTenantId(this.context.tenantId());
                return evalInitVo;
            }).collect(Collectors.toList());
            EvalInitMsgVo evalInitMsgVo = new EvalInitMsgVo();
            evalInitMsgVo.setEvalInitVos(evalInitVos);
            MessageVo messageVo = new MessageVo();
            logger.info("\u53d1\u9001\u8bc4\u4ef7\u521d\u59cb\u5316\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)evalInitMsgVo));
            messageVo.setData((Object)JSON.toJSONString((Object)evalInitMsgVo));
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("EVAL_INIT_TAG"), (Object)messageVo);
            logger.info("\u521d\u59cb\u5316\u8bc4\u4ef7\u6d88\u606f\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            logger.info("\u521d\u59cb\u5316\u8bc4\u4ef7\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }

    private void rush(CancelOrderBo cancelOrderBo) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        Long userId = this.context.userId();
        OrderEo orderEo = cancelOrderBo.getOrderEo();
        if (userId != null && orderEo != null) {
            Long memberId = (Long)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberIdByUserId(userId));
            pointsTradeInfoReqDto.setMemberId(memberId);
            pointsTradeInfoReqDto.setOrderNo(orderEo.getOrderNo());
            String sendJson = JSON.toJSONString((Object)pointsTradeInfoReqDto);
            logger.info("\u53d6\u6d88\u5355\u53f7{}\u8ba2\u5355\u62b5\u73b0\u79ef\u5206\u51b2\u6b63\u8acb\u6c42dto={}", (Object)orderEo.getOrderNo(), (Object)sendJson);
        }
    }
}

