/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.config.PayConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.IntegralOrderPayProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IPayRecordActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payRecordFlowAction")
@ActionNodeComponent
public class PayRecordFlowAction {
    private static Logger logger = LoggerFactory.getLogger(PayRecordFlowAction.class);
    @Value(value="${yundt.cube.center.payment.appvo.apiSecret}")
    public String apiSecret;
    @Autowired
    private PayConfig payConfig;
    @Resource
    private IOrderService orderService;
    @Resource
    private PayRecordDas payRecordDas;
    @Resource
    private IPayService payService;
    @Resource
    private OrderDas orderDas;
    @Resource
    ICreateTradeService createTradeService;
    @CubeResource
    IPayRecordActionExtPt payRecordActionExtPt;
    @Resource
    private IntegralOrderPayProducer integralOrderPayProducer;

    @ActionNode(entity=PayRecordEo.class, name="\u521b\u5efa\u652f\u4ed8\u5355")
    @Transactional
    public PayMethodBo create(PayMethodBo payMethodBo) {
        PayMethodReqDto payMethodReq = payMethodBo.getPayMethodReqDto();
        payMethodReq = (PayMethodReqDto)EoUtil.transformExtFieldsToDto((BaseVo)payMethodReq, (Class)this.payRecordActionExtPt.getDtoClass());
        payMethodBo.setPayMethodReqDto(payMethodReq);
        payMethodReq = this.validate(payMethodReq);
        payMethodBo = this.packBo(payMethodBo, payMethodReq);
        payMethodBo = this.save(payMethodBo, payMethodReq);
        return this.postProcessor(payMethodBo, payMethodReq);
    }

    private PayMethodBo postProcessor(PayMethodBo payMethodBo, PayMethodReqDto payMethodReq) {
        logger.info("postProcessor\u8c03\u7528\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3[{}],payMethodBo\u89e3\u6790\u7ed3\u679c\u4e3a{}", (Object)payMethodReq.getOrderNo(), (Object)JSON.toJSONString((Object)payMethodBo));
        if (!payMethodBo.isChildPay() && !"offLine".equals(payMethodBo.getPayType())) {
            PayResponse response = this.sendPayRequest(payMethodBo.getPayMethodReqDto(), payMethodBo.getPayRequest());
            String result = ObjectHelper.bean2Json((Object)response);
            payMethodBo.setSendPayResult(result);
            this.updatePayRecord(payMethodBo.getPayRecordEo(), response, payMethodBo.getPayRequest());
        }
        return this.payRecordActionExtPt.postProcessor(payMethodBo, payMethodReq);
    }

    private void updatePayRecord(PayRecordEo payRecordEo, PayResponse response, PayRequest request) {
        payRecordEo.setExtlPaySerial(response.getTradeId());
        JSONObject json = new JSONObject();
        json.put("storeId", (Object)request.getStoreId());
        json.put("appId", (Object)request.getAppId());
        json.put("appName", (Object)request.getAppName());
        payRecordEo.setExtension(json.toJSONString());
        PayResultEnum payResult = PayResultEnum.getByName((String)response.getResult());
        if (PayResultEnum.ACCEPT == payResult) {
            payRecordEo.setPayAcceptTime(new Date());
        } else if (PayResultEnum.SUCCESS == payResult) {
            Date now = new Date();
            payRecordEo.setPayAcceptTime(now);
            payRecordEo.setPayFinishTime(now);
        }
        payRecordEo.setUpdateTime(null);
    }

    private PayResponse sendPayRequest(PayMethodReqDto payMethodReqDto, PayRequest request) {
        PayResponse response;
        String apiSecret = payMethodReqDto.getIsDefined() == null || payMethodReqDto.getIsDefined().equals("1") ? this.payConfig.getApiSecret() : this.apiSecret;
        try {
            request.setOrderAmt(request.getOrderAmt().setScale(2));
            request.doEncrypt(apiSecret);
            response = this.createTradeService.createPayOrder(request);
            try {
                response.verifySign(apiSecret);
            }
            catch (Exception e) {
                response.verifyGlobalSign(apiSecret);
            }
        }
        catch (Exception ex) {
            logger.error("\u53d1\u8d77\u652f\u4ed8\u5f02\u5e38", (Throwable)ex);
            throw new BizException(ex.getMessage());
        }
        return response;
    }

    private PayMethodBo save(PayMethodBo payMethodBo, PayMethodReqDto payMethodReq) {
        if (null != payMethodBo.getPayRecordEo()) {
            payMethodBo.getPayRecordEo().setPayStartTime(new Date());
            this.payService.saveInitPayRecord(payMethodBo.getPayRecordEo());
        }
        payMethodBo = this.payRecordActionExtPt.save(payMethodBo, payMethodReq);
        return payMethodBo;
    }

    private PayMethodBo packBo(PayMethodBo payMethodBo, PayMethodReqDto payMethodReqDto) {
        payMethodBo.setPayType(StringUtils.isEmpty((CharSequence)payMethodBo.getPayType()) ? "default" : payMethodBo.getPayType());
        if ("OFFLINE_AMOUNT_PAY".equals(payMethodReqDto.getPayMethod()) || "OFFLINE_PUBLIC_REMIT_PAY".equals(payMethodReqDto.getPayMethod()) || "NORMAL_PAY_HELP".equals(payMethodReqDto.getPayMethod()) || "CREDIT_PAY".equals(payMethodReqDto.getPayMethod()) || "ACCOUNT_PERIOD".equals(payMethodReqDto.getPayMethod()) || "WX".equals(payMethodReqDto.getPayMethod()) || "ZFB".equals(payMethodReqDto.getPayMethod()) || "DJB".equals(payMethodReqDto.getPayMethod()) || "OFFLINE_ACCOUNT_PAY".equals(payMethodReqDto.getPayMethod()) || "STORED_AMOUNT_PAY".equals(payMethodReqDto.getPayMethod())) {
            payMethodBo.setPayType("offLine");
        }
        if (!payMethodBo.isChildPay()) {
            payMethodBo = this.payService.packPayInfo(payMethodBo, payMethodReqDto);
            PayRequest request = this.payService.packPayRequest(payMethodReqDto);
            payMethodBo.setPayRequest(request);
        }
        payMethodBo = this.payRecordActionExtPt.packBo(payMethodBo, payMethodReqDto);
        return payMethodBo;
    }

    private PayMethodReqDto validate(PayMethodReqDto payMethodReq) {
        if ("2".equals(payMethodReq.getIsDefined())) {
            Assert.notNull((Object)payMethodReq.getStoreId(), "storeId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)payMethodReq.getAppId(), "appId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)payMethodReq.getAppName(), "appName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        payMethodReq = this.payRecordActionExtPt.validate(payMethodReq);
        return payMethodReq;
    }
}

