/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ActionResult;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.flow.RefundNotifyDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RefundNotifyBo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ContextUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.RefundCreateBo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="refundFlowAction")
@ActionNodeComponent
public class RefundFlowAction {
    private static Logger logger = LoggerFactory.getLogger(RefundFlowAction.class);
    @CubeResource
    private IRefundActionExtPt refundActionExtPt;
    @Resource
    private ReturnDas returnDas;
    @Autowired
    ICreateTradeService createTradeService;
    @Resource
    private IContextService contextService;
    @Resource
    private IPayService payService;
    @Resource
    private RefundDas refundDas;
    @Autowired
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Resource
    private RefundItemDas refundItemDas;
    @Resource
    private ReturnItemDas returnItemDas;

    @ActionNode(entity=RefundEo.class, name="\u53d1\u8d77\u9000\u6b3e")
    @Transactional(rollbackFor={Exception.class})
    public RefundCreateBo doRefundAction(RefundCreateBo refundCreateBo) {
        RefundReqDto refundReqDto = refundCreateBo.getRefundReqDto();
        if (refundReqDto != null) {
            refundReqDto = (RefundReqDto)EoUtil.transformExtFieldsToDto((BaseVo)refundReqDto, (Class)this.refundActionExtPt.getDtoClass());
            refundCreateBo.setRefundReqDto(refundReqDto);
        }
        refundCreateBo = this.validate(refundCreateBo);
        refundCreateBo = this.packBo(refundCreateBo, refundReqDto);
        refundCreateBo = this.save(refundCreateBo, refundReqDto);
        refundCreateBo = this.postProcessor(refundCreateBo, refundReqDto);
        return refundCreateBo;
    }

    private RefundCreateBo postProcessor(RefundCreateBo refundCreateBo, RefundReqDto refundReqDto) {
        if (refundCreateBo.getRefundRequest() != null) {
            try {
                RefundResponse refundOrder = this.createTradeService.createRefundOrder(refundCreateBo.getRefundRequest());
                Object successResult = ResponseUtil.getSuccessResult(refundOrder);
                logger.info("\u53d1\u8d77\u652f\u4ed8\u7ed3\u679c={}", (Object)JSON.toJSONString(successResult));
            }
            catch (VerifyException e) {
                logger.error("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", (Throwable)e);
                throw new BizException("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
            }
        }
        return this.refundActionExtPt.postProcessor(refundCreateBo, refundReqDto);
    }

    private RefundCreateBo save(RefundCreateBo refundCreateBo, RefundReqDto refundReqDto) {
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(refundCreateBo.getReturnEo().getSaleChannel())) {
            RefundEo refundEo = refundCreateBo.getRefundEo();
            if (null != refundEo) {
                this.refundDas.insert((BaseEo)refundEo);
            }
            this.saveRefundItem(refundEo.getReturnNo());
        }
        return this.refundActionExtPt.save(refundCreateBo, refundReqDto);
    }

    private void saveRefundItem(String returnNo) {
        List returnItemEos = this.returnItemDas.getReturnItemEos(Arrays.asList(returnNo));
        if (CollectionUtils.isNotEmpty((Collection)returnItemEos)) {
            List<RefundItemEo> refundItems = BeanUtil.copyList(returnItemEos, RefundItemEo.class);
            refundItems.forEach(vo -> vo.setId(null));
            this.refundItemDas.insertBatch(refundItems);
        }
    }

    private RefundCreateBo packBo(RefundCreateBo refundCreateBo, RefundReqDto refundReqDto) {
        PayRecordEo payRecordEo = refundCreateBo.getPayRecordEo();
        RefundEo refundEo = new RefundEo();
        refundEo.setRefundTime(new Date());
        refundEo.setReturnNo(refundReqDto.getReturnNo());
        refundEo.setRefundNo(this.refundActionExtPt.generateRefundNo(refundCreateBo));
        refundEo.setTradeNo(refundEo.getRefundNo());
        refundEo.setRefundItemAmount(refundReqDto.getRefundTotalAmount());
        refundEo.setCreateTime(new Date());
        refundEo.setRefundPaymentType("1");
        refundEo.setRefundTotalAmount(refundReqDto.getRefundTotalAmount());
        refundEo.setRefundFreightAmount(BigDecimal.ZERO);
        refundEo.setDiscountRefundAmount(BigDecimal.ZERO);
        if (StringUtils.isNotEmpty((CharSequence)refundCreateBo.getReturnEo().getShopId())) {
            refundEo.setShopId(Long.valueOf(Long.parseLong(refundCreateBo.getReturnEo().getShopId())));
        }
        RefundRequest refundRequest = null;
        if (null != payRecordEo) {
            if (StringUtils.isEmpty((CharSequence)ContextUtil.getInstanceId())) {
                this.contextService.getAndSetInstanceInfo(payRecordEo.getInstanceId());
            }
            refundEo.setPayMethod(payRecordEo.getPayMethod());
            refundEo.setPayNo(payRecordEo.getPayNo());
            refundEo.setInstanceId(payRecordEo.getInstanceId());
            refundEo.setTenantId(payRecordEo.getTenantId());
            PayRefundReqDto payRefundReqDto = new PayRefundReqDto();
            payRefundReqDto.setTradeNo(refundEo.getTradeNo());
            payRefundReqDto.setPayNo(refundEo.getPayNo());
            payRefundReqDto.setInstanceId(payRecordEo.getInstanceId());
            payRefundReqDto.setTenantId(payRecordEo.getTenantId());
            payRefundReqDto.setExtlPaySerial(payRecordEo.getExtlPaySerial());
            payRefundReqDto.setAmount(refundEo.getRefundTotalAmount());
            payRefundReqDto.setUserId(payRecordEo.getUserId());
            String extension = payRecordEo.getExtension();
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                JSONObject json = JSON.parseObject((String)extension);
                payRefundReqDto.setStoreId(json.getString("storeId"));
                payRefundReqDto.setAppId(json.getString("appId"));
                payRefundReqDto.setAppName(json.getString("appName"));
            }
            refundRequest = this.payService.buildRefundRequest(payRefundReqDto);
        }
        refundCreateBo.setRefundEo(refundEo);
        refundCreateBo.setRefundRequest(refundRequest);
        return this.refundActionExtPt.packBo(refundCreateBo, refundReqDto);
    }

    private RefundCreateBo validate(RefundCreateBo refundCreateBo) {
        if (refundCreateBo.getPayRecordEo() == null) {
            RefundReqDto refundReqDto = refundCreateBo.getRefundReqDto();
            ReturnEo returnEo = refundCreateBo.getReturnEo();
            if (returnEo == null) {
                returnEo = this.returnDas.selectByTradeNo(refundReqDto.getReturnNo());
            }
            if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
                List<PayRecordEo> payRecordEos = this.payService.getPayRecordSuccessByOrderNo(returnEo.getOrderTradeNo());
                if (CollectionUtils.isEmpty(payRecordEos)) {
                    throw new BizException("\u627e\u4e0d\u5230\u6210\u529f\u652f\u4ed8\u8bb0\u5f55");
                }
                PayRecordEo payRecordEo = payRecordEos.get(0);
                if (StringUtils.isNotEmpty((CharSequence)payRecordEo.getParentPayNo()) && !payRecordEo.getParentPayNo().equals("0")) {
                    payRecordEo = this.payService.getPayRecordByTradeNo(payRecordEo.getParentPayNo());
                }
                Optional.ofNullable(payRecordEo).map(p -> {
                    if (!(p.getPayStatus().equals(PayStatusEnum.SUCCESS.getName()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getMsg()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getCode()))) {
                        throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getMsg());
                    }
                    return p;
                }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
                refundCreateBo.setReturnEo(returnEo);
                refundCreateBo.setPayRecordEos(payRecordEos);
                refundCreateBo.setPayRecordEo(payRecordEo);
            }
        }
        return this.refundActionExtPt.validate(refundCreateBo);
    }

    @ActionNode(entity=RefundEo.class, name="\u7b49\u5f85\u9000\u6b3e\u7ed3\u679c", results={@ActionResult(code="success", desc="\u9000\u6b3e\u6210\u529f"), @ActionResult(code="fail", desc="\u9000\u6b3e\u5931\u8d25")})
    @Transactional(rollbackFor={Exception.class})
    public RefundNotifyBo handleRefundNotifyAction(RefundNotifyBo refundNotifyBo) {
        RefundNotifyDto refundNotifyDto = refundNotifyBo.getRefundNotifyDto();
        RefundEo refundEo = refundNotifyBo.getRefundEo();
        if (RefundResultEnum.S.getName().equals(refundNotifyDto.getRefundStatus())) {
            refundEo.setExtlRefundSerail(refundNotifyDto.getExtlRefundId());
            refundNotifyBo.setRefundResult(RefundStatusEnum.SUCCESS.getName());
            this.marketOrderTradeStatusProducer.sendOrderReturnSuccessMessageToMarket(refundEo.getReturnNo());
        } else {
            refundNotifyBo.setRefundResult(RefundStatusEnum.FAIL.getName());
        }
        refundNotifyBo.setReturnNo(refundEo.getReturnNo());
        return refundNotifyBo;
    }

    public RefundNotifyBo checkIsNotifyReturn(RefundNotifyBo refundNotifyBo) {
        RefundEo refundEo = refundNotifyBo.getRefundEo();
        if (StringUtils.isNotEmpty((CharSequence)refundEo.getReturnNo())) {
            refundNotifyBo.setIfNotify("TRUE");
        } else {
            refundNotifyBo.setIfNotify("FALSE");
        }
        return refundNotifyBo;
    }
}

