/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnCreateBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="returnRefundFlowAction")
@ActionNodeComponent
public class ReturnRefundFlowAction {
    private Logger logger = LoggerFactory.getLogger(ReturnRefundFlowAction.class);
    @CubeResource
    private IReturnRefundActionExtPt returnRefundActionExtPt;
    @Resource
    private IOrderService orderService;
    @Autowired
    IPayService payService;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private ReturnItemDas returnItemDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private IAreaQueryApi areaQueryApi;

    @ActionNode(entity=ReturnEo.class, name="\u53d1\u8d77\u552e\u540e")
    @Transactional(rollbackFor={Exception.class})
    public ReturnCreateBo doReturn(ReturnCreateBo returnCreateBo) {
        ReturnReqDto returnReqDto = returnCreateBo.getReturnReqDto();
        returnReqDto = (ReturnReqDto)EoUtil.transformExtFieldsToDto((BaseVo)returnReqDto, (Class)this.returnRefundActionExtPt.getDtoClass());
        returnCreateBo.setReturnReqDto(returnReqDto);
        returnCreateBo.setReturnType(returnCreateBo.getReturnReqDto().getReturnType());
        if (null != returnCreateBo.getFlag() && returnCreateBo.getFlag().booleanValue()) {
            return this.returnRefundActionExtPt.dealWithoutOrderNo(returnCreateBo);
        }
        if (null != returnCreateBo.getUncertainlyItemFlag() && returnCreateBo.getUncertainlyItemFlag().booleanValue()) {
            return this.returnRefundActionExtPt.dealWithUncertaintyItem(returnCreateBo);
        }
        ReturnCreateBo returnBo = this.validate(returnCreateBo, returnReqDto);
        returnBo = this.packBo(returnBo, returnReqDto);
        returnBo = this.save(returnBo, returnReqDto);
        return this.postProcessor(returnBo, returnReqDto);
    }

    private ReturnCreateBo postProcessor(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        return this.returnRefundActionExtPt.postProcessor(returnBo, returnReqDto);
    }

    private ReturnCreateBo save(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        if (null != returnBo.getReturnEo()) {
            this.returnDas.insert((BaseEo)returnBo.getReturnEo());
        }
        if (CollectionUtils.isNotEmpty((Collection)returnBo.getReturnItemEos())) {
            this.returnItemDas.insertBatch(returnBo.getReturnItemEos());
        }
        return this.returnRefundActionExtPt.save(returnBo, returnReqDto);
    }

    private ReturnCreateBo packBo(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        if (returnBo.ifUseFlow()) {
            returnReqDto.setTradeNo(returnBo.getCurrentFlowNo());
        } else {
            returnReqDto.setTradeNo(TradeUtil.generateTradeNo(returnReqDto.getOrderTradeNo()));
        }
        OrderEo orderEo = this.orderService.getByOrderNo(returnReqDto.getOrderTradeNo());
        ReturnEo returnEo = new ReturnEo();
        if (returnBo.ifUseFlow()) {
            returnEo.setFlowDefId(returnBo.getCurrentFlowDefId());
        }
        CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnReqDto, (String[])new String[0]);
        returnEo.setTradeNo(returnReqDto.getTradeNo());
        returnEo.setReturnNo(returnReqDto.getTradeNo());
        this.copyRedundancyAttribute(returnEo, orderEo);
        if (StringUtils.isNotBlank((String)returnReqDto.getDeviceType())) {
            returnEo.setDeviceType(returnReqDto.getDeviceType());
        }
        returnBo.setReturnEo(returnEo);
        returnBo.setOrderEo(orderEo);
        HashMap<String, BigDecimal> itemFreightMap = new HashMap<String, BigDecimal>();
        this.setSkuRatio(itemFreightMap, orderEo);
        Integer gift = 0;
        HashMap map = new HashMap();
        List returnItemEos = returnReqDto.getAfterSalesItems().stream().map(bean -> {
            AfterSalesItemReqDto afterSalesItemReqDto = (AfterSalesItemReqDto)EoUtil.transformExtFieldsToDto((BaseVo)bean, (Class)this.returnRefundActionExtPt.getDetailDtoClass());
            ReturnItemEo returnItemEo = new ReturnItemEo();
            TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeNoAndTradeItemNo(returnReqDto.getOrderTradeNo(), bean.getTradeItemNo());
            BigDecimal rebateAmount = tradeItemEo.getRebateAmount() == null ? BigDecimal.ZERO : tradeItemEo.getRebateAmount();
            BigDecimal divide = rebateAmount.divide(BigDecimal.valueOf(tradeItemEo.getItemNum().intValue()), 1);
            BeanUtils.copyProperties((Object)tradeItemEo, (Object)returnItemEo);
            returnItemEo.setId(null);
            returnItemEo.setTradeItemId(tradeItemEo.getId());
            returnItemEo.setItemId(tradeItemEo.getItemSerial());
            returnItemEo.setBrandId(tradeItemEo.getBrandSerial());
            returnItemEo.setSkuSerial(tradeItemEo.getSkuSerial());
            returnItemEo.setReturnNo(returnEo.getReturnNo());
            returnItemEo.setGift(tradeItemEo.getGift());
            returnItemEo.setItemNum(afterSalesItemReqDto.getItemNum());
            returnItemEo.setReturnRebate(divide.multiply(BigDecimal.valueOf(afterSalesItemReqDto.getItemNum().intValue())));
            if (!itemFreightMap.isEmpty() && gift.equals(tradeItemEo.getGift())) {
                this.logger.info("\u8ba2\u5355\u4e0d\u662f\u5305\u90ae\u4e14\u5546\u54c1\u4e0d\u662f\u8d60\u54c1\uff0c\u5f00\u59cb\u8ba1\u7b97\u9000\u8fd0\u8d39");
                BigDecimal freight = (BigDecimal)itemFreightMap.get(tradeItemEo.getSkuSerial());
                this.logger.info("\u5546\u54c1:{}\u7684\u603b\u8fd0\u8d39:{}", (Object)tradeItemEo.getSkuSerial(), (Object)freight);
                if (null != freight) {
                    BigDecimal decimal = freight.divide(new BigDecimal(tradeItemEo.getItemNum())).setScale(2, 4);
                    this.logger.info("\u5546\u54c1:{}\u7684\u5355\u4ef6\u8fd0\u8d39:{}", (Object)tradeItemEo.getSkuSerial(), (Object)decimal);
                    BigDecimal freightAmount = BigDecimal.ZERO;
                    if (null == returnItemEo.getReturnedNum()) {
                        if (afterSalesItemReqDto.getItemNum().equals(tradeItemEo.getItemNum())) {
                            returnItemEo.setReturnFreightAmount(freight);
                        } else {
                            freightAmount = decimal.multiply(new BigDecimal(afterSalesItemReqDto.getItemNum())).setScale(2, 4);
                            returnItemEo.setReturnFreightAmount(freightAmount);
                        }
                    } else {
                        Integer returnedNum = returnItemEo.getReturnedNum() + afterSalesItemReqDto.getItemNum();
                        if (returnedNum.equals(tradeItemEo.getItemNum())) {
                            freightAmount = freight.subtract(decimal.multiply(new BigDecimal(returnItemEo.getReturnedNum())).setScale(2, 4));
                            returnItemEo.setReturnFreightAmount(freightAmount);
                        } else if (returnedNum < tradeItemEo.getItemNum()) {
                            freightAmount = decimal.multiply(new BigDecimal(afterSalesItemReqDto.getItemNum())).setScale(2, 4);
                            returnItemEo.setReturnFreightAmount(freightAmount);
                        }
                    }
                    this.logger.info("\u5546\u54c1:{}\u7684\u8981\u9000\u7684\u8fd0\u8d39:{}", (Object)tradeItemEo.getSkuSerial(), (Object)returnItemEo.getReturnFreightAmount());
                }
            }
            returnItemEo.setRefundAmount(tradeItemEo.getItemPrice());
            map.put(tradeItemEo.getSkuSerial(), afterSalesItemReqDto);
            returnItemEo.setIfExchange(afterSalesItemReqDto.getIfExchange());
            returnItemEo.setIsCombinedPackage(afterSalesItemReqDto.getIsCombinedPackage());
            returnItemEo.setCombinedPackageActivityId(afterSalesItemReqDto.getCombinedPackageActivityId());
            return returnItemEo;
        }).collect(Collectors.toList());
        BigDecimal totalRebate = returnItemEos.stream().map(item -> item.getReturnRebate() == null ? BigDecimal.ZERO : item.getReturnRebate()).reduce(BigDecimal.ZERO, BigDecimal::add);
        returnEo.setReturnRebate(totalRebate);
        BigDecimal totalFreightAmount = returnItemEos.stream().filter(returnItemEo -> null != returnItemEo.getReturnFreightAmount()).map(ReturnItemEo::getReturnFreightAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        returnEo.setReturnFreightAmount(totalFreightAmount);
        returnBo.setReturnEo(returnEo);
        returnBo.setSalesItemReqDtoMap(map);
        returnBo.setReturnItemEos(returnItemEos);
        return this.returnRefundActionExtPt.packBo(returnBo, returnReqDto);
    }

    public void setSkuRatio(Map<String, BigDecimal> itemFreightMap, OrderEo orderEo) {
        this.logger.info("\u8981\u7533\u8bf7\u552e\u540e\u7684\u8ba2\u5355:{} \u7684\u8ba2\u5355\u72b6\u6001:{}", (Object)orderEo.getOrderNo(), (Object)orderEo.getOrderTradeStatus());
        if (("WAIT_DELIVERY".equals(orderEo.getOrderTradeStatus()) || "WAIT_AUDIT".equals(orderEo.getOrderTradeStatus())) && null != orderEo.getFreightAmount() && orderEo.getFreightAmount().compareTo(BigDecimal.ZERO) > 0) {
            this.logger.info("\u8ba2\u5355\u4e0d\u662f\u5305\u90ae\uff0c\u5f00\u59cb\u8ba1\u7b97\u9000\u8fd0\u8d39");
            List<TradeItemEo> tradeItemEoList = this.tradeItemService.queryByTradeNo(orderEo.getOrderNo());
            if (CollectionUtils.isNotEmpty(tradeItemEoList)) {
                Integer gift = 0;
                BigDecimal totalAmount = tradeItemEoList.stream().filter(item -> gift.equals(item.getGift())).map(StdTradeItemEo::getPayTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<String, BigDecimal> itemMap = tradeItemEoList.stream().filter(item -> gift.equals(item.getGift())).collect(Collectors.toMap(StdTradeItemEo::getSkuSerial, StdTradeItemEo::getPayTotalAmount));
                ArrayList<TradeItemEo> tradeItemEos = new ArrayList<TradeItemEo>();
                if (itemMap.isEmpty()) {
                    return;
                }
                for (String key : itemMap.keySet()) {
                    TradeItemEo tradeItemEo = new TradeItemEo();
                    tradeItemEo.setSkuSerial(key);
                    BigDecimal payAmount = itemMap.get(key);
                    BigDecimal ratio = payAmount.divide(totalAmount, 2, 4);
                    BigDecimal freight = ratio.multiply(orderEo.getFreightAmount()).setScale(2, 4);
                    tradeItemEo.setPayTotalAmount(freight);
                    itemFreightMap.put(key, freight);
                    tradeItemEos.add(tradeItemEo);
                }
                TradeItemEo itemEo = tradeItemEos.stream().max(Comparator.comparing(A -> A.getPayTotalAmount())).get();
                BigDecimal decimal = tradeItemEos.stream().filter(item -> null != item.getPayTotalAmount()).map(StdTradeItemEo::getPayTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal oldRatioFreight = BigDecimal.ZERO;
                if (decimal.compareTo(orderEo.getFreightAmount()) == 1) {
                    oldRatioFreight = itemFreightMap.get(itemEo.getSkuSerial());
                    itemFreightMap.put(itemEo.getSkuSerial(), oldRatioFreight.subtract(decimal.subtract(orderEo.getFreightAmount())));
                } else if (decimal.compareTo(orderEo.getFreightAmount()) == -1) {
                    oldRatioFreight = itemFreightMap.get(itemEo.getSkuSerial());
                    itemFreightMap.put(itemEo.getSkuSerial(), oldRatioFreight.add(orderEo.getFreightAmount().subtract(decimal)));
                }
            }
        }
    }

    private void copyRedundancyAttribute(ReturnEo returnEo, OrderEo orderEo) {
        returnEo.setOrderTradeNo(orderEo.getTradeNo());
        returnEo.setBizStatus(ReturnStatusEnum.INIT.getName());
        returnEo.setDeviceType(orderEo.getDeviceType());
        returnEo.setSellerSrc(orderEo.getSellerSrc());
        returnEo.setSellerId(orderEo.getSellerId());
        returnEo.setShopType(orderEo.getShopType());
        returnEo.setShopId(orderEo.getShopId());
        returnEo.setUserSrc(orderEo.getUserSrc());
        returnEo.setUserId(orderEo.getUserId());
        returnEo.setSaleChannel(orderEo.getSaleChannel());
        returnEo.setMktChannel(orderEo.getMktChannel());
        returnEo.setOrganizationId(orderEo.getOrganizationId());
        returnEo.setOrganizationName(orderEo.getOrganizationName());
    }

    private ReturnCreateBo validate(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        if (ReturnTypeEnum.getByName((String)returnReqDto.getReturnType()) == null) {
            throw new BizException(TradeExceptionCode.RETURN_TYPE_ERROR.getCode(), TradeExceptionCode.RETURN_TYPE_ERROR.getMsg());
        }
        returnBo.setReturnReqDto(returnReqDto);
        this.returnRefundActionExtPt.validate(returnBo);
        return returnBo;
    }
}

