/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.utils.RandomUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CreateOrderDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.CreateDeliveryOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderDeliveryCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryCreateBo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@CubeExtImpl(name="C\u7aef\u751f\u6210\u53d1\u8d27\u5355\u6269\u5c55", descr="C\u7aef\u751f\u6210\u53d1\u8d27\u5355\u6269\u5c55")
public class CreateOrderDeliveryBBCExtImpl
implements IOrderDeliveryCreateActionExtPt {
    private static Logger logger = LoggerFactory.getLogger(CreateOrderDeliveryBBCExtImpl.class);
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    protected OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private TradeItemDas tradeItemDas;
    @Autowired
    private CreateDeliveryOrderFlowAction createDeliveryOrderAction;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IWarehouseQueryApi warehouseQueryApi;

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_DELIVERY.getFlowId();
    }

    public String getFlowDefName() {
        return BaseFlowDef.BASE_DELIVERY.getFlowName();
    }

    public Class getDtoClass() {
        return OrderDeliveryCreateBo.class;
    }

    public CreateOrderDeliveryReqDto validate(CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        return createOrderDeliveryReqDto;
    }

    public OrderDeliveryCreateBo packBo(OrderDeliveryCreateBo orderDeliveryCreateBo, CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        Integer warehouseType;
        OrderDeliveryEo orderDeliveryEo = orderDeliveryCreateBo.getOrderDeliveryEo();
        TradeItemEo tradeItemSelect = TradeItemEo.newInstance();
        tradeItemSelect.setTradeNo(orderDeliveryCreateBo.getOrderEo().getOrderNo());
        List tradeItemEos = this.tradeItemDas.select((BaseEo)tradeItemSelect, Integer.valueOf(0), Integer.valueOf(1024));
        BigDecimal itemAmount = BigDecimal.ZERO;
        BigDecimal actualItemAmount = BigDecimal.ZERO;
        for (TradeItemEo tradeItemEo : tradeItemEos) {
            itemAmount = itemAmount.add(tradeItemEo.getItemOrigPrice().multiply(new BigDecimal(tradeItemEo.getItemNum())));
            actualItemAmount = itemAmount.add(tradeItemEo.getItemPrice().multiply(new BigDecimal(tradeItemEo.getItemNum())));
        }
        BigDecimal discountAmount = itemAmount.subtract(actualItemAmount);
        orderDeliveryEo.setItemAmount(itemAmount);
        orderDeliveryEo.setDiscountAmount(discountAmount);
        orderDeliveryEo.setFreightAmount(orderDeliveryCreateBo.getOrderEo().getFreightAmount());
        orderDeliveryEo.setArAmount(itemAmount);
        orderDeliveryEo.setGotAmount(itemAmount);
        logger.info("\u63a5\u6536\u5230\u6839\u636e\u5546\u57ce\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\u4fe1\u606f --> \u8bbe\u7f6e\u4ea4\u6613\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u8ba2\u5355\u7ec4\u7ec7id\u6216\u5e97\u94fa\u7ec4\u7ec7id)(bbc\u5546\u573a) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[CreateOrderDeliveryBBCExtImpl].[packBo]", (Object)JSONObject.toJSONString((Object)orderDeliveryEo));
        ArrayList orderDeliveryList = Lists.newArrayList((Object[])new OrderDeliveryEo[]{orderDeliveryCreateBo.getOrderDeliveryEo()});
        List<DeliveryItemEo> deliveryItemEos = this.orderDeliveryService.handleDeliveryItems(tradeItemEos, orderDeliveryList);
        orderDeliveryCreateBo.setDeliveryItemEoList(deliveryItemEos);
        if (orderDeliveryCreateBo.getOrderDeliveryEo().getCycleBuy().booleanValue()) {
            List<OrderDeliveryEo> orderDeliveryEoList = this.orderDeliveryService.buildCycleOrderDelivery(orderDeliveryCreateBo.getOrderEo().getOrderNo(), orderDeliveryCreateBo.getOrderDeliveryEo(), createOrderDeliveryReqDto.getDeliveryPlanCycleDtoList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderDeliveryEoList)) {
                for (OrderDeliveryEo orderDelivery : orderDeliveryEoList) {
                    OrderDeliveryCreateBo orderDeliveryCreateCycle = new OrderDeliveryCreateBo();
                    BeanUtils.copyProperties((Object)orderDeliveryCreateBo, (Object)orderDeliveryCreateCycle);
                    orderDeliveryCreateCycle.setOrderDeliveryEo(orderDelivery);
                    orderDeliveryCreateCycle.setShippingType(DeliveryStatusEnum.TO_RECEIVING.getStatus());
                    RefDeliveryOrderEo refDeliveryOrder = this.orderDeliveryService.handleRefDeliveryOrder(orderDelivery, orderDeliveryCreateBo.getOrderEo());
                    orderDeliveryCreateCycle.setRefDeliveryOrderEo(refDeliveryOrder);
                    orderDeliveryCreateCycle.setStartFlowParam(orderDeliveryCreateBo.getCurrentFlowDefId(), orderDeliveryCreateBo.getCurrentFlowName());
                    this.createDeliveryOrderAction.create(orderDeliveryCreateCycle);
                }
            }
            orderDeliveryCreateBo.setDeliveryItemEoList(null);
            orderDeliveryCreateBo.setOrderDeliveryEo(null);
            orderDeliveryCreateBo.setRefDeliveryOrderEo(null);
        }
        OrderEo orderEo = orderDeliveryCreateBo.getOrderEo();
        OrderAddressReqDto orderAddressReqDto = (OrderAddressReqDto)JSON.parseObject((String)orderEo.getDeliveryAddress(), OrderAddressReqDto.class);
        Boolean autoReceive = orderDeliveryCreateBo.getAutoReceive();
        if (ShippingTypeEnum.PICKUP.getType().equals(orderDeliveryEo.getShippingType())) {
            orderDeliveryEo.setPickUpTime(orderAddressReqDto != null ? orderAddressReqDto.getDeliveryTime() : "");
            this.setOrderDeliveryPickUpCode(orderDeliveryEo);
            warehouseType = 2;
        } else if (ShippingTypeEnum.INTRA_CITY.getType().equals(orderDeliveryEo.getShippingType())) {
            orderDeliveryEo.setPickUpTime(orderAddressReqDto != null ? orderAddressReqDto.getDeliveryTime() : "");
            if (autoReceive.booleanValue()) {
                orderDeliveryEo.setShippingCompanyCode("0");
                orderDeliveryEo.setShippingCompany("\u5546\u5bb6\u81ea\u914d\u9001");
            }
            warehouseType = 2;
        } else {
            warehouseType = 1;
        }
        List shopWarehouses = (List)this.shopQueryApi.queryShopWarehouseByShopId(Long.valueOf(orderEo.getShopId()), warehouseType).getData();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopWarehouses)) {
            shopWarehouses = (List)this.shopQueryApi.queryShopWarehouseByShopId(Long.valueOf(orderEo.getShopId()), null).getData();
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopWarehouses)) {
            orderDeliveryEo.setWarehouseCode(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseCode());
            orderDeliveryEo.setWarehouseSerial(String.valueOf(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseId()));
            orderDeliveryEo.setWarehouseName(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseName());
            WarehouseRespDto warehouseRespDto = (WarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.warehouseQueryApi.queryWarehouseById(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseId(), null));
            if (warehouseRespDto != null) {
                orderDeliveryEo.setWarehouseOrganizationId(warehouseRespDto.getOrganizationId());
                orderDeliveryEo.setWarehouseOrganizationName(warehouseRespDto.getOrganizationName());
            }
            logger.info("\u63a5\u6536\u5230\u6839\u636e\u5546\u57ce\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\u4fe1\u606f --> \u8bbe\u7f6e\u5e93\u5b58\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u4ed3\u5e93id)(bbc\u5546\u573a) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[CreateDeliveryOrderFlowAction].[packBo]", (Object)JSONObject.toJSONString((Object)orderDeliveryEo));
        } else {
            logger.warn("\u751f\u6210\u53d1\u8d27\u5355\u672a\u627e\u5230\u5bf9\u5e94\u4ed3\u7684\u5e93\u4fe1\u606f\uff0cshopId\uff1a{}, warehouseType:{} (\u914d\u9001\u4ed3\u5e93\u914d\u578b,1-\u7ebf\u4e0a\u4e1a\u52a1\uff0c2-o2o\u4e1a\u52a1)", (Object)orderEo.getShopId(), (Object)warehouseType);
        }
        return orderDeliveryCreateBo;
    }

    public OrderDeliveryCreateBo save(OrderDeliveryCreateBo orderDeliveryCreateBo, CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        return orderDeliveryCreateBo;
    }

    public OrderDeliveryCreateBo postProcessor(OrderDeliveryCreateBo orderDeliveryCreateBo, CreateOrderDeliveryReqDto createOrderDeliveryReqDto) {
        return orderDeliveryCreateBo;
    }

    private OrderDeliveryEo setOrderDeliveryPickUpCode(OrderDeliveryEo orderDeliveryEo) {
        logger.info("\u8bbe\u7f6e\u53d1\u8d27\u5355\u7684\u63d0\u8d27\u7801: deliverNo={}", (Object)orderDeliveryEo.getDeliveryNo());
        int i = 0;
        do {
            String pickUpCode = RandomUtil.generateNumberString((int)6);
            OrderDeliveryEo paramEo = OrderDeliveryEo.newInstance();
            paramEo.setPickUpCode(pickUpCode);
            List eoList = this.orderDeliveryDas.selectList((BaseEo)paramEo);
            if (CollectionUtils.isEmpty((Collection)eoList)) {
                orderDeliveryEo.setPickUpCode(pickUpCode);
                continue;
            }
            if (!CollectionUtils.isEmpty(eoList = eoList.stream().filter(eo -> !Arrays.asList(DeliveryStatusEnum.SIGNED.getStatus(), DeliveryStatusEnum.FINISHED.getStatus()).contains(eo.getDeliveryStatus())).collect(Collectors.toList()))) continue;
            orderDeliveryEo.setPickUpCode(pickUpCode);
        } while (++i < 10 && StringUtils.isBlank((CharSequence)orderDeliveryEo.getPickUpCode()));
        return orderDeliveryEo;
    }
}

