/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryStoreReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.vo.OrderDeliverMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.vo.SalePersonMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.PerformanceProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderAddressService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.impl.DeliveryServiceImpl;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliverySellerDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliverySenderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PackageItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliverySellerEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliverySenderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PackageItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IDeliveryRecordActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryStoreBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="C\u7aef\u53d1\u8d27\u6269\u5c55", descr="C\u7aef\u53d1\u8d27\u6269\u5c55")
public class DeliveryRecordActionBBCExtPtImpl
implements IDeliveryRecordActionExtPt {
    @Autowired
    private DeliverySenderDas deliverySenderDas;
    @Autowired
    private DeliverySellerDas deliverySellerDas;
    @Autowired
    private PackageItemDas packageItemDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private ICacheService commonCacheService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private PerformanceProducer performanceProducer;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Resource
    private DeliveryRecordDas deliveryRecordDas;
    @Resource
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Resource
    private IDeliveryService deliveryService;
    @Resource
    private Environment environment;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private IOrderAddressService orderAddressService;
    private static Logger logger = LoggerFactory.getLogger(DeliveryServiceImpl.class);

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_DELIVERY.getFlowId();
    }

    public String getFlowDefName() {
        return BaseFlowDef.BASE_DELIVERY.getFlowName();
    }

    public Class getDtoClass() {
        return null;
    }

    public DeliveryStoreBo validate(DeliveryStoreBo deliveryStoreBo) {
        List deliveryItemEoList;
        DeliveryStoreReqDto deliveryStoreReqDto = deliveryStoreBo.getDeliveryStoreReqDto();
        if (StringUtils.isEmpty((CharSequence)deliveryStoreReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrderDeliveryEo orderDeliveryEo = deliveryStoreBo.getOrderDeliveryEo();
        if (ShippingTypeEnum.EXPRESS.getType().equals(orderDeliveryEo.getShippingType()) && StringUtils.isEmpty((CharSequence)deliveryStoreReqDto.getShippingCompanyCode())) {
            throw new BizException("\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List deliveryDetails = deliveryStoreReqDto.getDeliveryDetails();
        if (CollectionUtils.isEmpty((Collection)deliveryDetails)) {
            throw new BizException("\u53d1\u8d27\u5355\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String shippingType = orderDeliveryEo.getShippingType();
        if (!ShippingTypeEnum.PICKUP.getType().equals(shippingType) && CollectionUtils.isNotEmpty((Collection)(deliveryItemEoList = this.deliveryItemDas.queryByDeliveryNo(deliveryStoreReqDto.getDeliveryNo())))) {
            Map<Long, Integer> itemNumMap = deliveryItemEoList.stream().filter(deliveryItemEo -> deliveryItemEo.getItemNum() != null).collect(Collectors.toMap(BaseEo::getId, StdDeliveryItemEo::getItemNum));
            deliveryDetails.forEach(deliveryDetailReqDto -> {
                Integer itemNum = (Integer)itemNumMap.get(deliveryDetailReqDto.getDeliveryItemId());
                if (itemNum != null && itemNum.intValue() != deliveryDetailReqDto.getDeliveryNum().intValue()) {
                    String shippingTypeName = "";
                    if (ShippingTypeEnum.getByType((String)shippingType) != null) {
                        shippingTypeName = ShippingTypeEnum.getByType((String)shippingType).getShippingTypeName();
                    }
                    throw new BizException(String.format("[%s]\u53d1\u8d27\u5355\u4e0d\u80fd\u8fdb\u884c\u90e8\u5206\u53d1\u8d27\u64cd\u4f5c", shippingTypeName));
                }
            });
        }
        return deliveryStoreBo;
    }

    public DeliveryStoreBo packBo(DeliveryStoreBo deliveryStoreBo, DeliveryStoreReqDto deliveryStoreReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreReqDto.getSellers())) {
            ArrayList deliverySellerEos = new ArrayList();
            CubeBeanUtils.copyCollection(deliverySellerEos, (Collection)deliveryStoreReqDto.getSellers(), DeliverySellerEo.class);
            deliverySellerEos.stream().forEach(deliverySellerEo -> deliverySellerEo.setDeliveryNo(deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo()));
            deliveryStoreBo.setSellerEoList(deliverySellerEos);
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreReqDto.getSellers())) {
            RefDeliveryOrderEo queryDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
            queryDeliveryOrderEo.setDeliveryNo(deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
            RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)queryDeliveryOrderEo);
            if (StringUtils.isNotEmpty((CharSequence)refDeliveryOrderEo.getOrderNo())) {
                List salePersonMessageVos = deliveryStoreReqDto.getSellers().stream().map(bean -> {
                    SalePersonMessageVo salePersonMessageVo = new SalePersonMessageVo();
                    CubeBeanUtils.copyProperties((Object)salePersonMessageVo, (Object)bean, (String[])new String[0]);
                    salePersonMessageVo.setEmployeeNo(bean.getSellerCode());
                    salePersonMessageVo.setSellerName(bean.getSellerName());
                    return salePersonMessageVo;
                }).collect(Collectors.toList());
                OrderEo orderEo = this.orderService.queryByOrderNo(refDeliveryOrderEo.getOrderNo());
                OrderDeliverMessageVo messageVo = new OrderDeliverMessageVo();
                messageVo.setOrderNo(orderEo.getOrderNo());
                messageVo.setDeliverStatus(DeliverStatusEnum.DELIVER_SUCCESS.getCode());
                messageVo.setActualMoney(orderEo.getPayAmount());
                messageVo.setSalePersonMessageVoList(salePersonMessageVos);
                this.performanceProducer.sendPerformance(messageVo);
            }
        }
        if (null != deliveryStoreReqDto.getSender() && StringUtils.isNotBlank((CharSequence)deliveryStoreReqDto.getSender().getPhone())) {
            DeliverySenderEo deliverySenderEo = new DeliverySenderEo();
            CubeBeanUtils.copyProperties((Object)deliverySenderEo, (Object)deliveryStoreReqDto.getSender(), (String[])new String[0]);
            deliveryStoreBo.setDeliverySenderEo(deliverySenderEo);
        }
        ArrayList packageItemEos = new ArrayList();
        DeliveryItemEo deliveryItemSelect = new DeliveryItemEo();
        deliveryItemSelect.setDeliveryNo(deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
        List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        if (CollectionUtils.isEmpty((Collection)deliveryItemEos)) {
            String packageSerial = UUID.randomUUID().toString();
            deliveryItemEos.forEach(deliveryItemEo -> {
                PackageItemEo packageItemEo = new PackageItemEo();
                BeanUtils.copyProperties((Object)deliveryItemEo, (Object)packageItemEo);
                packageItemEo.setId(null);
                packageItemEo.setDeliveryNo(deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
                packageItemEo.setActualSkuSerial(deliveryItemEo.getSkuSerial());
                packageItemEo.setDeliveryType("NORMAL");
                packageItemEo.setActualDeliverySkuNum(deliveryItemEo.getItemNum());
                packageItemEo.setActualDeliveryNum(deliveryItemEo.getItemNum());
                packageItemEo.setPackageSerial(packageSerial);
                packageItemEo.setShippingCompany(deliveryStoreReqDto.getShippingCompany());
                packageItemEo.setShippingSerial(deliveryStoreReqDto.getExpressCode());
                packageItemEos.add(packageItemEo);
            });
            deliveryStoreBo.setPackageItemEos(packageItemEos);
        }
        RefDeliveryOrderEo refDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderEo.setDeliveryNo(deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderEo);
        deliveryStoreBo.setOrderNo(((RefDeliveryOrderEo)refDeliveryOrders.get(0)).getOrderNo());
        try {
            this.commonCacheService.delCache("DELIVERY_SF_CACHE_" + deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        List deliveryDetails = deliveryStoreReqDto.getDeliveryDetails();
        Map<Long, Integer> deliveryDetailNumMap = deliveryDetails.stream().collect(Collectors.toMap(DeliveryDetailReqDto::getDeliveryItemId, DeliveryDetailReqDto::getDeliveryNum));
        deliveryItemEos.forEach(deliveryItemEo -> {
            int deliveredNum = deliveryItemEo.getDeliveredNum() != null ? deliveryItemEo.getDeliveredNum() : 0;
            deliveryItemEo.setDeliveredNum(Integer.valueOf(deliveredNum + (Integer)deliveryDetailNumMap.get(deliveryItemEo.getId())));
        });
        deliveryStoreBo.setDeliveryItemEos(deliveryItemEos);
        Map<Long, DeliveryItemEo> deliveryItemEoMap = deliveryItemEos.stream().collect(Collectors.toMap(BaseEo::getId, eo -> eo));
        Date now = new Date();
        List deliveryRecordEos = deliveryDetails.stream().map(deliveryDetailReqDto -> {
            DeliveryRecordEo deliveryRecordEo = new DeliveryRecordEo();
            DeliveryItemEo deliveryItemEo = (DeliveryItemEo)deliveryItemEoMap.get(deliveryDetailReqDto.getDeliveryItemId());
            CubeBeanUtils.copyProperties((Object)deliveryRecordEo, (Object)deliveryItemEo, (String[])new String[]{"id"});
            deliveryRecordEo.setDeliveredNum(deliveryDetailReqDto.getDeliveryNum());
            deliveryRecordEo.setDeliveryTime(now);
            deliveryRecordEo.setCreateTime(now);
            deliveryItemEo.setUpdateTime(now);
            return deliveryRecordEo;
        }).collect(Collectors.toList());
        deliveryStoreBo.setDeliveryRecordEos(deliveryRecordEos);
        deliveryStoreBo.setDeliveryItemEos(deliveryItemEos);
        logger.info("\u53d1\u8d27\u5355\u662f\u5426\u5b8c\u6210\u53d1\u8d27: {}", (Object)deliveryStoreBo.getDeliveryResult());
        return deliveryStoreBo;
    }

    public DeliveryStoreBo save(DeliveryStoreBo deliveryStoreBo, DeliveryStoreReqDto deliveryStoreReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreBo.getSellerEoList())) {
            deliveryStoreBo.getSellerEoList().forEach(deliverySeller -> deliverySeller.setDeliveryNo(deliveryStoreReqDto.getDeliveryNo()));
            this.deliverySellerDas.insertBatch(deliveryStoreBo.getSellerEoList());
        }
        if (deliveryStoreBo.getDeliverySenderEo() != null) {
            this.deliverySenderDas.insert((BaseEo)deliveryStoreBo.getDeliverySenderEo());
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreBo.getPackageItemEos())) {
            this.packageItemDas.insertBatch(deliveryStoreBo.getPackageItemEos());
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreBo.getDeliveryItemEos())) {
            deliveryStoreBo.getDeliveryItemEos().forEach(deliveryItemEo -> this.deliveryItemDas.updateSelective((BaseEo)deliveryItemEo));
        }
        if (CollectionUtils.isNotEmpty((Collection)deliveryStoreBo.getDeliveryRecordEos())) {
            this.deliveryRecordDas.insertBatch(deliveryStoreBo.getDeliveryRecordEos());
        }
        deliveryStoreBo.setOptCode(DeliveryRouteOptEnum.DELIVER.getOptCode());
        deliveryStoreBo.setOptDesc("\u95e8\u5e97\uff08" + deliveryStoreBo.getOrderDeliveryEo().getWarehouseCode() + "-" + deliveryStoreBo.getOrderDeliveryEo().getWarehouseName() + "\uff09\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u53d1\u8d27");
        return deliveryStoreBo;
    }

    public DeliveryStoreBo postProcessor(DeliveryStoreBo deliveryStoreBo, DeliveryStoreReqDto deliveryStoreReqDto) {
        if (deliveryStoreBo.getOrderDeliveryEo().getCycleBuy() != null && deliveryStoreBo.getOrderDeliveryEo().getCycleBuy().booleanValue() && deliveryStoreBo.getOrderDeliveryEo().getDeliveryPlanId() != null) {
            logger.info("\u5468\u671f\u8d2d\u53d1\u8d27\u5355\u53d1\u8d27: {}", (Object)deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("DELIVERY_ORDER_DELIVERY_TAG"), (Object)deliveryStoreBo.getOrderDeliveryEo().getDeliveryNo());
        }
        OrderDeliveryEo orderDeliveryEo = deliveryStoreBo.getOrderDeliveryEo();
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(orderDeliveryEo.getChannel())) {
            this.marketOrderTradeStatusProducer.sendOrderDeliverySuccessMessageToMarket(deliveryStoreBo.getOrderDeliveryEo().getOrderNo());
        }
        if (ShippingTypeEnum.PICKUP.getType().equals(orderDeliveryEo.getShippingType())) {
            OrderDeliveryEo deliveryUpdateTemp = OrderDeliveryEo.newInstance();
            deliveryUpdateTemp.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            this.orderDeliveryService.setOrderDeliveryPickUpCode(deliveryUpdateTemp);
            deliveryStoreBo.getOrderDeliveryEo().setPickUpCode(deliveryUpdateTemp.getPickUpCode());
            logger.info("\u53d1\u8d27\u5355\u53d1\u8d27\u751f\u6210\u81ea\u63d0\u7801\uff0cdeliveryNo:{}, pickUpCode:{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)deliveryUpdateTemp.getPickUpCode());
            this.orderAddressService.updatePickupCodeByOrderNo(orderDeliveryEo.getOrderNo(), deliveryUpdateTemp.getPickUpCode());
        }
        return deliveryStoreBo;
    }
}

