/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayMethodEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnOrderStateChangeExtPt;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="\u6b63\u5927\u9879\u76ee-\u9000\u6b3e\u9000\u8d27\u5355\u72b6\u6001", descr="\u6b63\u5927\u9879\u76ee-\u9000\u6b3e\u9000\u8d27\u72b6\u6001\u53d8\u66f4\u901a\u77e5\u5b9a\u5236\u903b\u8f91\u5b9e\u73b0")
public class ReturnOrderStateChangeExtPtImpl
implements IReturnOrderStateChangeExtPt {
    private static final Logger logger = LoggerFactory.getLogger(ReturnOrderStateChangeExtPtImpl.class);
    @Autowired
    private IUserExtQueryApi userExtQueryApi;
    @Autowired
    private IAfterSalesService afterSalesService;
    @Autowired
    private ICommonsMqService commonsMqService;
    @Autowired
    private IPayService payService;

    public void notify(String returnNo, String orderTradeNo, String state) {
        logger.info("===> \u9000\u6b3e\u9000\u8d27\u5355\u72b6\u6001\u6269\u5c55\u70b9\u53c2\u6570\uff1a\u552e\u540e\u5355\u5355\u53f7:{}, \u4ea4\u6613\u8ba2\u5355\u5355\u53f7:{}, \u9000\u6b3e\u5355\u72b6\u6001:{}", new Object[]{returnNo, orderTradeNo, state});
        ReturnDetailRespDto returnDetail = this.afterSalesService.queryReturnDetail(returnNo, "{}");
        logger.info("===> \u83b7\u53d6\u552e\u540e\u9000\u8d27\u9000\u6b3e\u5355\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)returnDetail));
        if (returnDetail != null && returnDetail.getReturnOmniItemRespDtoList() != null) {
            Boolean flag = Boolean.FALSE;
            MessageVo messageVo = new MessageVo();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("tid", returnDetail.getOrderTradeNo());
            dataMap.put("oid", ((ReturnOmniItemRespDto)returnDetail.getReturnOmniItemRespDtoList().get(0)).getSkuCode());
            if (ReturnStatusEnum.AUDITING.getName().equals(state)) {
                dataMap.put("refund_state", 2);
                flag = Boolean.TRUE;
            } else if (ReturnStatusEnum.FINISH.getName().equals(state)) {
                dataMap.put("refund_state", 1);
                flag = Boolean.TRUE;
            }
            if (flag.booleanValue() && MapUtil.isNotEmpty(dataMap)) {
                messageVo.setData((Object)JSON.toJSONString(dataMap));
                logger.info("===> \u53d1\u9001\u552e\u540e\u9000\u6b3e\u9000\u8d27\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\uff0c\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)messageVo));
                MessageResponse messageResponse = this.commonsMqService.publishMessage("RETURN_ORDER_STATUS_CHANGE_TAG", (Object)messageVo);
                logger.info("===> \u53d1\u9001\u552e\u540e\u9000\u6b3e\u9000\u8d27\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\uff0c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)messageResponse));
            }
            logger.info("===> \u68c0\u67e5\u8ba2\u5355\u662f\u5426\u9000\u6b3e\u5b8c\u6210: {} <--> {}", (Object)orderTradeNo, (Object)this.afterSalesService.checkOrderReturnFinish(orderTradeNo));
            if (ReturnStatusEnum.FINISH.getName().equals(state)) {
                HashMap<String, Object> dataAfterSalesMap = new HashMap<String, Object>();
                if (ReturnTypeEnum.REFUND_ONLY.getName().equals(returnDetail.getReturnType())) {
                    dataAfterSalesMap.put("refund_type", 0);
                } else {
                    dataAfterSalesMap.put("refund_type", 1);
                }
                dataAfterSalesMap.put("refund_reason", returnDetail.getReturnReason());
                dataAfterSalesMap.put("shop_code", "006");
                RestResponse userDtoRest = this.userExtQueryApi.queryUserByIdIgnoreDr(ParamConverter.convertToLong((Object)returnDetail.getUserId()), null);
                dataAfterSalesMap.put("vip_code", ((UserDto)userDtoRest.getData()).getPhone());
                if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnDetail.getSaleChannel())) {
                    List<PayRecordEo> payRecordEos = this.payService.getPayRecordSuccessByOrderNo(returnDetail.getOrderTradeNo());
                    if (CollectionUtils.isEmpty(payRecordEos)) {
                        throw new BizException("\u627e\u4e0d\u5230\u6210\u529f\u652f\u4ed8\u8bb0\u5f55");
                    }
                    PayRecordEo payRecordEo = payRecordEos.get(0);
                    String payMethod = PayMethodEnum.getByCode((String)payRecordEo.getPayMethod()).getName();
                    dataAfterSalesMap.put("payment_type_code", StringUtils.isNotBlank((CharSequence)payMethod) ? payMethod : payRecordEo.getPayMethod());
                    dataAfterSalesMap.put("amount", returnDetail.getRefundAmount());
                    dataAfterSalesMap.put("note", returnDetail.getOrderTradeNo());
                    ArrayList itemDataList = new ArrayList();
                    if (dataAfterSalesMap.get("refund_type").equals(1)) {
                        returnDetail.getReturnOmniItemRespDtoList().forEach(returnItemRespDto -> {
                            HashMap<String, Object> itemDataMap = new HashMap<String, Object>();
                            itemDataMap.put("barcode", returnItemRespDto.getSkuSerial());
                            itemDataMap.put("qty", returnItemRespDto.getItemNum());
                            itemDataMap.put("price", returnItemRespDto.getItemPrice());
                            itemDataMap.put("note", returnItemRespDto.getRemark());
                            itemDataList.add(itemDataMap);
                        });
                    }
                    dataAfterSalesMap.put("item_detail", itemDataList);
                    messageVo.setData((Object)JSON.toJSONString(dataAfterSalesMap));
                    logger.info("===> \u5f00\u59cb\u53d1\u9001\u521b\u5efa\u9000\u6b3e\u5355MQ\u7ed9\u7b2c\u4e09\u65b9\u4e2d\u5fc3\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
                    MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("RETURN_REFUND_ORDER_CREATE_TAG", (Object)messageVo);
                    logger.info("===> \u7ed3\u675f\u53d1\u9001\u521b\u5efa\u9000\u6b3e\u5355MQ\u7ed9\u7b2c\u4e09\u65b9\u4e2d\u5fc3\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)messageResponse));
                }
            }
        }
    }
}

