/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.trade.api.constants.AuditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.AuditRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelReturnBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnCreateBo;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@CubeExtImpl(name="C\u7aef\u521b\u5efa\u552e\u540e\u5355\u6269\u5c55", descr="C\u7aef\u521b\u5efa\u552e\u540e\u5355\u6269\u5c55")
public class ReturnRefundActionBBCExtPtImpl
implements IReturnRefundActionExtPt {
    @Autowired
    IPayService payService;
    @Autowired
    IAfterSalesService afterSalesService;

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_RETURN.getFlowId();
    }

    public String getFlowDefName() {
        return BaseFlowDef.BASE_RETURN.getFlowName();
    }

    public Class getDtoClass() {
        return null;
    }

    public Class getDetailDtoClass() {
        return null;
    }

    public ReturnCreateBo validate(ReturnCreateBo returnBo) {
        HashSet orderNos = Sets.newHashSet((Object[])new String[]{returnBo.getReturnReqDto().getOrderTradeNo()});
        List<PayRecordRespDto> payRecordRespDtos = this.payService.getPaySuccessRecord(orderNos);
        if (CollectionUtils.isEmpty(payRecordRespDtos)) {
            throw new BizException("\u8ba2\u5355\u65e0\u91d1\u989d\u652f\u4ed8\uff0c\u4e0d\u80fd\u7533\u8bf7\u9000\u6b3e");
        }
        return returnBo;
    }

    public ReturnCreateBo packBo(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        returnReqDto = this.afterSalesService.countReturn(returnReqDto);
        ReturnEo returnEo = returnBo.getReturnEo();
        returnEo.setRefundAmount(returnReqDto.getRefundAmount());
        returnEo.setReturnIntegral(returnReqDto.getReturnIntegral());
        returnEo.setOrganizationId(returnBo.getOrderEo().getOrganizationId());
        returnEo.setOrganizationName(returnBo.getOrderEo().getOrganizationName());
        AuditRecordEo auditRecordEo = new AuditRecordEo();
        CubeBeanUtils.copyProperties((Object)auditRecordEo, (Object)returnReqDto.getAuditRecordReqDto(), (String[])new String[0]);
        auditRecordEo.setInstanceId(returnEo.getInstanceId());
        auditRecordEo.setTenantId(returnEo.getTenantId());
        auditRecordEo.setAuditRecordNo(TradeUtil.generateTradeNo(returnReqDto.getOrderTradeNo()));
        auditRecordEo.setBizTradeNo(returnEo.getTradeNo());
        if (ReturnTypeEnum.REFUND_ONLY.getName().equals(returnReqDto.getReturnType())) {
            auditRecordEo.setReqType("REFUND");
        } else {
            auditRecordEo.setReqType("RETURN");
        }
        auditRecordEo.setAuditStatus(AuditRecordStatusEnum.AUDITING.getName());
        returnBo.setAuditRecordEo(auditRecordEo);
        return returnBo;
    }

    public ReturnCreateBo save(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        if (returnBo.getAuditRecordEo() != null) {
            this.afterSalesService.saveInitAuditRecord(returnBo.getAuditRecordEo());
        }
        return returnBo;
    }

    public ReturnCreateBo postProcessor(ReturnCreateBo returnBo, ReturnReqDto returnReqDto) {
        return returnBo;
    }

    public ReturnCreateBo dealWithoutOrderNo(ReturnCreateBo returnCreateBo) {
        return returnCreateBo;
    }

    public CancelReturnBo cancelReturnFinishAction(CancelReturnBo cancelReturnBo) {
        ReturnEo returnEo = cancelReturnBo.getReturnEo();
        if (cancelReturnBo.getCancelReqDto() != null) {
            CancelReqDto cancelReqDto = cancelReturnBo.getCancelReqDto();
            returnEo.setCancelType(cancelReqDto.getCancelType());
            returnEo.setCancelDesc(cancelReqDto.getCancelDesc());
        }
        returnEo.setCancelTime(new Date());
        return cancelReturnBo;
    }

    public ReturnCreateBo dealWithUncertaintyItem(ReturnCreateBo returnCreateBo) {
        return returnCreateBo;
    }
}

