/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.payment.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizDataDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.AfterSalesReqDto;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@MQDesc(tag="refund", topic="${YUNDT_CUBE_CONNECTOR_MQ_CONVERT:YUNDT_CUBE_CONNECTOR_MQ_CONVERT}")
public class AfterSalesProcess
implements IMessageProcessor<BizDataDto> {
    private Logger logger = LoggerFactory.getLogger(AfterSalesProcess.class);
    @Value(value="${connector.callback.url}")
    private String callBackUrl;
    @Resource
    private IAfterSalesService iAfterSalesService;

    public MessageResponse process(BizDataDto message) {
        this.logger.info("\u63a5\u6536\u5230\u8fde\u63a5\u5668\u552e\u540e\u5355\u6d88\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)message));
        try {
            String data = (String)message.getData();
            if (StringUtils.isBlank((CharSequence)data)) {
                return MessageResponse.SUCCESS;
            }
            AfterSalesReqDto afterSalesReqDto = (AfterSalesReqDto)JSONObject.parseObject((String)data, AfterSalesReqDto.class);
            List<String> returnNos = this.iAfterSalesService.addSynReturn(afterSalesReqDto);
            this.sendConnector(message.getId().toString(), CollectionUtils.isEmpty(returnNos) ? null : StringUtils.join(returnNos, (String)","), Constants.PROCESS_SUCCESS.toString(), null);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u8fde\u63a5\u5668\u552e\u540e\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            this.sendConnector(message.getId().toString(), null, Constants.PROCESS_FAIL.toString(), e.getMessage());
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private void sendConnector(String dataId, String bizIds, String handleStatus, String remark) {
        String connectorCallBackUrl = this.callBackUrl + "/v1/biz/confirm";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataId", dataId);
        map.put("bizIds", bizIds);
        map.put("handleStatus", handleStatus);
        map.put("remark", remark);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String res = HttpUtil.post((String)connectorCallBackUrl, (String)JSON.toJSONString(map), headers);
            this.logger.info("\u901a\u77e5\u8fde\u63a5\u5668\u8ba2\u5355\u5904\u7406\u7ed3\u679c\u6210\u529f,dataId:{},handleStatus:{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{dataId, handleStatus, res});
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u8fde\u63a5\u5668\u8ba2\u5355\u5904\u7406\u7ed3\u679c\u5931\u8d25,dataId:{},handleStatus:{},e:{}", new Object[]{dataId, handleStatus, e.getMessage(), e});
        }
    }
}

