/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.payment.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.connector.IConDeliveryService;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizDataDto;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@MQDesc(topic="${YUNDT_CUBE_CONNECTOR_MQ_CONVERT:YUNDT_CUBE_CONNECTOR_MQ_CONVERT}", tag="delivery")
public class ConnectorDeliveryProcess
implements IMessageProcessor<BizDataDto> {
    private Logger logger = LoggerFactory.getLogger(ConnectorDeliveryProcess.class);
    @Autowired
    private IConDeliveryService conDeliveryService;
    @Value(value="${connector.callback.url}")
    private String connectorBaseUrl;

    public MessageResponse process(BizDataDto bizDataDto) {
        Thread.currentThread().setName("CONNECTOR-DELIVERY-PROCESS-" + UUID.randomUUID().toString());
        this.logger.info("\u63a5\u6536\u5230\u8fde\u63a5\u5668\u53d1\u8d27\u5355\u6d88\u606f\uff0cbizDataDto:{}", (Object)JSON.toJSONString((Object)bizDataDto));
        try {
            DeliveryRespDto deliveryRespDto = this.conDeliveryService.syncConDelivery(bizDataDto);
            this.noticeConnector(bizDataDto.getId(), deliveryRespDto.getDeliveryNo(), Constants.PROCESS_SUCCESS.toString(), null);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u8fde\u63a5\u5668\u53d1\u8d27\u5355\u6d88\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            this.noticeConnector(bizDataDto.getId(), null, Constants.PROCESS_FAIL.toString(), e.getMessage());
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private void noticeConnector(Long dataId, String bizIds, String handleStatus, String remark) {
        try {
            String connectorNoticeUrl = this.connectorBaseUrl + "/v1/biz/confirm";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataId", dataId.toString());
            map.put("bizIds", bizIds);
            map.put("remark", remark);
            map.put("handleStatus", handleStatus);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            this.logger.info("\u51c6\u5907\u901a\u77e5\u8fde\u673a\u5668\u53d1\u8d27\u5355\u5904\u7406\u7ed3\u679c\uff0curl:{}\uff0cdata:{}", (Object)connectorNoticeUrl, (Object)JSON.toJSONString(map));
            String res = HttpUtil.post((String)connectorNoticeUrl, (String)JSON.toJSONString(map), headers);
            this.logger.info("\u901a\u77e5\u8fde\u63a5\u5668\u53d1\u8d27\u5355\u5904\u7406\u7ed3\u679c\u6210\u529f,dataId:{},handleStatus:{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{dataId, handleStatus, res});
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u8fde\u63a5\u5668\u53d1\u8d27\u5355\u5904\u7406\u7ed3\u679c\u5931\u8d25,dataId:{},handleStatus:{},e:{}", new Object[]{dataId, handleStatus, e.getMessage(), e});
        }
    }
}

