/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.connector.core.api.dto.DeliveryOrderReqDto;
import com.dtyunxi.yundt.connector.core.api.dto.PackageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.api.IDeliveryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryStoreReqDto;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizDataDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@MQDesc(topic="YUNDT_CUBE_CONNECTOR_MQ_CONVERT", tag="deliveryConfirm")
public class DeliveryChangeProcess
implements IMessageProcessor<BizDataDto> {
    @Resource(name="deliveryApiImpl")
    private IDeliveryApi deliveryApi;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    private static final Logger logger = LoggerFactory.getLogger(DeliveryChangeProcess.class);

    public MessageResponse process(BizDataDto bizDataDto) {
        logger.info("\u63a5\u53d7\u5230WMS\u53d1\u8d27\u5b8c\u6210\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)bizDataDto));
        try {
            String data = (String)bizDataDto.getData();
            if (StringUtils.isBlank((CharSequence)data)) {
                return MessageResponse.SUCCESS;
            }
            List deliveryOrderReqDtos = JSONObject.parseArray((String)data, DeliveryOrderReqDto.class);
            DeliveryOrderReqDto deliveryOrderReqDto = (DeliveryOrderReqDto)deliveryOrderReqDtos.get(0);
            Map<String, String> map = this.getMap();
            String deliveryOrderNo = deliveryOrderReqDto.getDeliveryOrderNo();
            List deliveryItems = this.deliveryItemDas.select(SqlFilterBuilder.create(DeliveryItemEo.class).eq("delivery_no", (Object)deliveryOrderNo).eo());
            List packageReqDtoList = deliveryOrderReqDto.getPackageReqDtoList();
            PackageReqDto packageReqDto = (PackageReqDto)packageReqDtoList.get(0);
            DeliveryStoreReqDto deliveryStoreReqDto = new DeliveryStoreReqDto();
            deliveryStoreReqDto.setDeliveryNo(deliveryOrderNo);
            deliveryStoreReqDto.setExpressCode(packageReqDto.getShippingNo());
            deliveryStoreReqDto.setShippingCompany(StringUtils.isEmpty((CharSequence)packageReqDto.getShippingCompany()) ? map.get(packageReqDto.getShippingCompanyCode()) : packageReqDto.getShippingCompany());
            deliveryStoreReqDto.setShippingCompanyCode(packageReqDto.getShippingCompanyCode());
            deliveryStoreReqDto.setShippingType("express");
            if (CollectionUtils.isEmpty((Collection)deliveryItems)) {
                logger.info("WMS\u53d1\u8d27\u786e\u8ba4\u53d1\u8d27\u5355\u4e3a\u7a7a");
                return MessageResponse.SUCCESS;
            }
            List detailReqDtos = deliveryItems.stream().map(d -> {
                DeliveryDetailReqDto deliveryDetailReqDto = new DeliveryDetailReqDto();
                deliveryDetailReqDto.setDeliveryItemId(d.getId());
                deliveryDetailReqDto.setDeliveryNum(d.getItemNum());
                return deliveryDetailReqDto;
            }).collect(Collectors.toList());
            deliveryStoreReqDto.setDeliveryDetails(detailReqDtos);
            logger.info("\u786e\u8ba4WMS\u53d1\u8d27\u7ec4\u88c5\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)deliveryStoreReqDto));
            RestResponse deliver = this.deliveryApi.deliver(deliveryStoreReqDto);
            logger.info("\u786e\u8ba4WMS\u53d1\u8d27\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)deliver));
        }
        catch (Exception e) {
            logger.info("\u786e\u8ba4\u53d1\u8d27\u51fa\u9519\uff1a{}\uff0c{}", (Object)e, (Object)e.getMessage());
        }
        logger.info("\u786e\u8ba4WMS\u53d1\u8d27\u5b8c\u6210");
        return MessageResponse.SUCCESS;
    }

    private Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>(14);
        map.put("SF", "\u987a\u4e30\u901f\u8fd0");
        map.put("HTKY", "\u767e\u4e16\u5feb\u9012");
        map.put("ZTO", "\u4e2d\u901a\u5feb\u9012");
        map.put("STO", "\u7533\u901a\u5feb\u9012");
        map.put("YTO", "\u5706\u901a\u901f\u9012");
        map.put("YD", "\u97f5\u8fbe\u901f\u9012");
        map.put("YZPY", "\u90ae\u653f\u5feb\u9012\u5305\u88f9");
        map.put("EMS", "EMS");
        map.put("HHTT", "\u5929\u5929\u5feb\u9012");
        map.put("JD", "\u4eac\u4e1c\u5feb\u9012");
        map.put("UC", "\u4f18\u901f\u5feb\u9012");
        map.put("DBL", "\u5fb7\u90a6\u5feb\u9012");
        map.put("ZJS", "\u5b85\u6025\u9001");
        return map;
    }
}

