/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.GenerateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.DeliveryRecordAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.CreateDeliveryOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.GenerateDeliveryFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderDeliveryCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.GenerateDeliveryBo;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ActionNodeComponent
@MQDesc(topic="${GENERATE_DELIVERY_TOPIC:GENERATE_DELIVERY_TOPIC}", tag="GENERATE_DELIVERY_TAG")
public class GenerateDeliveryProcess
implements IMessageProcessor<GenerateOrderReqDto> {
    private static final Logger logger = LoggerFactory.getLogger(GenerateDeliveryProcess.class);
    @Autowired
    private DeliveryRecordAction deliveryRecordAction;
    @Autowired
    private CreateDeliveryOrderFlowAction createDeliveryOrderFlowAction;
    @CubeResource
    IOrderDeliveryCreateActionExtPt orderDeliveryCreateActionExtPt;
    @Resource
    IOrderService orderService;
    @Resource
    private IContextService contextService;
    @Resource
    private GenerateDeliveryFlowAction generateDeliveryFlowAction;
    @Resource
    private ICacheService cacheService;

    @ActionNode(entity=OrderDeliveryEo.class, name="\u521b\u5efa\u53d1\u8d27\u5355")
    public MessageResponse process(GenerateOrderReqDto generateOrderReqDto) {
        generateOrderReqDto.getOrderNos().forEach(orderNo -> {
            Thread.currentThread().setName("GENERATE-DELIVERY-PROCESS-" + UUID.randomUUID().toString());
            OrderEo orderEo = this.orderService.getByOrderNo((String)orderNo);
            this.contextService.getAndSetInstanceInfo(orderEo.getInstanceId());
            this.createDeliveryOrder(generateOrderReqDto);
            logger.info("\u6839\u636e\u8ba2\u5355\u53f7\uff1a{}\u751f\u6210\u53d1\u8d27\u5355\u5b8c\u6bd5", orderNo);
        });
        return MessageResponse.SUCCESS;
    }

    private void createDeliveryOrder(GenerateOrderReqDto generateOrderReqDto) {
        logger.info("\u63a5\u6536\u5230\u6839\u636e\u5168\u6e20\u9053\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\u4fe1\u606f\uff0c\u5165\u53c2generateOrderReqDto\uff1a{}", (Object)JSON.toJSONString((Object)generateOrderReqDto));
        generateOrderReqDto.getOrderNos().forEach(orderNo -> {
            String primaryKey = "generate_delivery_" + orderNo;
            boolean success = this.cacheService.add(primaryKey, (Object)"1", 60);
            if (!success) {
                logger.warn("\u6839\u636e\u8ba2\u5355\uff1a{}\u751f\u6210\u53d1\u8d27\u5355\u63a5\u6536\u5230\u91cd\u590dMQ\u6d88\u606f\uff0c\u5ffd\u7565\u3002", orderNo);
                return;
            }
            GenerateDeliveryBo generateDeliveryBo = new GenerateDeliveryBo();
            generateDeliveryBo.setOrderNo(orderNo);
            generateDeliveryBo.setStartFlowParam(this.orderDeliveryCreateActionExtPt.getFlowDefId(), this.orderDeliveryCreateActionExtPt.getFlowDefName());
            this.generateDeliveryFlowAction.create(generateDeliveryBo);
            this.cacheService.delCache(primaryKey);
        });
    }
}

