/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.PayApiImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OrderCloseMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="order_close")
public class OrderCloseProcessor
implements IMessageProcessor<OrderCloseMessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(OrderCloseProcessor.class);
    @Resource
    private IOrderService orderService;
    @Resource
    IPayService iPayService;
    @Resource
    ITradeService iTradeService;
    @Resource(name="orderApiImpl")
    private IOrderApi orderApi;
    @Resource
    private IContext context;
    @Resource
    private IPayService payService;
    @Resource
    private PayApiImpl payApiImpl;
    @Resource
    private IContextService contextService;

    public MessageResponse process(OrderCloseMessageVo message) {
        logger.info("\u8ba2\u5355\u5173\u95ed\u6d88\u606f\u5904\u7406: {}", (Object)JSON.toJSONString((Object)message));
        if (message.getInstanceId() != null) {
            this.contextService.getAndSetInstanceInfo((long)message.getInstanceId());
        } else if (message.getAppKey() != null) {
            this.contextService.getAndSetInstanceInfo(Long.valueOf(message.getAppKey()));
        }
        try {
            if (message != null) {
                OrderEo orderEo;
                String orderTradeNum = message.getOrderTradeNum();
                List<PayOrderNotifyRequest> checkOrderPayResult = this.payService.getCheckOrderPayResult(orderTradeNum);
                if (CollectionUtils.isNotEmpty(checkOrderPayResult)) {
                    logger.info("\u8d85\u65f6\u5173\u95ed\u4fee\u590d\u8ba2\u5355\u72b6\u6001,\u8ba2\u5355\u53f7={}", (Object)orderTradeNum);
                    for (PayOrderNotifyRequest payOrderNotifyRequest : checkOrderPayResult) {
                        this.payApiImpl.replyHandleNotify(payOrderNotifyRequest);
                    }
                }
                if ((orderEo = this.orderService.queryExpireOrder(orderTradeNum, new Date())) != null && "WAIT_PAY".equals(orderEo.getOrderTradeStatus())) {
                    this.releaseCouponAndInventoryBeforePay(orderEo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5173\u95ed\u8ba2\u5355\u7684\u6d88\u606f\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private void releaseCouponAndInventoryBeforePay(OrderEo orderEo) {
        String orderNo = orderEo.getOrderNo();
        this.contextService.getAndSetInstanceInfo(orderEo.getInstanceId());
        CancelReqDto cancelReqDto = new CancelReqDto();
        cancelReqDto.setCancelType(OrderCancelTypeEnum.BUYER_CANCLE.getName());
        cancelReqDto.setCancelDesc("\u8ba2\u5355\u8fc7\u671f\u81ea\u52a8\u53d6\u6d88");
        this.orderApi.cancelOrder(orderNo, cancelReqDto);
    }
}

