/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.payment.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizDataDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.TradeReqDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="order", topic="YUNDT_CUBE_CONNECTOR_MQ_CONVERT")
public class OrderProcess
implements IMessageProcessor<BizDataDto> {
    private Logger logger = LoggerFactory.getLogger(OrderProcess.class);
    @Resource
    private IOrderService orderService;
    @Value(value="${connector.callback.url}")
    private String callBackUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(BizDataDto dataDto) {
        Thread.currentThread().setName("ORDER-PROCESS-" + UUID.randomUUID().toString());
        this.logger.info("\u6536\u5230\u8fde\u63a5\u5668\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dataDto));
        HashMap<String, String> callBackParams = new HashMap<String, String>();
        callBackParams.put("dataId", dataDto.getId().toString());
        callBackParams.put("handleStatus", Constants.PROCESS_SUCCESS.toString());
        String url = this.callBackUrl + "/v1/biz/confirm";
        try {
            List orderNos;
            List<OrderEo> orderEos;
            String data = dataDto.getData().toString();
            if (StringUtils.isNotBlank((CharSequence)data) && CollectionUtils.isNotEmpty(orderEos = this.orderService.addSynOrder(JSONObject.parseArray((String)data, TradeReqDto.class))) && CollectionUtils.isNotEmpty(orderNos = orderEos.stream().filter(orderEo -> {
                String orderNo = orderEo.getOrderNo();
                return StringUtils.isNotBlank((CharSequence)orderNo);
            }).map(StdOrderEo::getOrderNo).collect(Collectors.toList()))) {
                callBackParams.put("bizIds", StringUtils.join(orderNos, (String)","));
            }
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5\u5668\u540c\u6b65\u8ba2\u5355\u51fa\u73b0\u5f02\u5e38,e:{}", (Object)e.getMessage(), (Object)e);
            callBackParams.put("handleStatus", Constants.PROCESS_FAIL.toString());
            callBackParams.put("remark", "\u8ba2\u5355\u5904\u7406\u5931\u8d25," + e.getMessage());
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            this.sendConnector(callBackParams, url);
        }
        return MessageResponse.SUCCESS;
    }

    private void sendConnector(Map<String, String> map, String callBackUrl) {
        String dataId = map.get("dataId");
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String res = HttpUtil.post((String)callBackUrl, (String)JSON.toJSONString(map), headers);
            this.logger.info("\u901a\u77e5\u8fde\u63a5\u5668\u8ba2\u5355\u5904\u7406\u7ed3\u679c\u6210\u529f,dataId:{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)dataId, (Object)res);
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u8fde\u63a5\u5668\u8ba2\u5355\u5904\u7406\u7ed3\u679c\u5931\u8d25,dataId:{},e:{}", (Object)dataId, (Object)e.getMessage());
        }
    }
}

