/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.producer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OrderStatusChangeMessageVo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class OrderStatusChangeProducer {
    private static final Logger logger = LoggerFactory.getLogger(OrderStatusChangeProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private Environment environment;

    public void sendOrderStatusMqMessage(String tradeNo, String orderStatus) {
        if (StringUtils.isEmpty((CharSequence)orderStatus) || StringUtils.isEmpty((CharSequence)tradeNo)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01orderStatus=" + orderStatus + ", tradeNo=" + tradeNo);
        }
        OrderStatusChangeMessageVo messageVo = new OrderStatusChangeMessageVo();
        messageVo.setTradeNo(tradeNo);
        messageVo.setOrderStatus(orderStatus);
        OrderEo orderEo = new OrderEo();
        orderEo.setTradeNo(tradeNo);
        orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        if (null == orderEo) {
            throw new BizException(this.environment.resolvePlaceholders(TradeExceptionCode.ORDER_NO_EXIT.getCode()), this.environment.resolvePlaceholders(TradeExceptionCode.ORDER_NO_EXIT.getMsg()));
        }
        messageVo.setOrderNo(orderEo.getOrderNo());
        messageVo.setInstanceId(orderEo.getInstanceId());
        messageVo.setTenantId(orderEo.getTenantId());
        this.sendOrderStatusMqMessage(messageVo);
    }

    public void sendOrderStatusMqMessage(Long orderId, String orderStatus) {
        if (StringUtils.isEmpty((CharSequence)orderStatus) || null == orderId || orderId == 0L) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01orderStatus=" + orderStatus + ", orderId=" + orderId);
        }
        OrderStatusChangeMessageVo messageVo = new OrderStatusChangeMessageVo();
        messageVo.setOrderStatus(orderStatus);
        OrderEo orderEo = (OrderEo)this.orderDas.selectByPrimaryKey(orderId);
        if (null == orderEo) {
            throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
        }
        messageVo.setTradeNo(orderEo.getTradeNo());
        messageVo.setOrderNo(orderEo.getOrderNo());
        messageVo.setInstanceId(orderEo.getInstanceId());
        messageVo.setTenantId(orderEo.getTenantId());
        this.sendOrderStatusMqMessage(messageVo);
    }

    private void sendOrderStatusMqMessage(OrderStatusChangeMessageVo orderStatusChangeMessageVo) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)((Object)orderStatusChangeMessageVo)));
        logger.info("mq\u53d1\u9001\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f,\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("order_status_change", (Object)messageVo);
    }
}

