/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.producer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.vo.OrderTradeStatusChangeMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class OrderTradeStatusChangeProducer {
    private static final Logger logger = LoggerFactory.getLogger(OrderTradeStatusChangeProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private Environment environment;

    public void sendMqMessage(String tradeNo, String orderTradeStatus) {
        if (StringUtils.isEmpty((CharSequence)orderTradeStatus) || StringUtils.isEmpty((CharSequence)tradeNo)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01orderTradeStatus=" + orderTradeStatus + ", tradeNo=" + tradeNo);
        }
        OrderTradeStatusChangeMessageVo messageVo = new OrderTradeStatusChangeMessageVo();
        messageVo.setTradeNo(tradeNo);
        messageVo.setOrderTradeStatus(orderTradeStatus);
        OrderEo orderEo = new OrderEo();
        orderEo.setTradeNo(tradeNo);
        orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        if (null == orderEo) {
            orderEo = new OrderEo();
            orderEo.setOrderNo(tradeNo);
            orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        }
        if (null == orderEo) {
            throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
        }
        if ("CANCEL".equals(orderTradeStatus)) {
            List<Long> activityIds = this.orderActivityService.queryByOrderNo(tradeNo);
            messageVo.setJoinedActivities(activityIds);
        }
        messageVo.setOrderNo(orderEo.getOrderNo());
        messageVo.setInstanceId(orderEo.getInstanceId());
        messageVo.setTenantId(orderEo.getTenantId());
        this.sendOrderStatusMqMessage(messageVo);
    }

    private void sendOrderStatusMqMessage(OrderTradeStatusChangeMessageVo orderTradeStatusChangeMessageVo) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)orderTradeStatusChangeMessageVo));
        logger.info("\u53d1\u9001\u8ba2\u5355\u4ea4\u6613\u72b6\u6001\u53d8\u66f4\u6d88\u606f,\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage(this.environment.resolvePlaceholders("order_trade_status_change"), (Object)messageVo);
        if (orderTradeStatusChangeMessageVo.getOrderTradeStatus().equals("CANCEL")) {
            logger.info("\u53d1\u9001\u8ba2\u5355\u53d6\u6d88\u6d88\u606ftradeNo={}", (Object)orderTradeStatusChangeMessageVo.getTradeNo());
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("order_trade_cancel_change"), (Object)messageVo);
        }
    }
}

