/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.scheduler;

import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ScheduleParam;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="releaseCouponAndInventory")
@Scope(value="prototype")
public class ReleaseCouponAndInventory
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(ReleaseCouponAndInventory.class);
    @Resource
    private IOrderService orderService;
    @Resource(name="orderApiImpl")
    private IOrderApi orderApi;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        logger.info("\u5173\u95ed\u8fc7\u671f\u8ba2\u5355\u5e76\u91ca\u653e\u5e93\u5b58\u548c\u4f18\u60e0\u5238\u5f00\u59cb");
        if (this.validate(taskMsg).booleanValue()) {
            ScheduleParam scheduleParam = (ScheduleParam)ObjectHelper.Json2Bean((String)taskMsg.getContent(), ScheduleParam.class);
            if (scheduleParam == null || scheduleParam.getOrderTradeNum() == null) {
                logger.info("\u8d85\u65f6\u4efb\u52a1==\u8ba2\u5355\u53f7={}\uff0c\u8c03\u5ea6\u4efb\u52a1\u6ca1\u6709\u8ba2\u5355\u53f7\uff0c\u4e0d\u5173\u95ed\u8ba2\u5355", (Object)scheduleParam.getOrderTradeNum());
                return false;
            }
            logger.info("\u5173\u95ed\u8fc7\u671f\u8ba2\u5355\u5e76\u91ca\u653e\u5e93\u5b58\u548c\u4f18\u60e0\u5238\u5f00\u59cb\uff0c\u8ba2\u5355\u53f7={}", (Object)scheduleParam.getOrderTradeNum());
            OrderEo orderEo = this.orderService.queryExpireOrder(scheduleParam.getOrderTradeNum(), new Date());
            if (orderEo == null) {
                logger.info("\u8d85\u65f6\u4efb\u52a1==\u8ba2\u5355\u53f7={}\uff0c\u65e0\u6cd5\u67e5\u8be2\u5f97\u5230\u8ba2\u5355\u53f7\uff0c\u4e0d\u5173\u95ed\u8ba2\u5355", (Object)scheduleParam.getOrderTradeNum());
                return true;
            }
            try {
                if (orderEo.getOrderTradeStatus().equals("WAIT_PAY")) {
                    logger.info("\u8d85\u65f6\u4efb\u52a1==\u8ba2\u5355\u53f7={}\uff0c\u5f00\u59cb\u5173\u95ed\u8ba2\u5355", (Object)scheduleParam.getOrderTradeNum());
                    this.releaseCouponAndInventoryAfterPay(orderEo);
                } else {
                    logger.info("\u8d85\u65f6\u4efb\u52a1==\u8ba2\u5355\u53f7={}\uff0c\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u5173\u95ed\u8ba2\u5355", (Object)scheduleParam.getOrderTradeNum());
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u5ea6\u4efb\u52a1\u8ba2\u5355\u53d6\u6d88\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={},{}", (Object)scheduleParam.getOrderTradeNum(), (Object)e);
            }
            return true;
        }
        return false;
    }

    public void after(TaskMsg taskMsg) {
    }

    private void releaseCouponAndInventoryBeforePay(OrderEo orderEo) {
        CancelReqDto cancelReqDto = new CancelReqDto();
        cancelReqDto.setCancelType(OrderCancelTypeEnum.BUYER_CANCLE.getName());
        cancelReqDto.setCancelDesc("\u8ba2\u5355\u8fc7\u671f\u81ea\u52a8\u53d6\u6d88");
        this.orderApi.cancelOrder(orderEo.getTradeNo(), cancelReqDto);
    }

    private void releaseCouponAndInventoryAfterPay(OrderEo orderEo) {
        this.releaseCouponAndInventoryBeforePay(orderEo);
    }

    private Boolean validate(TaskMsg taskMsg) {
        return taskMsg != null && taskMsg.getContent() != null;
    }
}

