/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliverySplitFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverMergeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfMergeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OnOffEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeSchedulerEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.DeliveryMergeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderSettingRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryMergeService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderDeliveryEo;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AutoMergeDeliveryOrderTask {
    private static Logger logger = LoggerFactory.getLogger(AutoMergeDeliveryOrderTask.class);
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Value(value="${scheduler.auto.merge.delivery.order.expression:}")
    private String scheduleExpression;
    @Autowired
    private IDeliveryMergeService deliveryMergeService;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;

    public void handleAutoMerge() {
        OrderSettingRespDto.DeliveryAutoMergeSettingDto deliveryAutoMergeSetting = this.deliveryMergeService.getDeliveryAutoMergeSetting();
        if (null == deliveryAutoMergeSetting) {
            logger.info("\u7cfb\u7edf\u81ea\u52a8\u5408\u5355\u8bbe\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u5408\u5355\u64cd\u4f5c\u3002");
            return;
        }
        if (OnOffEnum.OFF.getValue().equals(deliveryAutoMergeSetting.getAutoMergeSwitch())) {
            logger.info("\u53d1\u8d27\u5355\u81ea\u52a8\u5408\u5e76\u5f00\u5173\u672a\u5f00\u542f\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u5408\u5e76\u64cd\u4f5c\u3002");
            return;
        }
        OrderDeliveryEo orderDeliveryEo = new OrderDeliveryEo();
        orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_CONFIRM.getStatus());
        orderDeliveryEo.setSplitFlag(DeliverySplitFlagEnum.NOT_SPLIT.getFlag());
        orderDeliveryEo.setIfMerge(IfMergeEnum.NO_MERGE.getCode());
        List orderDeliveryEos = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoMergeSetting.getSellerRemarkSwitch()) || OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoMergeSetting.getBuyerRemarkSwitch())) {
            // empty if block
        }
        if (CollectionUtils.isEmpty((Collection)orderDeliveryEos)) {
            logger.info("\u6ca1\u6709\u5f85\u786e\u8ba4\u4e14\u672a\u62c6\u5355\u672a\u5408\u5355\u72b6\u6001\u7684\u53d1\u8d27\u5355\uff0c\u65e0\u9700\u5408\u5e76");
            return;
        }
        Map<String, List<OrderDeliveryEo>> map = orderDeliveryEos.stream().collect(Collectors.groupingBy(this::make));
        map.forEach((n, m) -> {
            if (m.size() > 1) {
                List deliveryNos = m.stream().map(StdOrderDeliveryEo::getDeliveryNo).collect(Collectors.toList());
                logger.info("\u53d1\u8d27\u5355\u81ea\u52a8\u5408\u5e76\uff0cdeliveryNos\uff1a{}", (Object)JSON.toJSONString(deliveryNos));
                DeliveryMergeReqDto deliveryMergeReqDto = new DeliveryMergeReqDto();
                deliveryMergeReqDto.setDeliverNos(deliveryNos);
                deliveryMergeReqDto.setMergeType(DeliverMergeTypeEnum.AUTO.getType());
                this.deliveryMergeService.autoMerge(deliveryMergeReqDto);
            }
        });
    }

    private String make(OrderDeliveryEo eo) {
        return eo.getDeliveryName() + eo.getDeliveryMobile() + eo.getAddress() + eo.getShopCode();
    }

    public void initTask() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011,scheduleExpression:{}", (Object)this.scheduleExpression);
        if (StringUtils.isEmpty((CharSequence)this.scheduleExpression)) {
            logger.warn("\u521d\u59cb\u5316\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5931\u8d25,\u4ea4\u6613\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(TradeSchedulerEnum.AUTO_MERGE_DELIVERY_ORDER_EVENT.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u4e0d\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.createAutoMergeTask();
            return;
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (this.scheduleExpression.equals(origTask.getScheduleExpression())) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                logger.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
            return;
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            logger.info("\u7981\u7528\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
        taskUpate.setScheduleExpression(this.scheduleExpression);
        taskUpate.setInstanceId(Long.valueOf(-1L));
        taskUpate.setTenantId(Long.valueOf(-1L));
        RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
        logger.info("\u66f4\u65b0\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        logger.info("\u542f\u7528\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    public void createAutoMergeTask() {
        logger.info("\u5f00\u59cb\u521b\u5efa\u3010\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.appCode);
        taskAndBizCreate.setBizCode(TradeSchedulerEnum.AUTO_MERGE_DELIVERY_ORDER_EVENT.getBizCode());
        taskAndBizCreate.setBizName(TradeSchedulerEnum.AUTO_MERGE_DELIVERY_ORDER_EVENT.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(this.scheduleExpression);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(TradeSchedulerEnum.AUTO_MERGE_DELIVERY_ORDER_EVENT.getBizName());
        taskAndBizCreate.setTaskDesc("\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1");
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        logger.info("\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
    }
}

