/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.scheduler.task;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CompareDiffStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReconciliationOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReconciliationTaskStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TaskTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeSchedulerEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderCompareQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ChannelDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderCompareDiffDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReconciliationTaskDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderCompareDiffEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReconciliationOrderRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReconciliationTaskEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderCompareDiffEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReconciliationOrderRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderCompareVo;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TwoTuple;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrderCompareDiffTask {
    private static final Logger logger = LoggerFactory.getLogger(OrderCompareDiffTask.class);
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private OrderCompareDiffDas orderCompareDiffDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private ChannelDas channelDas;
    @Resource
    private ReconciliationTaskDas reconciliationTaskDas;
    Snowflake snowflake = new Snowflake(1L, 1L);
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Value(value="${scheduler.compare.diff.expression:0 0 0 * * ?}")
    private String scheduleExpression;
    @Value(value="${order.compare.diff.checkTime:3600}")
    private Integer checkTime;
    @Value(value="#{${order.compare.diff.enableChannel: 'TB,TM,JD'}.split(',')}")
    private List<String> enableChannels;
    @Resource
    private ApplicationContext applicationContext;
    private static final Map<String, ShopBaseDto> SHOP_CACHE = new ConcurrentHashMap<String, ShopBaseDto>(20);
    private static final Map<String, ShopDto> SHOP_CODE_CACHE = new ConcurrentHashMap<String, ShopDto>(20);

    public void compareDiffHandle() {
        List channelEos = this.channelDas.select(SqlFilterBuilder.create(ChannelEo.class).eq("status", (Object)YesNoEnum.YES.getValue()).eq("dr", (Object)YesNoEnum.NO.getValue()).eo());
        if (CollectionUtils.isEmpty((Collection)channelEos) || CollectionUtils.isEmpty(channelEos = channelEos.stream().filter(o -> this.enableChannels.contains(o.getCode())).collect(Collectors.toList()))) {
            throw new BizException("\u65e0\u53ef\u7528\u6e20\u9053");
        }
        Map<String, String> channelMap = channelEos.stream().collect(Collectors.groupingBy(StdChannelEo::getCode, Collectors.mapping(StdChannelEo::getName, Collectors.joining(","))));
        Date date = new Date();
        long todayStartTime = date.getTime() - (date.getTime() + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        long yesterdayStartTime = todayStartTime - 86400000L;
        long checkStartTime = yesterdayStartTime - (long)(1000 * this.checkTime);
        Date yesterdayEnd = new Date(todayStartTime - 1L);
        Date yesterdayStart = new Date(yesterdayStartTime);
        Date checkStart = new Date(checkStartTime);
        List<String> repetitions = null;
        List compareDiffEos = this.orderCompareDiffDas.select(SqlFilterBuilder.create(OrderCompareDiffEo.class).le("pay_time", (Object)yesterdayStart).ge("pay_time", (Object)checkStart).eq("status", (Object)CompareDiffStatusEnum.MORE.getCode()).eq("dr", (Object)YesNoEnum.NO.getValue()).eo());
        if (!CollectionUtils.isEmpty((Collection)compareDiffEos)) {
            repetitions = compareDiffEos.stream().map(StdOrderCompareDiffEo::getSourceOrderNo).collect(Collectors.toList());
        }
        OrderCompareQueryReqDto dto = new OrderCompareQueryReqDto();
        dto.setStartTime(yesterdayStart);
        dto.setEndTime(yesterdayEnd);
        List<OrderCompareVo> orderCompares = this.orderService.selectCompareVos(dto);
        ArrayList<ReconciliationOrderRecordEo> reconciliationOrderRecordEos = new ArrayList<ReconciliationOrderRecordEo>(10);
        ((OrderCompareDiffTask)this.applicationContext.getBean(OrderCompareDiffTask.class)).compareDiffProcess(channelMap, orderCompares, reconciliationOrderRecordEos, repetitions, (TwoTuple<Integer, Map<String, ReconciliationTaskEo>>)new TwoTuple((Object)TaskTypeEnum.PLAN_IMPORT.getCode(), null));
    }

    @Transactional(rollbackFor={Exception.class})
    public void compareDiffProcess(Map<String, String> channelMap, List<OrderCompareVo> orderCompares, List<ReconciliationOrderRecordEo> reconciliationOrderRecordEos, List<String> repetitions, TwoTuple<Integer, Map<String, ReconciliationTaskEo>> typeTuple) {
        Map<Object, Object> orderMap = new HashMap(4);
        if (!CollectionUtils.isEmpty(orderCompares)) {
            orderMap = orderCompares.stream().collect(Collectors.groupingBy(OrderCompareVo::getSaleChannel));
        }
        SHOP_CACHE.clear();
        SHOP_CODE_CACHE.clear();
        Map<Object, Object> channelOrderMap = new HashMap(4);
        if (!CollectionUtils.isEmpty(reconciliationOrderRecordEos)) {
            channelOrderMap = reconciliationOrderRecordEos.stream().collect(Collectors.groupingBy(StdReconciliationOrderRecordEo::getChannelCode));
        }
        HashMap finalChannelOrderMap = channelOrderMap;
        Map<Object, Object> finalOrderMap = orderMap;
        ArrayList compareDiffEos = new ArrayList((channelMap.size() << 1) - (channelMap.size() >> 1));
        ArrayList taskList = new ArrayList(channelMap.size());
        Integer type = (Integer)typeTuple.getFirst();
        boolean updateFlag = type.equals(3);
        channelMap.forEach((k, v) -> {
            boolean returnFlag;
            List recordEos = (List)finalChannelOrderMap.get(k);
            List orders = (List)finalOrderMap.get(k);
            ReconciliationTaskEo checkEo = null;
            boolean bl = returnFlag = updateFlag && (typeTuple.getSecond() == null || (checkEo = (ReconciliationTaskEo)((Map)typeTuple.getSecond()).get(k)) == null);
            if (returnFlag) {
                return;
            }
            ReconciliationTaskEo reconciliationTaskEo = updateFlag ? checkEo : this.getReconciliationTaskEo(type, (String)k, (String)v);
            if (CollectionUtils.isEmpty((Collection)recordEos) && CollectionUtils.isEmpty((Collection)orders)) {
                reconciliationTaskEo.setImportStatus(ReconciliationTaskStatusEnum.FAIL.getCode());
                reconciliationTaskEo.setReconciliationResult("\u4e2d\u53f0\u6e20\u9053\u5747\u65e0\u6570\u636e");
                this.reconciliationTaskDas.insert((BaseEo)reconciliationTaskEo);
                return;
            }
            if (TaskTypeEnum.MANUAL_IMPORT.getCode().equals(typeTuple.getFirst())) {
                reconciliationTaskEo.setImportStatus(ReconciliationTaskStatusEnum.ING.getCode());
                this.reconciliationTaskDas.insert((BaseEo)reconciliationTaskEo);
            }
            try {
                int matchSize;
                int diffSize;
                if (CollectionUtils.isEmpty((Collection)recordEos)) {
                    reconciliationTaskEo.setImportStatus(ReconciliationTaskStatusEnum.SUCCESS.getCode());
                    int totalSize = orderCompares.size();
                    int matchSize2 = 0;
                    List<OrderCompareVo> newOrders = orders.stream().filter(o -> !repetitions.contains(o.getThirdOrderNo())).collect(Collectors.toList());
                    int diffSize2 = newOrders.size();
                    if (this.editReconciliationResult(taskList, reconciliationTaskEo, totalSize, matchSize2, diffSize2)) {
                        return;
                    }
                    int filterSize = totalSize - diffSize2;
                    reconciliationTaskEo.setReconciliationResult(String.format("\u5bf9\u8d26(\u884c): %s  \u5bf9\u5e73(\u884c): %s  \u5dee\u5f02(\u884c): %s \u5ffd\u7565(\u884c): %s", totalSize, matchSize2, diffSize2, filterSize));
                    taskList.add(reconciliationTaskEo);
                    newOrders.forEach(o -> this.addSortDiffRecord((String)k, (String)v, compareDiffEos, (OrderCompareVo)o, reconciliationTaskEo.getId()));
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)orders)) {
                    reconciliationTaskEo.setImportStatus(ReconciliationTaskStatusEnum.SUCCESS.getCode());
                    int totalSize = recordEos.size();
                    int matchSize3 = 0;
                    List<ReconciliationOrderRecordEo> newRecords = recordEos.stream().filter(o -> !repetitions.contains(o.getMerchantOrderNo())).collect(Collectors.toList());
                    int diffSize3 = newRecords.size();
                    if (this.editReconciliationResult(taskList, reconciliationTaskEo, totalSize, matchSize3, diffSize3)) {
                        return;
                    }
                    int filterSize = totalSize - diffSize3;
                    reconciliationTaskEo.setReconciliationResult(String.format("\u5bf9\u8d26(\u884c): %s  \u5bf9\u5e73(\u884c): %s  \u5dee\u5f02(\u884c): %s \u5ffd\u7565(\u884c): %s", totalSize, matchSize3, diffSize3, filterSize));
                    taskList.add(reconciliationTaskEo);
                    List shopCodes = newRecords.stream().map(StdReconciliationOrderRecordEo::getShopCode).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(shopCodes) && CollectionUtils.isEmpty(shopCodes = shopCodes.stream().filter(o -> !SHOP_CODE_CACHE.containsKey(o)).collect(Collectors.toList()))) {
                        ShopQueryReqDto shopQueryReqDto = new ShopQueryReqDto();
                        shopQueryReqDto.setCodes(shopCodes);
                        try {
                            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopByCode(shopQueryReqDto));
                            shopDtos.forEach(s -> SHOP_CODE_CACHE.put(s.getCode(), (ShopDto)s));
                        }
                        catch (Exception e) {
                            logger.error("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38{}", (Object)shopQueryReqDto);
                        }
                    }
                    newRecords.forEach(o -> this.addMoreDiffRecord((String)k, (String)v, compareDiffEos, (ReconciliationOrderRecordEo)o, reconciliationTaskEo.getId()));
                    return;
                }
                Set list = recordEos.stream().map(StdReconciliationOrderRecordEo::getMerchantOrderNo).collect(Collectors.toSet());
                list.addAll(orderCompares.stream().map(OrderCompareVo::getThirdOrderNo).collect(Collectors.toSet()));
                int totalSize = list.size();
                list.removeAll(repetitions);
                List<ReconciliationOrderRecordEo> newRecords = recordEos.stream().filter(o -> !repetitions.contains(o.getMerchantOrderNo())).collect(Collectors.toList());
                List newOrders = orders.stream().filter(o -> !repetitions.contains(o.getThirdOrderNo())).collect(Collectors.toList());
                ArrayList matchNos = new ArrayList(totalSize);
                int filterSize = totalSize - list.size();
                if (totalSize == filterSize || CollectionUtils.isEmpty(newOrders) || CollectionUtils.isEmpty(newRecords)) {
                    matchNos.addAll(repetitions);
                    diffSize = totalSize - filterSize;
                    matchSize = 0;
                } else {
                    Map<String, OrderCompareVo> orderCompareVoMap = newOrders.stream().collect(Collectors.toMap(OrderCompareVo::getThirdOrderNo, o -> o, (o1, o2) -> o1));
                    AtomicInteger matchAtomicSize = new AtomicInteger(0);
                    AtomicInteger diffAtomicSize = new AtomicInteger(0);
                    newRecords.forEach(record -> {
                        OrderCompareVo orderCompareVo = (OrderCompareVo)orderCompareVoMap.get(record.getMerchantOrderNo());
                        if (orderCompareVo == null) {
                            return;
                        }
                        matchNos.add(record.getMerchantOrderNo());
                        switch (ReconciliationOrderTypeEnum.getByCode((Integer)record.getOrderType())) {
                            case PAY: {
                                if (orderCompareVo.getPayAmount().compareTo(record.getChannelActualPrice()) == 0) {
                                    matchAtomicSize.incrementAndGet();
                                    return;
                                }
                                diffAtomicSize.incrementAndGet();
                                BigDecimal subtract = orderCompareVo.getPayAmount().subtract(record.getChannelActualPrice());
                                this.addDiffData(compareDiffEos, (String)k, (String)v, reconciliationTaskEo, (ReconciliationOrderRecordEo)record, orderCompareVo, subtract);
                                break;
                            }
                            case PAID: {
                                if (orderCompareVo.getPaidAmount().compareTo(record.getChannelPaidPrice()) == 0) {
                                    matchAtomicSize.incrementAndGet();
                                    return;
                                }
                                diffAtomicSize.incrementAndGet();
                                BigDecimal subtract1 = orderCompareVo.getPaidAmount().subtract(record.getChannelPaidPrice());
                                this.addDiffData(compareDiffEos, (String)k, (String)v, reconciliationTaskEo, (ReconciliationOrderRecordEo)record, orderCompareVo, subtract1);
                                break;
                            }
                        }
                    });
                    matchSize = matchAtomicSize.get();
                    diffSize = diffAtomicSize.get();
                }
                if (matchNos.size() > 0) {
                    List<OrderCompareVo> sortList;
                    List<ReconciliationOrderRecordEo> moreList;
                    if (CollectionUtils.isNotEmpty(newRecords) && !CollectionUtils.isEmpty(moreList = newRecords.stream().filter(o -> !matchNos.contains(o.getMerchantOrderNo())).collect(Collectors.toList()))) {
                        moreList.forEach(o -> this.addMoreDiffRecord((String)k, (String)v, compareDiffEos, (ReconciliationOrderRecordEo)o, reconciliationTaskEo.getId()));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)orderCompares) && !CollectionUtils.isEmpty(sortList = newOrders.stream().filter(o -> !matchNos.contains(o.getThirdOrderNo())).collect(Collectors.toList()))) {
                        sortList.forEach(o -> this.addSortDiffRecord((String)k, (String)v, compareDiffEos, (OrderCompareVo)o, reconciliationTaskEo.getId()));
                    }
                }
                reconciliationTaskEo.setImportStatus(ReconciliationTaskStatusEnum.SUCCESS.getCode());
                reconciliationTaskEo.setReconciliationResult(String.format("\u5bf9\u8d26(\u884c): %s  \u5bf9\u5e73(\u884c): %s  \u5dee\u5f02(\u884c): %s \u5ffd\u7565(\u884c): %s", totalSize, matchSize, diffSize, filterSize));
                taskList.add(reconciliationTaskEo);
            }
            catch (Exception e) {
                reconciliationTaskEo.setReconciliationResult(String.format("\u6267\u884c\u5f02\u5e38: %s", e.getMessage()));
                taskList.add(reconciliationTaskEo);
            }
        });
        int i = !updateFlag && TaskTypeEnum.PLAN_IMPORT.getCode().equals(typeTuple.getFirst()) ? this.reconciliationTaskDas.insertBatch(taskList) : taskList.stream().mapToInt(o -> this.reconciliationTaskDas.updateSelective((BaseEo)o)).sum();
        if (i > 0 && compareDiffEos.size() > 0) {
            this.orderCompareDiffDas.insertBatch(compareDiffEos);
        }
        SHOP_CACHE.clear();
        SHOP_CODE_CACHE.clear();
    }

    private void setShopData(OrderCompareVo orderCompareVo, OrderCompareDiffEo orderCompareDiffEo) {
        try {
            ShopBaseDto shopBaseDto = SHOP_CACHE.get(orderCompareVo.getShopId());
            if (shopBaseDto == null) {
                shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(orderCompareVo.getShopId())));
            }
            orderCompareDiffEo.setShopCode(shopBaseDto.getCode());
            orderCompareDiffEo.setShopName(shopBaseDto.getName());
            SHOP_CACHE.put(orderCompareVo.getShopId(), shopBaseDto);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38{}", (Object)orderCompareVo.getShopId());
        }
    }

    private void addSortDiffRecord(String k, String v, List<OrderCompareDiffEo> orderCompareDiffEos, OrderCompareVo orderCompareVo, Long id) {
        OrderCompareDiffEo orderCompareDiffEo = this.getOrderCompareDiffEo(k, v);
        orderCompareDiffEo.setReconciliationTaskId(id);
        orderCompareDiffEo.setSourceOrderNo(orderCompareVo.getThirdOrderNo());
        orderCompareDiffEo.setDiffStatus(CompareDiffStatusEnum.SHORT.getCode());
        orderCompareDiffEo.setChannelActualPrice(orderCompareVo.getTotalAmount());
        orderCompareDiffEo.setPayTime(orderCompareVo.getPayTime());
        orderCompareDiffEo.setTargetPayPrice(orderCompareVo.getTotalAmount());
        orderCompareDiffEo.setTargetActualPrice(orderCompareVo.getPayAmount());
        orderCompareDiffEo.setTargetOrderNo(orderCompareVo.getOrderNo());
        orderCompareDiffEo.setSourceOrderNo(orderCompareVo.getTradeNo());
        if (ReconciliationOrderTypeEnum.PAY.getCode().equals(orderCompareVo.getCompareType())) {
            orderCompareDiffEo.setTargetPayPrice(orderCompareVo.getTotalAmount());
            orderCompareDiffEo.setTargetActualPrice(orderCompareVo.getPayAmount());
        } else {
            orderCompareDiffEo.setTargetPaidPrice(orderCompareVo.getPaidAmount());
        }
        this.setShopData(orderCompareVo, orderCompareDiffEo);
        orderCompareDiffEos.add(orderCompareDiffEo);
    }

    private void addMoreDiffRecord(String k, String v, List<OrderCompareDiffEo> orderCompareDiffEos, ReconciliationOrderRecordEo o, Long id) {
        OrderCompareDiffEo orderCompareDiffEo = new OrderCompareDiffEo();
        orderCompareDiffEo.setReconciliationTaskId(id);
        orderCompareDiffEo.setChannelCode(k);
        orderCompareDiffEo.setChannelName(v);
        orderCompareDiffEo.setSourceOrderNo(o.getMerchantOrderNo());
        orderCompareDiffEo.setDiffStatus(CompareDiffStatusEnum.MORE.getCode());
        orderCompareDiffEo.setStatus(YesNoEnum.NO.getValue().toString());
        if (ReconciliationOrderTypeEnum.PAY.getCode().equals(o.getOrderType())) {
            orderCompareDiffEo.setChannelPayPrice(o.getChannelPayPrice());
            orderCompareDiffEo.setChannelActualPrice(o.getChannelActualPrice());
            orderCompareDiffEo.setChannelSellPrice(o.getChannelSellPrice());
        } else {
            orderCompareDiffEo.setChannelPaidPrice(o.getChannelPaidPrice());
        }
        orderCompareDiffEo.setShopCode(o.getShopCode());
        try {
            ShopDto shopDto = SHOP_CODE_CACHE.get(o.getShopCode());
            if (shopDto != null) {
                orderCompareDiffEo.setShopName(shopDto.getName());
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38{}", (Object)o.getShopCode());
        }
        orderCompareDiffEos.add(orderCompareDiffEo);
    }

    private void addDiffData(List<OrderCompareDiffEo> compareDiffEos, String k, String v, ReconciliationTaskEo reconciliationTaskEo, ReconciliationOrderRecordEo record, OrderCompareVo orderCompareVo, BigDecimal subtract) {
        OrderCompareDiffEo orderCompareDiffEo = this.getOrderCompareDiffEo(k, v);
        orderCompareDiffEo.setReconciliationTaskId(reconciliationTaskEo.getId());
        orderCompareDiffEo.setSourceOrderNo(orderCompareVo.getThirdOrderNo());
        orderCompareDiffEo.setDiffStatus(CompareDiffStatusEnum.DIFFERENCE.getCode());
        orderCompareDiffEo.setPayTime(orderCompareVo.getPayTime());
        orderCompareDiffEo.setDiffAmount(subtract);
        orderCompareDiffEo.setTargetOrderNo(orderCompareVo.getOrderNo());
        orderCompareDiffEo.setSourceOrderNo(orderCompareVo.getTradeNo());
        if (ReconciliationOrderTypeEnum.PAY.getCode().equals(orderCompareVo.getCompareType())) {
            orderCompareDiffEo.setChannelActualPrice(record.getChannelActualPrice());
            orderCompareDiffEo.setChannelPayPrice(record.getChannelPayPrice());
            orderCompareDiffEo.setTargetPayPrice(orderCompareVo.getTotalAmount());
            orderCompareDiffEo.setTargetActualPrice(orderCompareVo.getPayAmount());
        } else {
            orderCompareDiffEo.setChannelPaidPrice(record.getChannelPaidPrice());
            orderCompareDiffEo.setTargetPaidPrice(orderCompareVo.getPaidAmount());
        }
        this.setShopData(orderCompareVo, orderCompareDiffEo);
        compareDiffEos.add(orderCompareDiffEo);
    }

    private boolean editReconciliationResult(List<ReconciliationTaskEo> taskList, ReconciliationTaskEo reconciliationTaskEo, int totalSize, int matchSize, int diffSize) {
        if (diffSize == 0) {
            int filterSize = 0;
            reconciliationTaskEo.setReconciliationResult(String.format("\u5bf9\u8d26(\u884c): %s  \u5bf9\u5e73(\u884c): %s  \u5dee\u5f02(\u884c): %s \u5ffd\u7565(\u884c): %s", totalSize, matchSize, diffSize, filterSize));
            taskList.add(reconciliationTaskEo);
            return true;
        }
        return false;
    }

    private OrderCompareDiffEo getOrderCompareDiffEo(String k, String v) {
        OrderCompareDiffEo orderCompareDiffEo = new OrderCompareDiffEo();
        orderCompareDiffEo.setChannelCode(k);
        orderCompareDiffEo.setChannelName(v);
        orderCompareDiffEo.setDiffTime(new Date());
        orderCompareDiffEo.setStatus(YesNoEnum.NO.getValue().toString());
        return orderCompareDiffEo;
    }

    private ReconciliationTaskEo getReconciliationTaskEo(int type, String k, String v) {
        ReconciliationTaskEo reconciliationTaskEo = new ReconciliationTaskEo();
        reconciliationTaskEo.setId(Long.valueOf(this.snowflake.nextId()));
        reconciliationTaskEo.setChannelCode(k);
        reconciliationTaskEo.setChannelName(v);
        reconciliationTaskEo.setCode(this.getTaskCode(k));
        reconciliationTaskEo.setName(this.getTaskName(v));
        if (TaskTypeEnum.MANUAL_IMPORT.getCode().equals(type)) {
            reconciliationTaskEo.setImportFileUrl("");
            reconciliationTaskEo.setImportFileName("");
        }
        reconciliationTaskEo.setTaskType(Integer.valueOf(type));
        reconciliationTaskEo.setPushPerson("system");
        return reconciliationTaskEo;
    }

    private String getTaskName(String v) {
        return v + "\u5bf9\u8d26" + DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)new Date());
    }

    private String getTaskCode(String k) {
        return k + "rt" + System.currentTimeMillis();
    }

    public void initTask() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011,scheduleExpression:{}", (Object)this.scheduleExpression);
        if (StringUtils.isEmpty((CharSequence)this.scheduleExpression)) {
            logger.warn("\u521d\u59cb\u5316\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u5931\u8d25,\u4ea4\u6613\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(TradeSchedulerEnum.ORDER_COMPARE_DIFF_EVENT.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u4e0d\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.createTask();
            return;
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (this.scheduleExpression.equals(origTask.getScheduleExpression())) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                logger.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
            return;
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            logger.info("\u7981\u7528\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
        taskUpate.setScheduleExpression(this.scheduleExpression);
        taskUpate.setInstanceId(Long.valueOf(-1L));
        taskUpate.setTenantId(Long.valueOf(-1L));
        RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
        logger.info("\u66f4\u65b0\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        logger.info("\u542f\u7528\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    public void createTask() {
        logger.info("\u5f00\u59cb\u521b\u5efa\u3010\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.appCode);
        taskAndBizCreate.setBizCode(TradeSchedulerEnum.ORDER_COMPARE_DIFF_EVENT.getBizCode());
        taskAndBizCreate.setBizName(TradeSchedulerEnum.ORDER_COMPARE_DIFF_EVENT.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(this.scheduleExpression);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(TradeSchedulerEnum.ORDER_COMPARE_DIFF_EVENT.getBizName());
        taskAndBizCreate.setTaskDesc("\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)");
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        logger.info("\u81ea\u52a8\u5bf9\u8d26\u4efb\u52a1(N-1)\uff01");
    }
}

