/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DistributionRangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributionItemRecordAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributionShopRecordAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DistributionRecordAddRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.TradeConstant;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareDistributionService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeConfQueryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareDistributionDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareItemRecordDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareShopRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ShareItemRecordDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ShareShopRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.SharedDistributionEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareDistributionServiceImpl
implements IShareDistributionService {
    private static final Logger logger = LoggerFactory.getLogger(ShareDistributionServiceImpl.class);
    @Resource
    private ShareItemRecordDetailDas shareItemRecordDetailDas;
    @Resource
    private ShareShopRecordDas shareShopRecordDas;
    @Resource
    private ShareDistributionDas shareDistributionDas;
    @Resource
    private ITradeConfQueryService tradeConfQueryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DistributionRecordAddRespDto saveShareDistributionItemRecord(DistributionItemRecordAddReqDto distributionItemRecordAddReqDto) {
        logger.info("==>saveShareDistributionItemRecord req:" + JSON.toJSONString((Object)distributionItemRecordAddReqDto));
        Long placeUserId = distributionItemRecordAddReqDto.getPlaceUserId();
        Long shareItemDetailId = distributionItemRecordAddReqDto.getShareItemDetailId();
        ShareItemRecordDetailEo shareItemRecordDetailEo = (ShareItemRecordDetailEo)this.shareItemRecordDetailDas.selectByPrimaryKey(shareItemDetailId);
        if (shareItemRecordDetailEo == null) {
            logger.info("\u5206\u9500\u5546\u54c1\u94fe\u63a5\u4e0d\u5b58\u5728: shareItemDetailId={}", (Object)shareItemDetailId);
            throw new BizException(String.format("\u5206\u9500\u5546\u54c1%s\u94fe\u63a5\u4e0d\u5b58\u5728", shareItemDetailId));
        }
        if (placeUserId.longValue() == shareItemRecordDetailEo.getShareUserId().longValue()) {
            logger.info("\u5206\u9500\u7528\u6237\u548c\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u7528\u6237: placeUserId={}", (Object)placeUserId);
            throw new BizException("\u5206\u9500\u7528\u6237\u548c\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u7528\u6237");
        }
        DateTime now = DateTime.now();
        Integer distributionLimit = (Integer)this.tradeConfQueryService.queryByCode("distributionLimit");
        logger.info("\u5206\u9500\u4fdd\u62a4\u914d\u7f6e\u9879-\u5206\u9500\u4fdd\u62a4\u671f\u9650: {}", (Object)distributionLimit);
        Date expirationTime = now.plusDays(distributionLimit.intValue()).toDate();
        String distributionRange = (String)this.tradeConfQueryService.queryByCode("distributionRange");
        logger.info("\u5206\u9500\u4fdd\u62a4\u914d\u7f6e\u9879-\u5206\u9500\u4fdd\u62a4\u8303\u56f4: {}", (Object)distributionRange);
        Long shareDistributionId = null;
        if (DistributionRangeEnum.SHOP.getName().equals(distributionRange)) {
            SharedDistributionEo sharedDistributionEoSelect = SharedDistributionEo.newInstance();
            sharedDistributionEoSelect.setPlaceUserId(placeUserId);
            sharedDistributionEoSelect.setShopId(shareItemRecordDetailEo.getShopId());
            sharedDistributionEoSelect.setShareType(TradeConstant.SHARE_TYPE_SHOP);
            SharedDistributionEo shopDistributionEo = (SharedDistributionEo)this.shareDistributionDas.selectOne((BaseEo)sharedDistributionEoSelect);
            logger.info("==>\u5e97\u94fa\u4fdd\u62a4\u8303\u56f4\u5546\u54c1\u5206\u4eabplaceOrderId:" + placeUserId + ",shopId:" + shareItemRecordDetailEo.getShopId() + "\u67e5\u8be2\u7ed3\u679c:" + JSON.toJSONString((Object)shopDistributionEo));
            if (shopDistributionEo != null) {
                shareDistributionId = shopDistributionEo.getId();
                shopDistributionEo.setExpirationTime(expirationTime);
                this.shareDistributionDas.updateSelective((BaseEo)shopDistributionEo);
            } else {
                SharedDistributionEo sharedDistributionEo = new SharedDistributionEo();
                sharedDistributionEo.setShareType(TradeConstant.SHARE_TYPE_SHOP);
                sharedDistributionEo.setPlaceUserId(placeUserId);
                sharedDistributionEo.setShareItemDetailId(shareItemDetailId);
                sharedDistributionEo.setShareUserId(shareItemRecordDetailEo.getShareUserId());
                sharedDistributionEo.setShareUserName(shareItemRecordDetailEo.getShareUserName());
                sharedDistributionEo.setShareUserMobile(shareItemRecordDetailEo.getShareUserMobile());
                sharedDistributionEo.setExpirationTime(expirationTime);
                sharedDistributionEo.setItemId(Long.valueOf(shareItemRecordDetailEo.getItemSerial()));
                sharedDistributionEo.setShopId(shareItemRecordDetailEo.getShopId());
                this.shareDistributionDas.insert((BaseEo)sharedDistributionEo);
                shareDistributionId = sharedDistributionEo.getId();
            }
        } else if (DistributionRangeEnum.ITEM.getName().equals(distributionRange)) {
            SharedDistributionEo sharedDistributionEoSelect = SharedDistributionEo.newInstance();
            sharedDistributionEoSelect.setPlaceUserId(placeUserId);
            sharedDistributionEoSelect.setShopId(shareItemRecordDetailEo.getShopId());
            sharedDistributionEoSelect.setItemId(Long.valueOf(shareItemRecordDetailEo.getItemSerial()));
            sharedDistributionEoSelect.setShareType(TradeConstant.SHARE_TYPE_ITEM);
            SharedDistributionEo existSharedDistributionEo = (SharedDistributionEo)this.shareDistributionDas.selectOne((BaseEo)sharedDistributionEoSelect);
            logger.info("==>\u5546\u54c1\u4fdd\u62a4\u8303\u56f4\u5546\u54c1\u5206\u4eabplaceOrderId:" + placeUserId + ",shopId:" + shareItemRecordDetailEo.getShopId() + ",itemId:" + shareItemRecordDetailEo.getItemSerial() + ",\u67e5\u8be2\u7ed3\u679c:" + JSON.toJSONString((Object)existSharedDistributionEo));
            if (existSharedDistributionEo != null && !Objects.equals(existSharedDistributionEo.getShareItemDetailId(), shareItemDetailId)) {
                if (now.isBefore((ReadableInstant)new DateTime((Object)existSharedDistributionEo.getExpirationTime()))) {
                    return new DistributionRecordAddRespDto(existSharedDistributionEo.getShareItemDetailId(), Boolean.FALSE);
                }
                this.shareDistributionDas.logicDeleteById(existSharedDistributionEo.getId());
            }
            SharedDistributionEo sharedDistributionEoParam = SharedDistributionEo.newInstance();
            sharedDistributionEoParam.setPlaceUserId(placeUserId);
            sharedDistributionEoParam.setShareItemDetailId(shareItemDetailId);
            SharedDistributionEo sharedDistributionEo = (SharedDistributionEo)this.shareDistributionDas.selectOne((BaseEo)sharedDistributionEoParam);
            if (sharedDistributionEo != null) {
                shareDistributionId = sharedDistributionEo.getId();
                sharedDistributionEo.setExpirationTime(expirationTime);
                this.shareDistributionDas.updateSelective((BaseEo)sharedDistributionEo);
            } else {
                sharedDistributionEo = new SharedDistributionEo();
                sharedDistributionEo.setShareType(TradeConstant.SHARE_TYPE_ITEM);
                sharedDistributionEo.setPlaceUserId(placeUserId);
                sharedDistributionEo.setShareItemDetailId(shareItemDetailId);
                sharedDistributionEo.setShareUserId(shareItemRecordDetailEo.getShareUserId());
                sharedDistributionEo.setShareUserName(shareItemRecordDetailEo.getShareUserName());
                sharedDistributionEo.setShareUserMobile(shareItemRecordDetailEo.getShareUserMobile());
                sharedDistributionEo.setExpirationTime(expirationTime);
                sharedDistributionEo.setItemId(Long.valueOf(shareItemRecordDetailEo.getItemSerial()));
                sharedDistributionEo.setShopId(shareItemRecordDetailEo.getShopId());
                this.shareDistributionDas.insert((BaseEo)sharedDistributionEo);
                shareDistributionId = sharedDistributionEo.getId();
            }
        } else if (DistributionRangeEnum.MALL.getName().equals(distributionRange)) {
            SharedDistributionEo sharedDistributionEoSelect = SharedDistributionEo.newInstance();
            sharedDistributionEoSelect.setPlaceUserId(placeUserId);
            sharedDistributionEoSelect.setOrderBy("create_time");
            List mallDistributionEos = this.shareDistributionDas.select((BaseEo)sharedDistributionEoSelect);
            SharedDistributionEo mallDistributionEo = this.existDistribution(mallDistributionEos, shareItemRecordDetailEo.getShareUserId());
            logger.info("==>\u5e97\u94fa\u4fdd\u62a4\u8303\u56f4\u5546\u54c1\u5206\u4eabplaceOrderId:" + placeUserId + ",shopId:" + shareItemRecordDetailEo.getShopId() + "\u67e5\u8be2\u7ed3\u679c:" + JSON.toJSONString((Object)mallDistributionEos));
            if (mallDistributionEo != null) {
                shareDistributionId = mallDistributionEo.getId();
                mallDistributionEo.setExpirationTime(expirationTime);
                if (Objects.equals(mallDistributionEo.getShareUserId(), shareItemRecordDetailEo.getShareUserId())) {
                    this.shareDistributionDas.updateSelective((BaseEo)mallDistributionEo);
                }
            } else {
                SharedDistributionEo sharedDistributionEo = new SharedDistributionEo();
                sharedDistributionEo.setShareType(TradeConstant.SHARE_TYPE_MALL);
                sharedDistributionEo.setPlaceUserId(placeUserId);
                sharedDistributionEo.setShareItemDetailId(shareItemDetailId);
                sharedDistributionEo.setShareUserId(shareItemRecordDetailEo.getShareUserId());
                sharedDistributionEo.setShareUserName(shareItemRecordDetailEo.getShareUserName());
                sharedDistributionEo.setShareUserMobile(shareItemRecordDetailEo.getShareUserMobile());
                sharedDistributionEo.setExpirationTime(expirationTime);
                sharedDistributionEo.setItemId(Long.valueOf(shareItemRecordDetailEo.getItemSerial()));
                sharedDistributionEo.setShopId(shareItemRecordDetailEo.getShopId());
                this.shareDistributionDas.insert((BaseEo)sharedDistributionEo);
                shareDistributionId = sharedDistributionEo.getId();
            }
        }
        return new DistributionRecordAddRespDto(shareDistributionId, Boolean.TRUE);
    }

    private SharedDistributionEo existDistribution(List<SharedDistributionEo> mallDistributionEos, Long shareUserId) {
        SharedDistributionEo eo = null;
        if (CollectionUtils.isEmpty(mallDistributionEos)) {
            return null;
        }
        for (SharedDistributionEo mallDistributionEo : mallDistributionEos) {
            if (!mallDistributionEo.getExpirationTime().after(new Date())) continue;
            eo = mallDistributionEo;
            break;
        }
        if (eo != null) {
            return eo;
        }
        for (SharedDistributionEo mallDistributionEo : mallDistributionEos) {
            if (!Objects.equals(mallDistributionEo.getShareUserId(), shareUserId)) continue;
            eo = mallDistributionEo;
            break;
        }
        return eo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DistributionRecordAddRespDto saveShareDistributionShopRecord(DistributionShopRecordAddReqDto distributionShopRecordAddReqDto) {
        logger.info("==>saveShareDistributionShopRecord req:" + JSON.toJSONString((Object)distributionShopRecordAddReqDto));
        String distributionRange = (String)this.tradeConfQueryService.queryByCode("distributionRange");
        logger.info("==\u300bsaveShareDistributionShopRecord\u5206\u9500\u4fdd\u62a4\u914d\u7f6e\u9879-\u5206\u9500\u4fdd\u62a4\u8303\u56f4: {}", (Object)distributionRange);
        if (DistributionRangeEnum.ITEM.getName().equals(distributionRange)) {
            logger.info("==>\u5206\u9500\u4fdd\u62a4\u8303\u56f4\u4e3a\u5546\u54c1\uff0c\u5e97\u94fa\u5206\u4eab\u7801\u65e0\u6548\u7ed1\u5b9a\u5173\u7cfb\u3002");
            new DistributionRecordAddRespDto(null, Boolean.FALSE);
        }
        Long placeOrderId = distributionShopRecordAddReqDto.getPlaceUserId();
        Long shareShopId = distributionShopRecordAddReqDto.getShareShopId();
        ShareShopRecordEo shareShopRecordEo = (ShareShopRecordEo)this.shareShopRecordDas.selectByPrimaryKey(shareShopId);
        if (shareShopRecordEo == null) {
            logger.info("\u5206\u9500\u5e97\u94fa\u94fe\u63a5\u4e0d\u5b58\u5728: shareShopId={}", (Object)shareShopId);
            throw new BizException(String.format("\u5206\u9500\u5e97\u94fa%s\u94fe\u63a5\u4e0d\u5b58\u5728", shareShopId));
        }
        if (placeOrderId.longValue() == shareShopRecordEo.getShareUserId().longValue()) {
            logger.info("\u5206\u9500\u7528\u6237\u548c\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u7528\u6237: placeUserId={}", (Object)placeOrderId);
            throw new BizException("\u5206\u9500\u7528\u6237\u548c\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u7528\u6237");
        }
        DateTime now = DateTime.now();
        Integer distributionLimit = (Integer)this.tradeConfQueryService.queryByCode("distributionLimit");
        logger.info("\u5206\u9500\u4fdd\u62a4\u914d\u7f6e\u9879-\u5206\u9500\u4fdd\u62a4\u671f\u9650: {}", (Object)distributionLimit);
        Date expirationTime = now.plusDays(distributionLimit.intValue()).toDate();
        SharedDistributionEo sharedDistributionEoSelect = SharedDistributionEo.newInstance();
        sharedDistributionEoSelect.setPlaceUserId(placeOrderId);
        sharedDistributionEoSelect.setShopId(shareShopRecordEo.getShopId());
        sharedDistributionEoSelect.setShareType(TradeConstant.SHARE_TYPE_SHOP);
        SharedDistributionEo existSharedDistributionEo = (SharedDistributionEo)this.shareDistributionDas.selectOne((BaseEo)sharedDistributionEoSelect);
        logger.info("==>\u5e97\u94fa\u5206\u4eabplaceOrderId:" + placeOrderId + ",shopId:" + shareShopRecordEo.getShopId() + "\u67e5\u8be2\u7ed3\u679c:" + JSON.toJSONString((Object)existSharedDistributionEo));
        if (existSharedDistributionEo != null && existSharedDistributionEo.getShareShopId().longValue() != shareShopId.longValue()) {
            if (now.isBefore((ReadableInstant)new DateTime((Object)existSharedDistributionEo.getExpirationTime()))) {
                return new DistributionRecordAddRespDto(existSharedDistributionEo.getShareShopId(), Boolean.FALSE);
            }
            this.shareDistributionDas.logicDeleteById(existSharedDistributionEo.getId());
        }
        SharedDistributionEo delEo = SharedDistributionEo.newInstance();
        delEo.setPlaceUserId(placeOrderId);
        delEo.setShopId(shareShopRecordEo.getShopId());
        delEo.setShareType(TradeConstant.SHARE_TYPE_ITEM);
        List delEoList = this.shareDistributionDas.select((BaseEo)delEo);
        if (CollectionUtils.isNotEmpty((Collection)delEoList)) {
            delEoList.stream().forEach(temp -> this.shareDistributionDas.logicDeleteById(temp.getId()));
        }
        SharedDistributionEo sharedDistributionEoParam = SharedDistributionEo.newInstance();
        sharedDistributionEoParam.setPlaceUserId(placeOrderId);
        sharedDistributionEoParam.setShareShopId(shareShopId);
        SharedDistributionEo sharedDistributionEo = (SharedDistributionEo)this.shareDistributionDas.selectOne((BaseEo)sharedDistributionEoParam);
        if (sharedDistributionEo != null) {
            sharedDistributionEo.setExpirationTime(expirationTime);
            this.shareDistributionDas.updateSelective((BaseEo)sharedDistributionEo);
        } else {
            sharedDistributionEo = new SharedDistributionEo();
            sharedDistributionEo.setShareType(TradeConstant.SHARE_TYPE_SHOP);
            sharedDistributionEo.setPlaceUserId(placeOrderId);
            sharedDistributionEo.setShareShopId(shareShopId);
            sharedDistributionEo.setShareUserId(shareShopRecordEo.getShareUserId());
            sharedDistributionEo.setShareUserName(shareShopRecordEo.getShareUserName());
            sharedDistributionEo.setShareUserMobile(shareShopRecordEo.getShareUserMobile());
            sharedDistributionEo.setExpirationTime(expirationTime);
            sharedDistributionEo.setShopId(shareShopRecordEo.getShopId());
            this.shareDistributionDas.insert((BaseEo)sharedDistributionEo);
        }
        return new DistributionRecordAddRespDto(sharedDistributionEo.getId(), Boolean.TRUE);
    }

    @Override
    public List<SharedDistributionEo> getShareDistribution(Long placeUserId, Long shopId, Long itemId) {
        List<Object> list = new ArrayList<SharedDistributionEo>();
        if (placeUserId == null && shopId == null && itemId == null) {
            return list;
        }
        try {
            SharedDistributionEo sharedDistributionEoParam = new SharedDistributionEo();
            if (placeUserId != null) {
                sharedDistributionEoParam.setPlaceUserId(placeUserId);
            }
            if (shopId != null) {
                sharedDistributionEoParam.setShopId(shopId);
            }
            if (itemId != null) {
                sharedDistributionEoParam.setItemId(itemId);
            }
            sharedDistributionEoParam.setOrderBy("createTime");
            list = this.shareDistributionDas.select((BaseEo)sharedDistributionEoParam);
            Date now = new Date();
            return CollectionUtils.isNotEmpty(list) ? list.stream().filter(sharedDistributionEo -> now.before(sharedDistributionEo.getExpirationTime())).collect(Collectors.toList()) : new ArrayList<SharedDistributionEo>();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e0b\u5355\u7528\u6237\u7684\u5206\u9500\u5546\u54c1\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

