/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.action;

import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftConfigTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.AbstractAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.ActionContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class DiscountAction
extends AbstractAction {
    @Override
    public boolean judge(ActionContext actionContext) {
        return Objects.nonNull(actionContext.getContentData("discount", Boolean.class)) ? actionContext.getContentData("discount", Boolean.class).booleanValue() : Boolean.TRUE.booleanValue();
    }

    @Override
    protected void start(ActionContext actionContext) {
        GiftConfigBaseRespDto configBase = this.getConfigBase(actionContext);
        BalanceDetailRespDto account = this.getAccount(actionContext);
        GiftInfoRespDto info = this.getInfo(actionContext);
        boolean all = Objects.equals(GiftConfigTypeEnum.ALL_DEDUCT, configBase.getGiftConfigTypeEnum());
        info.setDeductionType(all);
        List<TradeItemRespDto> item = this.getItem(actionContext);
        ArrayList list = Lists.newArrayList();
        List<TradeItemRespDto> giftItemList = item.stream().filter(e -> Integer.valueOf(0).equals(e.getGift())).filter(x -> Objects.equals(SubTypeEnum.GIFT.getType(), x.getSubType()) || Objects.equals(SubTypeEnum.MATERIEL.getType(), x.getSubType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(giftItemList)) {
            BigDecimal nowUsableBalance;
            BigDecimal totalPrice = giftItemList.stream().map(f -> this.getTotalPrice((TradeItemRespDto)f)).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal bigDecimal = nowUsableBalance = Objects.nonNull(account.getUsableBalance()) ? account.getUsableBalance().add(info.getAddAmount()) : info.getAddAmount();
            if (nowUsableBalance.compareTo(BigDecimal.ZERO) > 0 && BigDecimal.ZERO.compareTo(totalPrice) < 0) {
                if (all) {
                    this.allDeduction(info, list, giftItemList, totalPrice, nowUsableBalance);
                } else {
                    BigDecimal tempUsableBalance = nowUsableBalance.compareTo(totalPrice) > 0 ? totalPrice : nowUsableBalance;
                    TradeItemRespDto tradeItemRespDto = giftItemList.stream().max(Comparator.comparing(e -> this.getTotalPrice((TradeItemRespDto)e))).get();
                    String maxKey = tradeItemRespDto.getItemSerial() + "#" + tradeItemRespDto.getIfExchange() + "#" + tradeItemRespDto.getExchangeActivityId() + "#" + tradeItemRespDto.getIsCombinedPackage() + "#" + tradeItemRespDto.getCombinedPackageActivityId();
                    BigDecimal sumDiscountAmount = BigDecimal.ZERO;
                    for (TradeItemRespDto itemRespDto : giftItemList) {
                        String targetKey = itemRespDto.getItemSerial() + "#" + itemRespDto.getIfExchange() + "#" + itemRespDto.getExchangeActivityId() + "#" + itemRespDto.getIsCombinedPackage() + "#" + itemRespDto.getCombinedPackageActivityId();
                        if (Objects.equals(maxKey, targetKey)) continue;
                        itemRespDto.setDiscountAmount(tempUsableBalance.multiply(this.getTotalPrice(itemRespDto)).divide(totalPrice, 2, 5));
                        sumDiscountAmount = sumDiscountAmount.add(itemRespDto.getDiscountAmount());
                        list.add(itemRespDto);
                    }
                    tradeItemRespDto.setDiscountAmount(tempUsableBalance.subtract(sumDiscountAmount));
                    info.setDeductionAmount(tempUsableBalance);
                    list.add(tradeItemRespDto);
                }
            }
            info.setList((List)list);
            if (info.getAddAmount().compareTo(info.getDeductionAmount()) > 0) {
                info.setUnableAmount(info.getAddAmount().subtract(info.getDeductionAmount()));
            } else {
                info.setUnableAmount(BigDecimal.ZERO);
            }
        }
    }

    private void allDeduction(GiftInfoRespDto info, List<TradeItemRespDto> list, List<TradeItemRespDto> giftItemList, BigDecimal totalPrice, BigDecimal nowUsableBalance) {
        if (nowUsableBalance.compareTo(totalPrice) >= 0) {
            for (TradeItemRespDto tradeItemRespDto : giftItemList) {
                tradeItemRespDto.setDiscountAmount(this.getTotalPrice(tradeItemRespDto));
                list.add(tradeItemRespDto);
            }
            info.setDeductionAmount(totalPrice);
        } else {
            BigDecimal maxDeductionAmount = BigDecimal.ZERO;
            if (this.getTotalPrice(giftItemList.get(0)).compareTo(nowUsableBalance) == 0) {
                TradeItemRespDto tradeItemRespDto = giftItemList.get(0);
                String maxKey = tradeItemRespDto.getItemSerial() + "#" + tradeItemRespDto.getIfExchange() + "#" + tradeItemRespDto.getExchangeActivityId() + "#" + tradeItemRespDto.getIsCombinedPackage() + "#" + tradeItemRespDto.getCombinedPackageActivityId();
                giftItemList.forEach(e -> {
                    String targetKey = e.getItemSerial() + "#" + e.getIfExchange() + "#" + e.getExchangeActivityId() + "#" + e.getIsCombinedPackage() + "#" + e.getCombinedPackageActivityId();
                    if (Objects.equals(maxKey, targetKey)) {
                        e.setDiscountAmount(this.getTotalPrice((TradeItemRespDto)e));
                    }
                    list.add((TradeItemRespDto)e);
                });
                maxDeductionAmount = this.getTotalPrice(giftItemList.get(0));
            } else {
                BigDecimal[][] dp = new BigDecimal[giftItemList.size()][nowUsableBalance.intValue() + 1];
                int maxIndex = 0;
                dp[0][0] = BigDecimal.ZERO;
                if (this.getTotalPrice(giftItemList.get(0)).compareTo(nowUsableBalance) < 0) {
                    dp[0][this.getTotalPrice((TradeItemRespDto)giftItemList.get((int)0)).intValue()] = this.getTotalPrice(giftItemList.get(0));
                    maxDeductionAmount = this.getTotalPrice(giftItemList.get(0));
                }
                for (int i = 1; i < giftItemList.size(); ++i) {
                    for (int j = 0; j < nowUsableBalance.intValue(); ++j) {
                        if (!Objects.nonNull(dp[i - 1][j])) continue;
                        dp[i][j] = dp[i - 1][j];
                        BigDecimal policyPrice = this.getTotalPrice(giftItemList.get(i)).add(dp[i - 1][j]);
                        if (policyPrice.compareTo(nowUsableBalance) > 0) continue;
                        dp[i][policyPrice.intValue()] = policyPrice;
                        if (policyPrice.compareTo(maxDeductionAmount) <= 0) continue;
                        maxDeductionAmount = policyPrice;
                        maxIndex = i;
                    }
                }
                HashSet<String> resItemSet = new HashSet<String>();
                BigDecimal temp = maxDeductionAmount;
                for (int i = maxIndex; i > 0; --i) {
                    if (temp.compareTo(this.getTotalPrice(giftItemList.get(i))) < 0 || !Objects.nonNull(dp[i - 1][temp.subtract(this.getTotalPrice(giftItemList.get(i))).intValue()]) || dp[i - 1][temp.subtract(this.getTotalPrice(giftItemList.get(i))).intValue()].add(this.getTotalPrice(giftItemList.get(i))).compareTo(temp) != 0) continue;
                    TradeItemRespDto tradeItemRespDto = giftItemList.get(i);
                    resItemSet.add(tradeItemRespDto.getItemSerial() + "#" + tradeItemRespDto.getIfExchange() + "#" + tradeItemRespDto.getExchangeActivityId() + "#" + tradeItemRespDto.getIsCombinedPackage() + "#" + tradeItemRespDto.getCombinedPackageActivityId());
                    temp = temp.subtract(this.getTotalPrice(giftItemList.get(i)));
                }
                if (temp.compareTo(BigDecimal.ZERO) > 0) {
                    TradeItemRespDto tradeItemRespDto = giftItemList.get(0);
                    resItemSet.add(tradeItemRespDto.getItemSerial() + "#" + tradeItemRespDto.getIfExchange() + "#" + tradeItemRespDto.getExchangeActivityId() + "#" + tradeItemRespDto.getIsCombinedPackage() + "#" + tradeItemRespDto.getCombinedPackageActivityId());
                }
                giftItemList.forEach(e -> {
                    if (resItemSet.contains(e.getItemSerial() + "#" + e.getIfExchange() + "#" + e.getExchangeActivityId() + "#" + e.getIsCombinedPackage() + "#" + e.getCombinedPackageActivityId())) {
                        e.setDiscountAmount(this.getTotalPrice((TradeItemRespDto)e));
                    }
                    list.add((TradeItemRespDto)e);
                });
            }
            info.setDeductionAmount(maxDeductionAmount);
        }
    }
}

