/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftConfigRangeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigCustomerExcludeQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuCustomerListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.AbstractAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.action.ActionContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GiveAction
extends AbstractAction {
    private final IGiftConfigCustomerQueryApi giftConfigCustomerQueryApi = (IGiftConfigCustomerQueryApi)SpringBeanUtil.getBean(IGiftConfigCustomerQueryApi.class);

    @Override
    protected void start(ActionContext actionContext) {
        BalanceDetailRespDto account = this.getAccount(actionContext);
        if (Objects.equals(SwitchEnum.OFF.getCode(), account.getGiveFlag())) {
            return;
        }
        Long customerId = this.getCustomerId(actionContext);
        GiftConfigBaseRespDto configBase = this.getConfigBase(actionContext);
        GiftInfoRespDto info = this.getInfo(actionContext);
        ItemSkuListQueryReqDto dto = new ItemSkuListQueryReqDto();
        dto.setGiftExclude(Integer.valueOf(1));
        List<TradeItemRespDto> item = this.getItem(actionContext);
        List<TradeItemRespDto> giftItemList = this.getGiftItem(actionContext);
        HashSet itemSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(giftItemList)) {
            giftItemList.stream().forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getGiftSkuIds())) {
                    itemSet.addAll(Arrays.asList(x.getGiftSkuIds().split(",")));
                }
            });
        }
        LOGGER.info("\u8d60\u54c1\u5173\u8054\u7684\u5546\u54c1" + JSON.toJSONString((Object)itemSet));
        List collect = item.stream().filter(e -> Objects.equals(1, e.getSubType())).map(e -> Long.parseLong(e.getSkuSerial())).distinct().collect(Collectors.toList());
        GiftConfigCustomerExcludeQueryReqDto customerExcludeQueryReqDto = new GiftConfigCustomerExcludeQueryReqDto();
        customerExcludeQueryReqDto.setCustomerId(customerId);
        customerExcludeQueryReqDto.setGiftExclude(Integer.valueOf(1));
        customerExcludeQueryReqDto.setPageNum(Integer.valueOf(1));
        customerExcludeQueryReqDto.setPageSize(Integer.valueOf(10000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftConfigCustomerQueryApi.getSkuList(customerExcludeQueryReqDto));
        LOGGER.info("[\u6392\u9664\u4fe1\u606f]\uff0c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        Set<Object> excludeSet = new HashSet();
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            excludeSet = pageInfo.getList().stream().map(ItemSkuCustomerListRespDto::getSkuId).collect(Collectors.toSet());
        }
        LOGGER.info("\u67e5\u8be2\u6392\u9664\u5546\u54c1\u4fe1\u606f\u4e3a" + JSON.toJSONString(excludeSet));
        HashSet finalExcludeSet = excludeSet;
        Set items = item.stream().filter(e -> Integer.valueOf(0).equals(e.getGift())).filter(x -> Objects.equals(1, x.getSubType())).filter(x -> !finalExcludeSet.contains(Long.valueOf(x.getSkuSerial()))).map(TradeItemRespDto::getSkuSerial).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        if (Objects.equals(account.getGiveType(), GiveTypeEnum.PROPORTION.getCode())) {
            item.stream().filter(e -> Integer.valueOf(0).equals(e.getGift())).filter(x -> items.contains(x.getSkuSerial())).forEach(x -> x.setAddAmount(BigDecimal.valueOf(x.getItemNum().intValue()).multiply(account.getQuantityScaleAmount()).setScale(4, 5).divide(account.getQuantityScaleSum(), 4, 5).multiply(account.getGiveProportion()).setScale(2, 5).divide(BigDecimal.valueOf(100L), 2, 5)));
        } else {
            item.stream().filter(e -> Integer.valueOf(0).equals(e.getGift())).filter(x -> items.contains(x.getSkuSerial())).forEach(x -> {
                boolean discountFlag = Objects.equals(account.getGivePriceType(), GivePriceTypeEnum.DISCOUNT_PRICE.getCode());
                BigDecimal totalPrice = x.getItemMarketPrice().multiply(BigDecimal.valueOf(x.getItemNum().intValue())).setScale(2, 5);
                if (discountFlag) {
                    if (CollectionUtils.isNotEmpty((Collection)configBase.getRebateRangeList())) {
                        for (String rebate : configBase.getRebateRangeList()) {
                            if (Objects.equals(rebate, GiftConfigRangeEnum.RANGE_SECTION.getCode()) && itemSet.contains(x.getSkuSerial())) {
                                x.setDiscountProductAmount(x.getItemOrigPrice());
                                totalPrice = BigDecimal.ZERO;
                                break;
                            }
                            if (Objects.equals(rebate, GiftConfigRangeEnum.RANGE_FRIST.getCode())) {
                                totalPrice = totalPrice.subtract(Optional.ofNullable(x.getDiscountTotalAmount()).orElse(BigDecimal.ZERO));
                            }
                            if (!Objects.equals(rebate, GiftConfigRangeEnum.RANGE_THREE.getCode())) continue;
                            totalPrice = totalPrice.subtract(Optional.ofNullable(x.getRebateAmount()).orElse(BigDecimal.ZERO));
                        }
                    }
                    x.setProductRebateAmount(totalPrice);
                }
                if (account.getGiveProportion() != null) {
                    x.setAddAmount(totalPrice.multiply(account.getGiveProportion()).setScale(2, 5).divide(BigDecimal.valueOf(100L), 2, 5));
                }
            });
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (TradeItemRespDto tradeItemRespDto : item) {
            totalAmount = totalAmount.add(tradeItemRespDto.getAddAmount());
        }
        info.setAddAmount(totalAmount);
        info.setUnableAmount(totalAmount);
    }
}

