/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.alarm;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.alarm.api.IMonitorDataFetcher;
import com.dtyunxi.yundt.cube.alarm.api.domain.BaseMonitorData;
import com.dtyunxi.yundt.cube.alarm.api.dto.req.MonitorDataFetchReqDto;
import com.dtyunxi.yundt.cube.alarm.domain.AlarmRule;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DeliveryMonitorDataFetcherImpl
implements IMonitorDataFetcher {
    @Resource
    private OrderDeliveryDas orderDeliveryDas;

    public List<BaseMonitorData> fetch(MonitorDataFetchReqDto reqDto) {
        AlarmRule alarmRule = reqDto.getAlarmRule();
        OrderDeliveryEo orderDeliveryEo = new OrderDeliveryEo();
        orderDeliveryEo.setTenantId(alarmRule.getTenantId());
        orderDeliveryEo.setInstanceId(alarmRule.getInstanceId());
        String startUpdateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00"));
        String endUpdateTime = LocalDateTime.now().plusMinutes(-1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:00"));
        List sqlFilterList = SqlFilterBuilder.create(OrderDeliveryEo.class).ge("update_time", (Object)startUpdateTime).le("update_time", (Object)endUpdateTime).filters();
        orderDeliveryEo.setSqlFilters(sqlFilterList);
        List orderDeliveryEoList = this.orderDeliveryDas.selectList((BaseEo)orderDeliveryEo, Integer.valueOf(1), Integer.valueOf(5000));
        List<BaseMonitorData> baseMonitorDataCollection = orderDeliveryEoList.stream().map(e -> this.convertToBaseMonitorData((OrderDeliveryEo)e)).collect(Collectors.toList());
        return baseMonitorDataCollection;
    }

    private BaseMonitorData convertToBaseMonitorData(OrderDeliveryEo e) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        BaseMonitorData baseMonitorData = new BaseMonitorData(e.getDeliveryNo(), vars);
        vars.put("deliveryStatus", e.getDeliveryStatus());
        vars.put("overtime", this.getCurrentDiffTime(e.getUpdateTime()));
        return baseMonitorData;
    }

    private long getCurrentDiffTime(Date date) {
        long currentTime = System.currentTimeMillis();
        long updateTime = date.getTime();
        long diff = (currentTime - updateTime) / 1000L / 60L;
        return diff;
    }
}

