/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.alarm;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.rules.RuleResultSet;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.alarm.api.constant.AlarmReceiverContentVariablesKey;
import com.dtyunxi.yundt.cube.alarm.client.rule.AbstractAlarmRuleExecutor;
import com.dtyunxi.yundt.cube.alarm.domain.Alarm;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.OrderDeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeliveryRuleExecutor
extends AbstractAlarmRuleExecutor {
    private static final Logger log = LoggerFactory.getLogger(DeliveryRuleExecutor.class);
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Resource
    private IShopQueryApi shopQueryApi;
    public static String CONTENT_TEMPLATE = "\u5c0a\u656c\u7684" + AlarmReceiverContentVariablesKey.PHONE + "\u60a8\u597d\uff0c${store}\u60a8\u6709${orderSize}\u6761\u8ba2\u5355${state}\uff0c\u5355\u53f7\u4e3a\uff1a${orderNos}\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b";

    public Alarm buildAlarm(Alarm alarm, RuleResultSet resultSet) {
        RestResponse shopDtoRestResponse;
        ShopDto shopDto;
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        String refId = alarm.getRefId();
        OrderDeliveryEo orderDeliveryEo = this.orderDeliveryDas.selectByDeliveryNo(refId);
        log.info("DeliveryRuleExecutor orderDeliveryEo:{}", JSONObject.toJSON((Object)orderDeliveryEo));
        if (Objects.nonNull(orderDeliveryEo)) {
            RefDeliveryOrderEo orderQuery = new RefDeliveryOrderEo();
            orderQuery.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            List refDeliveryOrderEoList = this.refDeliveryOrderDas.select((BaseEo)orderQuery);
            String orders = refDeliveryOrderEoList.stream().map(e -> e.getOrderNo()).collect(Collectors.joining(","));
            valuesMap.put("orderSize", refDeliveryOrderEoList.size());
            valuesMap.put("state", OrderDeliveryStatusEnum.getMsg(orderDeliveryEo.getDeliveryStatus()));
            valuesMap.put("orderNos", StringUtils.trimToEmpty((String)orders));
        }
        if (Objects.nonNull(shopDto = (ShopDto)(shopDtoRestResponse = this.shopQueryApi.queryById(Long.valueOf(orderDeliveryEo.getShopId()).longValue(), new String[0])).getData())) {
            valuesMap.put("store", shopDto.getName());
        }
        String content = StrSubstitutor.replace((Object)CONTENT_TEMPLATE, valuesMap);
        alarm.setContent(content);
        return alarm;
    }
}

