/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.ItemRelationComparisonRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.query.IItemRelationComparisonQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.AuditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeviceType;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShopTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.ReturnStatusToBEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderProofReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSettingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.AfterSalesItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemExtensionConvertDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.AuditRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ExchangeDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ExchangeRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderProofRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnBundleItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.ReturnOrderStatusCountRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.vo.OrderDeliverMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.mq.OrderAfterSalesProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.PerformanceProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.ReturnItemMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.ReturnMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IApplyReturnItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderProofService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.dto.BizItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ApplyReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.AuditRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ExchangeDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ProblemOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefReturnRefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefTradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnOmniDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ApplyReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.AuditRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ExchangeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ProblemOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefReturnRefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnOmniEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefReturnRefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngineUtil;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.AfterSaleCancelReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.AfterSalesBeanReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.AfterSalesReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.response.AfterSaleCancelRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AfterSalesServiceImpl
implements IAfterSalesService {
    private static Logger logger = LoggerFactory.getLogger(AfterSalesServiceImpl.class);
    @Autowired
    ExchangeDas exchangeDas;
    @Autowired
    ReturnDas returnDas;
    @Autowired
    AuditRecordDas auditRecordDas;
    @Autowired
    RefTradeItemDas refTradeItemDas;
    @Autowired
    TradeItemDas tradeItemDas;
    @Autowired
    ITradeItemService tradeItemService;
    @Resource
    IOrderService orderService;
    @Autowired
    IOrderProofService orderProofService;
    @Resource
    private OrderDas orderDas;
    @Autowired
    private ReturnOmniDas returnOmniDas;
    @Autowired
    private RefundDas refundDas;
    @Autowired
    private ReturnItemDas returnItemDas;
    @Autowired
    private ApplyReturnItemDas applyReturnItemDas;
    @Autowired
    private RefReturnRefundDas refReturnRefundDas;
    @Resource
    private PerformanceProducer performanceProducer;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private OrderAfterSalesProducer orderAfterSalesProducer;
    @Autowired
    private ProblemOrderDas problemOrderDas;
    @Autowired
    private IItemRelationComparisonQueryApi itemRelationComparisonQueryApi;
    @Resource
    private RefundDetailDas refundDetailDas;
    @Resource
    private IApplyReturnItemService applyReturnItemService;

    @Override
    public ExchangeEo saveInitExchange(ExchangeEo exchangeEo) {
        exchangeEo.setExchangeStatus(ExchangeStatusEnum.INIT.getName());
        this.exchangeDas.insert((BaseEo)exchangeEo);
        return exchangeEo;
    }

    @Override
    public void modifyReturn(String tradeNo, ReturnModReqDto order) {
        ReturnEo returnEo = new ReturnEo();
        returnEo.setBizStatus(order.getBizStatus());
        returnEo.setBizType(order.getBizType());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)order.getTradeNo()));
        sqlFilters.add(SqlFilter.eq((String)"tenant_id", (Object)order.getTenantId()));
        returnEo.setSqlFilters(sqlFilters);
        this.returnDas.updateSelectiveSqlFilter((BaseEo)returnEo);
    }

    @Override
    public void updateIsRefund(String returnNo, Integer isRefund) {
        ReturnItemEo returnItemEo = new ReturnItemEo();
        returnItemEo.setReturnNo(returnNo);
        List returnItemEoList = this.returnItemDas.select((BaseEo)returnItemEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)returnItemEoList)) {
            return;
        }
        for (ReturnItemEo eo : returnItemEoList) {
            ReturnItemEo returnItem = new ReturnItemEo();
            returnItem.setId(eo.getId());
            returnItem.setIsRefund(isRefund);
            this.returnItemDas.updateSelective((BaseEo)returnItem);
        }
    }

    @Override
    public ExchangeEo modifyExchangeStatus(String tradeNo, String status) {
        return Optional.ofNullable(this.exchangeDas.selectByTradeNo(tradeNo)).map(exchangeEo -> {
            if (ExchangeStatusEnum.getByName((String)status).getCode() < ExchangeStatusEnum.getByName((String)exchangeEo.getExchangeStatus()).getCode()) {
                throw new BizException(TradeExceptionCode.EXCHANGE_STATUS_ERROR.getCode(), TradeExceptionCode.EXCHANGE_STATUS_ERROR.getMsg());
            }
            exchangeEo.setExchangeStatus(status);
            this.exchangeDas.updateSelective((BaseEo)exchangeEo);
            return exchangeEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.EXCHANGE_NOT_EXIST.getCode(), TradeExceptionCode.EXCHANGE_NOT_EXIST.getMsg()));
    }

    @Override
    public ReturnReqDto initParam(ReturnReqDto returnReqDto) {
        Assert.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnReqDto.getOrderProofReturnList()), "\u6838\u9500\u7801\u9000\u6b3e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List<OrderProofRespDto> listByOrderNoAndStatus = this.orderProofService.findListByOrderNoAndStatusAndReturnType(returnReqDto.getOrderTradeNo(), 1, 2);
        Assert.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(listByOrderNoAndStatus), "\u6ca1\u6709\u7b26\u5408\u6ee1\u8db3\u9000\u6b3e\u6761\u4ef6\u7684\u865a\u62df\u5546\u54c1");
        if (StringUtils.isEmpty((CharSequence)returnReqDto.getReturnType()) && ReturnTypeEnum.getByName((String)returnReqDto.getReturnType()) == null) {
            throw new BizException(TradeExceptionCode.RETURN_TYPE_ERROR.getCode(), TradeExceptionCode.RETURN_TYPE_ERROR.getMsg());
        }
        Map<String, List<OrderProofRespDto>> codeMap = listByOrderNoAndStatus.stream().collect(Collectors.groupingBy(OrderProofRespDto::getCode));
        ArrayList<OrderProofRespDto> filterOrderProofReturnList = new ArrayList<OrderProofRespDto>();
        for (OrderProofReturnReqDto orderProofReturnReqDto : returnReqDto.getOrderProofReturnList()) {
            List<OrderProofRespDto> orderProofRespDtoList = codeMap.get(orderProofReturnReqDto.getCode());
            Assert.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(orderProofRespDtoList), "\u6838\u9500\u7801\u4e0d\u6b63\u786e(\u4e0d\u5b58\u5728\u6216\u8005\u72b6\u6001\u4e0d\u5bf9)");
            orderProofReturnReqDto.setId(orderProofRespDtoList.get(0).getId());
            filterOrderProofReturnList.add(orderProofRespDtoList.get(0));
        }
        Map<String, List<OrderProofRespDto>> returnItemNoMap = filterOrderProofReturnList.stream().collect(Collectors.groupingBy(OrderProofRespDto::getTargetSerial));
        ArrayList<AfterSalesItemReqDto> afterSalesItemReqDtos = new ArrayList<AfterSalesItemReqDto>();
        for (List<OrderProofRespDto> orderProofRespDtoList : returnItemNoMap.values()) {
            String tradeItemNo = orderProofRespDtoList.get(0).getTargetSerial();
            AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
            afterSalesItemReqDto.setItemNum(Integer.valueOf(orderProofRespDtoList.size()));
            afterSalesItemReqDto.setTradeItemNo(tradeItemNo);
            afterSalesItemReqDto.setInstanceId(returnReqDto.getInstanceId());
            afterSalesItemReqDto.setTenantId(returnReqDto.getTenantId());
            afterSalesItemReqDtos.add(afterSalesItemReqDto);
        }
        returnReqDto.setAfterSalesItems(afterSalesItemReqDtos);
        return returnReqDto;
    }

    @Override
    public void modifyExchange(String tradeNo, ExchangeEo exchangeEo) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        exchangeEo.setSqlFilters(sqlFilters);
        this.exchangeDas.updateSelectiveSqlFilter((BaseEo)exchangeEo);
    }

    @Override
    public ReturnEo saveInitReturn(ReturnEo returnEo) {
        returnEo.setReturnStatus(ReturnStatusEnum.INIT.getName());
        this.returnDas.insert((BaseEo)returnEo);
        return returnEo;
    }

    @Override
    public ReturnEo getByTradeNo(String returnNo) {
        return this.returnDas.selectByTradeNo(returnNo);
    }

    @Override
    public ReturnEo saveInitReturn4Flow(ReturnEo returnEo, String curActionNode, String result) {
        Long flowId = TradeEngineUtil.getFLowDefId();
        returnEo.setFlowDefId(flowId);
        TradeEngine.setFlowStatus(returnEo, result, curActionNode);
        this.returnDas.insert((BaseEo)returnEo);
        return returnEo;
    }

    @Override
    public ReturnEo modifyReturnStatus(String tradeNo, String status) {
        return Optional.ofNullable(this.returnDas.selectByTradeNo(tradeNo)).map(returnEo -> {
            if (ReturnStatusEnum.getByName((String)status).getCode() < ReturnStatusEnum.getByName((String)returnEo.getReturnStatus()).getCode()) {
                throw new BizException(TradeExceptionCode.RETURN_STATUS_ERROR.getCode(), TradeExceptionCode.RETURN_STATUS_ERROR.getMsg());
            }
            returnEo.setReturnStatus(status);
            this.returnDas.updateSelective((BaseEo)returnEo);
            return returnEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.RETURN_NOT_EXIST.getCode(), TradeExceptionCode.RETURN_NOT_EXIST.getMsg()));
    }

    @Override
    public ReturnEo modifyReturnStatus4Flow(String returnNo, String curActionNode, String bizResult) {
        if (StringUtils.isEmpty((CharSequence)returnNo)) {
            throw new BizException("\u9000\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Optional.ofNullable(this.returnDas.selectByTradeNo(returnNo)).map(returnEo -> {
            TradeEngineUtil.setFlowDefId(returnEo.getFlowDefId());
            TradeEngine.validate((IFlowEntity)returnEo, curActionNode);
            TradeEngine.setFlowStatus(returnEo, bizResult, curActionNode);
            this.returnDas.updateSelective((BaseEo)returnEo);
            return returnEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.RETURN_NOT_EXIST.getCode(), TradeExceptionCode.RETURN_NOT_EXIST.getMsg()));
    }

    @Override
    public void modifyReturn(String tradeNo, ReturnEo returnEo) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        returnEo.setSqlFilters(sqlFilters);
        this.returnDas.updateSelectiveSqlFilter((BaseEo)returnEo);
    }

    @Override
    public AuditRecordEo saveInitAuditRecord(AuditRecordEo auditRecordEo) {
        this.auditRecordDas.insert((BaseEo)auditRecordEo);
        return auditRecordEo;
    }

    @Override
    public AuditRecordEo modifyAuditRecordStatus(String tradeNo, String status) {
        return Optional.ofNullable(this.auditRecordDas.selectByTradeNo(tradeNo)).map(auditRecordEo -> {
            if (AuditRecordStatusEnum.getByName((String)status).getCode() < AuditRecordStatusEnum.getByName((String)auditRecordEo.getAuditStatus()).getCode()) {
                throw new BizException(TradeExceptionCode.RETURN_STATUS_ERROR.getCode(), TradeExceptionCode.RETURN_STATUS_ERROR.getMsg());
            }
            auditRecordEo.setAuditStatus(status);
            this.auditRecordDas.updateSelective((BaseEo)auditRecordEo);
            return auditRecordEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.RETURN_NOT_EXIST.getCode(), TradeExceptionCode.RETURN_NOT_EXIST.getMsg()));
    }

    @Override
    public void modifyAuditRecord(String auditRecordNo, AuditRecordEo auditRecordEo) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"audit_record_no", (Object)auditRecordNo));
        auditRecordEo.setSqlFilters(sqlFilters);
        this.auditRecordDas.updateSelectiveSqlFilter((BaseEo)auditRecordEo);
    }

    @Override
    public PageInfo<ExchangeRespDto> queryExchangeByPage(String filter, Integer pageNum, Integer pageSize) {
        ExchangeEo exchangeEo = (ExchangeEo)JSON.parseObject((String)filter, ExchangeEo.class);
        exchangeEo.setOrderByDesc("id");
        PageInfo pageInfo = this.exchangeDas.selectPage((BaseEo)exchangeEo, pageNum, pageSize);
        ArrayList exchangeRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), exchangeRespDtoList, ExchangeRespDto.class);
        pageInfo.setList(exchangeRespDtoList);
        return pageInfo;
    }

    @Override
    public ExchangeDetailRespDto queryExchangeDetail(String tradeNo, String filter) {
        ExchangeEo temp = (ExchangeEo)JSON.parseObject((String)filter, ExchangeEo.class);
        temp.setTradeNo(tradeNo);
        ExchangeEo exchangeEo = (ExchangeEo)this.exchangeDas.selectOne((BaseEo)temp);
        ExchangeDetailRespDto exchangeRepDto = new ExchangeDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)exchangeEo, (BaseVo)exchangeRepDto);
        exchangeRepDto.setAuditRecordReps(this.queryAuditRecord(tradeNo));
        exchangeRepDto.setAfterSalesItems(this.queryAfterSalesItem(tradeNo, null));
        return exchangeRepDto;
    }

    @Override
    public PageInfo<ReturnRespDto> queryReturnByPage(String filter, Integer pageNum, Integer pageSize) {
        ReturnQueryReqDto returnQueryReqDto = (ReturnQueryReqDto)JSON.parseObject((String)filter, ReturnQueryReqDto.class);
        return this.queryReturnByPage(returnQueryReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<RefundRespDto> queryReturnDetailByPage(String filter, Integer pageNum, Integer pageSize) {
        ReturnQueryReqDto returnQueryReqDto = (ReturnQueryReqDto)JSON.parseObject((String)filter, ReturnQueryReqDto.class);
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        DtoHelper.dto2Eo((BaseVo)returnQueryReqDto, (BaseEo)returnOmniEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (ObjectUtil.isNotEmpty((Object)returnQueryReqDto.getOrderTradeNo())) {
            sqlFilters.add(SqlFilter.in((String)"order_trade_no", (Object)returnQueryReqDto.getOrderTradeNo()));
        }
        returnOmniEo.setSqlFilters(sqlFilters);
        returnOmniEo.setOrderByDesc("id");
        PageInfo pageInfo = this.returnOmniDas.selectPage((BaseEo)returnOmniEo, pageNum, pageSize);
        ArrayList returnRespDtoList = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), returnRespDtoList, ReturnRespDto.class);
        pageInfo.setList(returnRespDtoList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(returnRespDtoList)) {
            return pageInfo;
        }
        String returnNos = returnRespDtoList.stream().map(ReturnRespDto::getReturnNo).collect(Collectors.joining("','", "'", "'"));
        RefundEo queryEo = new RefundEo();
        ArrayList<SqlFilter> refundSqlList = new ArrayList<SqlFilter>();
        refundSqlList.add(SqlFilter.in((String)"return_no", (Object)returnNos));
        queryEo.setSqlFilters(refundSqlList);
        List refundEoList = this.refundDas.select((BaseEo)queryEo);
        ArrayList refundRespDtos = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)refundEoList)) {
            Map<String, List<RefundDetailEo>> refundDetailMap;
            DtoHelper.eoList2DtoList((Collection)refundEoList, refundRespDtos, RefundRespDto.class);
            List refundNos = refundEoList.stream().map(StdRefundEo::getRefundNo).distinct().collect(Collectors.toList());
            RefundDetailEo queryDetailEo = RefundDetailEo.newInstance();
            ArrayList<SqlFilter> detailSqlFilters = new ArrayList<SqlFilter>();
            detailSqlFilters.add(SqlFilter.in((String)"refund_no", refundNos));
            queryDetailEo.setSqlFilters(detailSqlFilters);
            List refundDetailEos = this.refundDetailDas.select((BaseEo)queryDetailEo);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)refundDetailEos) && null != (refundDetailMap = refundDetailEos.stream().collect(Collectors.groupingBy(StdRefundDetailEo::getRefundNo))) && refundDetailMap.size() > 0) {
                refundRespDtos.stream().forEach(bean -> {
                    List detailEos = (List)refundDetailMap.get(bean.getRefundNo());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)detailEos)) {
                        ArrayList refundDetailRespDtos = new ArrayList();
                        DtoHelper.eoList2DtoList((Collection)detailEos, refundDetailRespDtos, RefundDetailRespDto.class);
                        bean.setRefundDetailRespDtos(refundDetailRespDtos);
                    }
                });
            }
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(refundRespDtos);
        return pageInfoDto;
    }

    @Override
    public PageInfo<ReturnRespDto> queryReturnByPage(ReturnQueryReqDto returnQueryReqDto, Integer pageNum, Integer pageSize) {
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        PageInfo paramPage = this.buildPageCommonQueryParam(returnQueryReqDto, returnOmniEo);
        if (paramPage != null) {
            return paramPage;
        }
        PageInfo pageInfo = this.returnOmniDas.selectPage((BaseEo)returnOmniEo, pageNum, pageSize);
        ArrayList returnRespDtoList = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), returnRespDtoList, ReturnRespDto.class);
        pageInfo.setList(returnRespDtoList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(returnRespDtoList)) {
            return pageInfo;
        }
        List returnRespDtos = pageInfo.getList();
        ReturnRespDto returnResp = (ReturnRespDto)returnRespDtos.get(0);
        Boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)(returnResp.getExtFields().get("customerId") + ""))) {
            flag = true;
        }
        String returnNos = returnRespDtoList.stream().map(ReturnRespDto::getReturnNo).collect(Collectors.joining("','", "'", "'"));
        List<ReturnItemEo> returnItemEos = this.getReturnItems(returnNos);
        List<ApplyReturnItemEo> applyReturnItemEos = this.getApplyReturnItems(returnNos);
        Map<String, List<ReturnItemEo>> itemMap = this.getItemMap(returnItemEos);
        Map<String, List<ApplyReturnItemEo>> applyItemMap = this.getApplyItemMap(applyReturnItemEos);
        Map<String, List<ReturnItemEo>> itemAmountMoney = this.getItemAmountMoney(returnItemEos);
        Map<String, BigDecimal> payAmount = this.getPayAmount(returnNos);
        Boolean finalFlag = flag;
        returnRespDtoList.stream().forEach(returnRespDto -> {
            BigDecimal payMoney;
            List tempReturnItemEos;
            returnRespDto.setReturnOmniItemRespDtoList(this.convertReturnOmniItemRespDto((List)itemMap.get(returnRespDto.getReturnNo())));
            returnRespDto.setApplyReturnItemRespDtoList(this.converApplyReturnItemRespDto((List)applyItemMap.get(returnRespDto.getReturnNo())));
            if (null != itemAmountMoney && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(tempReturnItemEos = (List)itemAmountMoney.get(returnRespDto.getReturnNo())))) {
                returnRespDto.setRefundAmount(tempReturnItemEos.stream().map(bean -> bean.getItemPrice().add(Optional.ofNullable(bean.getAdjustNum()).orElse(BigDecimal.ZERO)).multiply(new BigDecimal(Optional.ofNullable(bean.getReturnNum()).orElse(0)))).reduce(BigDecimal.ZERO, BigDecimal::add).abs());
            }
            if (null != payAmount && null != (payMoney = (BigDecimal)payAmount.get(returnRespDto.getReturnNo()))) {
                returnRespDto.setPayAmount(payMoney);
            }
        });
        RefundEo queryEo = new RefundEo();
        ArrayList<SqlFilter> refundSqlList = new ArrayList<SqlFilter>();
        refundSqlList.add(SqlFilter.in((String)"return_no", (Object)returnNos));
        queryEo.setSqlFilters(refundSqlList);
        List refundEoList = this.refundDas.select((BaseEo)queryEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)refundEoList)) {
            Map<String, List<RefundEo>> returnNoMap = refundEoList.stream().collect(Collectors.groupingBy(RefundEo::getReturnNo));
            returnRespDtoList.stream().forEach(returnRespDto -> {
                List refunds = (List)returnNoMap.get(returnRespDto.getReturnNo());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)refunds)) {
                    returnRespDto.setRefundStatus(((RefundEo)refunds.get(0)).getRefundStatus());
                }
            });
        }
        return pageInfo;
    }

    private PageInfo buildPageCommonQueryParam(ReturnQueryReqDto returnQueryReqDto, ReturnOmniEo returnOmniEo) {
        DtoHelper.dto2Eo((BaseVo)returnQueryReqDto, (BaseEo)returnOmniEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (returnQueryReqDto.getReturnTimeStart() != null) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)format.format(returnQueryReqDto.getReturnTimeStart())));
        }
        if (returnQueryReqDto.getReturnTimeEnd() != null) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)format.format(returnQueryReqDto.getReturnTimeEnd())));
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)returnQueryReqDto.getSellerIds())) {
            List sellerIds = returnQueryReqDto.getSellerIds();
            List sellerIdList = sellerIds.stream().map(String::valueOf).collect(Collectors.toList());
            sqlFilters.add(SqlFilter.in((String)"seller_id", sellerIdList));
        }
        if (StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getUserId())) {
            sqlFilters.add(SqlFilter.eq((String)"user_id", (Object)returnQueryReqDto.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getUserIds())) {
            sqlFilters.add(SqlFilter.in((String)"user_id", (Object)returnQueryReqDto.getUserIds()));
        }
        if (StringUtils.isNotEmpty((CharSequence)returnQueryReqDto.getCustomerIds())) {
            String[] customerIds = returnQueryReqDto.getCustomerIds().split(",");
            sqlFilters.add(SqlFilter.in((String)"customer_id", Arrays.asList(customerIds)));
        }
        if (StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getReturnStatusList())) {
            sqlFilters.add(SqlFilter.in((String)"return_status", (Object)returnQueryReqDto.getReturnStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getReturnNoList())) {
            sqlFilters.add(SqlFilter.in((String)"return_no", (Object)returnQueryReqDto.getReturnNoList()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnQueryReqDto.getOrderTradeNos())) {
            sqlFilters.add(SqlFilter.in((String)"order_trade_no", (Object)returnQueryReqDto.getOrderTradeNos()));
        }
        ArrayList returnNoList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getKeyword()) && StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getCustomerIds())) {
            String[] customerIds = returnQueryReqDto.getCustomerIds().split(",");
            returnNoList.addAll(this.applyReturnItemDas.queryTradeNoByKeywordAndCustomerIds(returnQueryReqDto.getKeyword(), customerIds));
            returnNoList.addAll(this.returnItemDas.queryTradeNoByKeywordAndCustomerIds(returnQueryReqDto.getKeyword(), customerIds));
            if (org.apache.commons.collections.CollectionUtils.isEmpty(returnNoList)) {
                return new PageInfo();
            }
            sqlFilters.add(SqlFilter.in((String)"return_no", returnNoList));
        }
        if (StrUtil.isNotBlank((CharSequence)returnQueryReqDto.getReturnNo())) {
            sqlFilters.add(SqlFilter.like((String)"return_no", (Object)("%" + returnQueryReqDto.getReturnNo() + "%")));
            returnOmniEo.setReturnNo(null);
        }
        if (StrUtil.isNotBlank((CharSequence)returnQueryReqDto.getOrderTradeNo())) {
            sqlFilters.add(SqlFilter.like((String)"order_trade_no", (Object)("%" + returnQueryReqDto.getOrderTradeNo() + "%")));
            returnOmniEo.setOrderTradeNo(null);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnQueryReqDto.getPlaceUserIds())) {
            sqlFilters.add(SqlFilter.in((String)"place_user_id", (Object)returnQueryReqDto.getPlaceUserIds()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnQueryReqDto.getItemCodes()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnQueryReqDto.getBatchNos()) || StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getItemCode()) || StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getBatchNo())) {
            List returnNoByDetails;
            List shopIds = null;
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)returnQueryReqDto.getSellerIds())) {
                ShopQueryDto queryDto = new ShopQueryDto();
                queryDto.setSellerIdList(returnQueryReqDto.getSellerIds());
                List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.shopList(queryDto));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDtos)) {
                    shopIds = shopDtos.stream().map(ShopDto::getId).collect(Collectors.toList());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(returnNoByDetails = this.applyReturnItemDas.queryReturnNoByDetail(returnQueryReqDto, shopIds)))) {
                return new PageInfo();
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(returnNoList)) {
                sqlFilters.add(SqlFilter.in((String)"return_no", returnNoList));
            }
            returnNoList.addAll(returnNoByDetails);
        }
        if (StrUtil.isNotBlank((CharSequence)returnQueryReqDto.getRemark())) {
            sqlFilters.add(SqlFilter.like((String)"remark", (Object)("%" + returnQueryReqDto.getRemark() + "%")));
            returnOmniEo.setRemark(null);
        }
        returnOmniEo.setSqlFilters(sqlFilters);
        returnOmniEo.setOrderByDesc("id");
        return null;
    }

    @Override
    public PageInfo<ReturnOmniItemRespDto> queryReturnItemByPage(String filter, Integer pageNum, Integer pageSize) {
        ReturnQueryReqDto returnQueryReqDto = (ReturnQueryReqDto)JSON.parseObject((String)filter, ReturnQueryReqDto.class);
        ReturnItemEo returnItemEo = new ReturnItemEo();
        DtoHelper.dto2Eo((BaseVo)returnQueryReqDto, (BaseEo)returnItemEo);
        PageInfo pageInfo = this.returnItemDas.selectPage((BaseEo)returnItemEo, pageNum, pageSize);
        ArrayList returnRespDtoList = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), returnRespDtoList, ReturnOmniItemRespDto.class);
        pageInfo.setList(returnRespDtoList);
        return pageInfo;
    }

    private Map<String, BigDecimal> getPayAmount(String returnNos) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        RefReturnRefundEo record = new RefReturnRefundEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"return_no", (Object)returnNos));
        record.setSqlFilters(sqlFilters);
        List select = this.refReturnRefundDas.select((BaseEo)record);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)select)) {
            return Maps.newHashMap();
        }
        String refundNos = select.stream().map(StdRefReturnRefundEo::getRefundNo).collect(Collectors.joining("','", "'", "'"));
        ArrayList<SqlFilter> sqlFiltersRefund = new ArrayList<SqlFilter>();
        sqlFiltersRefund.add(SqlFilter.in((String)"refund_no", (Object)refundNos));
        RefundEo refundEo = new RefundEo();
        refundEo.setSqlFilters(sqlFiltersRefund);
        List refundEos = this.refundDas.select((BaseEo)refundEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)refundEos)) {
            return Maps.newHashMap();
        }
        Map<String, BigDecimal> refundMoney = refundEos.stream().collect(Collectors.toMap(StdRefundEo::getRefundNo, StdRefundEo::getRefundTotalAmount));
        Map<String, List<RefReturnRefundEo>> refundReturnMap = select.stream().collect(Collectors.groupingBy(StdRefReturnRefundEo::getReturnNo));
        refundReturnMap.keySet().forEach(returnNo -> {
            List refReturnRefundEos = (List)refundReturnMap.get(returnNo);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)refReturnRefundEos)) {
                map.put((String)returnNo, refReturnRefundEos.stream().map(refReturnRefundEo -> refundMoney.getOrDefault(refReturnRefundEo.getRefundNo(), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        });
        return map;
    }

    private Map<String, List<ReturnItemEo>> getItemAmountMoney(List<ReturnItemEo> returnItemEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(returnItemEos)) {
            return Maps.newHashMap();
        }
        return returnItemEos.stream().collect(Collectors.groupingBy(StdReturnItemEo::getReturnNo));
    }

    private Map<String, OrderDeliveryEo> getAfterSalesOrderDeliveryMap(List<String> orderTradeNoList) {
        OrderEo orderEo = new OrderEo();
        ArrayList<SqlFilter> sqlFilter = new ArrayList<SqlFilter>();
        sqlFilter.add(SqlFilter.in((String)"trade_no", orderTradeNoList));
        orderEo.setSqlFilters(sqlFilter);
        orderEo.setOrderByDesc("id");
        List orderEoList = this.orderDas.select((BaseEo)orderEo);
        HashMap orderDeliveryEoMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderEoList)) {
            orderEoList.forEach(order -> {
                if (StringUtils.isNotEmpty((CharSequence)order.getDeliveryAddress())) {
                    orderDeliveryEoMap.put(order.getTradeNo(), JSON.parseObject((String)order.getDeliveryAddress(), OrderDeliveryEo.class));
                }
            });
        }
        return orderDeliveryEoMap;
    }

    @Override
    public boolean checkOrderReturnFinish(String orderNo) {
        List<ReturnItemEo> returnItemEos = this.queryReturnItemByOrderNo(orderNo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(returnItemEos)) {
            List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(orderNo);
            for (TradeItemEo tradeItemEo : tradeItemEos) {
                int skuNum = this.countNumBySkuId(returnItemEos, tradeItemEo);
                if (skuNum == tradeItemEo.getItemNum()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private int countNumBySkuId(List<ReturnItemEo> returnItemEos, TradeItemEo tradeItemEo) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(returnItemEos)) {
            return 0;
        }
        int num = 0;
        for (ReturnItemEo returnItemEo : returnItemEos) {
            if (returnItemEo.getSkuSerial() == null || tradeItemEo.getSkuSerial() == null || !returnItemEo.getSkuSerial().equals(tradeItemEo.getSkuSerial())) continue;
            if (returnItemEo.getReturnNum() != null) {
                num += returnItemEo.getReturnNum().intValue();
                continue;
            }
            num += tradeItemEo.getItemNum().intValue();
        }
        return num;
    }

    private List<ReturnItemEo> queryReturnItemByOrderNo(String orderNo) {
        ReturnEo returnEo = ReturnEo.newInstance();
        returnEo.setOrderTradeNo(orderNo);
        returnEo.setReturnStatus(ReturnStatusEnum.FINISH.getName());
        List returnList = this.returnDas.select((BaseEo)returnEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnList)) {
            List<String> returnNos = returnList.stream().map(StdReturnEo::getReturnNo).collect(Collectors.toList());
            List<ReturnItemEo> returnItemEos = this.queryReturnItemByReturnNos(returnNos);
            return returnItemEos;
        }
        return null;
    }

    private List<ReturnItemEo> queryReturnItemByReturnNos(List<String> returnNos) {
        ReturnItemEo returnItemEo = new ReturnItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"returnNo", returnNos));
        returnItemEo.setSqlFilters(sqlFilters);
        return this.returnItemDas.select((BaseEo)returnItemEo);
    }

    @Override
    public ReturnDetailRespDto queryReturnDetail(String returnNo, String filter) {
        BigDecimal payMoney;
        Map<String, BigDecimal> payAmount;
        if (StringUtils.isBlank((CharSequence)returnNo)) {
            throw new BizException("returnNo is not null");
        }
        ReturnDetailRespDto returnRespDto = new ReturnDetailRespDto();
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        returnOmniEo.setReturnNo(returnNo);
        ReturnOmniEo tempReturnOmniEo = (ReturnOmniEo)this.returnOmniDas.selectOne((BaseEo)returnOmniEo);
        if (null == tempReturnOmniEo) {
            throw new BizException("not find the return order info,returnNo:{}", returnNo);
        }
        DtoHelper.eo2Dto((BaseEo)tempReturnOmniEo, (BaseVo)returnRespDto);
        List<ReturnOmniItemRespDto> returnOmniItemRespDtos = this.getOmniReturnItemInfo(returnNo);
        returnRespDto.setReturnOmniItemRespDtoList(returnOmniItemRespDtos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(returnOmniItemRespDtos)) {
            if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnRespDto.getSaleChannel())) {
                returnRespDto.setPayAmount(returnOmniItemRespDtos.stream().map(bean -> bean.getItemPrice().multiply(new BigDecimal(Optional.ofNullable(bean.getItemNum()).orElse(0)))).reduce(BigDecimal.ZERO, BigDecimal::add).abs());
            } else {
                ProblemOrderEo problemOrderEoSelect = new ProblemOrderEo();
                problemOrderEoSelect.setTradeNo(returnRespDto.getTradeNo());
                ProblemOrderEo problemOrderEo = (ProblemOrderEo)this.problemOrderDas.selectOne((BaseEo)problemOrderEoSelect);
                if (problemOrderEo != null) {
                    returnRespDto.setPayAmount(problemOrderEo.getPayAmount());
                }
            }
        }
        if (null != (payAmount = this.getPayAmount(returnNo)) && null != (payMoney = payAmount.get(returnNo))) {
            returnRespDto.setRefundAmount(payMoney);
        }
        boolean queryRelTradeItem = true;
        List<ApplyReturnItemRespDto> applyReturnItemRespDtoList = this.applyReturnItemService.queryByReturnNo(returnNo, queryRelTradeItem);
        for (ApplyReturnItemRespDto applyReturnItemRespDto : applyReturnItemRespDtoList) {
            if (!StringUtils.isNotEmpty((CharSequence)applyReturnItemRespDto.getExtension())) continue;
            ApplyReturnItemExtensionConvertDto convertDto = (ApplyReturnItemExtensionConvertDto)JSONObject.parseObject((String)applyReturnItemRespDto.getExtension(), ApplyReturnItemExtensionConvertDto.class);
            CubeBeanUtils.copyProperties((Object)applyReturnItemRespDto, (Object)convertDto, (String[])new String[0]);
        }
        returnRespDto.setApplyReturnItemRespDtoList(applyReturnItemRespDtoList);
        returnRespDto.setRefundStatus(this.getReturnStatus(returnNo));
        if (StringUtils.isNotBlank((CharSequence)tempReturnOmniEo.getTradeNo())) {
            returnRespDto.setAuditRecordReps(this.queryAuditRecord(tempReturnOmniEo.getTradeNo()));
        }
        return returnRespDto;
    }

    private String getReturnStatus(String returnNo) {
        RefundEo refundEo = new RefundEo();
        refundEo.setReturnNo(returnNo);
        List refundEos = this.refundDas.select((BaseEo)refundEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)refundEos)) {
            return ((RefundEo)refundEos.get(0)).getRefundStatus();
        }
        return "";
    }

    public ReturnRespDto queryReturnByNo(String tradeNo) {
        ReturnEo temp = new ReturnEo();
        temp.setTradeNo(tradeNo);
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)temp);
        ReturnDetailRespDto returnRepDto = new ReturnDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)returnEo, (BaseVo)returnRepDto);
        return returnRepDto;
    }

    private List<AuditRecordRespDto> queryAuditRecord(String tradeNo) {
        AuditRecordEo auditRecord = new AuditRecordEo();
        auditRecord.setBizTradeNo(tradeNo);
        auditRecord.setOrderByDesc("id");
        List auditRecordEoList = this.auditRecordDas.select((BaseEo)auditRecord);
        ArrayList<AuditRecordRespDto> auditRecordRespDtoList = new ArrayList<AuditRecordRespDto>();
        DtoHelper.eoList2DtoList((Collection)auditRecordEoList, auditRecordRespDtoList, AuditRecordRespDto.class);
        return auditRecordRespDtoList;
    }

    private List<AfterSalesItemRespDto> queryAfterSalesItem(String tradeNo, String orderTradeNo) {
        RefTradeItemEo refTradeItemEo = new RefTradeItemEo();
        refTradeItemEo.setTradeNo(tradeNo);
        refTradeItemEo.setOrderByDesc("id");
        List refTradeItemEoList = this.refTradeItemDas.select((BaseEo)refTradeItemEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)refTradeItemEoList)) {
            return new ArrayList<AfterSalesItemRespDto>();
        }
        OrderDeliveryEo orderDeliveryEo = null;
        if (StringUtils.isNotBlank((CharSequence)orderTradeNo)) {
            ArrayList<String> orderTradeNoList = new ArrayList<String>();
            orderTradeNoList.add(orderTradeNo);
            Map<String, OrderDeliveryEo> orderDeliveryEoMap = this.getAfterSalesOrderDeliveryMap(orderTradeNoList);
            if (MapUtils.isNotEmpty(orderDeliveryEoMap)) {
                orderDeliveryEo = orderDeliveryEoMap.get(orderTradeNo);
            }
        }
        ArrayList<AfterSalesItemRespDto> afterSalesItemRespDtoList = new ArrayList<AfterSalesItemRespDto>(refTradeItemEoList.size());
        DtoHelper.eoList2DtoList((Collection)refTradeItemEoList, afterSalesItemRespDtoList, AfterSalesItemRespDto.class);
        for (AfterSalesItemRespDto afterSalesItemRespDto : afterSalesItemRespDtoList) {
            for (RefTradeItemEo refTradeItem : refTradeItemEoList) {
                if (!afterSalesItemRespDto.getTradeItemNo().equals(refTradeItem.getTradeItemNo()) || !StringUtils.isNotEmpty((CharSequence)refTradeItem.getRefDetail())) continue;
                TradeItemEo tradeItemEo = (TradeItemEo)JSON.parseObject((String)refTradeItem.getRefDetail(), TradeItemEo.class);
                afterSalesItemRespDto.setItemName(tradeItemEo.getItemName());
                afterSalesItemRespDto.setPayTotalAmount(tradeItemEo.getPayTotalAmount());
                afterSalesItemRespDto.setBrandSerial(tradeItemEo.getBrandSerial());
                afterSalesItemRespDto.setCatalogSerial(tradeItemEo.getCatalogSerial());
                afterSalesItemRespDto.setItemSerial(tradeItemEo.getItemSerial());
                afterSalesItemRespDto.setSkuSerial(tradeItemEo.getSkuSerial());
                afterSalesItemRespDto.setSkuDesc(tradeItemEo.getSkuDesc());
                afterSalesItemRespDto.setItemDetail(tradeItemEo.getItemDetail());
                if (null == orderDeliveryEo) continue;
                afterSalesItemRespDto.setDeliveryName(orderDeliveryEo.getDeliveryName());
                afterSalesItemRespDto.setDeliveryMobile(orderDeliveryEo.getDeliveryMobile());
                afterSalesItemRespDto.setDeliveryAddr(orderDeliveryEo.getAddress());
            }
        }
        return afterSalesItemRespDtoList;
    }

    @Override
    public int countAfterByTradeItemNo(String tradeNo, String tradeItemNo) {
        RefTradeItemEo refTradeItemEo = new RefTradeItemEo();
        refTradeItemEo.setTradeItemNo(tradeItemNo);
        refTradeItemEo.setRefType("RETURN");
        refTradeItemEo.setOrderByDesc("id");
        List refTradeItemEoList = this.refTradeItemDas.select((BaseEo)refTradeItemEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)refTradeItemEoList)) {
            return 0;
        }
        int sumCount = 0;
        for (RefTradeItemEo refTradeItem : refTradeItemEoList) {
            ReturnRespDto returnRespDto;
            if (refTradeItem.getTradeNo().equals(tradeNo) || !this.isTakeUpStatus(returnRespDto = this.queryReturnByNo(refTradeItem.getTradeNo()))) continue;
            sumCount += refTradeItem.getItemNum().intValue();
        }
        return sumCount;
    }

    @Override
    public boolean isTakeUpStatus(ReturnRespDto returnRespDto) {
        if (ReturnStatusEnum.REJECT.getName().equals(returnRespDto.getReturnStatus())) {
            return false;
        }
        return !ReturnStatusEnum.CANCEL.getName().equals(returnRespDto.getReturnStatus());
    }

    @Override
    public void modifyReturnBizStatus(String tradeNo, String status) {
        ReturnEo returnEo = ReturnEo.newInstance();
        returnEo.setBizStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"tradeNo", (Object)tradeNo));
        returnEo.setSqlFilters(sqlFilters);
        this.returnDas.updateSelectiveSqlFilter((BaseEo)returnEo);
    }

    @Override
    public ReturnReqDto countReturn(ReturnReqDto returnReqDto) {
        returnReqDto = this.countReturnAmount(returnReqDto);
        returnReqDto = this.countReturnIntegral(returnReqDto);
        return returnReqDto;
    }

    @Override
    public ReturnReqDto countReturnIntegral(ReturnReqDto returnReqDto) {
        if (returnReqDto.getReturnIntegral() == null) {
            Integer sum = 0;
            List afterSalesItemReqDtos = returnReqDto.getAfterSalesItems();
            for (AfterSalesItemReqDto afterSalesItemReqDto : afterSalesItemReqDtos) {
                TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeItemNo(afterSalesItemReqDto.getTradeItemNo());
                if (tradeItemEo.getIntegral() == null || tradeItemEo.getIntegral().equals(0)) continue;
                Integer haveReturnNum = this.countAfterByTradeItemNo(returnReqDto.getTradeNo(), afterSalesItemReqDto.getTradeItemNo());
                Integer sumNum = haveReturnNum + afterSalesItemReqDto.getItemNum();
                if (sumNum > tradeItemEo.getItemNum()) {
                    throw new BizException("\u53d1\u8d77\u9000\u6b3e\u5546\u54c1\u6570\u91cf\u5df2\u7ecf\u8d85\u51fa\u5546\u54c1\u7684\u6570\u91cf");
                }
                if (tradeItemEo.getItemNum().equals(afterSalesItemReqDto.getItemNum())) {
                    sum = sum + tradeItemEo.getIntegral();
                    continue;
                }
                if (sumNum < tradeItemEo.getItemNum()) {
                    Integer addIntegral = tradeItemEo.getIntegral() / tradeItemEo.getItemNum() * afterSalesItemReqDto.getItemNum();
                    sum = sum + addIntegral;
                    continue;
                }
                Integer haveIntegral = tradeItemEo.getIntegral() / tradeItemEo.getItemNum() * haveReturnNum;
                sum = tradeItemEo.getIntegral() - haveIntegral;
            }
            returnReqDto.setReturnIntegral(sum);
        }
        return returnReqDto;
    }

    @Override
    public ReturnReqDto countReturnAmount(ReturnReqDto returnReqDto) {
        if (returnReqDto.getRefundAmount() == null) {
            BigDecimal sumAmount = new BigDecimal(0.0);
            List afterSalesItemReqDtos = returnReqDto.getAfterSalesItems();
            for (AfterSalesItemReqDto afterSalesItemReqDto : afterSalesItemReqDtos) {
                TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeItemNo(afterSalesItemReqDto.getTradeItemNo());
                if (tradeItemEo.getPayTotalAmount() == null || tradeItemEo.getPayTotalAmount().compareTo(new BigDecimal(0)) == 0) continue;
                Integer haveReturnNum = this.countAfterByTradeItemNo(returnReqDto.getTradeNo(), afterSalesItemReqDto.getTradeItemNo());
                Integer sumNum = haveReturnNum + afterSalesItemReqDto.getItemNum();
                if (sumNum > tradeItemEo.getItemNum()) {
                    throw new BizException("\u53d1\u8d77\u9000\u6b3e\u5546\u54c1\u6570\u91cf\u5df2\u7ecf\u8d85\u51fa\u5546\u54c1\u7684\u6570\u91cf");
                }
                if (tradeItemEo.getItemNum().equals(afterSalesItemReqDto.getItemNum())) {
                    sumAmount = sumAmount.add(tradeItemEo.getPayTotalAmount());
                    continue;
                }
                if (sumNum < tradeItemEo.getItemNum()) {
                    BigDecimal addAmount = tradeItemEo.getPayTotalAmount().divide(new BigDecimal(tradeItemEo.getItemNum()), 2, 5).multiply(new BigDecimal(afterSalesItemReqDto.getItemNum()));
                    sumAmount = sumAmount.add(addAmount);
                    continue;
                }
                BigDecimal haveAmount = tradeItemEo.getPayTotalAmount().divide(new BigDecimal(tradeItemEo.getItemNum()), 2, 5).multiply(new BigDecimal(haveReturnNum));
                sumAmount = tradeItemEo.getPayTotalAmount().subtract(haveAmount);
            }
            returnReqDto.setRefundAmount(sumAmount);
        }
        return returnReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> addSynReturn(AfterSalesReqDto afterSalesReqDto) {
        OrderSettingReqDto.AfterSaleSettingDto afterSaleSettingDto = null;
        RestResponse dictDtos = this.dictQueryApi.queryByGroupCode(ComConstants.TENANT, "ORDER_SETTING");
        if (null != dictDtos || !CollectionUtils.isEmpty((Collection)((Collection)dictDtos.getData()))) {
            Map<String, DictDto> dictDtoMap = ((List)dictDtos.getData()).stream().collect(Collectors.toMap(DictDto::getCode, dictDto -> dictDto));
            HashMap<String, String> orderSettingDtoMap = new HashMap<String, String>();
            orderSettingDtoMap.put("AFTER_SALE_SETTING", "afterSaleSettingDto");
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            orderSettingDtoMap.keySet().forEach(key -> {
                DictDto dictDto = (DictDto)dictDtoMap.get(key);
                if (null != dictDto && StringUtils.isNotBlank((CharSequence)dictDto.getValue())) {
                    builder.append((String)orderSettingDtoMap.get(key)).append(":").append(dictDto.getValue()).append(",");
                }
            });
            if (builder.length() > 1) {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append("}");
            OrderSettingReqDto orderSettingReqDto = (OrderSettingReqDto)JSONObject.parseObject((String)builder.toString(), OrderSettingReqDto.class);
            afterSaleSettingDto = orderSettingReqDto.getAfterSaleSettingDto();
        }
        ArrayList<String> returnNos = new ArrayList<String>();
        try {
            List afterSalesBeanReqDtos = afterSalesReqDto.getAfterSalesBeanReqDtoList();
            Assert.isTrue(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)afterSalesBeanReqDtos), "\u4e2d\u53f0\u65b0\u589e\u5947\u95e8\u9000\u8d27\u5165\u5e93\u5355\u5165\u53c2\u4e3a\u7a7a");
            logger.info("addSynReturn params:{}", (Object)afterSalesReqDto.toString());
            for (AfterSalesBeanReqDto afterSalesBeanReqDto : afterSalesBeanReqDtos) {
                List<RefReturnRefundEo> refTradeItemEos;
                String returnNo;
                List<ReturnItemEo> returnItemEos;
                List errorList;
                afterSalesBeanReqDto.setSubSourceOrderCode(afterSalesBeanReqDto.getSourceOrderCode());
                afterSalesBeanReqDto.setSourceOrderCode(null);
                Assert.isTrue(!StringUtils.isEmpty((CharSequence)afterSalesBeanReqDto.getSubSourceOrderCode()), "\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7\u4e3a\u7a7a");
                List returnItemReqDtos = afterSalesBeanReqDto.getReturnItemReqDtos();
                Assert.isTrue(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)returnItemReqDtos), "\u9000\u8d27\u5355\u6ca1\u6709\u9000\u8d27\u5546\u54c1\u660e\u7ec6\uff0c\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7third_order_no:" + afterSalesBeanReqDto.getSubSourceOrderCode());
                logger.info("\u5947\u95e8\u9000\u8d27\u539f\u8ba2\u5355\u53f7\uff1a{}", (Object)afterSalesBeanReqDto.getSubSourceOrderCode());
                OrderEo origOrderEo = this.orderService.queryDetailByThirdOrderNo(afterSalesBeanReqDto.getSubSourceOrderCode(), afterSalesBeanReqDto.getSourceOrderCode());
                if (origOrderEo == null) {
                    logger.info("\u4e2d\u53f0\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u539f\u8ba2\u5355,\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7third_order_no:" + afterSalesBeanReqDto.getSubSourceOrderCode());
                    continue;
                }
                if (this.checkReturnIsExist(afterSalesBeanReqDto, returnNos) || org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList = (returnItemEos = this.convertReturnItemEo(afterSalesBeanReqDto, returnNo = TradeUtil.generateTradeNo(), origOrderEo)).stream().filter(tradeItemEo -> {
                    Map extFields = tradeItemEo.getExtFields();
                    return MapUtils.isNotEmpty((Map)extFields) && extFields.get("errorMsg") != null;
                }).map(BaseEo::getExtFields).collect(Collectors.toList()))) continue;
                ReturnOmniEo returnOmniEo = this.convertReturnOmniEo(afterSalesBeanReqDto, returnNo, origOrderEo, afterSaleSettingDto);
                this.returnOmniDas.insert((BaseEo)returnOmniEo);
                this.generateAuditRecord(returnOmniEo);
                List<RefundEo> refundEos = this.convertRefundOmniEo(afterSalesBeanReqDto, origOrderEo);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(refundEos)) {
                    refundEos.stream().forEach(refundEo -> {
                        refundEo.setReturnNo(returnNo);
                        this.refundDas.insert((BaseEo)refundEo);
                    });
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(refTradeItemEos = this.convertRefReturnRefund(refundEos, returnNo, origOrderEo.getTradeNo()))) {
                    this.refReturnRefundDas.insertBatch(refTradeItemEos);
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(returnItemEos)) {
                    returnItemEos.stream().forEach(returnItemEo -> this.returnItemDas.insert((BaseEo)returnItemEo));
                }
                if (OrderDeviceType.DRP.getCode().equals(afterSalesBeanReqDto.getSaleChannel())) {
                    OrderDeliverMessageVo messageVo = new OrderDeliverMessageVo();
                    messageVo.setOrderNo(origOrderEo.getOrderNo());
                    messageVo.setActualMoney(origOrderEo.getPayAmount());
                    messageVo.setDeliverStatus(DeliverStatusEnum.SALE_AFTER_ORDER.getCode());
                    this.performanceProducer.sendPerformance(messageVo);
                }
                returnNos.add(returnNo);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)afterSalesReqDto.getStorageChangeReqDtos())) {
                // empty if block
            }
            return returnNos;
        }
        catch (Exception e) {
            logger.info("\u552e\u540e\u5355\u540c\u6b65\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BizException("\u552e\u540e\u5355\u540c\u6b65\u5931\u8d25," + e.getMessage());
        }
    }

    private void generateAuditRecord(ReturnOmniEo returnOmniEo) {
        if (ReturnStatusEnum.AUDITING.getName().equals(returnOmniEo.getReturnStatus())) {
            AuditRecordEo auditRecordEo = new AuditRecordEo();
            auditRecordEo.setTenantId(returnOmniEo.getTenantId());
            auditRecordEo.setInstanceId(returnOmniEo.getInstanceId());
            auditRecordEo.setBizTradeNo(returnOmniEo.getReturnNo());
            auditRecordEo.setAuditStatus(returnOmniEo.getReturnStatus());
            auditRecordEo.setBuyerRemark("");
            auditRecordEo.setSellerRemark("");
            auditRecordEo.setReqType("RETURN");
            auditRecordEo.setReqReason(returnOmniEo.getReturnReason());
            auditRecordEo.setReqMethod("1");
            auditRecordEo.setReqMedia("");
            auditRecordEo.setHandleType("");
            auditRecordEo.setHandleDesc("");
            auditRecordEo.setAuditRecordNo(TradeUtil.generateTradeNo(returnOmniEo.getReturnNo()));
            this.auditRecordDas.insert((BaseEo)auditRecordEo);
        }
    }

    @Override
    public AfterSaleCancelRespDto cancelOmniReturn(AfterSaleCancelReqDto afterSaleCancelReqDto) {
        AfterSaleCancelRespDto afterSaleCancelRespDto = new AfterSaleCancelRespDto();
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        returnOmniEo.setExtlReturnSerial(afterSaleCancelReqDto.getThirdReturnNo());
        List returnOmniEos = this.returnOmniDas.select((BaseEo)returnOmniEo);
        Assert.isTrue(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)returnOmniEos), "\u4e2d\u53f0\u4e0d\u5b58\u5728\u8be5\u552e\u540e\u5355\uff0cextlReturnSerial:" + afterSaleCancelReqDto.getThirdReturnNo());
        Assert.isTrue(returnOmniEos.size() <= 1, "\u4e2d\u53f0\u552e\u540e\u5355\u5355\u636e\u5b58\u5728\u591a\u6761\uff0c \u5355\u636e\u53f7\uff1a" + afterSaleCancelReqDto.getThirdReturnNo());
        ReturnOmniEo returnOmniEoResp = (ReturnOmniEo)returnOmniEos.get(0);
        Assert.isTrue(null == returnOmniEoResp || !ReturnStatusEnum.CANCELED.getName().equals(returnOmniEoResp.getReturnStatus()), "\u5355\u636e\uff1a" + afterSaleCancelReqDto.getThirdReturnNo() + "\u5df2\u7ecf\u53d6\u6d88\uff0c\u8bf7\u60a8\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
        Assert.isTrue(null == returnOmniEoResp || ReturnStatusEnum.TO_ACCEPTANCE.getName().equals(returnOmniEoResp.getReturnStatus()), "\u5355\u636e\uff1a" + afterSaleCancelReqDto.getThirdReturnNo() + "\u4e0d\u53ef\u4ee5\u53d6\u6d88");
        this.updateReturnCancelStatus(afterSaleCancelReqDto);
        this.updateRefundCancelStatus(returnOmniEoResp.getReturnNo(), afterSaleCancelReqDto);
        this.handleAfterSaleCancelResp(afterSaleCancelReqDto, afterSaleCancelRespDto);
        return afterSaleCancelRespDto;
    }

    private void handleAfterSaleCancelResp(AfterSaleCancelReqDto afterSaleCancelReqDto, AfterSaleCancelRespDto afterSaleCancelRespDto) {
        afterSaleCancelRespDto.setOrderCode(afterSaleCancelReqDto.getThirdReturnNo());
        afterSaleCancelRespDto.setGoodsOwner(afterSaleCancelReqDto.getOwnerCode());
        afterSaleCancelRespDto.setOrderType(afterSaleCancelReqDto.getOrderType());
        afterSaleCancelRespDto.setRemark(afterSaleCancelReqDto.getCancelDesc());
    }

    private void updateRefundCancelStatus(String returnNo, AfterSaleCancelReqDto afterSaleCancelReqDto) {
        RefReturnRefundEo refReturnRefundEo = new RefReturnRefundEo();
        refReturnRefundEo.setReturnNo(returnNo);
        List refReturnRefundEos = this.refReturnRefundDas.select((BaseEo)refReturnRefundEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)refReturnRefundEos)) {
            return;
        }
        refReturnRefundEos.stream().forEach(refReturnRefundEo1 -> {
            RefundEo updateRefundEo = new RefundEo();
            updateRefundEo.setCancelDesc(afterSaleCancelReqDto.getCancelDesc());
            updateRefundEo.setCancelTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            updateRefundEo.setCancelType(OrderCancelTypeEnum.BUYER_CANCLE.getName());
            ArrayList<SqlFilter> refundSqlFilters = new ArrayList<SqlFilter>();
            refundSqlFilters.add(SqlFilter.eq((String)"refund_no", (Object)refReturnRefundEo1.getRefundNo()));
            updateRefundEo.setSqlFilters(refundSqlFilters);
            this.refundDas.updateSelectiveSqlFilter((BaseEo)updateRefundEo);
        });
    }

    private void updateReturnCancelStatus(AfterSaleCancelReqDto afterSaleCancelReqDto) {
        ReturnOmniEo updateReturnOmniEo = new ReturnOmniEo();
        updateReturnOmniEo.setCancelDesc(afterSaleCancelReqDto.getCancelDesc());
        updateReturnOmniEo.setCancelTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        updateReturnOmniEo.setCancelType(OrderCancelTypeEnum.BUYER_CANCLE.getName());
        updateReturnOmniEo.setReturnStatus(ReturnStatusEnum.CANCELED.getName());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"extl_return_serial", (Object)afterSaleCancelReqDto.getThirdReturnNo()));
        updateReturnOmniEo.setSqlFilters(sqlFilters);
        this.returnOmniDas.updateSelectiveSqlFilter((BaseEo)updateReturnOmniEo);
    }

    private List<ReturnOmniItemRespDto> getOmniReturnItemInfo(String returnNo) {
        ArrayList returnOmniItemRespDtos = Lists.newArrayList();
        ReturnItemEo returnItemEo = new ReturnItemEo();
        returnItemEo.setReturnNo(returnNo);
        returnItemEo.setOrderBy("id");
        List returnItemEos = this.returnItemDas.select((BaseEo)returnItemEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnItemEos)) {
            DtoHelper.eoList2DtoList((Collection)returnItemEos, (Collection)returnOmniItemRespDtos, ReturnOmniItemRespDto.class);
            for (ReturnOmniItemRespDto returnOmniItemRespDto : returnOmniItemRespDtos) {
                if (StringUtils.isEmpty((CharSequence)returnOmniItemRespDto.getTradeNo())) {
                    returnOmniItemRespDto.setItemMarketPrice(returnOmniItemRespDto.getItemOrigPrice());
                    continue;
                }
                TradeItemEo tradeItemEo = new TradeItemEo();
                tradeItemEo.setId(returnOmniItemRespDto.getTradeItemId());
                tradeItemEo.setTradeNo(returnOmniItemRespDto.getTradeNo());
                tradeItemEo.setItemSerial(returnOmniItemRespDto.getItemId());
                tradeItemEo.setSkuSerial(returnOmniItemRespDto.getSkuSerial());
                tradeItemEo.setGift(returnOmniItemRespDto.getGift());
                tradeItemEo.setIfExchange(returnOmniItemRespDto.getIfExchange());
                tradeItemEo.setIsCombinedPackage(returnOmniItemRespDto.getIsCombinedPackage());
                tradeItemEo.setCombinedPackageActivityId(returnOmniItemRespDto.getCombinedPackageActivityId());
                BigDecimal itemMarketPrice = returnOmniItemRespDto.getItemOrigPrice();
                List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeItemEo(tradeItemEo);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(tradeItemEos)) continue;
                returnOmniItemRespDto.setDeliveredNum(tradeItemEos.get(0).getDeliveredNum());
                returnOmniItemRespDto.setTradeItemNo(tradeItemEos.get(0).getTradeItemNo());
                itemMarketPrice = tradeItemEos.get(0).getItemMarketPrice();
                if (tradeItemEos.get(0).getGift() == 0) {
                    BigDecimal discountTotalAmount = tradeItemEos.get(0).getDiscountTotalAmount();
                    BigDecimal eachShareAmount = null;
                    if (discountTotalAmount != null && discountTotalAmount.compareTo(BigDecimal.ZERO) > 0) {
                        if (ExchangeEnum.YES.getType().equals(tradeItemEos.get(0).getIfExchange())) {
                            eachShareAmount = discountTotalAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                        } else {
                            BigDecimal timeDiscount = tradeItemEos.get(0).getItemMarketPrice().subtract(tradeItemEos.get(0).getItemOrigPrice());
                            BigDecimal shareAmount = discountTotalAmount.subtract(timeDiscount.multiply(new BigDecimal(tradeItemEos.get(0).getItemNum())));
                            eachShareAmount = shareAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                        }
                        returnOmniItemRespDto.setEachShareAmount(eachShareAmount);
                    }
                    returnOmniItemRespDto.setPromotionPrice(tradeItemEos.get(0).getItemOrigPrice());
                    Integer itemNum = tradeItemEos.get(0).getItemNum();
                    Map extFields = returnOmniItemRespDto.getExtFields();
                    Integer returnNum = extFields.get("returnNum") == null ? 0 : (Integer)extFields.get("returnNum");
                    BigDecimal giftDeductionTotalAmount = tradeItemEos.get(0).getGiftDeduction();
                    if (giftDeductionTotalAmount != null && giftDeductionTotalAmount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal eachGiftDeductionAmount = giftDeductionTotalAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                        BigDecimal curGiftTotalAmount = itemNum - returnNum == 0 ? giftDeductionTotalAmount : eachGiftDeductionAmount.multiply(BigDecimal.valueOf(returnNum.intValue()));
                        returnOmniItemRespDto.setGiftDeductionAmount(curGiftTotalAmount);
                        returnOmniItemRespDto.setEachGiftDeductionAmount(eachGiftDeductionAmount);
                    } else {
                        returnOmniItemRespDto.setGiftDeductionAmount(BigDecimal.ZERO);
                        returnOmniItemRespDto.setEachGiftDeductionAmount(BigDecimal.ZERO);
                    }
                    BigDecimal rebateTotalAmount = tradeItemEos.get(0).getRebateAmount();
                    if (rebateTotalAmount != null && rebateTotalAmount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal eachRebateAmount = rebateTotalAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                        returnOmniItemRespDto.setEachDiscountAmount(eachRebateAmount);
                        returnOmniItemRespDto.setDiscountAmount(returnOmniItemRespDto.getReturnRebate());
                    } else {
                        returnOmniItemRespDto.setEachDiscountAmount(BigDecimal.ZERO);
                        returnOmniItemRespDto.setDiscountAmount(BigDecimal.ZERO);
                    }
                }
                returnOmniItemRespDto.setItemMarketPrice(itemMarketPrice);
                String itemDetail = tradeItemEos.get(0).getItemDetail();
                if (StringUtils.isEmpty((CharSequence)itemDetail)) continue;
                BizItemDetailRespDto bizItemDetailRespDto = (BizItemDetailRespDto)((Object)ObjectHelper.Json2Bean((String)itemDetail, BizItemDetailRespDto.class));
                ArrayList returnBundleItemRespDtos = new ArrayList();
                CubeBeanUtils.copyCollection(returnBundleItemRespDtos, bizItemDetailRespDto.getSkuBundleItems(), ReturnBundleItemRespDto.class);
                returnOmniItemRespDto.setBundleItemDtos(returnBundleItemRespDtos);
            }
        }
        return returnOmniItemRespDtos;
    }

    private List<RefReturnRefundEo> convertRefReturnRefund(List<RefundEo> refundEoList, String returnNo, String tradeNo) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(refundEoList)) {
            return Lists.newArrayList();
        }
        return refundEoList.stream().map(refundEo -> {
            RefReturnRefundEo refReturnRefundEo = new RefReturnRefundEo();
            refReturnRefundEo.setTradeNo(tradeNo);
            refReturnRefundEo.setReturnNo(returnNo);
            refReturnRefundEo.setRefundNo(refundEo.getRefundNo());
            if (null != refundEo.getInstanceId()) {
                refReturnRefundEo.setInstanceId(refundEo.getInstanceId());
            }
            if (null != refundEo.getTenantId()) {
                refReturnRefundEo.setTenantId(refundEo.getTenantId());
            }
            return refReturnRefundEo;
        }).collect(Collectors.toList());
    }

    private List<ReturnOmniItemRespDto> convertReturnOmniItemRespDto(List<ReturnItemEo> returnItemEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(returnItemEos)) {
            return Lists.newArrayList();
        }
        return returnItemEos.stream().map(returnItemEo -> {
            ReturnOmniItemRespDto returnOmniItemRespDto = new ReturnOmniItemRespDto();
            DtoHelper.eo2Dto((BaseEo)returnItemEo, (BaseVo)returnOmniItemRespDto);
            returnOmniItemRespDto.setItemPrice(returnItemEo.getItemPrice());
            returnOmniItemRespDto.setItemCode(returnItemEo.getItemCode());
            returnOmniItemRespDto.setItemName(returnItemEo.getItemName());
            if (null != returnItemEo.getItemNum()) {
                returnOmniItemRespDto.setItemNum(returnItemEo.getItemNum());
            }
            returnOmniItemRespDto.setItemId(returnItemEo.getItemId());
            returnOmniItemRespDto.setCatalogSerial(returnItemEo.getCargoSerial());
            returnOmniItemRespDto.setBrandId(returnItemEo.getBrandId());
            returnOmniItemRespDto.setGift(returnItemEo.getGift());
            return returnOmniItemRespDto;
        }).collect(Collectors.toList());
    }

    private List<ApplyReturnItemRespDto> converApplyReturnItemRespDto(List<ApplyReturnItemEo> applyReturnItemEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(applyReturnItemEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtoList, applyReturnItemEos, ApplyReturnItemRespDto.class);
        for (ApplyReturnItemRespDto applyReturnItemRespDto : respDtoList) {
            if (!StringUtils.isNotEmpty((CharSequence)applyReturnItemRespDto.getExtension())) continue;
            ApplyReturnItemExtensionConvertDto convertDto = (ApplyReturnItemExtensionConvertDto)JSONObject.parseObject((String)applyReturnItemRespDto.getExtension(), ApplyReturnItemExtensionConvertDto.class);
            CubeBeanUtils.copyProperties((Object)applyReturnItemRespDto, (Object)convertDto, (String[])new String[0]);
        }
        return respDtoList;
    }

    private List<ReturnItemEo> getReturnItems(String returnNos) {
        if (StringUtils.isEmpty((CharSequence)returnNos)) {
            return Lists.newArrayList();
        }
        ReturnItemEo returnItemEo = new ReturnItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"return_no", (Object)returnNos));
        returnItemEo.setSqlFilters(sqlFilters);
        return this.returnItemDas.select((BaseEo)returnItemEo);
    }

    private List<ApplyReturnItemEo> getApplyReturnItems(String returnNos) {
        if (StringUtils.isEmpty((CharSequence)returnNos)) {
            return Lists.newArrayList();
        }
        ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"return_no", (Object)returnNos));
        applyReturnItemEo.setSqlFilters(sqlFilters);
        applyReturnItemEo.setDr(0);
        return this.applyReturnItemDas.select((BaseEo)applyReturnItemEo);
    }

    private Map<String, List<ReturnItemEo>> getItemMap(List<ReturnItemEo> returnItemEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(returnItemEos)) {
            return Maps.newHashMap();
        }
        return returnItemEos.stream().collect(Collectors.groupingBy(StdReturnItemEo::getReturnNo));
    }

    private Map<String, List<ApplyReturnItemEo>> getApplyItemMap(List<ApplyReturnItemEo> applyReturnItemEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(applyReturnItemEos)) {
            return Maps.newHashMap();
        }
        return applyReturnItemEos.stream().collect(Collectors.groupingBy(ApplyReturnItemEo::getReturnNo));
    }

    private ReturnOmniEo convertReturnOmniEo(AfterSalesBeanReqDto afterSalesBeanReqDto, String returnNo, OrderEo origOrderEo, OrderSettingReqDto.AfterSaleSettingDto afterSaleSettingDto) {
        String returnReason;
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        if (null == afterSalesBeanReqDto.getInstanceId()) {
            afterSalesBeanReqDto.setInstanceId(origOrderEo.getInstanceId());
        }
        if (null == afterSalesBeanReqDto.getTenantId()) {
            afterSalesBeanReqDto.setTenantId(origOrderEo.getTenantId());
        }
        DtoHelper.dto2Eo((BaseVo)afterSalesBeanReqDto, (BaseEo)returnOmniEo);
        returnOmniEo.setReturnNo(returnNo);
        returnOmniEo.setTradeNo(origOrderEo.getTradeNo());
        returnOmniEo.setOrderTradeNo(origOrderEo.getOrderNo());
        returnOmniEo.setExtlReturnSrc(" ");
        returnOmniEo.setReturnType(afterSalesBeanReqDto.getReturnType());
        returnOmniEo.setRefundAmount(origOrderEo.getPayAmount() == null ? BigDecimal.ZERO : origOrderEo.getPayAmount());
        if (OrderDeviceType.DRP.getCode().equals(afterSalesBeanReqDto.getSaleChannel())) {
            returnOmniEo.setReturnStatus(ReturnStatusEnum.FINISH.getName());
        } else {
            String returnStatus = afterSalesBeanReqDto.getReturnStatus();
            if (ReturnStatusEnum.TO_RECEIVE.getName().equals(returnStatus)) {
                returnOmniEo.setReturnStatus(returnStatus);
            } else {
                this.afterSalesAutoAudit(afterSaleSettingDto, returnOmniEo);
            }
        }
        ShopQueryReqDto shopQueryReqDto = new ShopQueryReqDto();
        shopQueryReqDto.setCodes(Arrays.asList(afterSalesBeanReqDto.getShopCode()));
        List shopList = (List)this.shopQueryApi.queryShopByCode(shopQueryReqDto).getData();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopList)) {
            ShopDto shopDto = (ShopDto)shopList.get(0);
            returnOmniEo.setShopId(String.valueOf(shopDto.getId()));
        }
        returnOmniEo.setReturnIntegral(Integer.valueOf(0));
        returnOmniEo.setCancelType(OrderCancelTypeEnum.BUYER_CANCLE.getName());
        returnOmniEo.setCancelTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        returnOmniEo.setBizType("normal");
        returnOmniEo.setThirdOrderNo(afterSalesBeanReqDto.getSubSourceOrderCode());
        if (StringUtils.isEmpty((CharSequence)returnOmniEo.getExtlReturnSerial()) && StringUtils.isNotEmpty((CharSequence)afterSalesBeanReqDto.getReturnOrderCode())) {
            returnOmniEo.setExtlReturnSerial(afterSalesBeanReqDto.getReturnOrderCode());
        }
        if (StringUtils.isNotBlank((CharSequence)(returnReason = afterSalesBeanReqDto.getReturnReason()))) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("reqReason", (Object)returnReason);
            returnOmniEo.setExtension(jsonObject.toJSONString());
        }
        return returnOmniEo;
    }

    private void afterSalesAutoAudit(OrderSettingReqDto.AfterSaleSettingDto afterSaleSettingDto, ReturnOmniEo returnOmniEo) {
        String status = ReturnStatusEnum.AUDITING.getName();
        if (null != afterSaleSettingDto && afterSaleSettingDto.getAutoCheckSwitch().equals("ON")) {
            ArrayList<String> types = new ArrayList<String>(3);
            if ("ON".equals(afterSaleSettingDto.getRefundGoodsSwitch())) {
                types.add(ReturnTypeEnum.RETURN_ONLY.getName());
            }
            if ("ON".equals(afterSaleSettingDto.getRefundOnlySwitch())) {
                types.add(ReturnTypeEnum.REFUND_ONLY.getName());
            }
            if ("ON".equals(afterSaleSettingDto.getReturnBaseSwitch())) {
                types.add(ReturnTypeEnum.RETURN_BASE.getName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(types) && types.contains(returnOmniEo.getReturnType()) && "ON".equals(afterSaleSettingDto.getRefundSwitch())) {
                BigDecimal refundAmount = returnOmniEo.getRefundAmount();
                BigDecimal refundMoneyGe = afterSaleSettingDto.getRefundMoneyGe();
                BigDecimal refundMoneyLe = afterSaleSettingDto.getRefundMoneyLe();
                if (refundMoneyGe != null && refundAmount.compareTo(refundMoneyGe) >= 0) {
                    status = ReturnStatusEnum.AUDITING.getName();
                }
                if (refundMoneyLe != null && refundAmount.compareTo(refundMoneyLe) <= 0) {
                    status = ReturnStatusEnum.AUDITING.getName();
                }
            }
        }
        returnOmniEo.setReturnStatus(status);
    }

    private List<RefundEo> convertRefundOmniEo(AfterSalesBeanReqDto afterSalesBeanReqDto, OrderEo origOrderEo) {
        ArrayList<RefundEo> refundEos = new ArrayList<RefundEo>();
        RefundEo refundEo = new RefundEo();
        String refundNo = TradeUtil.generateTradeNo();
        refundEo.setRefundNo(refundNo);
        refundEo.setRefundType(RefundTypeEnum.RETURN_BASE.getName());
        refundEo.setRefundStatus(RefundStatusEnum.AUDITING.getName());
        refundEo.setTradeNo(origOrderEo.getTradeNo());
        refundEo.setPayMethod("XSZF");
        refundEo.setExtlReturnSrc(" ");
        refundEo.setExtlRefundSerail("0");
        refundEo.setRefundTime(new Date());
        refundEo.setRefundReason(afterSalesBeanReqDto.getReturnReason());
        refundEo.setRefundDesc(afterSalesBeanReqDto.getReturnReason());
        refundEo.setRefundPaymentType("0");
        refundEo.setRefundTotalAmount(origOrderEo.getPayAmount() == null ? BigDecimal.ZERO : origOrderEo.getPayAmount());
        refundEo.setRefundItemAmount(BigDecimal.ZERO);
        refundEo.setRefundFreightAmount(BigDecimal.ZERO);
        refundEo.setCancelType("0");
        refundEo.setCancelTime(new Date());
        refundEo.setCancelDesc(afterSalesBeanReqDto.getReturnReason());
        refundEo.setDiscountRefundAmount(BigDecimal.ZERO);
        refundEo.setPayNo("0");
        if (null != afterSalesBeanReqDto.getInstanceId()) {
            refundEo.setInstanceId(afterSalesBeanReqDto.getInstanceId());
        }
        if (null != afterSalesBeanReqDto.getTenantId()) {
            refundEo.setTenantId(afterSalesBeanReqDto.getTenantId());
        }
        refundEos.add(refundEo);
        return refundEos;
    }

    private List<ReturnItemEo> convertReturnItemEo(AfterSalesBeanReqDto afterSalesBeanReqDto, String returnNo, OrderEo origOrderEo) {
        ArrayList tradeNoList = Lists.newArrayList();
        tradeNoList.add(origOrderEo.getOrderNo());
        List tradeItemEos = this.tradeItemDas.queryByTradeNoList((List)tradeNoList);
        Assert.isTrue(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)tradeItemEos), "get original order item fail,orderNo:" + origOrderEo.getOrderNo());
        List<Object> returnItemEos = new ArrayList<ReturnItemEo>();
        String channelCode = afterSalesBeanReqDto.getSaleChannel();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)afterSalesBeanReqDto.getReturnItemReqDtos())) {
            Map<String, List<TradeItemEo>> tradeItemMap = tradeItemEos.stream().collect(Collectors.groupingBy(tradeItemEo -> {
                String skuCode = tradeItemEo.getSkuCode();
                String skuCodeNew = skuCode != null ? skuCode : "";
                return tradeItemEo.getItemCode() + "_" + skuCodeNew;
            }));
            returnItemEos = afterSalesBeanReqDto.getReturnItemReqDtos().stream().map(skuItemReqDto -> {
                List itemRelationComparisonRespDtos;
                ReturnItemEo returnItemEo = new ReturnItemEo();
                DtoHelper.dto2Eo((BaseVo)skuItemReqDto, (BaseEo)returnItemEo);
                String channelItemCode = skuItemReqDto.getItemCode();
                String channelSkuCode = skuItemReqDto.getSkuCode();
                HashMap<String, String> errorMap = new HashMap<String, String>(1);
                if (StringUtils.isBlank((CharSequence)channelItemCode)) {
                    errorMap.put("errorMsg", String.format("\u6e20\u9053\u5546\u54c1\uff1a%s\uff0c\u6e20\u9053\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728", skuItemReqDto.getItemName()));
                    returnItemEo.setExtFields(errorMap);
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(itemRelationComparisonRespDtos = (List)ResponseUtil.getSuccessResult(this.itemRelationComparisonQueryApi.queryByParam(channelCode, channelItemCode, channelSkuCode))))) {
                    errorMap.put("errorMsg", String.format("\u6e20\u9053\u5546\u54c1\uff1a%s\uff0c\u672a\u5339\u914d\u5230\u5168\u6e20\u9053\u8fd0\u8425\u5e73\u53f0\u5546\u54c1\uff0c\u8bf7\u5b8c\u5584\u5546\u54c1\u5bf9\u7167\uff0c\u6e20\u9053\u5546\u54c1\u7f16\u7801\uff1a%s\uff0c\u6e20\u9053SKU\u7f16\u7801\uff1a%s", skuItemReqDto.getItemName(), channelItemCode, channelSkuCode));
                    returnItemEo.setExtFields(errorMap);
                } else if (itemRelationComparisonRespDtos.size() > 1) {
                    errorMap.put("errorMsg", String.format("\u6e20\u9053\u5546\u54c1\uff1a%s\uff0c\u5339\u914d\u5230\u5168\u6e20\u9053\u8fd0\u8425\u5e73\u53f0\u5546\u54c1\u5927\u4e8e\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u5bf9\u7167\uff0c\u6e20\u9053\u5546\u54c1\u7f16\u7801\uff1a%s\uff0c\u6e20\u9053SKU\u7f16\u7801\uff1a%s", skuItemReqDto.getItemName(), channelItemCode, channelSkuCode));
                    returnItemEo.setExtFields(errorMap);
                }
                if (MapUtils.isNotEmpty(errorMap)) {
                    return returnItemEo;
                }
                returnItemEo.setReturnNo(returnNo);
                if (null != skuItemReqDto.getItemNum()) {
                    returnItemEo.setItemNum(skuItemReqDto.getItemNum());
                }
                returnItemEo.setItemId(skuItemReqDto.getItemId());
                returnItemEo.setItemCode(skuItemReqDto.getItemCode());
                returnItemEo.setSkuCode(skuItemReqDto.getSkuCode());
                returnItemEo.setItemName(skuItemReqDto.getItemName());
                returnItemEo.setBrandId(skuItemReqDto.getBrandId());
                returnItemEo.setSkuDesc(skuItemReqDto.getSkuDesc());
                returnItemEo.setBrandId(skuItemReqDto.getBrandId());
                returnItemEo.setRefundAmount(skuItemReqDto.getItemPrice());
                if (null != afterSalesBeanReqDto.getInstanceId()) {
                    returnItemEo.setInstanceId(afterSalesBeanReqDto.getInstanceId());
                }
                if (null != afterSalesBeanReqDto.getTenantId()) {
                    returnItemEo.setTenantId(afterSalesBeanReqDto.getTenantId());
                }
                ItemRelationComparisonRespDto itemRelationComparisonRespDto = (ItemRelationComparisonRespDto)itemRelationComparisonRespDtos.get(0);
                String itemCode = itemRelationComparisonRespDto.getItemCode();
                String skuCode = itemRelationComparisonRespDto.getSkuCode();
                String key = itemCode + "_" + (skuCode != null ? skuCode : "");
                List tradeItemTemp = (List)tradeItemMap.get(key);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeItemTemp)) {
                    TradeItemEo tradeItemEo = (TradeItemEo)tradeItemTemp.get(0);
                    returnItemEo.setItemPrice(tradeItemEo.getItemPrice());
                    returnItemEo.setItemOrigPrice(tradeItemEo.getItemOrigPrice());
                    returnItemEo.setTradeNo(tradeItemEo.getTradeNo());
                    returnItemEo.setItemId(tradeItemEo.getItemSerial());
                    String extension = tradeItemEo.getExtension();
                    if (StringUtils.isNotBlank((CharSequence)extension)) {
                        JSONObject jsonObject = JSONObject.parseObject((String)extension);
                        jsonObject.put("reqReason", (Object)afterSalesBeanReqDto.getReturnReason());
                        returnItemEo.setExtension(jsonObject.toJSONString());
                    }
                }
                return returnItemEo;
            }).collect(Collectors.toList());
        }
        return returnItemEos;
    }

    private boolean checkReturnIsExist(AfterSalesBeanReqDto afterSalesBeanReqDto, List<String> orderNos) {
        ReturnOmniEo returnOmniEoSelect = new ReturnOmniEo();
        returnOmniEoSelect.setThirdOrderNo(afterSalesBeanReqDto.getSubSourceOrderCode());
        returnOmniEoSelect.setExtlReturnSerial(afterSalesBeanReqDto.getExtlReturnSerial());
        ReturnOmniEo returnOmniEo = (ReturnOmniEo)this.returnOmniDas.selectOne((BaseEo)returnOmniEoSelect);
        if (returnOmniEo != null) {
            ReturnOmniEo returnOmniEoUpdate;
            boolean logPrintFlag = false;
            String returnExpressCompany = afterSalesBeanReqDto.getReturnExpressCompany();
            String returnExpressSerial = afterSalesBeanReqDto.getReturnExpressSerial();
            if (StringUtils.isNotBlank((CharSequence)returnExpressCompany) && StringUtils.isNotBlank((CharSequence)returnExpressSerial)) {
                returnOmniEoUpdate = new ReturnOmniEo();
                returnOmniEoUpdate.setId(returnOmniEo.getId());
                returnOmniEoUpdate.setDeliveryType(String.valueOf(DeliveryTypeEnum.NORMAL.getId()));
                returnOmniEoUpdate.setReturnExpressCompanyName(returnExpressCompany);
                returnOmniEoUpdate.setReturnExpressCompany(returnExpressCompany);
                returnOmniEoUpdate.setReturnExpressSerial(returnExpressSerial);
                this.returnOmniDas.updateSelective((BaseEo)returnOmniEoUpdate);
                orderNos.add(returnOmniEo.getReturnNo());
            } else {
                logPrintFlag = true;
            }
            if (ReturnStatusEnum.FINISH.getName().equals(afterSalesBeanReqDto.getReturnStatus())) {
                returnOmniEoUpdate = new ReturnOmniEo();
                returnOmniEoUpdate.setId(returnOmniEo.getId());
                returnOmniEoUpdate.setReturnStatus(ReturnStatusEnum.FINISH.getName());
                this.returnOmniDas.updateSelective((BaseEo)returnOmniEoUpdate);
                RefundEo refundEo = this.refundDas.selectByTradeNo(returnOmniEo.getTradeNo());
                refundEo.setRefundStatus(RefundStatusEnum.SUCCESS.getName());
                this.refundDas.update((BaseEo)refundEo);
                orderNos.add(returnOmniEo.getReturnNo());
            } else {
                logPrintFlag = true;
            }
            if (logPrintFlag) {
                logger.info("\u552e\u540e\u5355\u91cd\u590d\uff0c\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7\uff1a{}\uff0c\u7b2c\u4e09\u65b9\u552e\u540e\u5355\u53f7\uff1a{}", (Object)afterSalesBeanReqDto.getSubSourceOrderCode(), (Object)afterSalesBeanReqDto.getExtlReturnSerial());
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean isReceivedGift(String orderTradeNo) {
        ReturnEo param = new ReturnEo();
        param.setOrderTradeNo(orderTradeNo);
        List returnEos = this.returnDas.select((BaseEo)param);
        return returnEos.stream().anyMatch(returnEo -> null != returnEo.getReceivedGift() && returnEo.getReceivedGift() != false);
    }

    @Override
    public void syncAfterSalesOrder(String tradeNo) {
        AuditRecordRespDto recordRespDto;
        ReturnDetailRespDto returnDetailRespDto = this.queryReturnDetail(tradeNo, null);
        ReturnMessageVo returnMessageVo = new ReturnMessageVo();
        returnMessageVo.setOrderNo(returnDetailRespDto.getOrderTradeNo());
        returnMessageVo.setReturnBalance(returnDetailRespDto.getRefundAmount());
        returnMessageVo.setCreateTime(DateUtil.getDateFormat((Date)returnDetailRespDto.getCreateTime(), (String)"yyyy-MM-dd"));
        returnMessageVo.setReturnNo(returnDetailRespDto.getReturnNo());
        returnMessageVo.setReturnStauts(returnDetailRespDto.getReturnStatus());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnDetailRespDto.getAuditRecordReps()) && null != (recordRespDto = (AuditRecordRespDto)returnDetailRespDto.getAuditRecordReps().get(0))) {
            returnMessageVo.setReturnReason(((AuditRecordRespDto)returnDetailRespDto.getAuditRecordReps().get(0)).getReqReason());
        }
        List returnOmniItemRespDtoList = returnDetailRespDto.getReturnOmniItemRespDtoList();
        int returnNum = returnOmniItemRespDtoList.stream().mapToInt(ReturnOmniItemRespDto::getItemNum).sum();
        returnMessageVo.setReturnQuantity(Double.valueOf(returnNum));
        returnMessageVo.setRemark("");
        String orderTradeNo = returnDetailRespDto.getOrderTradeNo();
        OrderEo orderEo = this.orderService.getByOrderNo(orderTradeNo);
        if (ShopTypeEnum.ONLINE.getType().equals(orderEo.getShopType())) {
            returnMessageVo.setPkType("1001E410000000AN2IGE");
        } else {
            returnMessageVo.setPkType("1001E41000000000CX58");
        }
        RestResponse listRestResponse = this.shopQueryApi.queryByIds((Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(orderEo.getShopId())}));
        List shopDtos = (List)listRestResponse.getData();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDtos)) {
            ShopDto shopDto = (ShopDto)shopDtos.get(0);
            returnMessageVo.setShopSource(shopDto.getCode());
        }
        List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(orderEo.getOrderNo());
        Map<String, TradeItemEo> tradeItemEoMap = tradeItemEos.stream().collect(Collectors.toMap(eo -> eo.getItemCode() + eo.getSkuCode(), a -> a));
        ArrayList returnItemMessageVos = Lists.newArrayList();
        for (ReturnOmniItemRespDto dto : returnOmniItemRespDtoList) {
            ReturnItemMessageVo returnItemMessageVo = new ReturnItemMessageVo();
            returnItemMessageVo.setReturnNum(dto.getItemNum());
            returnItemMessageVo.setReturnFee(dto.getItemPrice().multiply(new BigDecimal(dto.getItemNum())));
            TradeItemEo tradeItemEo = tradeItemEoMap.get(dto.getItemCode() + dto.getSkuCode());
            returnItemMessageVo.setTradeItemNo(tradeItemEo.getTradeItemNo());
            returnItemMessageVo.setReturnReason(returnMessageVo.getReturnReason());
            returnItemMessageVos.add(returnItemMessageVo);
        }
        returnMessageVo.setReturnItemMessageVoList(returnItemMessageVos);
        this.orderAfterSalesProducer.sendMqMessage(returnMessageVo, orderEo.getShopType());
    }

    @Override
    public void modifyItemOrigPriceById(Long id, BigDecimal itemOrigPrice) {
        if (id == null) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReturnItemEo returnItemEo = new ReturnItemEo();
        returnItemEo.setId(id);
        returnItemEo.setItemOrigPrice(itemOrigPrice);
        this.returnItemDas.updateSelective((BaseEo)returnItemEo);
    }

    @Override
    public void updateReturnItemTableCustomerId(List<String> returnNos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(returnNos)) {
            logger.info("\u6307\u5b9a\u9000\u8d27\u5355\u53f7\u8bbe\u7f6ecustomerId:{}", returnNos);
            ReturnEo returnEo = new ReturnEo();
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"return_no", returnNos));
            returnEo.setSqlFilters((List)sqlFilters);
            List eos = this.returnDas.select((BaseEo)returnEo);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eos)) {
                for (ReturnEo eo : eos) {
                    this.updateCustomerId(eo);
                }
            }
        } else {
            logger.info("\u5168\u91cf\u8bbe\u7f6e");
            Integer pageNum = 1;
            Integer pageSize = 1000;
            ReturnEo returnEo = new ReturnEo();
            while (true) {
                logger.info("\u5f53\u524d\u9875\u6570\uff1a{}", (Object)pageNum);
                PageInfo pageInfo = this.returnDas.selectPage((BaseEo)returnEo, pageNum, pageSize);
                if (pageInfo == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                    logger.info("\u5168\u91cf\u8bbe\u7f6e\u7ed3\u675f\uff0c\u5f53\u524d\u9875\u6570\uff1a{}", (Object)pageNum);
                    return;
                }
                for (ReturnEo eo : pageInfo.getList()) {
                    this.updateCustomerId(eo);
                }
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            }
        }
    }

    @Override
    public PageInfo<ReturnRespDto> queryPostReturnByPage(String filter) {
        ReturnQueryReqDto returnQueryReqDto = (ReturnQueryReqDto)JSON.parseObject((String)filter, ReturnQueryReqDto.class);
        return this.queryReturnByPage(returnQueryReqDto, returnQueryReqDto.getPageNum(), returnQueryReqDto.getPageSize());
    }

    @Override
    public ReturnOrderStatusCountRespDto countReturnOrder(ReturnQueryReqDto returnQueryReqDto) {
        List returnEos;
        ReturnOrderStatusCountRespDto respDto = new ReturnOrderStatusCountRespDto();
        ReturnOmniEo returnOmniEo = new ReturnOmniEo();
        PageInfo paramPage = this.buildPageCommonQueryParam(returnQueryReqDto, returnOmniEo);
        if (paramPage == null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(returnEos = this.returnOmniDas.selectWithColumn((BaseEo)returnOmniEo, new String[]{"return_status"})))) {
            Map<String, Long> groupMap = returnEos.stream().collect(Collectors.groupingBy(StdReturnEo::getReturnStatus, Collectors.counting()));
            HashMap groupIntMap = new HashMap();
            groupMap.forEach((k, v) -> {
                if (ObjectUtils.isNotEmpty((Object)v)) {
                    Integer num = Integer.valueOf(String.valueOf(v));
                    groupIntMap.put(k, num);
                }
            });
            respDto.setAllCount(Integer.valueOf(returnEos.size()));
            respDto.setWaitAuditCount((Integer)groupIntMap.get(ReturnStatusToBEnum.WAIT_AUDIT.getCode()));
            respDto.setWaitInStorageCount((Integer)groupIntMap.get(ReturnStatusToBEnum.WAIT_IN_STORAGE.getCode()));
            respDto.setWaitRefundCount((Integer)groupIntMap.get(ReturnStatusToBEnum.WAIT_REFUND.getCode()));
            respDto.setCompleteCount((Integer)groupIntMap.get(ReturnStatusToBEnum.COMPLETE.getCode()));
            respDto.setCancelCount((Integer)groupIntMap.get(ReturnStatusToBEnum.CANCEL.getCode()));
            respDto.setCloseCount((Integer)groupIntMap.get(ReturnStatusToBEnum.CLOSE.getCode()));
        }
        return respDto;
    }

    private void updateCustomerId(ReturnEo eo) {
        String customerId = eo.getCustomerId();
        String returnNo = eo.getReturnNo();
        ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
        ArrayList appSqlFilters = Lists.newArrayList();
        appSqlFilters.add(SqlFilter.eq((String)"return_no", (Object)returnNo));
        applyReturnItemEo.setCustomerId(customerId);
        applyReturnItemEo.setSqlFilters((List)appSqlFilters);
        this.applyReturnItemDas.updateSelectiveSqlFilter((BaseEo)applyReturnItemEo);
        ReturnItemEo updateEo = new ReturnItemEo();
        ArrayList returnSqlFilters = Lists.newArrayList();
        returnSqlFilters.add(SqlFilter.eq((String)"return_no", (Object)returnNo));
        updateEo.setCustomerId(customerId);
        updateEo.setSqlFilters((List)returnSqlFilters);
        this.returnItemDas.updateSelectiveSqlFilter((BaseEo)updateEo);
    }
}

