/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ApplyReturnItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IApplyReturnItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ApplyReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ApplyReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplyReturnItemServiceImpl
implements IApplyReturnItemService {
    @Autowired
    private IUnitQueryApi unitQueryApi;
    @Autowired
    ITradeItemService tradeItemService;
    @Resource
    private ApplyReturnItemDas applyReturnItemDas;

    @Override
    public Long addApplyReturnItem(ApplyReturnItemReqDto addReqDto) {
        ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)applyReturnItemEo);
        this.applyReturnItemDas.insert((BaseEo)applyReturnItemEo);
        return applyReturnItemEo.getId();
    }

    @Override
    public void modifyApplyReturnItem(ApplyReturnItemReqDto modifyReqDto) {
        ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)applyReturnItemEo);
        this.applyReturnItemDas.updateSelective((BaseEo)applyReturnItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeApplyReturnItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.applyReturnItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ApplyReturnItemRespDto queryById(Long id) {
        ApplyReturnItemEo applyReturnItemEo = (ApplyReturnItemEo)this.applyReturnItemDas.selectByPrimaryKey(id);
        ApplyReturnItemRespDto applyReturnItemRespDto = new ApplyReturnItemRespDto();
        DtoHelper.eo2Dto((BaseEo)applyReturnItemEo, (BaseVo)applyReturnItemRespDto);
        return applyReturnItemRespDto;
    }

    @Override
    public List<ApplyReturnItemRespDto> queryByReturnNo(String returnNo) {
        ApplyReturnItemEo queryParams = new ApplyReturnItemEo();
        queryParams.setReturnNo(returnNo);
        List res = this.applyReturnItemDas.selectList((BaseEo)queryParams, Integer.valueOf(1), Integer.valueOf(1000));
        ArrayList<ApplyReturnItemRespDto> dtoList = new ArrayList<ApplyReturnItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)res, dtoList, ApplyReturnItemRespDto.class);
        List unitIdList = dtoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getUnit())).map(e -> e.getUnit()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(unitIdList)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIdList, (String)",")));
            Map<String, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(unitResp -> unitResp.getId().toString(), UnitRespDto::getName, (e1, e2) -> e1));
            for (ApplyReturnItemRespDto applyReturnItemRespDto : dtoList) {
                String tmpUnit = StringUtils.isNotEmpty((CharSequence)applyReturnItemRespDto.getUnit()) ? applyReturnItemRespDto.getUnit() : "";
                applyReturnItemRespDto.setUnitName(unitNameMap.get(tmpUnit));
            }
        }
        return dtoList;
    }

    @Override
    public List<ApplyReturnItemRespDto> queryByReturnNo(String returnNo, boolean queryTradeItem) {
        List<ApplyReturnItemRespDto> res = this.queryByReturnNo(returnNo);
        if (queryTradeItem) {
            for (ApplyReturnItemRespDto itemRespDto : res) {
                if (StringUtils.isEmpty((CharSequence)itemRespDto.getTradeNo())) {
                    itemRespDto.setReturnedNum(Integer.valueOf(0));
                    itemRespDto.setCanReturnedNum(Integer.valueOf(Integer.MAX_VALUE));
                    itemRespDto.setItemMarketPrice(itemRespDto.getItemPrice());
                    itemRespDto.setSubTotalReturnAmount(itemRespDto.getRefundAmount());
                    continue;
                }
                TradeItemEo tradeItemEo = new TradeItemEo();
                tradeItemEo.setId(itemRespDto.getTradeItemId());
                tradeItemEo.setTradeNo(itemRespDto.getTradeNo());
                tradeItemEo.setItemSerial(itemRespDto.getItemId());
                tradeItemEo.setSkuSerial(itemRespDto.getSkuSerial());
                tradeItemEo.setGift(itemRespDto.getGift());
                tradeItemEo.setIfExchange(itemRespDto.getIfExchange());
                tradeItemEo.setIsCombinedPackage(itemRespDto.getIsCombinedPackage());
                tradeItemEo.setCombinedPackageActivityId(itemRespDto.getCombinedPackageActivityId());
                tradeItemEo.setId(itemRespDto.getTradeItemId());
                BigDecimal itemMarketPrice = itemRespDto.getItemOrigPrice();
                List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeItemEo(tradeItemEo);
                if (!CollectionUtils.isNotEmpty(tradeItemEos)) continue;
                itemRespDto.setSrcBatchNo(tradeItemEos.get(0).getBatchNo());
                itemRespDto.setSubTotalReturnAmount(itemRespDto.getRefundAmount());
                itemRespDto.setDeliveredNum(tradeItemEos.get(0).getDeliveredNum());
                Integer returnedNum = tradeItemEos.get(0).getReturnedNum() == null ? 0 : tradeItemEos.get(0).getReturnedNum();
                Integer canReturnedNum = tradeItemEos.get(0).getItemNum() - returnedNum;
                itemRespDto.setReturnedNum(returnedNum);
                itemRespDto.setCanReturnedNum(canReturnedNum);
                itemRespDto.setTradeItemNo(tradeItemEos.get(0).getTradeItemNo());
                itemMarketPrice = tradeItemEos.get(0).getItemMarketPrice();
                itemRespDto.setItemMarketPrice(itemMarketPrice);
                if (tradeItemEos.get(0).getGift() != 0) continue;
                BigDecimal discountTotalAmount = tradeItemEos.get(0).getDiscountTotalAmount();
                BigDecimal eachShareAmount = null;
                if (discountTotalAmount != null && discountTotalAmount.compareTo(BigDecimal.ZERO) > 0) {
                    if (ExchangeEnum.YES.getType().equals(tradeItemEos.get(0).getIfExchange()) || CombinationEnum.YES.getType().equals(tradeItemEos.get(0).getIsCombinedPackage())) {
                        eachShareAmount = discountTotalAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                    } else {
                        BigDecimal timeDiscount = tradeItemEos.get(0).getItemMarketPrice().subtract(tradeItemEos.get(0).getItemOrigPrice());
                        BigDecimal shareAmount = discountTotalAmount.subtract(timeDiscount.multiply(new BigDecimal(tradeItemEos.get(0).getItemNum())));
                        eachShareAmount = shareAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                    }
                }
                itemRespDto.setEachShareAmount(eachShareAmount);
                itemRespDto.setPromotionPrice(tradeItemEos.get(0).getItemOrigPrice());
                Integer itemNum = tradeItemEos.get(0).getItemNum();
                Integer returnNum = itemRespDto.getReturnNum();
                BigDecimal giftDeductionTotalAmount = tradeItemEos.get(0).getGiftDeduction();
                if (giftDeductionTotalAmount != null && giftDeductionTotalAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal eachGiftDeductionAmount = giftDeductionTotalAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                    BigDecimal curGiftTotalAmount = itemNum - returnNum == 0 ? giftDeductionTotalAmount : eachGiftDeductionAmount.multiply(BigDecimal.valueOf(returnNum.intValue()));
                    itemRespDto.setGiftDeductionAmount(curGiftTotalAmount);
                    itemRespDto.setEachGiftDeductionAmount(eachGiftDeductionAmount);
                } else {
                    itemRespDto.setGiftDeductionAmount(BigDecimal.ZERO);
                    itemRespDto.setEachGiftDeductionAmount(BigDecimal.ZERO);
                }
                BigDecimal rebateTotalAmount = tradeItemEos.get(0).getRebateAmount();
                if (rebateTotalAmount != null && rebateTotalAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal eachRebateAmount = rebateTotalAmount.divide(BigDecimal.valueOf(tradeItemEos.get(0).getItemNum().intValue()), 2, 1);
                    BigDecimal curRebateTotalAmount = itemNum - returnNum == 0 ? rebateTotalAmount : eachRebateAmount.multiply(BigDecimal.valueOf(returnNum.intValue()));
                    itemRespDto.setDiscountAmount(curRebateTotalAmount);
                    itemRespDto.setEachDiscountAmount(eachRebateAmount);
                    continue;
                }
                itemRespDto.setEachDiscountAmount(BigDecimal.ZERO);
                itemRespDto.setDiscountAmount(BigDecimal.ZERO);
            }
        }
        return res;
    }

    @Override
    public PageInfo<ApplyReturnItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ApplyReturnItemReqDto applyReturnItemReqDto = (ApplyReturnItemReqDto)JSON.parseObject((String)filter, ApplyReturnItemReqDto.class);
        ApplyReturnItemEo applyReturnItemEo = new ApplyReturnItemEo();
        DtoHelper.dto2Eo((BaseVo)applyReturnItemReqDto, (BaseEo)applyReturnItemEo);
        PageInfo eoPageInfo = this.applyReturnItemDas.selectPage((BaseEo)applyReturnItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ApplyReturnItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

