/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoOrderDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoStorageApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.shipping.api.IPackageApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackagePackedReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryPackageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ICargoDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CargoDeliveryServiceImpl
implements ICargoDeliveryService {
    private static Logger logger = LoggerFactory.getLogger(CargoDeliveryServiceImpl.class);
    @Resource
    private ICargoStorageApi cargoStorageApi;
    @Resource
    ICargoOrderDeliveryQueryApi cargoOrderDeliveryQueryApi;
    @Resource
    private IOrderDeliveryService deliveryService;
    @Resource
    ICargoOrderDeliveryApi cargoOrderDeliveryApi;
    @Resource
    IWarehouseQueryApi warehouseQueryApi;
    @Resource
    IStorageOrderApi storageOrderApi;
    @Resource
    IPackageApi packageApi;
    @Resource
    private IFlowEngine flowEngine;
    @Resource
    private ICacheService cacheService;

    @Override
    public boolean cancel(String tradeNo) {
        RestResponse isCancel = null;
        try {
            isCancel = this.cargoOrderDeliveryApi.cancelByOrderNo(tradeNo);
        }
        catch (Exception e) {
            return false;
        }
        if (!((Boolean)isCancel.getData()).booleanValue()) {
            throw new BizException(TradeExceptionCode.CANCEL_FAIL_STORAGE_OUT.getCode(), TradeExceptionCode.CANCEL_FAIL_STORAGE_OUT.getMsg());
        }
        return true;
    }

    @Override
    public void packageByIds(Set<String> packageIds) {
        packageIds.stream().forEach(packageId -> {
            PackagePackedReqDto packagePackedReqDto = new PackagePackedReqDto();
            packagePackedReqDto.setId(Long.valueOf(Long.parseLong(packageId)));
            ResponseUtil.getSuccessResult(this.packageApi.packed(packagePackedReqDto.getId(), packagePackedReqDto));
        });
    }

    @Override
    public WarehouseRespDto getByWarehouseId(String warehouseSerial) {
        return (WarehouseRespDto)ResponseUtil.getSuccessResult(this.warehouseQueryApi.queryWarehouseById(Long.valueOf(Long.parseLong(warehouseSerial)), "{}"));
    }

    @Override
    public void lockItems(OrderDeliveryReqDto delivery) {
        CargoStorageCreateReqDto cargoStorageCreateReqDto = new CargoStorageCreateReqDto();
        cargoStorageCreateReqDto.setInstanceId(delivery.getInstanceId());
        cargoStorageCreateReqDto.setTenantId(delivery.getTenantId());
        cargoStorageCreateReqDto.setOrderNo(delivery.getTradeNo());
        cargoStorageCreateReqDto.setAreaCode(delivery.getAreaCode());
        cargoStorageCreateReqDto.setProvCode(delivery.getProvinceCode());
        cargoStorageCreateReqDto.setCityCode(delivery.getCityCode());
        ArrayList<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtos = new ArrayList<CargoStorageInfoCreateReqDto>();
        for (DeliveryItemReqDto deliveryItem : delivery.getDeliveryItemList()) {
            CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto = new CargoStorageInfoCreateReqDto();
            cargoStorageInfoCreateReqDto.setNum(new BigDecimal(deliveryItem.getItemNum()));
            cargoStorageInfoCreateReqDto.setCargoId(Long.valueOf(Long.parseLong(deliveryItem.getCargoSerial())));
            if (!StringUtils.isEmpty((CharSequence)delivery.getWarehouseSerial())) {
                cargoStorageInfoCreateReqDto.setWarehouseId(Long.valueOf(Long.parseLong(delivery.getWarehouseSerial())));
            }
            cargoStorageInfoCreateReqDtos.add(cargoStorageInfoCreateReqDto);
        }
        cargoStorageCreateReqDto.setCargoList(cargoStorageInfoCreateReqDtos);
        ResponseUtil.getSuccessResult(this.cargoStorageApi.subCargoStorage(cargoStorageCreateReqDto));
    }

    @Override
    public void createStorageOrder(List<PackageDetailDto> packageDetailDtos) {
    }

    @Override
    public void deliveryOrder(List<OrderDeliveryEo> completeDeliveryList) {
    }

    @Override
    public List<DeliveryPackageReqDto> queryByNoList(List<String> orderDeliveryNoList) {
        ArrayList<DeliveryPackageReqDto> deliveryPackageReqDtos = new ArrayList<DeliveryPackageReqDto>();
        return deliveryPackageReqDtos;
    }
}

