/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ChannelPageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ChannelRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IChannelService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ChannelDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelServiceImpl
implements IChannelService {
    @Resource
    private ChannelDas channelDas;
    @Resource
    private ICacheService cacheService;

    private String getUsername() {
        return ServiceContext.getContext().getRequestUserCode();
    }

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    @Override
    public Long addChannel(ChannelEo channelEo) {
        if (StringUtils.isBlank((CharSequence)channelEo.getCode())) {
            throw new BizException("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long tenantId = this.getTenantId(channelEo.getTenantId());
        Long intanceId = this.getInstanceId(channelEo.getInstanceId());
        ChannelEo queryEo = new ChannelEo();
        queryEo.setTenantId(tenantId);
        queryEo.setCode(channelEo.getCode());
        if (this.channelDas.count((BaseEo)queryEo) > 0) {
            throw new BizException("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        channelEo.setTenantId(tenantId);
        channelEo.setInstanceId(intanceId);
        channelEo.setCreatePerson(this.getUsername());
        this.channelDas.insert((BaseEo)channelEo);
        return channelEo.getId();
    }

    @Override
    public void modifyChannel(ChannelEo channelEo) {
        Long id = channelEo.getId();
        if (id == null) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long tenantId = this.getTenantId(channelEo.getTenantId());
        String code = channelEo.getCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            ChannelEo queryEo = new ChannelEo();
            queryEo.setTenantId(tenantId);
            queryEo.setCode(channelEo.getCode());
            queryEo.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)id)));
            if (this.channelDas.count((BaseEo)queryEo) > 0) {
                throw new BizException("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        channelEo.setTenantId(null);
        channelEo.setInstanceId(null);
        channelEo.setCreateTime(null);
        channelEo.setUpdatePerson(this.getUsername());
        this.channelDas.updateSelective((BaseEo)channelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChannel(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.channelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ChannelRespDto queryById(Long id) {
        ChannelEo channelEo = (ChannelEo)this.channelDas.selectByPrimaryKey(id);
        return (ChannelRespDto)EoUtil.eoToDto((BaseEo)channelEo, ChannelRespDto.class);
    }

    @Override
    public List<ChannelRespDto> queryByIds(List<Long> channelId) {
        ChannelEo query = (ChannelEo)SqlFilterBuilder.create(ChannelEo.class).in("id", channelId).eo();
        List channels = this.channelDas.select((BaseEo)query);
        return EoUtil.eoListToDtoList((Collection)channels, ChannelRespDto.class);
    }

    @Override
    public List<ChannelEo> queryByCondition(ChannelEo channelEo) {
        return this.channelDas.select((BaseEo)channelEo);
    }

    @Override
    public ChannelEo queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ChannelEo channelEo = (ChannelEo)this.cacheService.getCache("channelCode_" + code, ChannelEo.class);
        if (channelEo == null) {
            ChannelEo channelEoQuery = new ChannelEo();
            channelEoQuery.setCode(code);
            channelEo = (ChannelEo)this.channelDas.selectOne((BaseEo)channelEoQuery);
            if (channelEo != null) {
                this.cacheService.setCache("channelCode_" + code, (Object)channelEo);
            }
        }
        return channelEo;
    }

    @Override
    public PageInfo<ChannelRespDto> queryByPage(ChannelPageReqDto channelPageReqDto) {
        ChannelEo queryEo = (ChannelEo)EoUtil.dtoToEo((BaseVo)channelPageReqDto, ChannelEo.class);
        ArrayList sqlFilters = new ArrayList(2);
        if (StringUtils.isNotEmpty((CharSequence)channelPageReqDto.getCode())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChannelEo.class).like("code", (Object)("%" + channelPageReqDto.getCode() + "%")).filters());
            queryEo.setCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)channelPageReqDto.getName())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChannelEo.class).like("name", (Object)("%" + channelPageReqDto.getName() + "%")).filters());
            queryEo.setName(null);
        }
        if (null != channelPageReqDto.getUpdateStartTime() && null != channelPageReqDto.getUpdateEndTime()) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChannelEo.class).ge("update_time", (Object)channelPageReqDto.getUpdateStartTime()).le("update_time", (Object)channelPageReqDto.getUpdateEndTime()).filters());
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            queryEo.setSqlFilters(sqlFilters);
        }
        queryEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.channelDas.selectPage((BaseEo)queryEo, channelPageReqDto.getPageNum(), channelPageReqDto.getPageSize());
        return EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, ChannelRespDto.class);
    }
}

