/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliverySplitFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OnOffEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderSettingEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliverySplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderSettingRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliverySplitVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliverySplitService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryOrderVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliverySplitServiceImpl
implements IDeliverySplitService {
    private static Logger logger = LoggerFactory.getLogger(DeliverySplitServiceImpl.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private DeliveryProducer deliveryProducer;
    @Autowired
    private IDictQueryApi dictQueryApi;
    @Autowired
    private ICargoQueryApi cargoQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualSplit(DeliverySplitReqDto deliverySplitReqDto) {
        logger.info("\u624b\u52a8\u62c6\u5206\u53d1\u8d27\u5355\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)deliverySplitReqDto));
        DeliveryVo deliveryVo = this.deliveryService.getDeliveryByDeliveryNo(deliverySplitReqDto.getDeliveryNo());
        if (null == deliveryVo) {
            throw new BizException("\u627e\u4e0d\u5230\u8be5\u53d1\u8d27\u5355\u4fe1\u606f\uff01");
        }
        OrderDeliveryEo orderDelivery = deliveryVo.getOrderDelivery();
        if (!DeliveryStatusEnum.TO_CONFIRM.getStatus().equals(orderDelivery.getDeliveryStatus())) {
            logger.error("\u624b\u52a8\u62c6\u5206\u53d1\u8d27\u5355:{}\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001\uff0c\u4e0d\u80fd\u62c6\u5206\uff0c\u5f53\u524d\u53d1\u8d27\u5355\u72b6\u6001\uff1a{}", (Object)deliverySplitReqDto.getDeliveryNo(), (Object)orderDelivery.getDeliveryStatus());
            throw new BizException("\u53d1\u8d27\u5355\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u4e0d\u652f\u6301\u62c6\u5206\uff01");
        }
        OrderDeliveryEo rootDelivery = this.deliveryService.getRootDelivery(deliveryVo.getOrderDelivery());
        if (rootDelivery.getSplitCount() >= 3) {
            logger.error("\u624b\u52a8\u62c6\u5206\u53d1\u8d27\u5355:{}\u5931\u8d25\uff0c\u62c6\u5355\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u5f53\u524d\u62c6\u5355\u6b21\u6570\uff1aSplitCount{}\uff01", (Object)deliverySplitReqDto.getDeliveryNo(), (Object)rootDelivery.getSplitCount());
            throw new BizException("\u62c6\u5355\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u80fd\u518d\u62c6\u5206\uff01");
        }
        List<DeliveryItemEo> deliveryItems = deliveryVo.getDeliveryItems();
        RefDeliveryOrderEo refDeliveryOrder = deliveryVo.getRefDeliveryOrders().get(0);
        Map<Long, DeliveryItemEo> deliveryItemMap = deliveryItems.stream().collect(Collectors.toMap(BaseEo::getId, o -> o));
        OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
        orderDeliveryUpdate.setId(orderDelivery.getId());
        orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
        orderDeliveryUpdate.setCancelType(DeliveryCancelTypeEnum.MANUAL_SPILT_CANCEL.getType());
        orderDeliveryUpdate.setCancelDesc(DeliveryCancelTypeEnum.MANUAL_SPILT_CANCEL.getDesc());
        orderDeliveryUpdate.setCancelTime(new Date());
        orderDeliveryUpdate.setSplitFlag(DeliverySplitFlagEnum.SPLIT.getFlag());
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        ArrayList<DeliveryVo> deliverySplitChilds = new ArrayList<DeliveryVo>();
        List childs = deliverySplitReqDto.getChilds();
        childs.stream().forEach(childDto -> {
            DeliveryVo deliveryChild = new DeliveryVo();
            String newDeliveryNo = TradeUtil.generateTradeNo(refDeliveryOrder.getOrderNo());
            OrderDeliveryEo orderDeliveryChild = OrderDeliveryEo.newInstance();
            BeanUtils.copyProperties((Object)orderDelivery, (Object)orderDeliveryChild, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            orderDeliveryChild.setDeliveryNo(newDeliveryNo);
            orderDeliveryChild.setParentDeliveryNo(orderDelivery.getDeliveryNo());
            orderDeliveryChild.setSplitFlag(DeliverySplitFlagEnum.SPLIT.getFlag());
            orderDeliveryChild.setSplitLevel(Integer.valueOf(1));
            this.orderDeliveryDas.insert((BaseEo)orderDeliveryChild);
            List childItems = childDto.getChildItems();
            ArrayList<DeliveryItemEo> deliveryItemChilds = new ArrayList<DeliveryItemEo>();
            childItems.stream().forEach(childItemDto -> {
                DeliveryItemEo deliveryItemChild = DeliveryItemEo.newInstance();
                DeliveryItemEo deliveryItemEo = (DeliveryItemEo)deliveryItemMap.get(childItemDto.getDeliveryItemId());
                BeanUtils.copyProperties((Object)deliveryItemEo, (Object)deliveryItemChild, (String[])new String[]{"id", "deliveryNo", "itemNo", "createTime", "updateTime"});
                deliveryItemChild.setDeliveryNo(newDeliveryNo);
                deliveryItemChild.setItemNum(childItemDto.getItemNum());
                this.deliveryItemDas.insert((BaseEo)deliveryItemChild);
                if (null != childItemDto.getItemNum() && childItemDto.getItemNum() > 0) {
                    deliveryItemChilds.add(deliveryItemChild);
                }
            });
            RefDeliveryOrderEo refDeliveryOrderEo = RefDeliveryOrderEo.newInstance();
            BeanUtils.copyProperties((Object)refDeliveryOrder, (Object)refDeliveryOrderEo, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            refDeliveryOrderEo.setDeliveryNo(newDeliveryNo);
            this.refDeliveryOrderDas.insert((BaseEo)refDeliveryOrderEo);
            deliveryChild.setOrderDelivery(orderDeliveryChild);
            deliveryChild.setDeliveryItems(deliveryItemChilds);
            deliverySplitChilds.add(deliveryChild);
        });
        OrderDeliveryEo rootDeliveryUpdate = OrderDeliveryEo.newInstance();
        rootDeliveryUpdate.setId(rootDelivery.getId());
        rootDeliveryUpdate.setSplitCount(Integer.valueOf(rootDelivery.getSplitCount() + 1));
        this.orderDeliveryDas.updateSelective((BaseEo)rootDeliveryUpdate);
        DeliverySplitVo deliverySplitVo = new DeliverySplitVo();
        DeliverySplitVo.DeliveryParent deliveryParent = new DeliverySplitVo.DeliveryParent();
        BeanUtils.copyProperties((Object)orderDeliveryUpdate, (Object)deliveryParent);
        deliverySplitVo.setDeliveryParent(deliveryParent);
        deliverySplitVo.setDeliveryChilds(deliverySplitChilds);
        logger.info("\u624b\u52a8\u62c6\u5206\u53d1\u8d27\u5355\u5b8c\u6bd5\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}", (Object)orderDelivery.getDeliveryNo());
        this.deliveryProducer.sendInventoryDeliverySplit(deliverySplitVo);
    }

    @Override
    public List<DeliveryVo> getAutoSplitDelivery(DeliveryOrderVo deliveryOrderVo) {
        List<DeliveryVo> deliveryVos;
        List splitByItemPropertys;
        List<DeliveryVo> deliveryVos2;
        OrderSettingRespDto.DeliveryAutoSplitSettingDto deliveryAutoSplitSetting = this.getDeliveryAutoSplitSetting();
        if (null == deliveryAutoSplitSetting) {
            logger.info("\u7cfb\u7edf\u81ea\u52a8\u62c6\u5206\u8bbe\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u62c6\u5206\u64cd\u4f5c\u3002");
            return null;
        }
        if (!OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoSplitSetting.getAutoSplitSwitch())) {
            logger.info("\u53d1\u8d27\u5355\u81ea\u52a8\u62c6\u5206\u5f00\u5173\u672a\u5f00\u542f\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u62c6\u5206\u64cd\u4f5c\u3002");
            return null;
        }
        OrderDeliveryEo orderDeliveryEo = deliveryOrderVo.getOrderDelivery();
        ArrayList<DeliveryVo> splitResultDeliveryVos = new ArrayList<DeliveryVo>();
        List<DeliveryItemEo> deliveryItems = BeanUtil.copyList(deliveryOrderVo.getDeliveryItems(), DeliveryItemEo.class);
        List<String> cargoCodes = deliveryItems.stream().filter(o -> StringUtils.isNotBlank((String)o.getCargoSerial())).map(StdDeliveryItemEo::getCargoSerial).distinct().collect(Collectors.toList());
        ArrayList<DeliveryVo> itemSkuAndPropertyVos = new ArrayList<DeliveryVo>();
        ArrayList weightDeliveryVos = new ArrayList();
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoSplitSetting.getAloneOrderSwitch()) && CollectionUtils.isNotEmpty(deliveryVos2 = this.splitByAloneOrderSetting(deliveryAutoSplitSetting, deliveryItems))) {
            itemSkuAndPropertyVos.addAll(deliveryVos2);
        }
        if (CollectionUtils.isNotEmpty((Collection)(splitByItemPropertys = deliveryAutoSplitSetting.getSplitByItemPropertys())) && CollectionUtils.isNotEmpty(deliveryVos = this.splitByItemProperty(deliveryAutoSplitSetting, deliveryItems))) {
            itemSkuAndPropertyVos.addAll(deliveryVos);
        }
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoSplitSetting.getSplitByWeightSwitch()) && CollectionUtils.isNotEmpty(cargoCodes)) {
            List cargos = (List)this.cargoQueryApi.listByCodes(cargoCodes).getData();
            if (CollectionUtils.isNotEmpty((Collection)cargos)) {
                List<DeliveryVo> deliveryVos3;
                Map<String, CargoRespDto> cargoMap = cargos.stream().collect(Collectors.toMap(CargoRespDto::getCode, o -> o));
                if (CollectionUtils.isNotEmpty(itemSkuAndPropertyVos)) {
                    for (DeliveryVo deliveryVo2 : itemSkuAndPropertyVos) {
                        List<DeliveryItemEo> items = deliveryVo2.getDeliveryItems();
                        List<DeliveryVo> deliveryVos4 = this.splitByWeightSetting(deliveryAutoSplitSetting, items, cargoCodes, cargoMap);
                        splitResultDeliveryVos.addAll(deliveryVos4);
                    }
                }
                if (CollectionUtils.isNotEmpty(deliveryVos3 = this.splitByWeightSetting(deliveryAutoSplitSetting, deliveryItems, cargoCodes, cargoMap))) {
                    splitResultDeliveryVos.addAll(deliveryVos3);
                }
            }
        } else {
            splitResultDeliveryVos.addAll(itemSkuAndPropertyVos);
        }
        if (CollectionUtils.isNotEmpty(weightDeliveryVos)) {
            if (YesNoEnum.NO.getValue().equals(((DeliveryVo)weightDeliveryVos.get(0)).getIfWeight()) && weightDeliveryVos.size() > 1) {
                List<DeliveryItemEo> deliveryItems0 = ((DeliveryVo)weightDeliveryVos.get(0)).getDeliveryItems();
                List<DeliveryItemEo> deliveryItems1 = ((DeliveryVo)weightDeliveryVos.get(1)).getDeliveryItems();
                deliveryItems0.addAll(deliveryItems1);
                ((DeliveryVo)weightDeliveryVos.get(1)).setDeliveryItems(deliveryItems0);
                weightDeliveryVos.remove(0);
            }
            splitResultDeliveryVos.addAll(weightDeliveryVos);
        }
        if (CollectionUtils.isNotEmpty(deliveryItems)) {
            DeliveryVo leftDeliveryVo = new DeliveryVo();
            leftDeliveryVo.setDeliveryItems(deliveryItems);
            splitResultDeliveryVos.add(leftDeliveryVo);
        }
        if (CollectionUtils.isEmpty(splitResultDeliveryVos) || splitResultDeliveryVos.size() <= 1) {
            logger.info("\u53d1\u8d27\u5355\uff1a{}\u65e0\u9700\u7cfb\u7edf\u62c6\u5355", (Object)orderDeliveryEo.getDeliveryNo());
            return null;
        }
        RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)deliveryOrderVo.getRefDeliveryOrders().get(0);
        splitResultDeliveryVos.stream().forEach(deliveryVo -> {
            String deliveryNo = TradeUtil.generateTradeNo(refDeliveryOrderEo.getOrderNo());
            String parentDeliveryNo = orderDeliveryEo.getParentDeliveryNo();
            OrderDeliveryEo orderDeliveryTemp = OrderDeliveryEo.newInstance();
            BeanUtils.copyProperties((Object)orderDeliveryEo, (Object)orderDeliveryTemp, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            orderDeliveryTemp.setDeliveryNo(deliveryNo);
            orderDeliveryTemp.setParentDeliveryNo(parentDeliveryNo);
            deliveryVo.setOrderDelivery(orderDeliveryTemp);
            deliveryVo.getDeliveryItems().stream().forEach(deliveryItemEo -> {
                deliveryItemEo.setDeliveryNo(deliveryNo);
                deliveryItemEo.setParentDeliveryNo(parentDeliveryNo);
            });
            RefDeliveryOrderEo refDeliveryOrderTemp = RefDeliveryOrderEo.newInstance();
            BeanUtils.copyProperties((Object)refDeliveryOrderEo, (Object)refDeliveryOrderTemp, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            refDeliveryOrderTemp.setDeliveryNo(deliveryNo);
            ArrayList<RefDeliveryOrderEo> refDeliveryOrdersTemp = new ArrayList<RefDeliveryOrderEo>();
            refDeliveryOrdersTemp.add(refDeliveryOrderTemp);
            deliveryVo.setRefDeliveryOrders(refDeliveryOrdersTemp);
        });
        return splitResultDeliveryVos;
    }

    @Override
    @Deprecated
    public void autoSplit(DeliveryOrderVo deliveryOrderVo) {
        List cargos;
        List<DeliveryVo> deliveryVos;
        OrderSettingRespDto.DeliveryAutoSplitSettingDto deliveryAutoSplitSetting = this.getDeliveryAutoSplitSetting();
        if (null == deliveryAutoSplitSetting) {
            logger.info("\u7cfb\u7edf\u81ea\u52a8\u62c6\u5206\u8bbe\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u62c6\u5206\u64cd\u4f5c\u3002");
            return;
        }
        if (!OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoSplitSetting.getAutoSplitSwitch())) {
            logger.info("\u53d1\u8d27\u5355\u81ea\u52a8\u62c6\u5206\u5f00\u5173\u672a\u5f00\u542f\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u62c6\u5206\u64cd\u4f5c\u3002");
            return;
        }
        OrderDeliveryEo orderDeliveryEo = deliveryOrderVo.getOrderDelivery();
        ArrayList<DeliveryVo> splitResultDeliveryVos = new ArrayList<DeliveryVo>();
        List<DeliveryItemEo> deliveryItems = BeanUtil.copyList(deliveryOrderVo.getDeliveryItems(), DeliveryItemEo.class);
        List<String> cargoCodes = deliveryItems.stream().filter(o -> StringUtils.isNotBlank((String)o.getCargoSerial())).map(StdDeliveryItemEo::getCargoSerial).distinct().collect(Collectors.toList());
        ArrayList<DeliveryVo> aloneOrderDeliveryVos = new ArrayList<DeliveryVo>();
        ArrayList<DeliveryVo> weightDeliveryVos = new ArrayList<DeliveryVo>();
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoSplitSetting.getAloneOrderSwitch()) && CollectionUtils.isNotEmpty(deliveryVos = this.splitByAloneOrderSetting(deliveryAutoSplitSetting, deliveryItems))) {
            aloneOrderDeliveryVos.addAll(deliveryVos);
        }
        if (OnOffEnum.ON.getValue().equalsIgnoreCase(deliveryAutoSplitSetting.getSplitByWeightSwitch()) && CollectionUtils.isNotEmpty(cargoCodes) && CollectionUtils.isNotEmpty((Collection)(cargos = (List)this.cargoQueryApi.listByCodes(cargoCodes).getData()))) {
            List<DeliveryVo> deliveryVos2;
            Map<String, CargoRespDto> cargoMap = cargos.stream().collect(Collectors.toMap(CargoRespDto::getCode, o -> o));
            if (CollectionUtils.isNotEmpty(aloneOrderDeliveryVos)) {
                aloneOrderDeliveryVos = new ArrayList();
                for (DeliveryVo deliveryVo2 : aloneOrderDeliveryVos) {
                    List<DeliveryItemEo> items = deliveryVo2.getDeliveryItems();
                    List<DeliveryVo> deliveryVos3 = this.splitByWeightSetting(deliveryAutoSplitSetting, items, cargoCodes, cargoMap);
                    aloneOrderDeliveryVos.addAll(deliveryVos3);
                }
            }
            if (CollectionUtils.isNotEmpty(deliveryVos2 = this.splitByWeightSetting(deliveryAutoSplitSetting, deliveryItems, cargoCodes, cargoMap))) {
                weightDeliveryVos.addAll(deliveryVos2);
            }
        }
        if (CollectionUtils.isNotEmpty(aloneOrderDeliveryVos)) {
            splitResultDeliveryVos.addAll(aloneOrderDeliveryVos);
        }
        if (CollectionUtils.isNotEmpty(weightDeliveryVos)) {
            if (YesNoEnum.NO.getValue().equals(((DeliveryVo)weightDeliveryVos.get(0)).getIfWeight()) && weightDeliveryVos.size() > 1) {
                List<DeliveryItemEo> deliveryItems0 = ((DeliveryVo)weightDeliveryVos.get(0)).getDeliveryItems();
                List<DeliveryItemEo> deliveryItems1 = ((DeliveryVo)weightDeliveryVos.get(1)).getDeliveryItems();
                deliveryItems0.addAll(deliveryItems1);
                ((DeliveryVo)weightDeliveryVos.get(1)).setDeliveryItems(deliveryItems0);
                weightDeliveryVos.remove(0);
            }
            splitResultDeliveryVos.addAll(weightDeliveryVos);
        }
        RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)deliveryOrderVo.getRefDeliveryOrders().get(0);
        splitResultDeliveryVos.stream().forEach(deliveryVo -> {
            String deliveryNo = TradeUtil.generateTradeNo(refDeliveryOrderEo.getOrderNo());
            String parentDeliveryNo = orderDeliveryEo.getParentDeliveryNo();
            OrderDeliveryEo orderDeliveryTemp = OrderDeliveryEo.newInstance();
            BeanUtils.copyProperties((Object)orderDeliveryEo, (Object)orderDeliveryTemp, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            orderDeliveryTemp.setDeliveryNo(deliveryNo);
            orderDeliveryTemp.setParentDeliveryNo(parentDeliveryNo);
            deliveryVo.setOrderDelivery(orderDeliveryTemp);
            deliveryVo.getDeliveryItems().stream().forEach(deliveryItemEo -> {
                deliveryItemEo.setDeliveryNo(deliveryNo);
                deliveryItemEo.setParentDeliveryNo(parentDeliveryNo);
            });
            RefDeliveryOrderEo refDeliveryOrderTemp = RefDeliveryOrderEo.newInstance();
            BeanUtils.copyProperties((Object)refDeliveryOrderEo, (Object)refDeliveryOrderTemp, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            refDeliveryOrderTemp.setDeliveryNo(deliveryNo);
            ArrayList<RefDeliveryOrderEo> refDeliveryOrdersTemp = new ArrayList<RefDeliveryOrderEo>();
            refDeliveryOrdersTemp.add(refDeliveryOrderTemp);
            deliveryVo.setRefDeliveryOrders(refDeliveryOrdersTemp);
        });
        if (CollectionUtils.isEmpty(splitResultDeliveryVos) || splitResultDeliveryVos.size() <= 1) {
            logger.info("\u53d1\u8d27\u5355\uff1a{}\u65e0\u9700\u7cfb\u7edf\u62c6\u5355", (Object)orderDeliveryEo.getDeliveryNo());
            return;
        }
        OrderDeliveryEo orderDeliveryParent = OrderDeliveryEo.newInstance();
        orderDeliveryParent.setId(orderDeliveryEo.getId());
        orderDeliveryParent.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
        orderDeliveryParent.setCancelType(DeliveryCancelTypeEnum.AUTO_SPILT_CANCEL.getType());
        orderDeliveryParent.setCancelDesc(DeliveryCancelTypeEnum.AUTO_SPILT_CANCEL.getDesc());
        orderDeliveryParent.setCancelTime(new Date());
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryParent);
        this.saveSplitDeliverys(splitResultDeliveryVos);
        DeliverySplitVo deliverySplitVo = new DeliverySplitVo();
        DeliverySplitVo.DeliveryParent deliveryParent = new DeliverySplitVo.DeliveryParent();
        BeanUtils.copyProperties((Object)orderDeliveryParent, (Object)deliveryParent);
        deliverySplitVo.setDeliveryParent(deliveryParent);
        deliverySplitVo.setDeliveryChilds(splitResultDeliveryVos);
        this.deliveryProducer.sendInventoryDeliverySplit(deliverySplitVo);
    }

    public void saveSplitDeliverys(List<DeliveryVo> splitResultDeliveryVos) {
        splitResultDeliveryVos.stream().forEach(deliveryVo -> {
            OrderDeliveryEo orderDelivery = deliveryVo.getOrderDelivery();
            List<DeliveryItemEo> deliveryItems = deliveryVo.getDeliveryItems();
            List<RefDeliveryOrderEo> refDeliveryOrders = deliveryVo.getRefDeliveryOrders();
            this.orderDeliveryDas.insert((BaseEo)orderDelivery);
            this.deliveryItemDas.insertBatch(deliveryItems);
            this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
        });
    }

    private List<DeliveryVo> splitByAloneOrderSetting(OrderSettingRespDto.DeliveryAutoSplitSettingDto deliveryAutoSplitSetting, List<DeliveryItemEo> deliveryItems) {
        String aloneOrderSkuCodes = deliveryAutoSplitSetting.getAloneOrderSkuCodes();
        if (StringUtils.isBlank((String)aloneOrderSkuCodes)) {
            return null;
        }
        ArrayList<DeliveryVo> aloneOrderDeliveryVos = new ArrayList<DeliveryVo>();
        List<String> skuCodeList = Arrays.asList(aloneOrderSkuCodes.split(","));
        skuCodeList.forEach(skuCode -> {
            DeliveryVo deliveryVo = new DeliveryVo();
            ArrayList<DeliveryItemEo> childDeliveryItems = new ArrayList<DeliveryItemEo>();
            Iterator iterator = deliveryItems.iterator();
            while (iterator.hasNext()) {
                DeliveryItemEo deliveryItemEo;
                if (StringUtils.isBlank((String)skuCode) || !skuCode.equals((deliveryItemEo = (DeliveryItemEo)iterator.next()).getSkuCode())) continue;
                DeliveryItemEo deliveryItem = DeliveryItemEo.newInstance();
                BeanUtils.copyProperties((Object)deliveryItemEo, (Object)deliveryItem, (String[])new String[]{"id", "create_time", "update_time", "delivery_no"});
                childDeliveryItems.add(deliveryItem);
                logger.info("\u72ec\u7acb\u6210\u5355SKU:{}", skuCode);
                iterator.remove();
            }
            deliveryVo.setDeliveryItems(childDeliveryItems);
            if (CollectionUtils.isNotEmpty(childDeliveryItems)) {
                aloneOrderDeliveryVos.add(deliveryVo);
            }
        });
        return aloneOrderDeliveryVos;
    }

    private List<DeliveryVo> splitByItemProperty(OrderSettingRespDto.DeliveryAutoSplitSettingDto deliveryAutoSplitSetting, List<DeliveryItemEo> deliveryItems) {
        ArrayList<DeliveryVo> aloneOrderDeliveryVos = new ArrayList<DeliveryVo>();
        List splitByItemPropertys = deliveryAutoSplitSetting.getSplitByItemPropertys();
        if (CollectionUtils.isEmpty((Collection)splitByItemPropertys)) {
            logger.info("\u6839\u636e\u5546\u54c1\u5c5e\u6027\u8fdb\u884c\u62c6\u5206\u672a\u8bbe\u7f6e\uff0c\u8df3\u8fc7\u6b64\u62c6\u5206\u5904\u7406\u903b\u8f91\u3002");
            return null;
        }
        ArrayList propertyList = new ArrayList();
        splitByItemPropertys.forEach(property -> propertyList.addAll(property.getValues()));
        propertyList.forEach(property -> {
            DeliveryVo deliveryVo = new DeliveryVo();
            ArrayList<DeliveryItemEo> childDeliveryItems = new ArrayList<DeliveryItemEo>();
            Iterator iterator = deliveryItems.iterator();
            while (iterator.hasNext()) {
                DeliveryItemEo deliveryItemEo = (DeliveryItemEo)iterator.next();
                String skuDesc = deliveryItemEo.getSkuDesc();
                if (StringUtils.isBlank((String)skuDesc)) continue;
                HashSet<String> set = new HashSet<String>();
                if (skuDesc.contains(":")) {
                    List<String> proList = Arrays.asList(skuDesc.split(","));
                    proList.forEach(str -> {
                        String[] split = str.split(":");
                        if (null != split && split.length > 1) {
                            set.add(split[1]);
                        }
                    });
                } else {
                    set.addAll(Arrays.asList(skuDesc.split(",")));
                }
                if (!set.contains(property)) continue;
                DeliveryItemEo deliveryItem = DeliveryItemEo.newInstance();
                BeanUtils.copyProperties((Object)deliveryItemEo, (Object)deliveryItem, (String[])new String[]{"id", "create_time", "update_time", "delivery_no"});
                childDeliveryItems.add(deliveryItem);
                iterator.remove();
            }
            deliveryVo.setDeliveryItems(childDeliveryItems);
            if (CollectionUtils.isNotEmpty(childDeliveryItems)) {
                aloneOrderDeliveryVos.add(deliveryVo);
            }
        });
        return aloneOrderDeliveryVos;
    }

    private List<DeliveryVo> splitByWeightSetting(OrderSettingRespDto.DeliveryAutoSplitSettingDto deliveryAutoSplitSetting, List<DeliveryItemEo> deliveryItems, List<String> cargoCodes, Map<String, CargoRespDto> cargoMap) {
        if (CollectionUtils.isEmpty(cargoCodes)) {
            ArrayList<DeliveryVo> deliveryVos = new ArrayList<DeliveryVo>();
            DeliveryVo deliveryVo = new DeliveryVo();
            deliveryVo.setDeliveryItems(deliveryItems);
            return deliveryVos;
        }
        ArrayList<DeliveryVo> aloneOrderDeliveryVos = new ArrayList<DeliveryVo>();
        DeliveryVo noWeightDelivery = new DeliveryVo();
        ArrayList<DeliveryItemEo> noWeightDeliveryItems = new ArrayList<DeliveryItemEo>();
        Iterator<DeliveryItemEo> iterator = deliveryItems.iterator();
        while (iterator.hasNext()) {
            DeliveryItemEo itemEo = iterator.next();
            String cargoCode = itemEo.getCargoSerial();
            if (!StringUtils.isEmpty((String)cargoCode) && null != cargoMap.get(cargoCode) && null != cargoMap.get(cargoCode).getQuantity() && BigDecimal.ZERO.compareTo(cargoMap.get(cargoCode).getQuantity()) != 0) continue;
            DeliveryItemEo deliveryItem = DeliveryItemEo.newInstance();
            BeanUtils.copyProperties((Object)itemEo, (Object)deliveryItem, (String[])new String[]{"id", "create_time", "update_time", "delivery_no"});
            noWeightDeliveryItems.add(deliveryItem);
            iterator.remove();
        }
        if (CollectionUtils.isNotEmpty(noWeightDeliveryItems)) {
            noWeightDelivery.setDeliveryItems(noWeightDeliveryItems);
            aloneOrderDeliveryVos.add(noWeightDelivery);
        }
        if (CollectionUtils.isNotEmpty(deliveryItems)) {
            ArrayList<DeliveryItemEo> hasWeightPlatDeliveryItems = new ArrayList<DeliveryItemEo>();
            for (DeliveryItemEo itemEo : deliveryItems) {
                Integer itemNum = itemEo.getItemNum();
                for (int i = 1; i <= itemNum; ++i) {
                    DeliveryItemEo deliveryItemTemp = DeliveryItemEo.newInstance();
                    BeanUtils.copyProperties((Object)itemEo, (Object)deliveryItemTemp, (String[])new String[]{"id", "create_time", "update_time", "delivery_no"});
                    hasWeightPlatDeliveryItems.add(deliveryItemTemp);
                }
            }
            BigDecimal splitWeight = deliveryAutoSplitSetting.getSplitWeight();
            List<DeliveryVo> hasWeightDeliveryVos = this.splitByWeight(hasWeightPlatDeliveryItems, cargoMap, splitWeight);
            aloneOrderDeliveryVos.addAll(hasWeightDeliveryVos);
        }
        return aloneOrderDeliveryVos;
    }

    private List<DeliveryVo> splitByWeight(List<DeliveryItemEo> hasWeightDeliveryItems, Map<String, CargoRespDto> cargoMap, BigDecimal splitWeight) {
        ArrayList<DeliveryVo> deliveryVos = new ArrayList<DeliveryVo>();
        ArrayList<Object> deliveryItemEos = new ArrayList<DeliveryItemEo>();
        BigDecimal weightTotal = BigDecimal.ZERO;
        while (CollectionUtils.isNotEmpty(hasWeightDeliveryItems)) {
            Iterator<DeliveryItemEo> iterator = hasWeightDeliveryItems.iterator();
            while (iterator.hasNext()) {
                DeliveryItemEo deliveryItemEo = iterator.next();
                String cargoCode = deliveryItemEo.getCargoSerial();
                CargoRespDto cargoRespDto = cargoMap.get(cargoCode);
                BigDecimal quantity = cargoRespDto.getQuantity();
                if (weightTotal.compareTo(BigDecimal.ZERO) != 0 && weightTotal.add(quantity).compareTo(splitWeight) > 0) continue;
                deliveryItemEos.add(deliveryItemEo);
                weightTotal = weightTotal.add(quantity);
                iterator.remove();
            }
            DeliveryVo delivery = new DeliveryVo();
            delivery.setDeliveryItems(deliveryItemEos);
            deliveryVos.add(delivery);
            deliveryItemEos = new ArrayList();
            weightTotal = BigDecimal.ZERO;
        }
        return deliveryVos;
    }

    public static void mainx(String[] args) {
        HashMap<String, CargoRespDto> cargoMap = new HashMap<String, CargoRespDto>();
        CargoRespDto cargo001 = new CargoRespDto();
        cargo001.setCode("001");
        cargo001.setQuantity(new BigDecimal(1));
        cargoMap.put(cargo001.getCode(), cargo001);
        cargo001 = new CargoRespDto();
        cargo001.setCode("002");
        cargo001.setQuantity(new BigDecimal(2));
        cargoMap.put(cargo001.getCode(), cargo001);
        cargo001 = new CargoRespDto();
        cargo001.setCode("003");
        cargo001.setQuantity(new BigDecimal(3));
        cargoMap.put(cargo001.getCode(), cargo001);
        cargo001 = new CargoRespDto();
        cargo001.setCode("004");
        cargo001.setQuantity(new BigDecimal(4));
        cargoMap.put(cargo001.getCode(), cargo001);
        cargo001 = new CargoRespDto();
        cargo001.setCode("005");
        cargo001.setQuantity(new BigDecimal(5));
        cargoMap.put(cargo001.getCode(), cargo001);
        ArrayList<DeliveryItemEo> deliveryItemTiles = new ArrayList<DeliveryItemEo>();
        DeliveryItemEo deliveryItem1 = DeliveryItemEo.newInstance();
        deliveryItem1.setCargoSerial("001");
        deliveryItem1.setItemName("001");
        deliveryItemTiles.add(deliveryItem1);
        deliveryItem1 = DeliveryItemEo.newInstance();
        deliveryItem1.setCargoSerial("002");
        deliveryItem1.setItemName("002");
        deliveryItemTiles.add(deliveryItem1);
        deliveryItem1 = DeliveryItemEo.newInstance();
        deliveryItem1.setCargoSerial("003");
        deliveryItem1.setItemName("003");
        deliveryItemTiles.add(deliveryItem1);
        deliveryItem1 = DeliveryItemEo.newInstance();
        deliveryItem1.setCargoSerial("004");
        deliveryItem1.setItemName("004");
        deliveryItemTiles.add(deliveryItem1);
        deliveryItem1 = DeliveryItemEo.newInstance();
        deliveryItem1.setCargoSerial("005");
        deliveryItem1.setItemName("005");
        deliveryItemTiles.add(deliveryItem1);
        ArrayList<DeliveryVo> deliveryVos = new ArrayList<DeliveryVo>();
        ArrayList<Object> deliveryItemEos = new ArrayList<DeliveryItemEo>();
        BigDecimal weightTotal = BigDecimal.ZERO;
        BigDecimal splitWeight = new BigDecimal(6);
        while (CollectionUtils.isNotEmpty(deliveryItemTiles)) {
            Iterator iterator = deliveryItemTiles.iterator();
            while (iterator.hasNext()) {
                DeliveryItemEo deliveryItemEo = (DeliveryItemEo)iterator.next();
                String cargoCode = deliveryItemEo.getCargoSerial();
                CargoRespDto cargoRespDto = (CargoRespDto)cargoMap.get(cargoCode);
                BigDecimal quantity = cargoRespDto.getQuantity();
                if (weightTotal.compareTo(BigDecimal.ZERO) != 0 && weightTotal.add(quantity).compareTo(splitWeight) > 0) continue;
                deliveryItemEos.add(deliveryItemEo);
                weightTotal = weightTotal.add(quantity);
                iterator.remove();
            }
            DeliveryVo delivery = new DeliveryVo();
            delivery.setDeliveryItems(deliveryItemEos);
            deliveryVos.add(delivery);
            deliveryItemEos = new ArrayList();
            weightTotal = BigDecimal.ZERO;
        }
        System.out.println(JSON.toJSON(deliveryVos));
    }

    private OrderSettingRespDto.DeliveryAutoSplitSettingDto getDeliveryAutoSplitSetting() {
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, OrderSettingEnum.DELIVERY_AUTO_SPLIT_SETTING.getGroupCode(), OrderSettingEnum.DELIVERY_AUTO_SPLIT_SETTING.getCode()).getData();
        if (null == dictDto) {
            return null;
        }
        String autoSplitSettingJson = dictDto.getValue();
        if (StringUtils.isBlank((String)autoSplitSettingJson)) {
            return null;
        }
        OrderSettingRespDto.DeliveryAutoSplitSettingDto deliveryAutoSplitSettingDto = (OrderSettingRespDto.DeliveryAutoSplitSettingDto)JSON.parseObject((String)autoSplitSettingJson, OrderSettingRespDto.DeliveryAutoSplitSettingDto.class);
        return deliveryAutoSplitSettingDto;
    }
}

