/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IExtlDataService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IMarketService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderCouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import java.util.Collection;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketServiceImpl
implements IMarketService {
    @Resource
    IOrderCouponService orderCouponService;
    @Autowired
    private IExtlDataService extlDataService;

    @Override
    public EngineParams marketCheck(OrderReqDto orderReqDto) {
        this.extlDataService.saveExtlData(orderReqDto.getTradeNo(), "ORDER_COUPON", orderReqDto.getCouponString());
        EngineParams engineParams = this.orderCouponService.lockCoupon(orderReqDto);
        orderReqDto = this.orderCouponService.resolveCouponData(orderReqDto, engineParams);
        this.orderCouponService.updateOrderCouponData(orderReqDto);
        List giftVos = engineParams.getGifts();
        Map giftNumMap = null;
        if (CollectionUtils.isNotEmpty((Collection)giftVos)) {
            // empty if block
        }
        List givingTradeItems = orderReqDto.getOrderItems().stream().filter(tradeItemReqDto -> "7".equals(tradeItemReqDto.getItemType())).collect(Collectors.toList());
        Map<String, LongSummaryStatistics> givingNumMap = null;
        if (CollectionUtils.isNotEmpty(givingTradeItems)) {
            givingNumMap = givingTradeItems.stream().collect(Collectors.groupingBy(tradeItemReqDto -> String.valueOf(tradeItemReqDto.getItemSerial()) + String.valueOf(tradeItemReqDto.getSkuSerial()), Collectors.summarizingLong(TradeItemReqDto::getItemNum)));
        }
        if (giftNumMap != null && givingNumMap != null) {
            if (giftNumMap.size() != givingNumMap.size()) {
                throw new BizException(TradeExceptionCode.GIVING_ERROR.getCode(), TradeExceptionCode.GIVING_ERROR.getMsg());
            }
            for (String key : giftNumMap.keySet()) {
                LongSummaryStatistics giftSum = (LongSummaryStatistics)giftNumMap.get(key);
                LongSummaryStatistics givingSum = givingNumMap.get(key);
                if (givingSum != null && giftSum.getSum() == givingSum.getSum()) continue;
                throw new BizException(TradeExceptionCode.GIVING_ERROR.getCode(), TradeExceptionCode.GIVING_ERROR.getMsg());
            }
            for (String key : givingNumMap.keySet()) {
                LongSummaryStatistics givingSum = givingNumMap.get(key);
                LongSummaryStatistics giftSum = (LongSummaryStatistics)giftNumMap.get(key);
                if (giftSum != null && giftSum.getSum() == givingSum.getSum()) continue;
                throw new BizException(TradeExceptionCode.GIVING_ERROR.getCode(), TradeExceptionCode.GIVING_ERROR.getMsg());
            }
        } else if (giftNumMap != null || givingNumMap != null) {
            throw new BizException(TradeExceptionCode.GIVING_ERROR.getCode(), TradeExceptionCode.GIVING_ERROR.getMsg());
        }
        return engineParams;
    }
}

