/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.basis.query.IMemberQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.EventReqDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.response.MemberRespDto;
import com.dtyunxi.yundt.cube.center.member.api.point.IEventApi;
import com.dtyunxi.yundt.cube.center.member.api.point.IPointsTradeApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DecreaseIntegralFailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IMemberService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MemberServiceImpl
implements IMemberService {
    private static final Logger logger = LoggerFactory.getLogger(MemberServiceImpl.class);
    @Resource
    IMemberQueryApi memberQueryApi;
    @Resource
    IPointsTradeApi pointsTradeApi;
    @Resource
    IEventApi eventApi;
    @Resource
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;

    @Override
    public MemberRespDto queryMemberAndItemsByUserId(Long instanceId, Long id) {
        String[] items = new String[]{"account"};
        RestResponse restResponse = this.memberQueryApi.queryMemberAndItemsByUserId(instanceId, id, items);
        if (restResponse.getResultCode().equals("0")) {
            MemberRespDto memberRespDto = (MemberRespDto)restResponse.getData();
            if (memberRespDto == null) {
                throw new BizException(TradeExceptionCode.MEMBER_NOT_EXIST.getCode(), TradeExceptionCode.MEMBER_NOT_EXIST.getMsg());
            }
            return memberRespDto;
        }
        throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
    }

    @Override
    public void decreaseIntegral(Long instanceId, String userId, Integer integral, String tradeNo) {
        MemberRespDto memberRespDto = this.queryMemberAndItemsByUserId(instanceId, this.isValueInputUserId(userId));
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        pointsTradeInfoReqDto.setPoints(integral.intValue());
        pointsTradeInfoReqDto.setOrderNo(tradeNo);
        pointsTradeInfoReqDto.setInstanceId(instanceId);
        pointsTradeInfoReqDto.setMemberId(memberRespDto.getId());
        pointsTradeInfoReqDto.setTradeSource("order");
        pointsTradeInfoReqDto.setRemark("\u8ba2\u5355:" + tradeNo + ",\u4e0b\u5355\u6263\u51cf");
        RestResponse restResponse = this.pointsTradeApi.decrease(pointsTradeInfoReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
    }

    @Override
    public void decreaseMemberIntegral(Long tenantId, Long instanceId, String memberId, Integer integral, String tradeNo) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        pointsTradeInfoReqDto.setPoints(integral.intValue());
        pointsTradeInfoReqDto.setOrderNo(tradeNo);
        pointsTradeInfoReqDto.setInstanceId(instanceId);
        pointsTradeInfoReqDto.setTenantId(tenantId);
        pointsTradeInfoReqDto.setMemberId(this.isValueInputMemberId(memberId));
        pointsTradeInfoReqDto.setTradeSource("order");
        pointsTradeInfoReqDto.setRemark("\u8ba2\u5355:" + tradeNo + ",\u4e0b\u5355\u6263\u51cf");
        RestResponse restResponse = this.pointsTradeApi.decrease(pointsTradeInfoReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
    }

    @Override
    public void refundOrder(Long tenantId, Long instanceId, Long memberId, Integer integral, String tradeNo) {
        EventReqDto eventReqDto = new EventReqDto();
        eventReqDto.setMemberId(memberId);
        eventReqDto.setType("1");
        eventReqDto.setInstanceId(instanceId);
        eventReqDto.setTenantId(tenantId);
        eventReqDto.setEventName("return_order");
        eventReqDto.setEventCode("return_order");
        eventReqDto.setEventData("{\"\u9000\u8d27\u9000\u79ef\u5206\":true,\"points\":" + integral + "}");
        eventReqDto.setRemark("\u8ba2\u5355\u53f7" + tradeNo + "\u9000\u8d27");
        RestResponse restResponse = this.eventApi.trigger(eventReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
    }

    private Long isValueInputUserId(String userId) {
        try {
            Long id = Long.parseLong(userId);
            return id;
        }
        catch (NumberFormatException e) {
            throw new BizException("\u8f93\u5165\u7684\u7528\u6237id\u683c\u5f0f\u4e0d\u6b63\u786e,\u5fc5\u987b\u662fLong\u578b");
        }
    }

    private Long isValueInputMemberId(String memberId) {
        try {
            Long id = Long.parseLong(memberId);
            return id;
        }
        catch (NumberFormatException e) {
            throw new BizException("\u8f93\u5165\u7684\u4f1a\u5458id\u683c\u5f0f\u4e0d\u6b63\u786e,\u5fc5\u987b\u662fLong\u578b");
        }
    }

    @Override
    public void cancelOrder(Long tenantId, Long instanceId, Long memberId, Integer integral, String tradeNo) {
        EventReqDto eventReqDto = new EventReqDto();
        eventReqDto.setMemberId(memberId);
        eventReqDto.setType("1");
        eventReqDto.setInstanceId(instanceId);
        eventReqDto.setTenantId(tenantId);
        eventReqDto.setEventName("cancel_order");
        eventReqDto.setEventCode("cancel_order");
        eventReqDto.setEventData("{\"\u53d6\u6d88\u8ba2\u5355\":true,\"points\":" + integral + "}");
        eventReqDto.setRemark("\u8ba2\u5355\u53f7" + tradeNo + "\u53d6\u6d88\u8ba2\u5355");
        RestResponse restResponse = this.eventApi.trigger(eventReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
    }

    @Override
    public DecreaseIntegralFailRespDto freezeMemberIntegral(Long tenantId, Long instanceId, String memberId, Integer integral, String tradeNo) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        pointsTradeInfoReqDto.setPoints(integral.intValue());
        pointsTradeInfoReqDto.setOrderNo(tradeNo);
        pointsTradeInfoReqDto.setInstanceId(instanceId);
        pointsTradeInfoReqDto.setTenantId(tenantId);
        pointsTradeInfoReqDto.setMemberId(this.isValueInputMemberId(memberId));
        pointsTradeInfoReqDto.setTradeSource("order");
        pointsTradeInfoReqDto.setRemark("\u8ba2\u5355:" + tradeNo + ",\u4e0b\u5355\u9884\u5360");
        RestResponse restResponse = this.pointsTradeApi.freeze(pointsTradeInfoReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            return new DecreaseIntegralFailRespDto(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return null;
    }

    @Override
    public DecreaseIntegralFailRespDto unFreezeMemberIntegral(Long tenantId, Long instanceId, String memberId, Integer integral, String tradeNo) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        pointsTradeInfoReqDto.setPoints(integral.intValue());
        pointsTradeInfoReqDto.setOrderNo(tradeNo);
        pointsTradeInfoReqDto.setInstanceId(instanceId);
        pointsTradeInfoReqDto.setTenantId(tenantId);
        pointsTradeInfoReqDto.setMemberId(this.isValueInputMemberId(memberId));
        pointsTradeInfoReqDto.setTradeSource("order");
        pointsTradeInfoReqDto.setRemark("\u8ba2\u5355:" + tradeNo + ",\u53d6\u6d88\u8ba2\u5355\u89e3\u51bb");
        RestResponse restResponse = this.pointsTradeApi.unfreeze(pointsTradeInfoReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            return new DecreaseIntegralFailRespDto(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return null;
    }

    @Override
    public DecreaseIntegralFailRespDto verificationMemberIntegral(Long tenantId, Long instanceId, String memberId, Integer integral, String tradeNo) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        pointsTradeInfoReqDto.setPoints(integral.intValue());
        pointsTradeInfoReqDto.setOrderNo(tradeNo);
        pointsTradeInfoReqDto.setInstanceId(instanceId);
        pointsTradeInfoReqDto.setTenantId(tenantId);
        pointsTradeInfoReqDto.setMemberId(this.isValueInputMemberId(memberId));
        pointsTradeInfoReqDto.setTradeSource("order");
        pointsTradeInfoReqDto.setRemark("\u8ba2\u5355:" + tradeNo + ",\u4e0b\u5355\u6838\u9500");
        RestResponse restResponse = this.pointsTradeApi.verification(pointsTradeInfoReqDto);
        if (!restResponse.getResultCode().equals("0")) {
            return new DecreaseIntegralFailRespDto(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return null;
    }

    @Override
    public Long getMemberId(Long userId) {
        try {
            MemberInfoDetailRespDto memberInfoDetail = (MemberInfoDetailRespDto)this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(userId).getData();
            if (null != memberInfoDetail) {
                return memberInfoDetail.getId();
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7528\u6237id\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

