/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SwitchEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSettingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAuditRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.UnitConvertUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.OrderAuditService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAuditDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAuditEo;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.AddressReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.TradeReqDto;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderAuditServiceImpl
implements OrderAuditService {
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private OrderAddressDas orderAddressDas;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private ICargoQueryApi cargoQueryApi;
    @Autowired
    private IUnitQueryApi unitQueryApi;
    @Autowired
    private OrderAuditDas orderAuditDas;

    @Override
    public String isNeedAudit(TradeReqDto tradeReqDto) {
        OrderSettingReqDto.OrderAuditInterceptSettingDto orderAuditInterceptSettingDto = this.getOrderAuditInterceptSettingDto();
        if (orderAuditInterceptSettingDto == null) {
            return "TRUE";
        }
        String autoAuditSwitch = orderAuditInterceptSettingDto.getAutoAuditSwitch();
        if (SwitchEnum.ON.getValue().equals(autoAuditSwitch)) {
            boolean flag = this.matchSetting(orderAuditInterceptSettingDto, tradeReqDto);
            if (flag) {
                return "TRUE";
            }
            return "FALSE";
        }
        if (SwitchEnum.OFF.getValue().equals(autoAuditSwitch)) {
            return "TRUE";
        }
        return "TRUE";
    }

    @Override
    public OrderAuditRespDto queryNewestByOrderNoAndAuditType(String orderNo, Integer auditType) {
        OrderAuditRespDto orderAuditRespDto = null;
        OrderAuditEo orderAuditEo = this.orderAuditDas.queryNewestByOrderNoAndAuditType(orderNo, auditType);
        if (orderAuditEo != null) {
            orderAuditRespDto = new OrderAuditRespDto();
            CubeBeanUtils.copyProperties((Object)orderAuditRespDto, (Object)orderAuditEo, (String[])new String[0]);
        }
        return orderAuditRespDto;
    }

    private OrderSettingReqDto.OrderAuditInterceptSettingDto getOrderAuditInterceptSettingDto() {
        String ORDER_SETTING = "ORDER_SETTING";
        String ORDER_AUDIT_INTERCEPT_SETTING = "ORDER_AUDIT_INTERCEPT_SETTING";
        OrderSettingReqDto.OrderAuditInterceptSettingDto orderAuditInterceptSettingDto = this.getSettingDto(ORDER_SETTING, ORDER_AUDIT_INTERCEPT_SETTING, OrderSettingReqDto.OrderAuditInterceptSettingDto.class);
        return orderAuditInterceptSettingDto;
    }

    private <T> T getSettingDto(String groupCode, String code, Class<T> clazz) {
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, groupCode, code).getData();
        if (dictDto == null) {
            return null;
        }
        return (T)JSONObject.parseObject((String)dictDto.getValue(), clazz);
    }

    private boolean matchSetting(OrderSettingReqDto.OrderAuditInterceptSettingDto orderAuditInterceptSettingDto, TradeReqDto tradeReqDto) {
        BigDecimal orderItemTotalVolumeGreatThanOrEqualTo;
        BigDecimal orderItemTotalWeightGreatThanOrEqualTo;
        List order = tradeReqDto.getOrder();
        OrderReqDto orderReqDto = (OrderReqDto)order.get(0);
        String sellerRemark = orderReqDto.getSellerRemark();
        String buyerRemark = orderReqDto.getBuyerRemark();
        BigDecimal payAmount = orderReqDto.getPayAmount();
        Integer cashOnDelivery = orderReqDto.getCashOnDelivery();
        AddressReqDto addressReqDto = tradeReqDto.getAddressReqDto();
        String salerRemarkSwitch = orderAuditInterceptSettingDto.getSalerRemarkNotBlankSwitch();
        String salerRemarkContainsKeywordsSwitch = orderAuditInterceptSettingDto.getSalerRemarkContainsKeywordsSwitch();
        String salerRemarkContainsKeywords = orderAuditInterceptSettingDto.getSalerRemarkContainsKeywords();
        boolean ifSalerRemarkSwitchOn = SwitchEnum.ON.getValue().equals(salerRemarkSwitch);
        boolean ifSalerRemarkKeywordsSwitchOn = SwitchEnum.ON.getValue().equals(salerRemarkContainsKeywordsSwitch);
        if (ifSalerRemarkKeywordsSwitchOn) {
            String[] keywords = salerRemarkContainsKeywords.split("[;]");
            if (StringUtils.isNotBlank((CharSequence)sellerRemark)) {
                for (String keyword : keywords) {
                    if (!sellerRemark.contains(keyword)) continue;
                    return true;
                }
            }
        } else if (ifSalerRemarkSwitchOn && StringUtils.isNotBlank((CharSequence)sellerRemark)) {
            return true;
        }
        String buyerRemarkSwitch = orderAuditInterceptSettingDto.getBuyerRemarkNotBlankSwitch();
        String buyerRemarkContainsKeywordsSwitch = orderAuditInterceptSettingDto.getBuyerRemarkContainsKeywordsSwitch();
        String buyerRemarkContainsKeywords = orderAuditInterceptSettingDto.getBuyerRemarkContainsKeywords();
        boolean ifBuyerRemarkSwitchOn = SwitchEnum.ON.getValue().equals(buyerRemarkSwitch);
        boolean ifBuyerRemarkKeywordsSwitchOn = SwitchEnum.ON.getValue().equals(buyerRemarkContainsKeywordsSwitch);
        if (ifBuyerRemarkKeywordsSwitchOn) {
            String[] keywords = buyerRemarkContainsKeywords.split("[;]");
            if (StringUtils.isNotBlank((CharSequence)buyerRemark)) {
                for (String keyword : keywords) {
                    if (!buyerRemark.contains(keyword)) continue;
                    return true;
                }
            }
        } else if (ifBuyerRemarkSwitchOn && StringUtils.isNotBlank((CharSequence)buyerRemark)) {
            return true;
        }
        String orderPayAmountSwitch = orderAuditInterceptSettingDto.getOrderPayAmountSwitch();
        BigDecimal orderPayAmountGreatThanOrEqualTo = orderAuditInterceptSettingDto.getOrderPayAmountGreatThanOrEqualTo();
        BigDecimal orderPayAmountLessThanOrEqualTo = orderAuditInterceptSettingDto.getOrderPayAmountLessThanOrEqualTo();
        if (SwitchEnum.ON.getValue().equals(orderPayAmountSwitch)) {
            if (orderPayAmountGreatThanOrEqualTo != null && payAmount.compareTo(orderPayAmountGreatThanOrEqualTo) >= 0) {
                return true;
            }
            if (orderPayAmountLessThanOrEqualTo != null && payAmount.compareTo(orderPayAmountLessThanOrEqualTo) <= 0) {
                return true;
            }
        }
        String orderPayAmountIsZeroSwitch = orderAuditInterceptSettingDto.getOrderPayAmountIsZeroSwitch();
        if (SwitchEnum.ON.getValue().equals(orderPayAmountIsZeroSwitch) && payAmount.compareTo(new BigDecimal(0)) == 0) {
            return true;
        }
        String orderTypeOfCashOnDeliverySwitch = orderAuditInterceptSettingDto.getOrderTypeOfCashOnDeliverySwitch();
        if (SwitchEnum.ON.getValue().equals(orderTypeOfCashOnDeliverySwitch) && cashOnDelivery != null && YesNoEnum.YES.getValue().intValue() == cashOnDelivery.intValue()) {
            return true;
        }
        String addressWordsLessThanOrEqualToSwitch = orderAuditInterceptSettingDto.getAddressWordsLessThanOrEqualToSwitch();
        if (SwitchEnum.ON.getValue().equals(addressWordsLessThanOrEqualToSwitch)) {
            String address = addressReqDto.getAddress();
            Integer addressWordsLessThanOrEqualTo = orderAuditInterceptSettingDto.getAddressWordsLessThanOrEqualTo();
            if (address != null && addressWordsLessThanOrEqualTo != null && address.length() <= addressWordsLessThanOrEqualTo) {
                return true;
            }
        }
        List tradeItemReqDtos = orderReqDto.getTradeItemReqDto();
        BigDecimal quantityTotal = new BigDecimal(0);
        BigDecimal volumeTotal = new BigDecimal(0);
        for (TradeItemReqDto tradeItemReqDto : tradeItemReqDtos) {
            UnitRespDto successResult;
            String skuCode = tradeItemReqDto.getSkuCode();
            RestResponse listRestResponse = this.itemSkuQueryApi.queryBySkuCode(Arrays.asList(skuCode));
            List itemSkuRespDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            if (!CollectionUtils.isNotEmpty((Collection)itemSkuRespDtoList)) continue;
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemSkuRespDtoList.get(0);
            String cargoCode = itemSkuRespDto.getCargoCode();
            RestResponse cargoRespDtoRestResponse = this.cargoQueryApi.queryByCode(cargoCode, null);
            CargoRespDto cargoRespDto = (CargoRespDto)RestResponseHelper.extractData((RestResponse)cargoRespDtoRestResponse);
            BigDecimal grossWeight = cargoRespDto.getGrossWeight();
            String grossWeightUnit = cargoRespDto.getGrossWeightUnit();
            if (StringUtils.isNotBlank((CharSequence)grossWeightUnit) && grossWeight != null && (successResult = (UnitRespDto)ResponseUtil.getSuccessResult(this.unitQueryApi.queryById(Long.valueOf(grossWeightUnit)))) != null) {
                BigDecimal quantity = UnitConvertUtil.convert2StandardQuantity((BigDecimal)grossWeight, (String)successResult.getCode().toLowerCase());
                quantityTotal = quantityTotal.add(quantity);
            }
            Integer length = cargoRespDto.getLength();
            Integer width = cargoRespDto.getWidth();
            Integer height = cargoRespDto.getHeight();
            String lengthUnit = cargoRespDto.getLengthUnit();
            String widthUnit = cargoRespDto.getWidthUnit();
            String heightUnit = cargoRespDto.getHeightUnit();
            if (length == null || width == null || height == null || !StringUtils.isNotBlank((CharSequence)lengthUnit) || !StringUtils.isNotBlank((CharSequence)widthUnit) || !StringUtils.isNotBlank((CharSequence)heightUnit)) continue;
            UnitRespDto lengthResp = (UnitRespDto)ResponseUtil.getSuccessResult(this.unitQueryApi.queryById(Long.valueOf(lengthUnit)));
            UnitRespDto widthResp = (UnitRespDto)ResponseUtil.getSuccessResult(this.unitQueryApi.queryById(Long.valueOf(widthUnit)));
            UnitRespDto heightResp = (UnitRespDto)ResponseUtil.getSuccessResult(this.unitQueryApi.queryById(Long.valueOf(heightUnit)));
            if (lengthResp == null || widthResp == null || heightResp == null) continue;
            BigDecimal lengthDecimal = UnitConvertUtil.convert2StandardVolumn((BigDecimal)new BigDecimal(length), (String)lengthResp.getCode().toLowerCase());
            BigDecimal widthDecimal = UnitConvertUtil.convert2StandardVolumn((BigDecimal)new BigDecimal(width), (String)widthResp.getCode().toLowerCase());
            BigDecimal heightDecimal = UnitConvertUtil.convert2StandardVolumn((BigDecimal)new BigDecimal(height), (String)heightResp.getCode().toLowerCase());
            BigDecimal volume = lengthDecimal.multiply(widthDecimal).multiply(heightDecimal);
            volumeTotal = volumeTotal.add(volume);
        }
        String orderItemTotalWeightSwitch = orderAuditInterceptSettingDto.getOrderItemTotalWeightSwitch();
        if (SwitchEnum.ON.getValue().equals(orderItemTotalWeightSwitch) && (orderItemTotalWeightGreatThanOrEqualTo = orderAuditInterceptSettingDto.getOrderItemTotalWeightGreatThanOrEqualTo()) != null && quantityTotal.compareTo(orderItemTotalWeightGreatThanOrEqualTo) >= 0) {
            return true;
        }
        String orderItemTotalVolumeSwitch = orderAuditInterceptSettingDto.getOrderItemTotalVolumeSwitch();
        return SwitchEnum.ON.getValue().equals(orderItemTotalVolumeSwitch) && (orderItemTotalVolumeGreatThanOrEqualTo = orderAuditInterceptSettingDto.getOrderItemTotalVolumeGreatThanOrEqualTo()) != null && volumeTotal.compareTo(orderItemTotalVolumeGreatThanOrEqualTo) >= 0;
    }
}

