/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.RandomUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryPackageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryPlanCycleDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PackageItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PackageRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.DeliveryRecordAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ICargoDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeConfQueryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanCopierUtils;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PackageItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PackageItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdPackageItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryOrderVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderDeliveryServiceImpl
implements IOrderDeliveryService {
    private static Logger logger = LoggerFactory.getLogger(OrderDeliveryServiceImpl.class);
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private PackageItemDas packageItemDas;
    @Resource
    private ICargoDeliveryService cargoDeliveryService;
    @Resource
    private ITradeService tradeService;
    @Resource
    private IFlowEngine flowEngine;
    @Autowired
    private OrderDas orderDas;
    @Autowired
    private TradeItemDas tradeItemDas;
    @Autowired
    private OrderAddressDas orderAddressDas;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IPayService payService;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private DeliveryProducer deliveryProducer;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Resource
    private IAfterSalesService afterSalesService;
    @Resource
    private ITradeConfQueryService tradeConfQueryService;
    @Resource
    private DeliveryRecordAction deliveryRecordAction;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateDelivery(String orderNo, List<OrderDeliveryPlanCycleDto> deliveryPlanCycleDtoList, String curNode) {
        ArrayList orderDeliveryEoList;
        if (orderNo == null) {
            throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), "\u7f3a\u5c11orderNo");
        }
        logger.info("\u5f00\u59cb\u6839\u636e\u5546\u57ce\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\u4fe1\u606f\uff0corderNo\uff1a{}", (Object)orderNo);
        OrderEo orderSelect = OrderEo.newInstance();
        orderSelect.setOrderNo(orderNo);
        OrderEo orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderSelect);
        this.marketOrderTradeStatusProducer.sendOrderDeliverySuccessMessageToMarket(orderNo);
        TradeItemEo tradeItemSelect = TradeItemEo.newInstance();
        tradeItemSelect.setTradeNo(orderNo);
        List tradeItems = this.tradeItemDas.select((BaseEo)tradeItemSelect, Integer.valueOf(0), Integer.valueOf(1024));
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        this.handleOrderDelivery(orderDeliveryEo, orderEo, tradeItems);
        String deliveryStatus = orderDeliveryEo.getDeliveryStatus();
        orderDeliveryEo.setFlowDefId(orderEo.getFlowDefId());
        if (StringUtils.isNotBlank((CharSequence)curNode)) {
            TradeEngine.setFlowStatus(orderDeliveryEo, "succ", curNode);
        }
        orderDeliveryEo.setDeliveryStatus(deliveryStatus);
        ArrayList arrayList = orderDeliveryEoList = orderDeliveryEo.getCycleBuy() != false ? this.buildCycleOrderDelivery(orderNo, orderDeliveryEo, deliveryPlanCycleDtoList) : Lists.newArrayList((Object[])new OrderDeliveryEo[]{orderDeliveryEo});
        if (CollectionUtils.isEmpty((Collection)orderDeliveryEoList)) {
            logger.error("\u7ec4\u88c5OrderDeliveryEo\u5931\u8d25\uff0corderNo\uff1a{}", (Object)orderNo);
            throw new BizException("\u7ec4\u88c5OrderDeliveryEo\u5931\u8d25");
        }
        this.orderDeliveryDas.insertBatch((List)orderDeliveryEoList);
        logger.info("\u4fdd\u5b58\u53d1\u8d27\u5355\u4fe1\u606ftr_order_delivery\u6210\u529f\uff01");
        List<RefDeliveryOrderEo> refDeliveryOrders = this.handleRefDeliveryOrder(orderDeliveryEoList, orderEo);
        if (CollectionUtils.isEmpty(refDeliveryOrders)) {
            logger.error("\u7ec4\u88c5\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u8868\u5931\u8d25\uff0corderNo\uff1a{}", (Object)orderNo);
            throw new BizException("\u7ec4\u88c5\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u8868\u5931\u8d25");
        }
        this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
        logger.info("\u6279\u91cf\u4fdd\u5b58\u53d1\u8d27\u5355\u8ba2\u5355\u5173\u8054\u8868tr_ref_delivery_order\u6210\u529f\uff01");
        List<DeliveryItemEo> deliveryItemEos = this.handleDeliveryItems(tradeItems, orderDeliveryEoList);
        if (CollectionUtils.isEmpty(deliveryItemEos)) {
            logger.error("\u7ec4\u88c5\u53d1\u8d27\u5355\u5546\u54c1\u5931\u8d25\uff0corderNo\uff1a{}", (Object)orderNo);
            throw new BizException("\u7ec4\u88c5\u53d1\u8d27\u5355\u5546\u54c1\u5931\u8d25");
        }
        this.deliveryItemDas.insertBatch(deliveryItemEos);
        logger.info("\u6279\u91cf\u4fdd\u5b58\u5e94\u53d1\u8d27\u660e\u7ec6tr_delivery_item\u6210\u529f\uff01");
        Map<String, List<RefDeliveryOrderEo>> refDeliveryOrderMap = refDeliveryOrders.stream().collect(Collectors.groupingBy(StdRefDeliveryOrderEo::getDeliveryNo));
        Map<String, List<DeliveryItemEo>> deliveryItemMap = deliveryItemEos.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getDeliveryNo));
        orderDeliveryEoList.forEach(orderDeliveryEo1 -> {
            String deliveryNo = orderDeliveryEo1.getDeliveryNo();
            DeliveryOrderVo deliveryOrderVo = new DeliveryOrderVo();
            deliveryOrderVo.setOrderDelivery(orderDeliveryEo1);
            deliveryOrderVo.setRefDeliveryOrders((List)refDeliveryOrderMap.get(deliveryNo));
            deliveryOrderVo.setDeliveryItems((List)deliveryItemMap.get(deliveryNo));
            this.deliveryProducer.sendInventoryDelivery(deliveryOrderVo);
        });
        logger.info("\u540c\u6b65\u5546\u57ce\u8ba2\u5355\u5230\u5e93\u5b58\u4e2d\u5fc3...");
    }

    @Override
    public List<OrderDeliveryEo> buildCycleOrderDelivery(String orderNo, OrderDeliveryEo orderDeliveryEo, List<OrderDeliveryPlanCycleDto> deliveryPlanCycleDtoList) {
        List<Object> orderDeliveryEoList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deliveryPlanCycleDtoList)) {
            orderDeliveryEoList = deliveryPlanCycleDtoList.stream().map(dto -> {
                OrderDeliveryEo eo = new OrderDeliveryEo();
                CubeBeanUtils.copyProperties((Object)eo, (Object)orderDeliveryEo, (String[])new String[0]);
                String deliveryNo = TradeUtil.generateTradeNo(orderNo);
                eo.setDeliveryNo(deliveryNo);
                eo.setDeliveryPlanId(dto.getDeliveryPlanId());
                eo.setDeliveryTime(dto.getDeliveryDate());
                eo.setArrivalDate(dto.getDeliveryDate());
                eo.setItemAmount(new BigDecimal(dto.getCycleItemCount()));
                eo.setDeliveryStatus(DeliveryStatusEnum.TO_RECEIVING.getStatus());
                return eo;
            }).collect(Collectors.toList());
        }
        return orderDeliveryEoList;
    }

    private void handleOrderDelivery(OrderDeliveryEo orderDeliveryEo, OrderEo orderEo, List<TradeItemEo> tradeItemEos) {
        Integer warehouseType;
        OrderAddressEo addressSelect = new OrderAddressEo();
        addressSelect.setOrderNo(orderEo.getOrderNo());
        OrderAddressEo orderAddress = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)addressSelect);
        String deliveryNo = TradeUtil.generateTradeNo(orderEo.getOrderNo());
        orderDeliveryEo.setBizType(DeliveryBizTypeEnum.MALL.getType());
        orderDeliveryEo.setDeliveryNo(deliveryNo);
        HashSet<String> orderNoSet = new HashSet<String>();
        orderNoSet.add(orderEo.getOrderNo());
        List<PayRecordRespDto> paySuccessRecords = this.payService.getPaySuccessRecord(orderNoSet);
        if (!CollectionUtils.isEmpty(paySuccessRecords)) {
            orderDeliveryEo.setThirdPayNo(paySuccessRecords.get(0).getExtlPaySerial());
        }
        logger.info("\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff1a{}", (Object)orderEo.getDeliveryAddress());
        OrderAddressReqDto orderAddressReqDto = (OrderAddressReqDto)JSON.parseObject((String)orderEo.getDeliveryAddress(), OrderAddressReqDto.class);
        if (ShippingTypeEnum.PICKUP.getType().equals(orderAddressReqDto.getShippingType())) {
            this.setOrderDeliveryPickUpCode(orderDeliveryEo);
            Integer n = 2;
        }
        if (ShippingTypeEnum.INTRA_CITY.getType().equals(orderAddressReqDto.getShippingType())) {
            logger.info("\u540c\u57ce\u914d\u9001o2o\u8ba2\u5355\uff0c\u72b6\u6001\u8bbe\u7f6e\u4e3a\u5f85\u63a5\u5355TO_RECEIVING\u72b6\u6001");
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_RECEIVING.getStatus());
            warehouseType = 2;
        } else {
            logger.info("\u975e\u540c\u57ce\u914d\u9001\u8ba2\u5355\uff0c\u72b6\u6001\u8bbe\u7f6e\u4e3a\u5f85\u53d1\u8d27INIT\u72b6\u6001");
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.INIT.getStatus());
            warehouseType = 1;
        }
        Object omniRouterOpen = this.tradeConfQueryService.queryByCode("omniRouterOpen");
        boolean deliveryRouteOpen = EnableEnum.ENABLE.getCodeEn().equals(String.valueOf(omniRouterOpen));
        if (deliveryRouteOpen) {
            logger.info("\u8ba2\u5355\u8def\u7531\u914d\u7f6e\u5df2\u5f00\u542f\uff0c\u53d1\u8d27\u5355{}\u521d\u59cb\u72b6\u6001\u8bbe\u7f6e\u4e3a\u5f85\u8def\u7531\u72b6\u6001\u2026\u2026", (Object)orderDeliveryEo.getDeliveryNo());
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_ROUTE.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)orderAddressReqDto.getShippingType())) {
            orderDeliveryEo.setShippingType(orderAddressReqDto.getShippingType());
        } else {
            orderDeliveryEo.setShippingType(ShippingTypeEnum.EXPRESS.getType());
        }
        orderDeliveryEo.setChannel(orderEo.getSaleChannel());
        String shopId = orderEo.getShopId();
        if (StringUtils.isNotEmpty((CharSequence)shopId)) {
            ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(Long.valueOf(shopId).longValue(), new String[0]).getData();
            orderDeliveryEo.setShopCode(shopDto.getCode());
            List shopWarehouses = (List)this.shopQueryApi.queryShopWarehouseByShopId(Long.valueOf(shopId), warehouseType).getData();
            if (!CollectionUtils.isEmpty((Collection)shopWarehouses)) {
                orderDeliveryEo.setWarehouseCode(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseCode());
                orderDeliveryEo.setWarehouseSerial(String.valueOf(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseId()));
                orderDeliveryEo.setWarehouseName(((ShopWarehouseDto)shopWarehouses.get(0)).getWarehouseName());
            } else {
                logger.warn("\u540c\u57ce\u914d\u9001\uff08020\uff09\u672a\u627e\u5230\u5bf9\u5e94\u4ed3\u5e93\u4fe1\u606f\uff0cshopId\uff1a{}", (Object)shopId);
            }
        }
        orderDeliveryEo.setTotalAmount(orderEo.getTotalAmount());
        BigDecimal itemAmount = BigDecimal.ZERO;
        BigDecimal actualItemAmount = BigDecimal.ZERO;
        for (TradeItemEo tradeItemEo : tradeItemEos) {
            itemAmount = itemAmount.add(tradeItemEo.getItemOrigPrice().multiply(new BigDecimal(tradeItemEo.getItemNum())));
            actualItemAmount = itemAmount.add(tradeItemEo.getItemPrice().multiply(new BigDecimal(tradeItemEo.getItemNum())));
        }
        BigDecimal discountAmount = itemAmount.subtract(actualItemAmount);
        orderDeliveryEo.setItemAmount(itemAmount);
        orderDeliveryEo.setDiscountAmount(discountAmount);
        orderDeliveryEo.setFreightAmount(orderEo.getFreightAmount());
        orderDeliveryEo.setArAmount(itemAmount);
        orderDeliveryEo.setGotAmount(itemAmount);
        orderDeliveryEo.setDeliveryName(orderAddress.getDeliveryName());
        orderDeliveryEo.setAddress(orderAddress.getAddress());
        orderDeliveryEo.setDeliveryMobile(orderAddress.getDeliveryMobile());
        orderDeliveryEo.setDeliveryPhone(orderAddress.getDeliveryPhone());
        orderDeliveryEo.setProvinceName(orderAddress.getProvinceName());
        orderDeliveryEo.setCityName(orderAddress.getCityName());
        orderDeliveryEo.setAreaName(orderAddress.getAreaCode());
        orderDeliveryEo.setStreetName(orderAddress.getAreaCode());
        orderDeliveryEo.setDetailed(orderAddress.getDetailed());
        orderDeliveryEo.setPostcode(orderAddress.getPostcode());
        orderDeliveryEo.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
        orderDeliveryEo.setEmail(orderAddress.getEmail());
        orderDeliveryEo.setCountryCode(orderAddress.getCountryCode());
        orderDeliveryEo.setInstanceId(orderEo.getInstanceId());
        orderDeliveryEo.setTenantId(orderEo.getTenantId());
        orderDeliveryEo.setOrderNo(orderEo.getOrderNo());
        orderDeliveryEo.setTradeNo(orderEo.getTradeNo());
        orderDeliveryEo.setOrganizationId(orderEo.getOrganizationId());
        orderDeliveryEo.setOrganizationName(orderEo.getOrganizationName());
        this.setWarehouseOrganization(orderDeliveryEo.getWarehouseSerial(), orderDeliveryEo);
        orderDeliveryEo.setCycleBuy(Boolean.valueOf(orderEo.getIsCycleBuy() != null && 1 == orderEo.getIsCycleBuy()));
    }

    private void setWarehouseOrganization(String warehouseId, OrderDeliveryEo orderDeliveryEo) {
        if (StringUtils.isEmpty((CharSequence)warehouseId)) {
            logger.warn("\u67e5\u8be2\u5230\u7684\u4ed3\u5e93id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u4ed3\u5e93\u4fe1\u606f\uff0c\u8bbe\u7f6e\u9ed8\u8ba4\u7ec4\u7ec7");
            orderDeliveryEo.setWarehouseOrganizationId(Long.valueOf(0L));
            orderDeliveryEo.setWarehouseOrganizationName("\u9ed8\u8ba4\u7ec4\u7ec7");
            return;
        }
        WarehouseRespDto warehouseRespDto = (WarehouseRespDto)this.warehouseQueryApi.queryWarehouseBaseById(Long.valueOf(warehouseId)).getData();
        if (null != warehouseRespDto) {
            orderDeliveryEo.setWarehouseOrganizationId(warehouseRespDto.getOrganizationId());
            orderDeliveryEo.setWarehouseOrganizationName(warehouseRespDto.getOrganizationName());
        }
    }

    @Override
    public OrderDeliveryEo setOrderDeliveryPickUpCode(OrderDeliveryEo orderDeliveryEo) {
        logger.info("\u8bbe\u7f6e\u53d1\u8d27\u5355\u7684\u63d0\u8d27\u7801: deliverNo={}", (Object)orderDeliveryEo.getDeliveryNo());
        int i = 0;
        do {
            String pickUpCode = RandomUtil.generateNumberString((int)6);
            OrderDeliveryEo paramEo = OrderDeliveryEo.newInstance();
            paramEo.setPickUpCode(pickUpCode);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.ne((String)"deliveryStatus", (Object)DeliveryStatusEnum.SIGNED.getStatus()));
            sqlFilters.add(SqlFilter.ne((String)"deliveryStatus", (Object)DeliveryStatusEnum.FINISHED.getStatus()));
            paramEo.setSqlFilters(sqlFilters);
            List eoList = this.orderDeliveryDas.selectList((BaseEo)paramEo);
            if (CollectionUtils.isEmpty((Collection)eoList)) {
                orderDeliveryEo.setPickUpCode(pickUpCode);
                continue;
            }
            if (!CollectionUtils.isEmpty(eoList = eoList.stream().filter(eo -> !Arrays.asList(DeliveryStatusEnum.SIGNED.getStatus(), DeliveryStatusEnum.FINISHED.getStatus()).contains(eo.getDeliveryStatus())).collect(Collectors.toList()))) continue;
            orderDeliveryEo.setPickUpCode(pickUpCode);
        } while (++i < 10 && StringUtils.isBlank((CharSequence)orderDeliveryEo.getPickUpCode()));
        return orderDeliveryEo;
    }

    @Override
    public List<RefDeliveryOrderEo> handleRefDeliveryOrder(List<OrderDeliveryEo> orderDeliveryEoList, OrderEo orderEo) {
        ArrayList<RefDeliveryOrderEo> refDeliveryOrders = new ArrayList<RefDeliveryOrderEo>();
        orderDeliveryEoList.forEach(orderDelivery -> {
            RefDeliveryOrderEo refDeliveryOrder = RefDeliveryOrderEo.newInstance();
            refDeliveryOrder.setOrderNo(orderEo.getOrderNo());
            refDeliveryOrder.setDeliveryNo(orderDelivery.getDeliveryNo());
            refDeliveryOrder.setInstanceId(orderEo.getInstanceId());
            refDeliveryOrder.setTenantId(orderEo.getTenantId());
            refDeliveryOrders.add(refDeliveryOrder);
        });
        return refDeliveryOrders;
    }

    @Override
    public RefDeliveryOrderEo handleRefDeliveryOrder(OrderDeliveryEo orderDelivery, OrderEo orderEo) {
        RefDeliveryOrderEo refDeliveryOrder = RefDeliveryOrderEo.newInstance();
        refDeliveryOrder.setOrderNo(orderEo.getOrderNo());
        refDeliveryOrder.setDeliveryNo(orderDelivery.getDeliveryNo());
        refDeliveryOrder.setInstanceId(orderEo.getInstanceId());
        refDeliveryOrder.setTenantId(orderEo.getTenantId());
        return refDeliveryOrder;
    }

    @Override
    public List<DeliveryItemEo> handleDeliveryItems(List<TradeItemEo> tradeItems, List<OrderDeliveryEo> orderDeliveryEoList) {
        ArrayList<DeliveryItemEo> deliveryItemEos = new ArrayList<DeliveryItemEo>();
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEoList) {
            String deliveryNo = orderDeliveryEo.getDeliveryNo();
            for (TradeItemEo tradeItem : tradeItems) {
                DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
                deliveryItemEo.setTradeNo(tradeItem.getTradeNo());
                deliveryItemEo.setDeliveryNo(deliveryNo);
                deliveryItemEo.setTrOrderItemNo(tradeItem.getTradeItemNo());
                deliveryItemEo.setCargoSerial(tradeItem.getCargoSerial());
                deliveryItemEo.setDeliveredNum(Integer.valueOf(0));
                deliveryItemEo.setItemNum(orderDeliveryEo.getCycleBuy() != false ? tradeItem.getCycleItemNum() : tradeItem.getItemNum());
                deliveryItemEo.setDeliverySubType(orderDeliveryEo.getCycleBuy() != false ? "CYCLE_BUY" : "NORMAL");
                deliveryItemEo.setDeliveryType(orderDeliveryEo.getCycleBuy() != false ? "CYCLE_BUY" : "NORMAL");
                deliveryItemEo.setSkuSerial(tradeItem.getSkuSerial());
                deliveryItemEo.setSkuCode(tradeItem.getSkuCode());
                deliveryItemEo.setSkuDesc(tradeItem.getSkuDesc());
                deliveryItemEo.setItemCode(tradeItem.getItemCode());
                deliveryItemEo.setItemName(tradeItem.getItemName());
                deliveryItemEo.setItemPrice(tradeItem.getItemPrice());
                deliveryItemEo.setItemOrigPrice(tradeItem.getItemOrigPrice());
                deliveryItemEo.setRemark(tradeItem.getRemark());
                deliveryItemEo.setItemSerial(tradeItem.getItemSerial());
                String extension = tradeItem.getExtension();
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    JSONObject extensionObj = JSON.parseObject((String)extension);
                    deliveryItemEo.setItemImgPath(extensionObj.getString("imgPath"));
                }
                deliveryItemEo.setTenantId(tradeItem.getTenantId());
                deliveryItemEo.setInstanceId(tradeItem.getInstanceId());
                deliveryItemEos.add(deliveryItemEo);
            }
        }
        return deliveryItemEos;
    }

    @Override
    public int countPackageNum(String tradeItemNo) {
        PackageItemEo packageItemEo = new PackageItemEo();
        packageItemEo.setTradeNo(tradeItemNo);
        List packageItemEos = this.packageItemDas.select((BaseEo)packageItemEo);
        int count = 0;
        for (PackageItemEo packageItem : packageItemEos) {
            count += packageItem.getActualDeliveryNum().intValue();
        }
        return count;
    }

    @Override
    public Integer count(String filter) {
        DeliveryItemEo orderDeliveryEo = (DeliveryItemEo)JSON.parseObject((String)filter, DeliveryItemEo.class);
        return this.deliveryItemDas.count((BaseEo)orderDeliveryEo);
    }

    @Override
    public Set<String> queryDeliveryItemSupplierSerialNoReply(String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return new HashSet<String>();
        }
        DeliveryItemEo orderDeliveryEo = (DeliveryItemEo)JSON.parseObject((String)filter, DeliveryItemEo.class);
        Set deliveryItemEos = this.deliveryItemDas.queryDeliveryItemSupplierSerialDistinct(orderDeliveryEo);
        if (CollectionUtils.isEmpty((Collection)deliveryItemEos)) {
            return new HashSet<String>();
        }
        return deliveryItemEos.stream().filter(deliveryItemEo -> null != deliveryItemEo).map(deliveryItemEo -> deliveryItemEo.getSupplierSerial()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> queryDeliveryItemSkuSerialNoReply(String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return new HashSet<String>();
        }
        DeliveryItemEo orderDeliveryEo = (DeliveryItemEo)JSON.parseObject((String)filter, DeliveryItemEo.class);
        Set deliveryItemEos = this.deliveryItemDas.queryDeliveryItemSupplierSkuDistinct(orderDeliveryEo);
        if (CollectionUtils.isEmpty((Collection)deliveryItemEos)) {
            return new HashSet<String>();
        }
        return deliveryItemEos.stream().map(deliveryItemEo -> deliveryItemEo.getSkuSerial()).collect(Collectors.toSet());
    }

    @Override
    public Integer sumItemSkuSerial(String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return 0;
        }
        DeliveryItemEo orderDeliveryEo = (DeliveryItemEo)JSON.parseObject((String)filter, DeliveryItemEo.class);
        DeliveryItemEo result = this.deliveryItemDas.sumItemSkuSerial(orderDeliveryEo);
        if (result != null) {
            return result.getItemNum();
        }
        return 0;
    }

    @Override
    public Set<String> queryDeliveryDelivererIdNoReply(String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return new HashSet<String>();
        }
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)JSON.parseObject((String)filter, OrderDeliveryEo.class);
        Set deliveryEos = this.orderDeliveryDas.queryDeliveryDelivererIdNoReply(orderDeliveryEo);
        if (CollectionUtils.isEmpty((Collection)deliveryEos)) {
            return new HashSet<String>();
        }
        return deliveryEos.stream().map(deliveryEo -> deliveryEo.getDelivererId()).collect(Collectors.toSet());
    }

    @Override
    @Transactional
    public OrderDeliveryReqDto add(OrderDeliveryReqDto delivery) {
        List deliveryItems = delivery.getDeliveryItemList();
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)delivery, (BaseEo)orderDeliveryEo);
        orderDeliveryEo.setId(null);
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
        delivery.setId(orderDeliveryEo.getId());
        if (!CollectionUtils.isEmpty((Collection)deliveryItems)) {
            for (DeliveryItemReqDto deliveryItem : deliveryItems) {
                deliveryItem.setDelivererId(delivery.getDelivererId());
                deliveryItem.setDeliveryNo(delivery.getTradeNo());
                deliveryItem.setTradeNo(delivery.getTradeNo());
            }
            ArrayList deliveryItemEos = new ArrayList();
            DtoHelper.dtoList2EoList((Collection)delivery.getDeliveryItemList(), deliveryItemEos, DeliveryItemEo.class);
            this.deliveryItemDas.insertBatch(deliveryItemEos);
        }
        return delivery;
    }

    @Override
    public void deliveryStorageOut(List<DeliveryPackageReqDto> deliveryPackageReqDtos, boolean exceptionDeal) {
        if (!CollectionUtils.isEmpty(deliveryPackageReqDtos)) {
            for (DeliveryPackageReqDto deliveryPackageReqDto : deliveryPackageReqDtos) {
                OrderDeliveryEo orderDeliveryEo = StringUtils.isNotBlank((CharSequence)deliveryPackageReqDto.getDeliveryNo()) ? this.queryByDeliveryNo(deliveryPackageReqDto.getDeliveryNo()) : (!CollectionUtils.isEmpty((Collection)deliveryPackageReqDto.getPackageItems()) && StringUtils.isNotBlank((CharSequence)((PackageItemReqDto)deliveryPackageReqDto.getPackageItems().get(0)).getDeliveryNo()) ? this.queryByDeliveryNo(((PackageItemReqDto)deliveryPackageReqDto.getPackageItems().get(0)).getDeliveryNo()) : this.queryByTradeNo(deliveryPackageReqDto.getTradeNo()));
                if (orderDeliveryEo.getFlowDefId() == null || "pickup".equals(orderDeliveryEo.getShippingType())) continue;
                deliveryPackageReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
                this.deliveryRecordAction.warehouseOut(deliveryPackageReqDto);
            }
        }
    }

    @Override
    public void modifyStatus(Long id, String status) {
        if (id == null) {
            return;
        }
        OrderDeliveryEo orderDelivery = new OrderDeliveryEo();
        orderDelivery.setId(id);
        orderDelivery.setDeliveryStatus(status);
        this.orderDeliveryDas.updateSelective((BaseEo)orderDelivery);
    }

    @Override
    public void modifyStatus(String tradeNo, String status) {
        OrderDeliveryEo orderDelivery = new OrderDeliveryEo();
        orderDelivery.setDeliveryStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        orderDelivery.setSqlFilters(sqlFilters);
        this.orderDeliveryDas.updateSelectiveSqlFilter((BaseEo)orderDelivery);
    }

    @Override
    public void addPackageItems(List<PackageItemReqDto> packageItems) {
        ArrayList packageItemEos = new ArrayList();
        DtoHelper.dtoList2EoList(packageItems, packageItemEos, PackageItemEo.class);
        this.packageItemDas.insertBatch(packageItemEos);
    }

    @Override
    public List<PackageItemEo> getPackItemByDeliveryNo(String deliveryNo) {
        PackageItemEo packageItemEo = new PackageItemEo();
        packageItemEo.setTradeNo(deliveryNo);
        return this.packageItemDas.select((BaseEo)packageItemEo);
    }

    @Override
    public List<PackageItemEo> queryPackItemByDeliveryNos(Set<String> deliveryNos) {
        PackageItemEo packageItemEo = new PackageItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"delivery_no", deliveryNos));
        packageItemEo.setSqlFilters(sqlFilters);
        return this.packageItemDas.select((BaseEo)packageItemEo);
    }

    @Override
    public List<DeliveryItemEo> queryItemByTradeNo(String tradeNo) {
        DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
        deliveryItemEo.setTradeNo(tradeNo);
        return this.deliveryItemDas.select((BaseEo)deliveryItemEo);
    }

    @Override
    public Boolean isOutPackageComplete(String tradeNo) {
        List<DeliveryItemEo> deliveryItemEos = this.queryItemByTradeNo(tradeNo);
        for (DeliveryItemEo deliveryItemEo : deliveryItemEos) {
            Integer num = this.countByTradeNoAndCargoSerial(tradeNo, deliveryItemEo.getTrOrderItemNo(), deliveryItemEo.getCargoSerial());
            if (num.equals(deliveryItemEo.getItemNum())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean isAllWarehouseOut(String deliveryNo) {
        List deliveryItemEos = this.deliveryItemDas.queryByDeliveryNo(deliveryNo);
        for (DeliveryItemEo deliveryItemEo : deliveryItemEos) {
            Integer num = this.countWarehouseOut(deliveryNo, deliveryItemEo.getTrOrderItemNo(), deliveryItemEo.getCargoSerial());
            if (num.equals(deliveryItemEo.getItemNum())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<DeliveryItemEo> queryListByDeliveryNo(String deliveryNo) {
        return this.deliveryItemDas.queryByDeliveryNo(deliveryNo);
    }

    @Override
    public int countByTradeNoAndCargoSerial(String tradeNo, String tradeItemNo, String cargoSerial) {
        PackageItemEo packageItem = new PackageItemEo();
        packageItem.setCargoSerial(cargoSerial);
        packageItem.setTradeNo(tradeNo);
        packageItem.setTrOrderItemNo(tradeItemNo);
        List packageItemEos = this.packageItemDas.select((BaseEo)packageItem);
        int sum = 0;
        if (!CollectionUtils.isEmpty((Collection)packageItemEos)) {
            for (PackageItemEo packageItemEo : packageItemEos) {
                sum += packageItemEo.getActualDeliverySkuNum().intValue();
            }
        }
        return sum;
    }

    private int countWarehouseOut(String deliveryNo, String tradeItemNo, String cargoSerial) {
        PackageItemEo packageItem = new PackageItemEo();
        packageItem.setCargoSerial(cargoSerial);
        packageItem.setDeliveryNo(deliveryNo);
        packageItem.setTrOrderItemNo(tradeItemNo);
        List packageItemEos = this.packageItemDas.select((BaseEo)packageItem, Integer.valueOf(0), Integer.valueOf(4096));
        int sum = 0;
        if (!CollectionUtils.isEmpty((Collection)packageItemEos)) {
            for (PackageItemEo packageItemEo : packageItemEos) {
                sum += packageItemEo.getActualDeliverySkuNum().intValue();
            }
        }
        return sum;
    }

    @Override
    public void replyByPackId(String tradeNo, String packageSerial) {
        PackageItemEo packageItem = new PackageItemEo();
        packageItem.setPackageSerial(packageSerial);
        packageItem.setTradeNo(tradeNo);
        List packageItemEos = this.packageItemDas.select((BaseEo)packageItem);
        HashMap<String, String> exitPackItemMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)packageItemEos) && packageItemEos.size() > 1) {
            for (int i = 0; i < packageItemEos.size(); ++i) {
                PackageItemEo packageItemEo = (PackageItemEo)packageItemEos.get(i);
                String key = packageItemEo.getCargoSerial() + packageItemEo.getTrOrderItemNo();
                String id = (String)exitPackItemMap.get(key);
                if (id == null) {
                    exitPackItemMap.put(key, packageItemEo.getId().toString());
                    continue;
                }
                logger.error("\u9501\u5931\u6548\uff0c\u4ea7\u751f\u591a\u4f59\u6570\u636etradeNo=" + tradeNo + "packId=" + packageSerial + "\u5220\u9664packItemId=" + ((PackageItemEo)packageItemEos.get(i)).getId());
            }
        }
    }

    @Override
    public int countPackItem(String packageSerial, String cargoSerial) {
        PackageItemEo packageItem = new PackageItemEo();
        packageItem.setPackageSerial(packageSerial);
        packageItem.setCargoSerial(cargoSerial);
        int count = this.packageItemDas.count((BaseEo)packageItem);
        return count;
    }

    @Override
    public OrderDeliveryReqDto initDeliveryOrder(OrderDeliveryReqDto delivery, String parentTradeNo, OrderAddressReqDto orderAddressBo, List<TradeItemReqDto> tradeItemBos) {
        if (delivery.getShippingType() != null && delivery.getShippingType().equals("pickup")) {
            Assert.notNull((Object)delivery.getWarehouseSerial(), "\u914d\u9001\u4e3a\u81ea\u63d0\u65f6\uff0c\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
            WarehouseRespDto warehouseRespDto = this.cargoDeliveryService.getByWarehouseId(delivery.getWarehouseSerial());
            Assert.notNull((Object)warehouseRespDto, "\u67e5\u8be2\u4e0d\u5230\u8be5\u4ed3\u5e93");
            if (!warehouseRespDto.getType().equals(WarehouseTypeEnum.STORE.getType())) {
                throw new BizException("\u5bf9\u5e94\u4ed3\u5e93\u7c7b\u578b\u5fc5\u987b\u662f\u95e8\u5e97\u4ed3");
            }
            orderAddressBo.setAddress(warehouseRespDto.getAddr());
            orderAddressBo.setAreaCode(warehouseRespDto.getAreaCode());
            orderAddressBo.setCountryCode(warehouseRespDto.getCityCode());
            orderAddressBo.setProvinceCode(warehouseRespDto.getProvCode());
            orderAddressBo.setProvinceName("pickup");
            orderAddressBo.setAreaCode("pickup");
            orderAddressBo.setCountryCode("pickup");
        }
        return this.createDeliveryOrder(delivery, parentTradeNo, orderAddressBo, tradeItemBos);
    }

    @Override
    public OrderDeliveryReqDto createDeliveryOrder(OrderDeliveryReqDto delivery, String parentTradeNo, OrderAddressReqDto orderAddressBo, List<TradeItemReqDto> tradeItemBos) {
        TradeItemReqDto tradeItemBo = tradeItemBos.get(0);
        BeanCopierUtils.copy(orderAddressBo, delivery);
        delivery.setDeliveryNo(delivery.getDeliveryNo());
        delivery.setTenantId(tradeItemBo.getTenantId());
        delivery.setDeliveryStatus("INIT");
        delivery.setInstanceId(tradeItemBo.getInstanceId());
        ArrayList<DeliveryItemReqDto> deliveryItems = new ArrayList<DeliveryItemReqDto>();
        for (TradeItemReqDto tradeItem : tradeItemBos) {
            DeliveryItemReqDto deliveryItem = new DeliveryItemReqDto();
            deliveryItem.setDeliveryType("NORMAL");
            deliveryItem.setDeliverySubType("NORMAL");
            deliveryItem.setItemNum(tradeItem.getItemNum());
            deliveryItem.setTradeItem(tradeItem);
            deliveryItem.setParentDeliveryNo(delivery.getParentDeliveryNo());
            deliveryItem.setSkuSerial(tradeItem.getSkuSerial());
            deliveryItem.setSupplierSerial(tradeItem.getSupplierSerial());
            deliveryItem.setTradeNo(delivery.getTradeNo());
            deliveryItem.setTrOrderItemNo(tradeItem.getTradeItemNo());
            deliveryItem.setCargoSerial(tradeItem.getCargoSerial());
            deliveryItems.add(deliveryItem);
        }
        delivery.setDeliveryItemList(deliveryItems);
        return delivery;
    }

    @Override
    public OrderDeliveryReqDto createLockDeliveryOrder(OrderDeliveryReqDto orderDeliveryReqDto, String parentTradeNo, OrderAddressReqDto orderAddressBo, List<TradeItemReqDto> tradeItemBos) {
        OrderDeliveryReqDto delivery = this.initDeliveryOrder(orderDeliveryReqDto, parentTradeNo, orderAddressBo, tradeItemBos);
        delivery.setDeliveryNo(delivery.getTradeNo());
        delivery.setTradeNo(delivery.getTradeNo());
        delivery.setDeliveryStatus("INIT");
        this.lockItems(delivery);
        delivery.setDeliveryStatus("LOCK");
        this.modifyStatus(delivery.getId(), "LOCK");
        return delivery;
    }

    @Override
    public OrderDeliveryRespDto queryOrderByTradeNo(String tradeNo) {
        OrderDeliveryEo result = this.queryByTradeNo(tradeNo);
        if (result != null) {
            OrderDeliveryRespDto orderDeliveryRespDto = new OrderDeliveryRespDto();
            DtoHelper.eo2Dto((BaseEo)result, (BaseVo)orderDeliveryRespDto);
            return orderDeliveryRespDto;
        }
        return null;
    }

    @Override
    public OrderDeliveryRespDto queryOrderByDeliveryNo(String deliveryNo) {
        OrderDeliveryEo result = this.queryByDeliveryNo(deliveryNo);
        if (result != null) {
            OrderDeliveryRespDto orderDeliveryRespDto = new OrderDeliveryRespDto();
            DtoHelper.eo2Dto((BaseEo)result, (BaseVo)orderDeliveryRespDto);
            return orderDeliveryRespDto;
        }
        return null;
    }

    @Override
    public List<OrderDeliveryRespDto> queryOrderDeliveryByOrderNo(String orderNo) {
        ArrayList list = Lists.newArrayList();
        OrderDeliveryEo orderDeliveryEoParam = OrderDeliveryEo.newInstance();
        orderDeliveryEoParam.setOrderNo(orderNo);
        List eoList = this.orderDeliveryDas.selectList((BaseEo)orderDeliveryEoParam);
        if (!CollectionUtils.isEmpty((Collection)eoList)) {
            CubeBeanUtils.copyCollection((Collection)list, (Collection)eoList, OrderDeliveryRespDto.class);
        }
        return list;
    }

    private OrderDeliveryEo queryByTradeNo(String tradeNo) {
        OrderDeliveryEo orderDeliveryEo = new OrderDeliveryEo();
        orderDeliveryEo.setTradeNo(tradeNo);
        return (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliveryEo);
    }

    private OrderDeliveryEo queryByDeliveryNo(String deliveryNo) {
        OrderDeliveryEo orderDeliveryEo = new OrderDeliveryEo();
        orderDeliveryEo.setDeliveryNo(deliveryNo);
        return (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliveryEo);
    }

    @Override
    public List<OrderDeliveryRespDto> queryByOrderNos(Set<String> orderNos) {
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"order_no", (Object)StringUtils.join(orderNos, (String)",")));
        orderDeliveryEo.setSqlFilters(sqlFilters);
        List results = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
        ArrayList<OrderDeliveryRespDto> orderDeliveryRespDtos = new ArrayList<OrderDeliveryRespDto>();
        if (orderDeliveryRespDtos != null) {
            DtoHelper.eoList2DtoList((Collection)results, orderDeliveryRespDtos, OrderDeliveryRespDto.class);
            return orderDeliveryRespDtos;
        }
        return orderDeliveryRespDtos;
    }

    @Override
    public List<OrderDeliveryRespDto> queryOrderByTradeNo(Set<String> tradeNos) {
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)StringUtils.join(tradeNos, (String)",")));
        orderDeliveryEo.setSqlFilters(sqlFilters);
        List results = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
        ArrayList<OrderDeliveryRespDto> orderDeliveryRespDtos = new ArrayList<OrderDeliveryRespDto>();
        if (orderDeliveryRespDtos != null) {
            DtoHelper.eoList2DtoList((Collection)results, orderDeliveryRespDtos, OrderDeliveryRespDto.class);
            return orderDeliveryRespDtos;
        }
        return orderDeliveryRespDtos;
    }

    @Override
    public List<OrderDeliveryRespDto> queryDeliveryContainPackInfoList(String parentTradeNo, Set<String> tradeTypeList) {
        Set<String> tradeNos = this.tradeService.queryChildrenTradeNosByTradeType(parentTradeNo, tradeTypeList);
        if (!CollectionUtils.isEmpty(tradeNos)) {
            Set<String> deliveryNos;
            List<PackageItemEo> packageItemEos;
            List<OrderDeliveryRespDto> orderDeliveryRespDtos = this.queryOrderByTradeNo(tradeNos);
            if (!CollectionUtils.isEmpty(orderDeliveryRespDtos) && !CollectionUtils.isEmpty(packageItemEos = this.queryPackItemByDeliveryNos(deliveryNos = orderDeliveryRespDtos.stream().map(OrderDeliveryRespDto::getDeliveryNo).collect(Collectors.toSet())))) {
                Map<String, List<PackageItemEo>> deliveryPackageItemMap = packageItemEos.stream().collect(Collectors.groupingBy(StdPackageItemEo::getDeliveryNo));
                orderDeliveryRespDtos.forEach(orderDeliveryRespDto -> {
                    List packageItemEos1 = (List)deliveryPackageItemMap.get(orderDeliveryRespDto.getDeliveryNo());
                    if (!CollectionUtils.isEmpty((Collection)packageItemEos1) && !CollectionUtils.isEmpty(packageItemEos1 = packageItemEos1.stream().filter(packageItemEo -> StringUtils.isNotEmpty((CharSequence)packageItemEo.getShippingCompany())).collect(Collectors.toList()))) {
                        Map<String, List<PackageItemEo>> shippingNoMap = packageItemEos1.stream().collect(Collectors.groupingBy(StdPackageItemEo::getShippingSerial));
                        Set shippingNos = packageItemEos1.stream().map(StdPackageItemEo::getShippingSerial).collect(Collectors.toSet());
                        List packageRespDtos = shippingNos.stream().map(shippingNo -> {
                            PackageRespDto packageRespDto = new PackageRespDto();
                            packageRespDto.setShippingSerial(shippingNo);
                            List packageItemList = (List)shippingNoMap.get(shippingNo);
                            if (!CollectionUtils.isEmpty((Collection)packageItemList)) {
                                packageRespDto.setShippingCompany(((PackageItemEo)packageItemList.get(0)).getShippingCompany());
                            }
                            return packageRespDto;
                        }).collect(Collectors.toList());
                        orderDeliveryRespDto.setPackageList(packageRespDtos);
                    }
                });
            }
            return orderDeliveryRespDtos;
        }
        return null;
    }

    @Override
    public PageInfo<OrderDeliveryEo> getNotCompleteDelivery(Date startTime, Date endTime, int currentPage, int pageSize) {
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        ArrayList<String> status = new ArrayList<String>();
        status.add("ACCEPT");
        status.add("OUT_PART");
        sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)startTime));
        sqlFilters.add(SqlFilter.le((String)"update_time", (Object)endTime));
        sqlFilters.add(SqlFilter.in((String)"delivery_status", (Object)StringUtils.join(status, (String)",")));
        orderDeliveryEo.setSqlFilters(sqlFilters);
        return this.orderDeliveryDas.selectPage((BaseEo)orderDeliveryEo, Integer.valueOf(currentPage), Integer.valueOf(pageSize));
    }

    @Override
    public PageInfo<OrderDeliveryEo> getInitDelivery(Date startTime, Date endTime, int currentPage, int pageSize) {
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        ArrayList<String> status = new ArrayList<String>();
        status.add("INIT");
        sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)startTime));
        sqlFilters.add(SqlFilter.le((String)"update_time", (Object)endTime));
        sqlFilters.add(SqlFilter.in((String)"delivery_status", (Object)StringUtils.join(status, (String)",")));
        orderDeliveryEo.setSqlFilters(sqlFilters);
        return this.orderDeliveryDas.selectPage((BaseEo)orderDeliveryEo, Integer.valueOf(currentPage), Integer.valueOf(pageSize));
    }

    @Override
    public void lockItems(OrderDeliveryReqDto delivery) {
        this.cargoDeliveryService.lockItems(delivery);
    }

    @Override
    public void cancel(String tradeNo, CancelReqDto cancelReqDto) {
        OrderDeliveryRespDto orderDeliveryRespDto = this.queryOrderByTradeNo(tradeNo);
        OrderDeliveryEo updateOrder = OrderDeliveryEo.newInstance();
        updateOrder.setId(orderDeliveryRespDto.getId());
        updateOrder.setCancelDesc(cancelReqDto.getCancelDesc());
        updateOrder.setCancelTime(new Date());
        updateOrder.setCancelType(cancelReqDto.getCancelType());
        this.orderDeliveryDas.updateSelective((BaseEo)updateOrder);
    }

    @Override
    public PageInfo<OrderDeliveryRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)JSON.parseObject((String)filter, OrderDeliveryEo.class);
        orderDeliveryEo.setOrderByDesc("id");
        PageInfo pageInfo = this.orderDeliveryDas.selectPage((BaseEo)orderDeliveryEo, pageNum, pageSize);
        ArrayList orderDeliveryRespDtoList = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), orderDeliveryRespDtoList, OrderDeliveryRespDto.class);
        pageInfo.setList(orderDeliveryRespDtoList);
        return pageInfo;
    }

    @Override
    public OrderDeliveryDetailRespDto queryDetail(String tradeNo) {
        OrderDeliveryEo orderDeliveryEo = this.queryByTradeNo(tradeNo);
        OrderDeliveryDetailRespDto orderDeliveryRepDto = new OrderDeliveryDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)orderDeliveryEo, (BaseVo)orderDeliveryRepDto);
        DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
        deliveryItemEo.setTradeNo(tradeNo);
        List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
        ArrayList deliveryItemRespDtoList = new ArrayList(deliveryItemEoList.size());
        DtoHelper.eoList2DtoList((Collection)deliveryItemEoList, deliveryItemRespDtoList, DeliveryItemRespDto.class);
        orderDeliveryRepDto.setDeliveryItems(deliveryItemRespDtoList);
        return orderDeliveryRepDto;
    }

    @Override
    public void modify(OrderDeliveryReqDto delivery) {
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        CubeBeanUtils.copyProperties((Object)orderDeliveryEo, (Object)delivery, (String[])new String[0]);
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryEo);
    }

    @Override
    public PageInfo<OrderDeliveryDetailRespDto> queryDetailByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)JSON.parseObject((String)filter, OrderDeliveryEo.class);
        orderDeliveryEo.setOrderByDesc("id");
        PageInfo pageInfo = this.orderDeliveryDas.selectPage((BaseEo)orderDeliveryEo, pageNum, pageSize);
        ArrayList orderDeliveryDetailRespDtos = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), orderDeliveryDetailRespDtos, OrderDeliveryDetailRespDto.class);
        orderDeliveryDetailRespDtos.stream().forEach(bean -> {
            DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
            deliveryItemEo.setDeliveryNo(bean.getDeliveryNo());
            List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
            ArrayList deliveryItemRespDtoList = new ArrayList(deliveryItemEoList.size());
            DtoHelper.eoList2DtoList((Collection)deliveryItemEoList, deliveryItemRespDtoList, DeliveryItemRespDto.class);
            bean.setDeliveryItems(deliveryItemRespDtoList);
        });
        pageInfo.setList(orderDeliveryDetailRespDtos);
        return pageInfo;
    }

    @Override
    public Map<String, Boolean> queryCanServiceFlag(String orderNos, String deliveryNos) {
        HashMap<String, Boolean> flagMap;
        block7: {
            block6: {
                flagMap = new HashMap<String, Boolean>();
                if (!StringUtils.isNotEmpty((CharSequence)orderNos)) break block6;
                OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
                ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
                sqlFilterList.add(SqlFilter.in((String)"order_no", (Object)orderNos));
                orderDeliveryEo.setSqlFilters(sqlFilterList);
                orderDeliveryEo.setDeliveryStatus("SIGNED");
                List orderDeliveryEoList = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
                if (CollectionUtils.isEmpty((Collection)orderDeliveryEoList)) {
                    return flagMap;
                }
                List needDeliveryNos = orderDeliveryEoList.stream().map(StdOrderDeliveryEo::getDeliveryNo).collect(Collectors.toList());
                DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
                ArrayList<SqlFilter> itemFilterList = new ArrayList<SqlFilter>();
                itemFilterList.add(SqlFilter.in((String)"delivery_no", needDeliveryNos));
                deliveryItemEo.setSqlFilters(itemFilterList);
                List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
                TradeItemEo tradeItemEo = TradeItemEo.newInstance();
                ArrayList<SqlFilter> filterList = new ArrayList<SqlFilter>();
                filterList.add(SqlFilter.in((String)"trade_no", (Object)orderNos));
                tradeItemEo.setSqlFilters(filterList);
                List tradeItemEoList = this.tradeItemDas.select((BaseEo)tradeItemEo);
                Map<String, TradeItemEo> tradeItemMap = tradeItemEoList.stream().collect(Collectors.toMap(StdTradeItemEo::getTradeItemNo, item -> item, (v1, v2) -> v2));
                Map<String, List<DeliveryItemEo>> deliveryItemMap = deliveryItemEoList.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getDeliveryNo));
                Map<String, List<OrderDeliveryEo>> orderDeliveryMap = orderDeliveryEoList.stream().collect(Collectors.groupingBy(StdOrderDeliveryEo::getOrderNo));
                for (Map.Entry<String, List<OrderDeliveryEo>> entry : orderDeliveryMap.entrySet()) {
                    String orderNo = entry.getKey();
                    List<OrderDeliveryEo> orderDeliveryEos = entry.getValue();
                    Boolean flag = false;
                    for (OrderDeliveryEo deliveryEo : orderDeliveryEos) {
                        List<DeliveryItemEo> deliveryItemEos = deliveryItemMap.get(deliveryEo.getDeliveryNo());
                        for (DeliveryItemEo itemEo : deliveryItemEos) {
                            TradeItemEo tradeItem;
                            if (itemEo.getItemNum() == 0 || !Objects.isNull(itemEo.getReturnedNum()) && itemEo.getReturnedNum() != 0 && itemEo.getReturnedNum() == itemEo.getItemNum() || (tradeItem = tradeItemMap.get(itemEo.getTrOrderItemNo())).getGift() == 1) continue;
                            flag = true;
                            break;
                        }
                        if (!flag.booleanValue()) continue;
                        break;
                    }
                    flagMap.put(orderNo, flag);
                }
                break block7;
            }
            if (!StringUtils.isNotEmpty((CharSequence)deliveryNos)) break block7;
            DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"delivery_no", (Object)deliveryNos));
            deliveryItemEo.setSqlFilters(sqlFilterList);
            List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
            TradeItemEo tradeItemEo = TradeItemEo.newInstance();
            tradeItemEo.setTradeNo(((DeliveryItemEo)deliveryItemEoList.get(0)).getTradeNo());
            List tradeItemEoList = this.tradeItemDas.select((BaseEo)tradeItemEo);
            Map<String, TradeItemEo> tradeItemMap = tradeItemEoList.stream().collect(Collectors.toMap(StdTradeItemEo::getTradeItemNo, item -> item, (v1, v2) -> v2));
            Map<String, List<DeliveryItemEo>> deliveryItemMap = deliveryItemEoList.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getDeliveryNo));
            for (Map.Entry<String, List<DeliveryItemEo>> entry : deliveryItemMap.entrySet()) {
                String deliveryNo = entry.getKey();
                List<DeliveryItemEo> deliveryItemRespDtos = entry.getValue();
                Boolean flag = false;
                for (DeliveryItemEo itemEo : deliveryItemRespDtos) {
                    TradeItemEo tradeItem;
                    if (itemEo.getItemNum() == 0 || !Objects.isNull(itemEo.getReturnedNum()) && itemEo.getReturnedNum() != 0 && itemEo.getReturnedNum() == itemEo.getItemNum() || (tradeItem = tradeItemMap.get(itemEo.getTrOrderItemNo())).getGift() == 1) continue;
                    flag = true;
                    break;
                }
                flagMap.put(deliveryNo, flag);
            }
        }
        return flagMap;
    }

    @Override
    public List<DeliveryItemRespDto> queryDeliveryItemForCanService(String deliveryNo, String customerId) {
        ArrayList deliveryItemRespDtoList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)deliveryNo)) {
            OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
            orderDeliveryEo.setDeliveryStatus("SIGNED");
            orderDeliveryEo.setDeliveryNo(deliveryNo);
            List deliveryEos = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
            if (!CollectionUtils.isEmpty((Collection)deliveryEos)) {
                List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(((OrderDeliveryEo)deliveryEos.get(0)).getOrderNo());
                Map<String, TradeItemEo> tradeItemMap = tradeItemEos.stream().collect(Collectors.toMap(StdTradeItemEo::getTradeItemNo, item -> item, (v1, v2) -> v2));
                DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
                deliveryItemEo.setDeliveryNo(deliveryNo);
                List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
                for (DeliveryItemEo itemEo : deliveryItemEoList) {
                    TradeItemEo tradeItemEo;
                    DeliveryItemRespDto deliveryItemRespDto = new DeliveryItemRespDto();
                    DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)deliveryItemRespDto);
                    if (deliveryItemRespDto.getItemNum() == 0) continue;
                    if (Objects.isNull(deliveryItemRespDto.getReturnedNum()) || deliveryItemRespDto.getReturnedNum() == 0) {
                        deliveryItemRespDto.setCanReturnedNum(deliveryItemRespDto.getItemNum());
                        deliveryItemRespDto.setReturnedNum(Integer.valueOf(0));
                    } else {
                        if (deliveryItemRespDto.getReturnedNum().equals(deliveryItemRespDto.getItemNum())) continue;
                        deliveryItemRespDto.setCanReturnedNum(Integer.valueOf(deliveryItemRespDto.getItemNum() - deliveryItemRespDto.getReturnedNum()));
                    }
                    if ((tradeItemEo = tradeItemMap.get(itemEo.getTrOrderItemNo())).getGift() != 0) continue;
                    deliveryItemRespDto.setGift(Integer.valueOf(0));
                    deliveryItemRespDtoList.add(deliveryItemRespDto);
                }
                if (!CollectionUtils.isEmpty((Collection)deliveryItemRespDtoList)) {
                    List skuIds = deliveryItemRespDtoList.stream().map(DeliveryItemRespDto::getSkuSerial).collect(Collectors.toList());
                    List giftItemList = tradeItemEos.stream().filter(eo -> eo.getGift() == 1).collect(Collectors.toList());
                    for (TradeItemEo tradeItemEo : giftItemList) {
                        if (!StringUtils.isNotEmpty((CharSequence)tradeItemEo.getGiftSkuIds())) continue;
                        List<String> giftSkuIds = Arrays.asList(tradeItemEo.getGiftSkuIds().split(","));
                        giftSkuIds.retainAll(skuIds);
                        if (CollectionUtils.isEmpty(giftSkuIds) || Objects.isNull(tradeItemEo.getDeliveredNum())) continue;
                        DeliveryItemRespDto deliveryItem = new DeliveryItemRespDto();
                        DtoHelper.eo2Dto((BaseEo)tradeItemEo, (BaseVo)deliveryItem);
                        deliveryItem.setTrOrderItemNo(tradeItemEo.getTradeItemNo());
                        if (Objects.isNull(tradeItemEo.getReturnedNum()) || tradeItemEo.getReturnedNum() == 0) {
                            deliveryItem.setCanReturnedNum(tradeItemEo.getDeliveredNum());
                            deliveryItem.setReturnedNum(Integer.valueOf(0));
                        } else {
                            if (tradeItemEo.getReturnedNum().equals(tradeItemEo.getDeliveredNum())) continue;
                            deliveryItem.setCanReturnedNum(Integer.valueOf(tradeItemEo.getDeliveredNum() - tradeItemEo.getReturnedNum()));
                        }
                        String extensionStr = tradeItemEo.getExtension();
                        if (StringUtils.isNotEmpty((CharSequence)extensionStr)) {
                            JSONObject json = JSON.parseObject((String)extensionStr);
                            Object imgPath = json.get((Object)"imgPath");
                            deliveryItem.setItemImgPath((String)imgPath);
                        }
                        deliveryItem.setItemNum(tradeItemEo.getDeliveredNum());
                        deliveryItemRespDtoList.add(deliveryItem);
                    }
                }
            }
            return deliveryItemRespDtoList;
        }
        ArrayList newDeliveryItemList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
            orderDeliveryEo.setCustomerId(customerId);
            orderDeliveryEo.setDeliveryStatus("SIGNED");
            List deliveryEos = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
            if (!CollectionUtils.isEmpty((Collection)deliveryEos)) {
                String deliveryNos = deliveryEos.stream().map(StdOrderDeliveryEo::getDeliveryNo).collect(Collectors.joining("','", "'", "'"));
                DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"delivery_no", (Object)deliveryNos));
                deliveryItemEo.setSqlFilters(sqlFilters);
                List deliveryItemEoList = this.deliveryItemDas.select((BaseEo)deliveryItemEo);
                for (DeliveryItemEo itemEo : deliveryItemEoList) {
                    DeliveryItemRespDto deliveryItemRespDto = new DeliveryItemRespDto();
                    DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)deliveryItemRespDto);
                    if (deliveryItemRespDto.getItemNum() == 0) continue;
                    if (Objects.isNull(deliveryItemRespDto.getReturnedNum()) || deliveryItemRespDto.getReturnedNum() == 0) {
                        deliveryItemRespDto.setCanReturnedNum(deliveryItemRespDto.getItemNum());
                        deliveryItemRespDto.setReturnedNum(Integer.valueOf(0));
                    } else {
                        if (deliveryItemRespDto.getReturnedNum() == deliveryItemRespDto.getItemNum()) continue;
                        deliveryItemRespDto.setCanReturnedNum(Integer.valueOf(deliveryItemRespDto.getItemNum() - deliveryItemRespDto.getReturnedNum()));
                    }
                    deliveryItemRespDtoList.add(deliveryItemRespDto);
                }
                Map<String, List<DeliveryItemRespDto>> deliveryItemMap = deliveryItemRespDtoList.stream().collect(Collectors.groupingBy(DeliveryItemRespDto::getSkuSerial));
                for (Map.Entry<String, List<DeliveryItemRespDto>> entry : deliveryItemMap.entrySet()) {
                    String skuSerial = entry.getKey();
                    List<DeliveryItemRespDto> deliveryItemRespDtos = entry.getValue();
                    Integer canReturnedNum = 0;
                    Integer returnedNum = 0;
                    for (DeliveryItemRespDto itemRespDto : deliveryItemRespDtos) {
                        canReturnedNum = canReturnedNum + itemRespDto.getCanReturnedNum();
                        returnedNum = returnedNum + itemRespDto.getReturnedNum();
                    }
                    DeliveryItemRespDto newDeliveryItemResp = deliveryItemRespDtos.get(0);
                    newDeliveryItemResp.setCanReturnedNum(canReturnedNum);
                    newDeliveryItemResp.setReturnedNum(returnedNum);
                    newDeliveryItemList.add(newDeliveryItemResp);
                }
            }
        }
        return newDeliveryItemList;
    }

    @Override
    public List<DeliveryItemEo> queryListByDeliveryNos(List<String> deliveryNos) {
        DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"delivery_no", deliveryNos));
        deliveryItemEo.setSqlFilters(sqlFilters);
        return this.deliveryItemDas.select((BaseEo)deliveryItemEo);
    }

    @Override
    public void cancelDelivery(String deliveryNo) {
        logger.info("\u53d1\u8d27\u5355\u53d6\u6d88:{}", (Object)deliveryNo);
        OrderDeliveryEo select = OrderDeliveryEo.newInstance();
        select.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)select);
        boolean flagMiddleGround = true;
        if (YesNoEnum.NO.getValue().equals(orderDeliveryEo.getIfAgreement())) {
            flagMiddleGround = Boolean.FALSE;
        }
        if (flagMiddleGround) {
            logger.info("\u53d1\u8d27\u5355\u53d6\u6d88\u4e2d\u53f0\u5c65\u7ea6");
            this.MultiSceneByMiddleGround(orderDeliveryEo);
        } else {
            logger.info("\u53d1\u8d27\u5355\u53d6\u6d88\u4e0b\u6e38\u5c65\u7ea6");
            this.MultiSceneByDownStream(orderDeliveryEo);
        }
    }

    private void MultiSceneByMiddleGround(OrderDeliveryEo orderDeliveryEo) {
        Integer update = this.updateDeliveryStatusToCanCel(orderDeliveryEo);
        DeliveryChangeReqDto deliveryChangeReqDto = new DeliveryChangeReqDto();
        DtoHelper.eo2Dto((BaseEo)orderDeliveryEo, (BaseVo)deliveryChangeReqDto);
        if (update > 0) {
            deliveryChangeReqDto.setOperatorDesc("\u53d6\u6d88\u53d1\u8d27\u5355\u6210\u529f");
        } else {
            deliveryChangeReqDto.setOperatorDesc("\u53d6\u6d88\u53d1\u8d27\u5355\u5931\u8d25,\u5f85\u4e70\u5bb6\u62d2\u6536\u6216\u8005\u7b7e\u6536\u540e\u53d1\u8d77\u552e\u540e");
        }
        this.deliveryProducer.sendInventoryDeliveryChange(deliveryChangeReqDto);
    }

    private void MultiSceneByDownStream(OrderDeliveryEo orderDeliveryEo) {
        if (DeliveryStatusEnum.PROCESSING.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
            this.afterSalesService.syncAfterSalesOrder(orderDeliveryEo.getTradeNo());
        }
    }

    private Integer updateDeliveryStatusToCanCel(OrderDeliveryEo orderDeliveryEo) {
        orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
        return this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryEo);
    }
}

