/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.connector.core.api.constant.ChannelCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.UnitTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.ItemRelationComparisonRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.query.IItemRelationComparisonQueryApi;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.ItemBaseDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IRuleQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.ShopFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.FreightCountType;
import com.dtyunxi.yundt.cube.center.shop.api.query.IFreightTemplateQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.AuditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DefaultValue;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.FreezeStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfMergeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IsBillingEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeviceType;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderProofConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ProblemOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ConfirmOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.GenerateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderCompareQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExcelDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RemarkOrderTagsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SubOrderPayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCreateRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderInvoiceRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.activity.OrderActivityRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.delivery.FactoryDeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.SplitOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.api.vo.OrderDeliverMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.vo.SalePersonMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.CreateOrderDeliveryOrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.OrderStatusChangeProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.OrderTradeStatusChangeProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.PerformanceProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IChannelService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderAddressService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryInfoService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderInvoiceService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IScheduleService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareDistributionService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareRegisterDistributionService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeConfQueryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.OrderAuditService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderStockService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.impl.RebateHelper;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanCopierUtils;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.DistributionUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ExcelParseObjectUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ResponseUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderInvoiceDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderPromotionDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderSalePersonDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ProblemOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ProblemTradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefTradeInvoiceDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderActivityEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderInvoiceEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderPromotionEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderSalePersonEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ProblemOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ProblemTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefTradeInvoiceEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderCompareVo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderQueryVo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderStatusCountVo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.split.proxy.ISplitProxyService;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserInfoQueryApi;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.OrderInvoiceReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.PayReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.TradeReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

@Service(value="orderServiceImpl")
@Transactional(rollbackFor={Exception.class})
public class OrderServiceImpl
implements IOrderService {
    private static Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private IBalanceApi iBalanceApi;
    @Resource
    private OrderDas orderDas;
    @Resource
    private OrderAddressDas orderAddressDas;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private OrderInvoiceDas orderInvoiceDas;
    @Resource
    private RefTradeInvoiceDas refTradeInvoiceDas;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    ITradeService iTradeService;
    @Resource
    private IScheduleService scheduleService;
    @Resource
    private IPayService payService;
    @Resource
    private ITradeService tradeService;
    @Resource
    private OrderStatusChangeProducer orderStatusChangeProducer;
    @Resource
    private OrderTradeStatusChangeProducer orderTradeStatusChangeProducer;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    private ISplitProxyService splitProxyService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private OrderSalePersonDas orderSalePersonDas;
    @Resource
    private OrderPromotionDas orderPromotionDas;
    @Resource
    private PayRecordDas payRecordDas;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IOrderService orderService;
    @Resource
    private PerformanceProducer performanceProducer;
    @Resource
    private IExtlOrderActivityService extlOrderActivityService;
    @Resource
    private IOrderAddressService orderAddressService;
    @Resource
    private IOrderInvoiceService orderInvoiceService;
    @Resource
    private IChannelService channelService;
    @Resource
    private IShareDistributionService shareDistributionService;
    @Resource
    protected ICacheService cacheService;
    @Resource
    private IOrderDeliveryInfoService orderDeliveryInfoService;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @CubeResource
    private IOrderCreateActionExtPt orderCreateActionExtPt;
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private IDeliveryService deliveryService;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private IAfterSalesService afterSalesService;
    @Resource
    private IExtlOrderStockService extlOrderStockService;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private IUserInfoQueryApi userInfoQueryApi;
    @Resource
    private IFreightTemplateQueryApi freightTemplateQueryApi;
    @Resource
    private Environment environment;
    @Resource
    private OrderAuditService orderAuditService;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ILockService lockService;
    @Resource
    private IShareRegisterDistributionService shareRegisterDistributionService;
    @Resource
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Autowired
    private IDirectoryQueryApi directoryQueryApi;
    @Autowired
    private IItemRelationComparisonQueryApi itemRelationComparisonQueryApi;
    @Autowired
    private ProblemOrderDas problemOrderDas;
    @Autowired
    private ProblemTradeItemDas problemTradeItemDas;
    @Resource
    private ITradeConfQueryService tradeConfQueryService;
    @Autowired
    private DistributionUtil distributionUtil;
    @Resource
    private IRuleQueryApi rebateRuleQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IGiftConfigQueryApi giftConfigQueryApi;
    @Autowired
    private IDeliveryOrderService deliveryOrderService;
    @Autowired
    private RebateHelper rebateHelper;

    @Override
    public PageInfo<OrderBizRespDto> queryByPageForBizResp(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        PageInfo<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> orderRespDtoPageInfo = this.orderService.queryByPageForResp(orderQueryReq, pageNum, pageSize);
        if (orderRespDtoPageInfo == null) {
            return null;
        }
        if (orderRespDtoPageInfo.getList() == null) {
            PageInfo pageInfo = new PageInfo();
            BeanUtils.copyProperties(orderRespDtoPageInfo, (Object)pageInfo);
            return pageInfo;
        }
        ArrayList<OrderBizRespDto> bizRespDtos = new ArrayList<OrderBizRespDto>();
        CubeBeanUtils.copyCollection(bizRespDtos, (Collection)orderRespDtoPageInfo.getList(), OrderBizRespDto.class);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(orderRespDtoPageInfo, (Object)pageInfo);
        pageInfo.setList(bizRespDtos);
        if (Boolean.TRUE.equals(orderQueryReq.getIfExport()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(bizRespDtos)) {
            this.orderService.fillDeliveryInfo(bizRespDtos);
        }
        return pageInfo;
    }

    @Override
    public OrderCountTobRespDto queryByPageOnPostCount(OrderQueryReqDto orderQueryReq) {
        List orderEoList;
        OrderCountTobRespDto respDto = new OrderCountTobRespDto();
        if (null == orderQueryReq.getOrderType()) {
            orderQueryReq.setIsSplit(DefaultValue.NO);
        } else if (OrderTypeEnum.CHILDREN_ORDER.getType().equals(orderQueryReq.getOrderType()) || OrderTypeEnum.PARENT_ORDER.getType().equals(orderQueryReq.getOrderType())) {
            orderQueryReq.setIsSplit(orderQueryReq.getOrderType());
        }
        OrderEo orderEo = OrderEo.newInstance();
        PageInfo pageInfo = this.buildCommonQueryForCountAndPage(orderQueryReq, orderEo, null, null);
        if (ObjectUtils.isEmpty((Object)pageInfo) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(orderEoList = this.orderDas.selectWithColumn((BaseEo)orderEo, new String[]{"order_trade_status"})))) {
            AtomicInteger deliveryCount = new AtomicInteger();
            Map<String, Long> groupMap = orderEoList.stream().collect(Collectors.groupingBy(StdOrderEo::getOrderTradeStatus, Collectors.counting()));
            HashMap groupIntMap = new HashMap();
            groupMap.forEach((k, v) -> {
                if (ObjectUtils.isNotEmpty((Object)v)) {
                    Integer num = Integer.valueOf(String.valueOf(v));
                    groupIntMap.put(k, num);
                    if (OrderBizStatusTobEnum.PART_DELIVERY.getCode().equals(k) || OrderBizStatusTobEnum.ALL_DELIVERY.getCode().equals(k) || OrderBizStatusTobEnum.PART_OUT_STORAGE.getCode().equals(k) || OrderBizStatusTobEnum.ALL_OUT_STORAGE.getCode().equals(k) || OrderBizStatusTobEnum.PART_CONFIRM.getCode().equals(k)) {
                        deliveryCount.getAndAdd(num);
                    }
                }
            });
            respDto.setWaitCsAuditCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.WAIT_CS_AUDIT.getCode()));
            respDto.setWaitFinanceAuditCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.WAIT_FINANCE_AUDIT.getCode()));
            respDto.setConfirmCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.CONFIRM.getCode()));
            respDto.setWaitOutStorageCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.WAIT_OUT_STORAGE.getCode()));
            respDto.setDraftCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.DRAFT.getCode()));
            respDto.setCancelCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.CANCEL.getCode()));
            respDto.setCloseCount((Integer)groupIntMap.get(OrderBizStatusTobEnum.CLOSE.getCode()));
            respDto.setDeliveryCount(Integer.valueOf(deliveryCount.get()));
            respDto.setAllCount(Integer.valueOf(orderEoList.size()));
            orderEo.setPayStatus(OrderTradeStatusEnum.WAIT_PAY.getCode());
            orderEo.setOrderStatus(OrderTradeStatusEnum.WAIT_PAY.getCode());
            int waitPayCount = this.orderDas.count((BaseEo)orderEo);
            respDto.setWaitPayCount(Integer.valueOf(waitPayCount));
        }
        return respDto;
    }

    @Override
    public PageInfo<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> queryByPageForResp(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        if (null == orderQueryReq.getOrderType()) {
            orderQueryReq.setIsSplit(DefaultValue.NO);
        } else if (OrderTypeEnum.CHILDREN_ORDER.getType().equals(orderQueryReq.getOrderType()) || OrderTypeEnum.PARENT_ORDER.getType().equals(orderQueryReq.getOrderType())) {
            orderQueryReq.setIsSplit(orderQueryReq.getOrderType());
        }
        List<Object> orderRepDtoList = Lists.newArrayList();
        PageInfo<OrderEo> pageInfo = this.queryByPage(orderQueryReq, pageNum, pageSize);
        PageInfo page = new PageInfo();
        CubeBeanUtils.copyProperties((Object)page, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            orderRepDtoList = this.getOrderRespDto(pageInfo.getList(), orderQueryReq.getIsContainItem(), orderQueryReq.getIfExport());
        }
        page.setList((List)orderRepDtoList);
        return page;
    }

    private List<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> batchFillItem(List<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> orderRepDtoList) {
        Set<String> orderNos = orderRepDtoList.stream().map(com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto::getOrderNo).collect(Collectors.toSet());
        List<TradeItemRespDto> tradeItemRespDtos = this.tradeItemService.queryByOrderNos(orderNos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tradeItemRespDtos)) {
            Map<String, List<TradeItemRespDto>> orderItemsMap = tradeItemRespDtos.stream().collect(Collectors.groupingBy(TradeItemRespDto::getTradeNo));
            orderRepDtoList.forEach(orderRespDto -> orderRespDto.setOrderItems((List)orderItemsMap.get(orderRespDto.getOrderNo())));
        }
        return orderRepDtoList;
    }

    private List<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> getOrderRespDto(List<OrderEo> orderEoList, Integer isContainItem, Boolean ifExport) {
        if (isContainItem == null) {
            isContainItem = DefaultValue.YES;
        }
        ArrayList<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> orderRepDtoList = new ArrayList<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto>();
        DtoHelper.eoList2DtoList(orderEoList, orderRepDtoList, com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto.class);
        orderRepDtoList.forEach(orderRespDto -> {
            ReturnEo returnEo;
            ChannelEo channelEo = this.channelService.queryByCode(orderRespDto.getSaleChannel());
            if (channelEo != null) {
                orderRespDto.setSaleChannel(channelEo.getName());
            }
            if (Objects.isNull(returnEo = this.returnDas.selectByOrderTradeNo(orderRespDto.getOrderNo()))) {
                orderRespDto.setIsApplyRefund("\u5426");
            } else if (ReturnStatusEnum.CANCELED.getName().equals(returnEo.getReturnStatus())) {
                orderRespDto.setIsApplyRefund("\u5426");
            } else {
                orderRespDto.setIsApplyRefund("\u662f");
            }
        });
        if (Boolean.TRUE.equals(ifExport)) {
            return this.batchFillItem(orderRepDtoList);
        }
        if (DefaultValue.YES.equals(isContainItem)) {
            orderRepDtoList.forEach(orderRespDto -> orderRespDto.setOrderItems(this.tradeItemService.queryDtoByTradeNo(orderRespDto.getOrderNo())));
        }
        return orderRepDtoList;
    }

    @Override
    public OrderCreateBo packOrderBaseDetailInfoForUpdate(OrderCreateBo baseInfoBo) {
        com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto = baseInfoBo.getOrderReqDto();
        String orderNo = orderReqDto.getOrderNo();
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrderEo order = this.orderDas.findByOrderNo(orderNo);
        DtoHelper.dto2Eo((BaseVo)orderReqDto, (BaseEo)order);
        if (StringUtils.isEmpty((CharSequence)order.getFrozenStatus())) {
            order.setFrozenStatus(FreezeStatusEnum.DEFAULT.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)order.getOrderStatus())) {
            order.setOrderStatus(OrderStatusEnum.INIT.getCode());
        }
        if (orderReqDto.getIsSplit() != null) {
            order.setIsSplit(orderReqDto.getIsSplit());
        } else {
            order.setIsSplit(DefaultValue.NO);
        }
        if (order.getPlaceTime() == null) {
            order.setPlaceTime(new Date());
        }
        baseInfoBo.setOrderEo(order);
        TradeItemEo tradeItemEo_query = TradeItemEo.newInstance();
        tradeItemEo_query.setTradeNo(orderNo);
        List select = this.tradeItemDas.select((BaseEo)tradeItemEo_query);
        List tradeItems = orderReqDto.getOrderItems();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeItems)) {
            List tradeItemEos = tradeItems.stream().map(t -> {
                TradeItemEo tradeItemEo = null;
                Optional<TradeItemEo> first = select.stream().filter(o -> o.getId() == t.getId() || o.getTradeItemNo() == t.getTradeItemNo()).findFirst();
                if (first.isPresent()) {
                    tradeItemEo = first.get();
                    DtoHelper.dto2Eo((BaseVo)t, (BaseEo)tradeItemEo);
                } else {
                    tradeItemEo = (TradeItemEo)EoUtil.dtoToEo((BaseVo)t, TradeItemEo.class);
                    tradeItemEo.setTradeItemNo(TradeUtil.generateTradeNo(orderReqDto.getTradeNo()));
                    tradeItemEo.setTradeNo(orderReqDto.getTradeNo());
                    tradeItemEo.setUserId(orderReqDto.getUserId());
                }
                if (Objects.isNull(tradeItemEo.getItemMarketPrice())) {
                    tradeItemEo.setItemMarketPrice(t.getItemPrice());
                }
                this.checkNullParams(tradeItemEo);
                return tradeItemEo;
            }).collect(Collectors.toList());
            baseInfoBo.setTradeItemEoList(tradeItemEos);
        }
        orderReqDto.getDeliveryAddress().setPickupType(orderReqDto.getPickupType());
        orderReqDto.getDeliveryAddress().setShippingType(orderReqDto.getShippingType());
        orderReqDto.getDeliveryAddress().setWarehouseSerial(orderReqDto.getWarehouseSerial());
        order.setDeliveryAddress(JSON.toJSONString((Object)orderReqDto.getDeliveryAddress()));
        OrderAddressEo orderAddressEo_query = OrderAddressEo.newInstance();
        orderAddressEo_query.setOrderNo(orderNo);
        OrderAddressEo orderAddressEo = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)orderAddressEo_query);
        if (orderAddressEo != null) {
            DtoHelper.dto2Eo((BaseVo)orderReqDto.getDeliveryAddress(), (BaseEo)orderAddressEo);
        } else {
            orderAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)orderReqDto.getDeliveryAddress(), OrderAddressEo.class);
            if (null != orderReqDto.getShippingType() && ShippingTypeEnum.getByType((String)orderReqDto.getShippingType()) != null) {
                orderAddressEo.setDeliveryType(Integer.valueOf(ShippingTypeEnum.getByType((String)orderReqDto.getShippingType()).getCode()));
            }
            orderAddressEo.setOrderNo(order.getOrderNo());
            orderAddressEo.setId(null);
        }
        baseInfoBo.setOrderAddressEo(orderAddressEo);
        baseInfoBo.setOrderEo(order);
        return baseInfoBo;
    }

    @Override
    public void saveOrderBaseDetailInfoForUpdate(OrderCreateBo orderCreateBo) {
        this.orderDas.update((BaseEo)orderCreateBo.getOrderEo());
        this.cacheService.delCache("order_address" + orderCreateBo.getOrderEo().getOrderNo());
        this.orderAddressDas.update((BaseEo)orderCreateBo.getOrderAddressEo());
        this.cacheService.delCache("order_item_list_" + orderCreateBo.getOrderEo().getOrderNo());
        TradeItemEo tradeItemEo = TradeItemEo.newInstance();
        tradeItemEo.setTradeNo(orderCreateBo.getOrderEo().getOrderNo());
        this.tradeItemDas.delete((BaseEo)tradeItemEo);
        this.tradeItemService.setCatalogNames(orderCreateBo.getTradeItemEoList());
        this.tradeItemDas.insertBatch(orderCreateBo.getTradeItemEoList());
    }

    private OrderServiceImpl aopProxy() {
        return (OrderServiceImpl)AopContext.currentProxy();
    }

    @Override
    public void refundCancelOrder(OrderEo orderEo, CancelReqDto cancelReq) {
        List<PayRecordEo> payRecordEos = this.payService.getPayRecordSuccessByOrderNo(orderEo.getOrderNo());
        RefundEo refundEo = new RefundEo();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(payRecordEos)) {
            return;
        }
        PayRecordEo payRecordEo = payRecordEos.get(0);
        if (StringUtils.isNotEmpty((CharSequence)payRecordEo.getParentPayNo()) && !payRecordEo.getParentPayNo().equals("0")) {
            payRecordEo = this.payService.getPayRecordByTradeNo(payRecordEo.getParentPayNo());
        }
        refundEo.setPayMethod(payRecordEo.getPayMethod());
        Optional.ofNullable(payRecordEo).map(p -> {
            if (!(p.getPayStatus().equals(PayStatusEnum.SUCCESS.getName()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getMsg()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getCode()))) {
                throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getMsg());
            }
            return p;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
        refundEo.setRefundTime(new Date());
        refundEo.setRefundPaymentType("1");
        refundEo.setRefundNo(TradeUtil.generateTradeNo());
        refundEo.setTradeNo(refundEo.getRefundNo());
        refundEo.setPayNo(payRecordEo.getPayNo());
        refundEo.setInstanceId(payRecordEo.getInstanceId());
        refundEo.setTenantId(payRecordEo.getTenantId());
        refundEo.setCreateTime(new Date());
        refundEo.setRefundFreightAmount(orderEo.getFreightAmount());
        if (orderEo.getFreightAmount() != null) {
            refundEo.setRefundItemAmount(payRecordEo.getPayAmount().subtract(orderEo.getFreightAmount()));
        } else {
            refundEo.setRefundItemAmount(payRecordEo.getPayAmount());
        }
        refundEo.setRefundTotalAmount(payRecordEo.getPayAmount());
        refundEo.setDiscountRefundAmount(new BigDecimal(0));
        refundEo.setRefundType(RefundTypeEnum.REFUND_CANCEl.getName());
        refundEo.setFlowDefId(orderEo.getFlowDefId());
        PayRefundReqDto payRefundReqDto = new PayRefundReqDto();
        BeanUtils.copyProperties((Object)refundEo, (Object)payRefundReqDto);
        payRefundReqDto.setAmount(refundEo.getRefundTotalAmount());
        payRefundReqDto.setExtlPaySerial(payRecordEo.getExtlPaySerial());
        payRefundReqDto.setUserId(payRecordEo.getUserId());
        try {
            logger.info("\u8ba2\u5355\u53f7{}\u53d1\u8d77\u9000\u6b3e\u8bf7\u6c42", (Object)orderEo.getOrderNo());
            RefundResponse response = this.payService.createRefundOrder(payRefundReqDto);
            if (!"0".equals(response.getResultCode())) {
                logger.error("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25{}", (Object)JSON.toJSONString((Object)response));
                throw new BizException(response.getResultCode(), response.getResultMsg());
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u53f7{}\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", (Object)orderEo.getOrderNo(), (Object)e);
            throw new BizException("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        refundEo.setRefundStatus(RefundStatusEnum.SUCCESS.getName());
        this.payService.saveInitRefund(refundEo, orderEo);
    }

    @Override
    public void refundloseOrder(OrderEo orderEo, CancelReqDto closeReqDto) {
        List<PayRecordEo> payRecordEos = this.payService.getPayRecordSuccessByOrderNo(orderEo.getOrderNo());
        RefundEo refundEo = new RefundEo();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(payRecordEos)) {
            return;
        }
        PayRecordEo payRecordEo = payRecordEos.get(0);
        if (StringUtils.isNotEmpty((CharSequence)payRecordEo.getParentPayNo()) && !payRecordEo.getParentPayNo().equals("0")) {
            payRecordEo = this.payService.getPayRecordByTradeNo(payRecordEo.getParentPayNo());
        }
        refundEo.setPayMethod(payRecordEo.getPayMethod());
        Optional.ofNullable(payRecordEo).map(p -> {
            if (!(p.getPayStatus().equals(PayStatusEnum.SUCCESS.getName()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getMsg()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getCode()))) {
                throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getMsg());
            }
            return p;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
        refundEo.setRefundTime(new Date());
        refundEo.setRefundPaymentType("1");
        refundEo.setRefundNo(TradeUtil.generateTradeNo());
        refundEo.setTradeNo(refundEo.getRefundNo());
        refundEo.setPayNo(payRecordEo.getPayNo());
        refundEo.setInstanceId(payRecordEo.getInstanceId());
        refundEo.setTenantId(payRecordEo.getTenantId());
        refundEo.setCreateTime(new Date());
        refundEo.setRefundFreightAmount(orderEo.getFreightAmount());
        if (orderEo.getFreightAmount() != null) {
            refundEo.setRefundItemAmount(payRecordEo.getPayAmount().subtract(orderEo.getFreightAmount()));
        } else {
            refundEo.setRefundItemAmount(payRecordEo.getPayAmount());
        }
        refundEo.setRefundTotalAmount(payRecordEo.getPayAmount());
        refundEo.setDiscountRefundAmount(new BigDecimal(0));
        refundEo.setRefundType(RefundTypeEnum.REFUND_CANCEl.getName());
        refundEo.setFlowDefId(orderEo.getFlowDefId());
        PayRefundReqDto payRefundReqDto = new PayRefundReqDto();
        BeanUtils.copyProperties((Object)refundEo, (Object)payRefundReqDto);
        payRefundReqDto.setAmount(refundEo.getRefundTotalAmount());
        payRefundReqDto.setExtlPaySerial(payRecordEo.getExtlPaySerial());
        payRefundReqDto.setUserId(payRecordEo.getUserId());
        try {
            logger.info("\u8ba2\u5355\u53f7{}\u53d1\u8d77\u9000\u6b3e\u8bf7\u6c42", (Object)orderEo.getOrderNo());
            RefundResponse response = this.payService.createRefundOrder(payRefundReqDto);
            if (!"0".equals(response.getResultCode())) {
                logger.error("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25{}", (Object)JSON.toJSONString((Object)response));
                throw new BizException(response.getResultCode(), response.getResultMsg());
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u53f7{}\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", (Object)orderEo.getOrderNo(), (Object)e);
            throw new BizException("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        refundEo.setRefundStatus(RefundStatusEnum.SUCCESS.getName());
        this.payService.saveInitRefund(refundEo, orderEo);
    }

    @Override
    public List<OrderEo> addSynOrder(List<TradeReqDto> tradeReqDtoList) {
        ArrayList<OrderEo> orderEos = new ArrayList<OrderEo>();
        for (TradeReqDto tradeReqDto : tradeReqDtoList) {
            orderEos.addAll(this.handleSyncOrder(tradeReqDto));
        }
        this.sendDeliveryMsg(orderEos);
        return orderEos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OrderEo> handleSyncOrder(TradeReqDto tradeReqDto) {
        List<OrderEo> orderEos;
        ArrayList orderAddressEoList;
        ArrayList tradeItemEoList;
        Mutex mutex;
        block9: {
            String channel;
            List reqDtoOrder;
            block8: {
                List list;
                logger.info("\u8ba2\u5355\u540c\u6b65mq\u63a5\u6536\u6570\u636e\u662f\uff1a{}", (Object)JSON.toJSONString((Object)tradeReqDto));
                reqDtoOrder = tradeReqDto.getOrder();
                Map extendProps = tradeReqDto.getExtendProps();
                channel = extendProps.getOrDefault("channel", "");
                Assert.isTrue(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqDtoOrder), "\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a");
                OrderReqDto orderReqDto = (OrderReqDto)reqDtoOrder.get(0);
                mutex = null;
                try {
                    mutex = this.lockService.lock("SYNC_ORDER", orderReqDto.getThirdOrderNo());
                    if (null == mutex) {
                        throw new RuntimeException("\u8ba2\u5355\u540c\u6b65\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                    }
                    List thirdOrderNo = this.orderDas.select(SqlFilterBuilder.create(OrderEo.class).in("third_order_no", (Object)StringUtils.join((Iterable)reqDtoOrder.stream().map(OrderReqDto::getThirdOrderNo).collect(Collectors.toList()), (String)",")).eo());
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)thirdOrderNo)) break block8;
                    logger.info("\u8ba2\u5355\u540c\u6b65\u91cd\u590d\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\uff0c\u76f4\u63a5\u8fd4\u56de");
                    list = thirdOrderNo;
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                return list;
            }
            logger.info("\u8ba2\u5355\u540c\u6b65\u4e0d\u91cd\u590d\uff0c\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c");
            tradeItemEoList = Lists.newArrayList();
            orderAddressEoList = Lists.newArrayList();
            orderEos = reqDtoOrder.stream().map(r -> {
                OrderEo orderEo = (OrderEo)EoUtil.dtoToEo((BaseVo)r, OrderEo.class);
                String orderNo = TradeUtil.generateTradeNo();
                orderEo.setOrderNo(orderNo);
                orderEo.setTradeNo(orderNo);
                orderEo.setDeviceType(channel);
                orderEo.setSaleChannel(channel);
                if ("TRUE".equals(this.orderAuditService.isNeedAudit(tradeReqDto))) {
                    orderEo.setOrderStatus(OrderStatusEnum.WAIT_AUDIT.getCode());
                    orderEo.setOrderTradeStatus(OrderStatusEnum.WAIT_AUDIT.getCode());
                } else {
                    orderEo.setOrderStatus(OrderStatusEnum.WAIT_DELIVERY.getCode());
                    orderEo.setOrderTradeStatus(OrderStatusEnum.WAIT_DELIVERY.getCode());
                }
                orderEo.setBizStatus(OrderProofConstant.ENABLED.toString());
                orderEo.setBizType(OrderBizTypeEnum.COMMERCEORDER.getType().toString());
                if (StringUtils.isNotBlank((CharSequence)r.getBizType())) {
                    orderEo.setBizType(r.getBizType());
                }
                orderEo.setFrozenStatus(FreezeStatusEnum.DEFAULT.getCode());
                orderEo.setAuditType(AuditRecordStatusEnum.INIT.getCode());
                if (orderEo.getFreightAmount() == null) {
                    orderEo.setFreightAmount(BigDecimal.ZERO);
                }
                orderEo.setPlatformDiscountAmount(BigDecimal.ZERO);
                orderEo.setShopDiscountAmount(BigDecimal.ZERO);
                orderEo.setIntegral(Integer.valueOf(null == r.getIntegral() ? 0 : r.getIntegral()));
                orderEo.setPointCoupon(Integer.valueOf(0));
                orderEo.setChangeTime(new Date());
                orderEo.setCancelType(OrderCancelTypeEnum.NOT_CANCELLED.getName());
                orderEo.setAllAmount(null == r.getTotalAmount() ? BigDecimal.ZERO : r.getTotalAmount());
                orderEo.setDiscountMargin(BigDecimal.ZERO);
                orderEo.setDiscountAmount(null == r.getDiscountAmount() ? BigDecimal.ZERO : r.getDiscountAmount());
                orderEo.setHasDeliveryAddress(Integer.valueOf(null == r.getHasDeliveryAddress() ? 0 : r.getHasDeliveryAddress()));
                orderEo.setIsUrgent(Integer.valueOf(0));
                orderEo.setInvoiceFlag(Integer.valueOf(0));
                orderEo.setDeliveryTime(new Date());
                orderEo.setReceiveTime(new Date());
                orderEo.setPayTime(null == r.getPayTime() ? new Date() : r.getPayTime());
                orderEo.setCashOnDelivery(Integer.valueOf(0));
                if (OrderDeviceType.DRP.getCode().equals(r.getSaleChannel())) {
                    orderEo.setIsSplit(Integer.valueOf(0));
                }
                orderEo.setIsSplit(Integer.valueOf(0));
                orderEo.setShopCode(r.getShopCode());
                OrderAddressEo orderAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)tradeReqDto.getAddressReqDto(), OrderAddressEo.class);
                orderAddressEo.setOrderNo(orderNo);
                orderAddressEoList.add(orderAddressEo);
                orderEo.setDeliveryAddress(JSON.toJSONString((Object)orderAddressEo));
                orderEo.setBusType(Integer.valueOf(0));
                orderEo.setIsCycleBuy(Integer.valueOf(0));
                orderEo.setOrganizationId(r.getOrganizationId());
                orderEo.setOrganizationName(r.getOrganizationName());
                ShopDto shopDto = null;
                ShopQueryReqDto shopQueryReqDto = new ShopQueryReqDto();
                shopQueryReqDto.setCodes(Arrays.asList(r.getShopCode()));
                logger.info("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)shopQueryReqDto));
                List shopDtos = (List)ResponseUtil.getSuccessResult(this.shopQueryApi.queryShopByCode(shopQueryReqDto));
                logger.info("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)shopQueryReqDto), (Object)JSONObject.toJSONString((Object)shopDtos));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDtos)) {
                    shopDto = (ShopDto)shopDtos.get(0);
                }
                orderEo.setShopId(shopDto != null ? String.valueOf(shopDto.getId()) : null);
                orderEo.setShopName(shopDto != null ? shopDto.getName() : r.getShopName());
                orderEo.setTenantId(Long.valueOf(shopDto != null ? shopDto.getTenantId() : -1L));
                orderEo.setInstanceId(Long.valueOf(shopDto != null ? shopDto.getInstanceId() : -1L));
                orderEo.setSellerId(shopDto != null ? String.valueOf(shopDto.getSellerId()) : "");
                List<TradeItemEo> tradeItemEos = this.getTradeItemEos((OrderReqDto)r, orderNo, shopDto, channel);
                tradeItemEoList.addAll(tradeItemEos);
                return orderEo;
            }).collect(Collectors.toList());
            List<Map<String, Object>> errorList = tradeItemEoList.stream().filter(tradeItemEo -> {
                Map extFields = tradeItemEo.getExtFields();
                return MapUtils.isNotEmpty((Map)extFields) && extFields.get("errorMsg") != null;
            }).map(BaseEo::getExtFields).collect(Collectors.toList());
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) break block9;
            this.saveProblemOrder(tradeReqDto, reqDtoOrder, tradeItemEoList, orderEos, errorList);
            List<OrderEo> list = this.handleRetryErrorMsg(errorList);
            this.lockService.unlock(mutex);
            return list;
        }
        this.orderDas.insertBatch(orderEos);
        this.orderAddressDas.insertBatch((List)orderAddressEoList);
        logger.info("\u4fdd\u5b58tr_order\u8868\u6210\u529f\u3002");
        this.orderService.setCargoCodeBySkuId(tradeItemEoList);
        this.tradeItemDas.insertBatch((List)tradeItemEoList);
        logger.info("\u4fdd\u5b58tr_trade_item\u8868\u6210\u529f\u3002");
        String parentOrderNo = orderEos.get(0).getThirdParentOrderNo();
        if (OrderDeviceType.DRP.getCode().equals(orderEos.get(0).getDeviceType())) {
            parentOrderNo = orderEos.get(0).getThirdOrderNo();
        }
        String orderNo = orderEos.get(0).getOrderNo();
        String shopCode = orderEos.get(0).getShopCode();
        OrderAddressEo orderAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)tradeReqDto.getAddressReqDto(), OrderAddressEo.class);
        if (null != orderAddressEo) {
            orderAddressEo.setOrderNo(parentOrderNo);
            this.orderAddressDas.insert((BaseEo)orderAddressEo);
            logger.info("\u4fdd\u5b58tr_order_address\u8868\u6210\u529f\u3002");
        }
        this.handlePay(tradeReqDto, orderNo, shopCode);
        this.handleSalePerson(tradeReqDto, orderNo);
        this.handlePromotion(tradeReqDto, orderNo, shopCode);
        this.handleInvoice(tradeReqDto, orderNo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeReqDto.getStorageChangeReqDtos())) {
            // empty if block
        }
        this.handlePerformance(tradeReqDto, orderEos, orderNo);
        logger.info("\u5904\u7406\u5947\u95e8\u540c\u6b65\u8ba2\u5355\u5b8c\u6bd5\u3002");
        List<OrderEo> list = orderEos;
        this.lockService.unlock(mutex);
        return list;
    }

    private List<OrderEo> handleRetryErrorMsg(List<Map<String, Object>> errorList) {
        ArrayList<OrderEo> orderEosError = new ArrayList<OrderEo>();
        for (Map<String, Object> stringObjectMap : errorList) {
            OrderEo orderEo = new OrderEo();
            orderEo.setExtFields(stringObjectMap);
            orderEosError.add(orderEo);
        }
        return orderEosError;
    }

    private void saveProblemOrder(TradeReqDto tradeReqDto, List<OrderReqDto> reqDtoOrder, List<TradeItemEo> tradeItemEoList, List<OrderEo> orderEos, List<Map<String, Object>> errorList) {
        List errorMsg = errorList.stream().map(element -> element.get("errorMsg")).collect(Collectors.toList());
        String problemReason = StringUtils.join((Iterable)errorMsg.stream().map(str -> str.toString()).collect(Collectors.toList()), (String)"|");
        List problemOrderEosRepeat = this.problemOrderDas.select(SqlFilterBuilder.create(ProblemOrderEo.class).in("third_order_no", (Object)StringUtils.join((Iterable)reqDtoOrder.stream().map(OrderReqDto::getThirdOrderNo).collect(Collectors.toList()), (String)",")).eo());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)problemOrderEosRepeat)) {
            logger.info("\u5f02\u5e38\u5355\u5904\u7406\u91cd\u590d\uff0c\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7\uff1a{}\uff0c\u66f4\u65b0\u5f02\u5e38\u8bf4\u660e", (Object)((OrderReqDto)tradeReqDto.getOrder().get(0)).getThirdOrderNo());
            for (ProblemOrderEo problemOrderEo : problemOrderEosRepeat) {
                ProblemOrderEo problemOrderEoUpdate = new ProblemOrderEo();
                problemOrderEoUpdate.setId(problemOrderEo.getId());
                problemOrderEoUpdate.setProblemReason(problemReason);
                this.problemOrderDas.updateSelective((BaseEo)problemOrderEoUpdate);
            }
        } else {
            ArrayList problemOrderEos = new ArrayList();
            CubeBeanUtils.copyCollection(problemOrderEos, orderEos, ProblemOrderEo.class);
            for (ProblemOrderEo problemOrderEo : problemOrderEos) {
                problemOrderEo.setDatagramInfo(JSONObject.toJSONString((Object)tradeReqDto));
                problemOrderEo.setOrderStatus(ProblemOrderStatusEnum.PENDING.getCode());
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(errorMsg)) continue;
                problemOrderEo.setProblemReason(problemReason);
            }
            this.problemOrderDas.insertBatch(problemOrderEos);
            ArrayList problemTradeItemEos = new ArrayList();
            CubeBeanUtils.copyCollection(problemTradeItemEos, tradeItemEoList, ProblemTradeItemEo.class);
            this.problemTradeItemDas.insertBatch(problemTradeItemEos);
        }
    }

    private void handlePerformance(TradeReqDto tradeReqDto, List<OrderEo> orderEos, String orderNo) {
        if (OrderDeviceType.DRP.getCode().equals(orderEos.get(0).getDeviceType()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeReqDto.getSalePersonReqDtos())) {
            List salePersonMessageVos = tradeReqDto.getSalePersonReqDtos().stream().map(bean -> {
                SalePersonMessageVo salePersonMessageVo = new SalePersonMessageVo();
                salePersonMessageVo.setEmployeeNo(bean.getSellerCode());
                salePersonMessageVo.setSellerName(bean.getSellerName());
                salePersonMessageVo.setWeight(bean.getWeight());
                return salePersonMessageVo;
            }).collect(Collectors.toList());
            OrderDeliverMessageVo messageVo = new OrderDeliverMessageVo();
            messageVo.setOrderNo(orderNo);
            messageVo.setDeliverStatus(DeliverStatusEnum.SALE_ORDER.getCode());
            messageVo.setActualMoney(orderEos.get(0).getPayAmount());
            messageVo.setSalePersonMessageVoList(salePersonMessageVos);
            this.performanceProducer.sendPerformance(messageVo);
        }
    }

    private void handleInvoice(TradeReqDto tradeReqDto, String parentOrderNo) {
        List orderInvoiceReqDtos = tradeReqDto.getOrderInvoiceReqDtos();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderInvoiceReqDtos)) {
            ArrayList refTradeInvoiceEoList = Lists.newArrayList();
            ArrayList orderInvoiceEos = Lists.newArrayList();
            for (OrderInvoiceReqDto orderInvoiceReqDto : orderInvoiceReqDtos) {
                String invoiceNo = TradeUtil.generateTradeNo(parentOrderNo);
                RefTradeInvoiceEo refTradeInvoiceEo = new RefTradeInvoiceEo();
                refTradeInvoiceEo.setTradeNo(parentOrderNo);
                refTradeInvoiceEo.setInvoiceNo(invoiceNo);
                refTradeInvoiceEoList.add(refTradeInvoiceEo);
                OrderInvoiceEo orderInvoiceEo = (OrderInvoiceEo)EoUtil.dtoToEo((BaseVo)orderInvoiceReqDto, OrderInvoiceEo.class);
                orderInvoiceEo.setInvoiceNo(invoiceNo);
                orderInvoiceEos.add(orderInvoiceEo);
            }
            this.orderInvoiceDas.insertBatch((List)orderInvoiceEos);
            this.refTradeInvoiceDas.insertBatch((List)refTradeInvoiceEoList);
        }
    }

    private void handlePromotion(TradeReqDto tradeReqDto, String orderNo, String shopCode) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeReqDto.getPromotionReqDtos())) {
            List<OrderPromotionEo> orderPromotionEos = BeanUtil.copyList(tradeReqDto.getPromotionReqDtos(), OrderPromotionEo.class);
            orderPromotionEos.stream().forEach(bean -> {
                bean.setOrderNo(orderNo);
                bean.setShopCode(shopCode);
            });
            this.orderPromotionDas.insertBatch(orderPromotionEos);
        }
    }

    private void handlePay(TradeReqDto tradeReqDto, String orderNo, String shopCode) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeReqDto.getPayReqDtos())) {
            for (PayReqDto payReqDto : tradeReqDto.getPayReqDtos()) {
                PayRecordEo payRecordEo = (PayRecordEo)EoUtil.dtoToEo((BaseVo)payReqDto, PayRecordEo.class);
                payRecordEo.setPayFinishTime(null == payReqDto.getPayTime() ? new Date() : payReqDto.getPayTime());
                payRecordEo.setPayNo("0");
                payRecordEo.setOrderNo(orderNo);
                payRecordEo.setPayStartTime(null == payReqDto.getPayTime() ? new Date() : payReqDto.getPayTime());
                payRecordEo.setShopCode(shopCode);
                payRecordEo.setTradeNo("0");
                if (StringUtils.isBlank((CharSequence)payReqDto.getPayStatus())) {
                    payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
                }
                payRecordEo.setRefundAmount(BigDecimal.ZERO);
                payRecordEo.setTenantId(Long.valueOf(0L));
                payRecordEo.setInstanceId(Long.valueOf(0L));
                payRecordEo.setUserId("0");
                payRecordEo.setCreatePerson("0");
                payRecordEo.setCreateTime(new Date());
                payRecordEo.setUpdatePerson("0");
                this.payRecordDas.insertPayRecord(payRecordEo);
            }
        }
    }

    private void handleSalePerson(TradeReqDto tradeReqDto, String orderNo) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeReqDto.getSalePersonReqDtos())) {
            List<OrderSalePersonEo> salePersonReqDtos = BeanUtil.copyList(tradeReqDto.getSalePersonReqDtos(), OrderSalePersonEo.class);
            salePersonReqDtos.stream().forEach(bean -> bean.setOrderNo(orderNo));
            this.orderSalePersonDas.insertBatch(salePersonReqDtos);
        }
    }

    private List<TradeItemEo> getTradeItemEos(OrderReqDto orderReqDto, String orderNo, ShopDto shopDto, String channelCode) {
        logger.info("\u5904\u7406\u5546\u54c1\u5217\u8868\u5f00\u59cb\uff0corderNo\uff1a{}", (Object)orderNo);
        ChannelCodeEnum channelByCode = ChannelCodeEnum.getChannelByCode((String)channelCode);
        ArrayList<TradeItemEo> tradeItemEos = new ArrayList<TradeItemEo>();
        List tradeItemReqDtos = orderReqDto.getTradeItemReqDto();
        for (TradeItemReqDto itemReqDto : tradeItemReqDtos) {
            List itemRelationComparisonRespDtos;
            TradeItemEo tradeItemEo = (TradeItemEo)EoUtil.dtoToEo((BaseVo)itemReqDto, TradeItemEo.class);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("imgPath", (Object)itemReqDto.getPicPath());
            tradeItemEo.setExtension(jsonObject.toJSONString());
            tradeItemEo.setShopId(shopDto != null ? String.valueOf(shopDto.getId()) : null);
            tradeItemEo.setTenantId(Long.valueOf(shopDto != null ? shopDto.getTenantId() : -1L));
            tradeItemEo.setInstanceId(Long.valueOf(shopDto != null ? shopDto.getInstanceId() : -1L));
            String channelItemCode = itemReqDto.getItemCode();
            String channelSkuCode = itemReqDto.getSkuCode();
            HashMap<String, String> errorMap = new HashMap<String, String>(1);
            if (StringUtils.isBlank((CharSequence)channelItemCode)) {
                errorMap.put("errorMsg", String.format("\u6e20\u9053\u5546\u54c1\uff1a%s\uff0c\u6e20\u9053\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728", itemReqDto.getItemName()));
                tradeItemEo.setExtFields(errorMap);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(itemRelationComparisonRespDtos = (List)ResponseUtil.getSuccessResult(this.itemRelationComparisonQueryApi.queryByParam(channelCode, channelItemCode, channelSkuCode))))) {
                errorMap.put("errorMsg", String.format("\u6e20\u9053\u5546\u54c1\uff1a%s\uff0c\u672a\u5339\u914d\u5230\u5168\u6e20\u9053\u8fd0\u8425\u5e73\u53f0\u5546\u54c1\uff0c\u8bf7\u5b8c\u5584\u5546\u54c1\u5bf9\u7167\uff0c\u6e20\u9053\u5546\u54c1\u7f16\u7801\uff1a%s\uff0c\u6e20\u9053SKU\u7f16\u7801\uff1a%s", itemReqDto.getItemName(), channelItemCode, channelSkuCode));
                tradeItemEo.setExtFields(errorMap);
            } else if (itemRelationComparisonRespDtos.size() > 1) {
                errorMap.put("errorMsg", String.format("\u6e20\u9053\u5546\u54c1\uff1a%s\uff0c\u5339\u914d\u5230\u5168\u6e20\u9053\u8fd0\u8425\u5e73\u53f0\u5546\u54c1\u5927\u4e8e\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u5bf9\u7167\uff0c\u6e20\u9053\u5546\u54c1\u7f16\u7801\uff1a%s\uff0c\u6e20\u9053SKU\u7f16\u7801\uff1a%s", itemReqDto.getItemName(), channelItemCode, channelSkuCode));
                tradeItemEo.setExtFields(errorMap);
            }
            if (MapUtils.isEmpty(errorMap)) {
                ItemRelationComparisonRespDto itemRelationComparisonRespDto = (ItemRelationComparisonRespDto)itemRelationComparisonRespDtos.get(0);
                this.setTradeItemInfo(itemReqDto, tradeItemEo, itemRelationComparisonRespDto);
            } else {
                tradeItemEo.setItemCode(null);
                tradeItemEo.setSkuSerial(null);
                tradeItemEo.setSkuCode(null);
                tradeItemEo.setSkuDesc(itemReqDto.getSkuName());
            }
            tradeItemEo.setTradeNo(orderNo);
            tradeItemEo.setTradeItemNo(TradeUtil.generateTradeNo(orderNo));
            tradeItemEo.setParentOrderNo(orderReqDto.getThirdParentOrderNo());
            tradeItemEo.setBusType(ItemBusTypeEnum.ORDINARY.getType());
            tradeItemEo.setCycleBuy(Boolean.valueOf(false));
            this.checkNullParams(tradeItemEo);
            tradeItemEos.add(tradeItemEo);
        }
        logger.info("\u5904\u7406\u5546\u54c1\u5217\u8868\u5f00\u59cb\uff0corderNo\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONArray.toJSONString(tradeItemEos));
        return tradeItemEos;
    }

    private void setTradeItemInfo(TradeItemReqDto itemReqDto, TradeItemEo tradeItemEo, ItemRelationComparisonRespDto itemRelationComparisonRespDto) {
        List<String> skuCodes;
        List itemSkuRespDtoList;
        String skuCode;
        String itemCode = itemRelationComparisonRespDto.getItemCode();
        RestResponse itemRespDtoRestResponse = this.itemQueryApi.queryByItemCode(itemCode);
        ItemRespDto itemRespDto = (ItemRespDto)ResponseUtil.getSuccessResult(itemRespDtoRestResponse);
        if (itemRespDto != null && itemRespDto.getId() != null) {
            tradeItemEo.setItemSerial(String.valueOf(itemRespDto.getId()));
            tradeItemEo.setItemCode(itemRespDto.getCode());
            ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(itemRespDto.getId(), "attributes,sku,medias", null).getData();
            tradeItemEo.setItemDetail(JSONObject.toJSONString((Object)itemDetailRespDto));
        }
        if (StringUtils.isNotBlank((CharSequence)(skuCode = itemRelationComparisonRespDto.getSkuCode())) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemSkuRespDtoList = (List)ResponseUtil.getSuccessResult(this.itemSkuQueryApi.queryBySkuCode(skuCodes = Arrays.asList(skuCode)))))) {
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemSkuRespDtoList.get(0);
            tradeItemEo.setSkuDesc(itemReqDto.getSkuName());
            tradeItemEo.setSkuSerial(String.valueOf(itemSkuRespDto.getId()));
            tradeItemEo.setSkuCode(itemSkuRespDto.getCode());
        }
    }

    private void sendDeliveryMsg(List<OrderEo> orderEos) {
        GenerateOrderReqDto generateOrderReqDto = new GenerateOrderReqDto();
        List orderNos = orderEos.stream().filter(orderEo -> OrderStatusEnum.WAIT_DELIVERY.getCode().equals(orderEo.getOrderStatus())).map(StdOrderEo::getOrderNo).collect(Collectors.toList());
        generateOrderReqDto.setOrderNos(orderNos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderNos)) {
            MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${GENERATE_DELIVERY_TOPIC:GENERATE_DELIVERY_TOPIC}"), this.environment.resolvePlaceholders("GENERATE_DELIVERY_TAG"), (Object)generateOrderReqDto);
            logger.info("\u53d1\u9001\u5168\u6e20\u9053\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355MQ\u6307\u4ee4\u5b8c\u6bd5\uff0cgenerateOrderReqDto\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)generateOrderReqDto), (Object)JSONObject.toJSONString((Object)messageResponse));
        }
    }

    private Long getOrderAddressId(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto) {
        if (orderReqDto.getDeliveryAddress() != null && orderReqDto.getDeliveryAddress().getId() != null) {
            return orderReqDto.getDeliveryAddress().getId();
        }
        return null;
    }

    @Override
    public com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto countFreight(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto) {
        Long addressId = this.getOrderAddressId(orderReqDto);
        if (addressId == null) {
            logger.info("\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u5730\u5740");
            return orderReqDto;
        }
        String shopId = ((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)orderReqDto.getOrderItems().get(0)).getShopId();
        ShopFreightCountReqDto countFreightDto = new ShopFreightCountReqDto();
        countFreightDto.setAddressId(addressId);
        countFreightDto.setShopId(Long.valueOf(Long.parseLong(shopId)));
        countFreightDto.setOrderPayAmount(orderReqDto.getPayAmount());
        OrderAddressReqDto deliveryAddress = orderReqDto.getDeliveryAddress();
        if (deliveryAddress != null) {
            countFreightDto.setAreaCode(deliveryAddress.getAreaCode());
            countFreightDto.setProvinceCode(deliveryAddress.getProvinceCode());
            countFreightDto.setCityCode(deliveryAddress.getCityCode());
        }
        ArrayList<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues = new ArrayList<ShopFreightCountReqDto.CountFreightItemValue>();
        for (com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto tradeItemReqDto : orderReqDto.getOrderItems()) {
            if (Integer.valueOf(1).equals(tradeItemReqDto.getGift())) continue;
            ShopFreightCountReqDto.CountFreightItemValue countFreightItemNumValue = new ShopFreightCountReqDto.CountFreightItemValue();
            countFreightItemNumValue.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_NUM);
            countFreightItemNumValue.setCountValue(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()));
            countFreightItemNumValue.setSkuId(tradeItemReqDto.getSkuSerial());
            countFreightItemNumValue.setFreightTemplateId(tradeItemReqDto.getFreightTemplateId());
            countFreightItemNumValue.setBackDirLabelName(tradeItemReqDto.getBackDirLabelName());
            countFreightItemNumValue.setBackDirLabelId(tradeItemReqDto.getBackDirLabelId());
            countFreightItemValues.add(countFreightItemNumValue);
            if (tradeItemReqDto.getWeight() != null) {
                ShopFreightCountReqDto.CountFreightItemValue countFreightItemWeightValue = new ShopFreightCountReqDto.CountFreightItemValue();
                countFreightItemWeightValue.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_WEIGHT);
                countFreightItemWeightValue.setCountValue(tradeItemReqDto.getWeight().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue())));
                if (UnitTypeEnum.WEIGHT_G.getTypeCode().equals(tradeItemReqDto.getWeightUnit())) {
                    countFreightItemWeightValue.setCountValue(countFreightItemWeightValue.getCountValue().divide(BigDecimal.valueOf(1000L)));
                }
                if (UnitTypeEnum.WEIGHT_MG.getTypeCode().equals(tradeItemReqDto.getWeightUnit())) {
                    countFreightItemWeightValue.setCountValue(countFreightItemWeightValue.getCountValue().divide(BigDecimal.valueOf(1000000L)));
                }
                if (UnitTypeEnum.WEIGHT_T.getTypeCode().equals(tradeItemReqDto.getWeightUnit())) {
                    countFreightItemWeightValue.setCountValue(countFreightItemWeightValue.getCountValue().multiply(BigDecimal.valueOf(1000L)));
                }
                countFreightItemWeightValue.setSkuId(tradeItemReqDto.getSkuSerial());
                countFreightItemWeightValue.setFreightTemplateId(tradeItemReqDto.getFreightTemplateId());
                countFreightItemValues.add(countFreightItemWeightValue);
            }
            if (tradeItemReqDto.getVolume() != null) {
                ShopFreightCountReqDto.CountFreightItemValue countFreightItemVolumeValue = new ShopFreightCountReqDto.CountFreightItemValue();
                countFreightItemVolumeValue.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_VOLUMN);
                countFreightItemVolumeValue.setCountValue(tradeItemReqDto.getVolume().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue())));
                if (UnitTypeEnum.VOLUME_DM3.getTypeCode().equals(tradeItemReqDto.getVolumeUnit())) {
                    countFreightItemVolumeValue.setCountValue(countFreightItemVolumeValue.getCountValue().divide(BigDecimal.valueOf(1000L)));
                }
                if (UnitTypeEnum.VOLUME_CM3.getTypeCode().equals(tradeItemReqDto.getVolumeUnit())) {
                    countFreightItemVolumeValue.setCountValue(countFreightItemVolumeValue.getCountValue().divide(BigDecimal.valueOf(1000000L)));
                }
                countFreightItemVolumeValue.setSkuId(tradeItemReqDto.getSkuSerial());
                countFreightItemVolumeValue.setFreightTemplateId(tradeItemReqDto.getFreightTemplateId());
                countFreightItemValues.add(countFreightItemVolumeValue);
            }
            ShopFreightCountReqDto.CountFreightItemValue countFreightItemAmountValue = new ShopFreightCountReqDto.CountFreightItemValue();
            countFreightItemAmountValue.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_AMOUNT);
            countFreightItemAmountValue.setCountValue(tradeItemReqDto.getPayTotalAmount());
            countFreightItemAmountValue.setSkuId(tradeItemReqDto.getSkuSerial());
            countFreightItemAmountValue.setFreightTemplateId(tradeItemReqDto.getFreightTemplateId());
            countFreightItemAmountValue.setBackDirLabelId(tradeItemReqDto.getBackDirLabelId());
            countFreightItemAmountValue.setBackDirLabelName(tradeItemReqDto.getBackDirLabelName());
            countFreightItemAmountValue.setItemNum(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()));
            countFreightItemAmountValue.setPrice(tradeItemReqDto.getPayTotalAmount());
            countFreightItemValues.add(countFreightItemAmountValue);
        }
        countFreightDto.setItemAttrValues(countFreightItemValues);
        logger.info("\u8ba1\u7b97\u8fd0\u8d39\u7684\u53c2\u6570:{}", (Object)JacksonUtil.toJson((Object)countFreightDto));
        if (countFreightDto.getFreightTemplateId() != null) {
            RestResponse bigDecimalRestResponse = this.freightTemplateQueryApi.queryCountFreight(countFreightDto);
            FreightCountRespDto freightCountRespDto = (FreightCountRespDto)ResponseUtil.getSuccessResult(bigDecimalRestResponse);
            orderReqDto.setPayAmount(orderReqDto.getPayAmount().add(freightCountRespDto.getFreight()));
            orderReqDto.setFreightAmount(freightCountRespDto.getFreight());
            orderReqDto.setStartingPric(freightCountRespDto.getStartingPric());
            orderReqDto.setFreightDes(freightCountRespDto.getFreeFreightDes());
            orderReqDto.setTotalAmount(orderReqDto.getTotalAmount());
        } else {
            orderReqDto.setFreightAmount(BigDecimal.ZERO);
            orderReqDto.setStartingPric(BigDecimal.ZERO);
        }
        return orderReqDto;
    }

    private List<Long> getDirListParent(Long dirId) {
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        Map<Long, String> dirMap = this.getDirParent(dirId);
        for (Map.Entry<Long, String> entry : dirMap.entrySet()) {
            dirIdList.add(entry.getKey());
        }
        Collections.reverse(dirIdList);
        return dirIdList;
    }

    private Map<Long, String> getDirParent(Long dirId) {
        DirectoryItemRespDto directoryRespDto;
        Long reqParam = dirId;
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        Long parentId = -1L;
        while (parentId != null && parentId != 0L && (parentId = (directoryRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(reqParam).getData()).getParentId()) != 0L) {
            resultMap.put(directoryRespDto.getId(), directoryRespDto.getName());
            reqParam = parentId;
        }
        return resultMap;
    }

    @Override
    public OrderSplitReqDto splitOrderAndCountFreight(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto order) {
        OrderSplitReqDto orderSplitReqDto = new OrderSplitReqDto();
        orderSplitReqDto.setParentOrderReqDto(order);
        if ("Y".equalsIgnoreCase(order.getIsSplitBySys())) {
            this.splitProxyService.splitOrder(orderSplitReqDto);
        }
        order.setFreightAmount(BigDecimal.ZERO);
        BigDecimal totalPayAmount = BigDecimal.ZERO;
        BigDecimal totalStartPrice = BigDecimal.ZERO;
        for (com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto : orderSplitReqDto.getChildrenOrderList()) {
            orderReqDto = this.orderService.countOrderAmount(orderReqDto);
            this.countFreight(orderReqDto);
            if (orderReqDto.getStartingPric() != null) {
                totalStartPrice = totalStartPrice.add(orderReqDto.getStartingPric());
            }
            if (order.getFreightAmount() != null && orderReqDto.getFreightAmount() != null) {
                order.setFreightAmount(order.getFreightAmount().add(orderReqDto.getFreightAmount()));
            }
            if (orderReqDto.getFreightAmount() == null) {
                orderReqDto.setFreightAmount(BigDecimal.ZERO);
            }
            Integer presentPoint = this.sumPresentPoint(orderReqDto.getOrderItems());
            orderReqDto.setPresentPoint(presentPoint);
            BigDecimal acTotalPay = orderReqDto.getPayAmount().subtract(orderReqDto.getFreightAmount());
            BigDecimal discountAmount = orderReqDto.getTotalAmount().subtract(acTotalPay);
            orderReqDto.setDiscountAmount(discountAmount);
            if (orderReqDto.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                orderReqDto.setPayAmount(new BigDecimal(0.0));
            }
            totalPayAmount = totalPayAmount.add(orderReqDto.getPayAmount());
        }
        if (order.getFreightAmount() == null) {
            order.setFreightAmount(BigDecimal.ZERO);
        }
        order.setStartingPric(totalStartPrice);
        BigDecimal acTotalPay = totalPayAmount.subtract(order.getFreightAmount());
        BigDecimal discountAmount = order.getTotalAmount().subtract(acTotalPay);
        order.setDiscountAmount(discountAmount);
        order.setPayAmount(totalPayAmount);
        return orderSplitReqDto;
    }

    @Override
    public Boolean isCreateDeliveryOrder(String orderNo) {
        OrderEo order = this.getByOrderNo(orderNo);
        if (order.getItemType() != null && ItemTypeEnum.VIRTUAL.getType().intValue() == order.getItemType().intValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isCreateDeliveryOrder(OrderEo orderEo) {
        if (orderEo.getItemType() != null && ItemTypeEnum.VIRTUAL.getType().intValue() == orderEo.getItemType().intValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isSplitOrder(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto order) {
        return this.splitProxyService.isSplitOrder(order);
    }

    @Override
    public OrderCreateRespDto addOrder(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderBo) {
        return this.aopProxy().addOrder(orderBo);
    }

    @Override
    public void modifyOrderStatus(String tradeNo, String orderNo, String status, String buyerRemark) {
        OrderEo orderEo = new OrderEo();
        orderEo.setBuyerRemark(buyerRemark);
        orderEo.setOrderStatus(status);
        if (OrderStatusEnum.SUCCESS.getCode().equals(status)) {
            orderEo.setEndTime(new Date());
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(StringUtils.isNotEmpty((CharSequence)tradeNo) ? SqlFilter.eq((String)"trade_no", (Object)tradeNo) : (orderNo.contains(",") ? SqlFilter.in((String)"order_no", (Object)orderNo) : SqlFilter.eq((String)"order_no", (Object)orderNo)));
        orderEo.setSqlFilters(sqlFilters);
        this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
        this.orderStatusChangeProducer.sendOrderStatusMqMessage(tradeNo, status);
    }

    @Override
    public void modifyOrderTradeStatus(String tradeNo, String orderNo, String status) {
        OrderEo orderEo = new OrderEo();
        orderEo.setOrderTradeStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(StringUtils.isNotEmpty((CharSequence)tradeNo) ? SqlFilter.eq((String)"trade_no", (Object)tradeNo) : (orderNo.contains(",") ? SqlFilter.in((String)"order_no", (Object)orderNo) : SqlFilter.eq((String)"order_no", (Object)orderNo)));
        orderEo.setSqlFilters(sqlFilters);
        if ("COMPLETE".equals(status)) {
            orderEo.setEndTime(new Date());
        }
        if ("CANCEL".equals(status)) {
            orderEo.setCancelTime(new Date());
        }
        if ("DELIVERY".equals(status)) {
            orderEo.setDeliveryTime(new Date());
            OrderEo order = this.orderDas.findByOrderNo(orderNo);
            if (order == null) {
                logger.info("===\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u72b6\u6001===");
                return;
            }
            if ("CONFIRM".equals(order.getOrderTradeStatus()) || "COMPLETE".equals(order.getOrderTradeStatus())) {
                logger.info("===\u8ba2\u5355\u72b6\u6001\u662f\u5df2\u7b7e\u6536\u6216\u5df2\u5b8c\u6210\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u5df2\u53d1\u8d27\u72b6\u6001===");
                return;
            }
        }
        this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
        this.orderTradeStatusChangeProducer.sendMqMessage((String)StringUtils.defaultIfBlank((CharSequence)tradeNo, (CharSequence)orderNo), status);
        if ("DELIVERY".equals(status)) {
            this.marketOrderTradeStatusProducer.sendOrderDeliverySuccessMessageToMarket(orderNo);
        }
    }

    @Override
    public void publishWhenOrderTradeStatusChange(OrderEo orderEo, String originTradeBizStatus) {
        final String status = orderEo.getOrderTradeStatus();
        if (!StringUtils.equals((CharSequence)originTradeBizStatus, (CharSequence)status)) {
            final String tradeNo = orderEo.getThirdOrderNo();
            final String orderNo = orderEo.getOrderNo();
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCommit() {
                        OrderServiceImpl.this.orderTradeStatusChangeProducer.sendMqMessage((String)StringUtils.defaultIfBlank((CharSequence)tradeNo, (CharSequence)orderNo), status);
                    }
                });
            } else {
                this.orderTradeStatusChangeProducer.sendMqMessage((String)StringUtils.defaultIfBlank((CharSequence)tradeNo, (CharSequence)orderNo), status);
            }
        }
    }

    @Override
    public List<OrderEo> queryList(OrderEo orderEo) {
        return this.queryList(orderEo, 0, 1024);
    }

    @Override
    public List<OrderEo> queryList(OrderEo orderEo, int pageNum, int pageSize) {
        return this.orderDas.select((BaseEo)orderEo, Integer.valueOf(pageNum), Integer.valueOf(pageSize));
    }

    @Override
    public List<OrderEo> queryList(OrderQueryReqDto orderQueryReq) {
        OrderEo orderEo = OrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderQueryReq, (BaseEo)orderEo);
        return this.orderDas.select((BaseEo)orderEo);
    }

    @Override
    public List<OrderEo> queryByTradeNos(List<String> tradeNos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(tradeNos)) {
            return null;
        }
        OrderEo orderEo = new OrderEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", tradeNos));
        orderEo.setSqlFilters(sqlFilters);
        List list = this.orderDas.select((BaseEo)orderEo);
        return list;
    }

    @Override
    public void modifyOrderAddress(String tradeNo, OrderAddressReqDto deliveryAddress) {
        OrderEo orderEo = this.getByOrderNo(tradeNo);
        Assert.notNull((Object)orderEo, TradeExceptionCode.ORDER_NO_EXIT);
        String orderNo = (String)StringUtils.defaultIfBlank((CharSequence)orderEo.getParentOrderNo(), (CharSequence)orderEo.getOrderNo());
        String orderStatus = orderEo.getOrderStatus();
        if ("WAIT_AUDIT".equals(orderStatus)) {
            this.modifyAddress4OrderAddress(deliveryAddress, orderEo, orderNo);
        } else if ("WAIT_DELIVERY".equals(orderStatus)) {
            this.modifyOrderAddress4MultiScene(deliveryAddress, orderEo, orderNo);
        }
    }

    private void modifyOrderAddress4MultiScene(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo) {
        Map<Integer, List<OrderDeliveryEo>> sceneMap = this.querySceneNum(orderNo);
        if (MapUtils.isEmpty(sceneMap) || sceneMap.containsKey(-1)) {
            throw new BizException("\u67e5\u8be2\u53d1\u8d27\u5355\u573a\u666f\u5931\u8d25");
        }
        boolean flagMiddleGround = false;
        block0: for (Map.Entry<Integer, List<OrderDeliveryEo>> entry : sceneMap.entrySet()) {
            List<OrderDeliveryEo> orderDeliveryEos = entry.getValue();
            for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
                if (null != orderDeliveryEo.getIfAgreement() && YesNoEnum.YES.getValue() != orderDeliveryEo.getIfAgreement()) continue;
                flagMiddleGround = true;
                continue block0;
            }
        }
        if (flagMiddleGround) {
            this.modifyOrderAddress4MultiSceneByMiddleGround(deliveryAddress, orderEo, orderNo, sceneMap);
        } else if (!flagMiddleGround) {
            this.modifyOrderAddress4MultiSceneByDownStream(deliveryAddress, orderEo, orderNo, sceneMap);
        }
    }

    private Map<Integer, List<OrderDeliveryEo>> querySceneNum(String orderNo) {
        return this.orderDeliveryInfoService.querySceneNum(orderNo);
    }

    @Transactional(rollbackFor={Exception.class, RuntimeException.class})
    public void modifyOrderAddress4MultiSceneByMiddleGround(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo, Map<Integer, List<OrderDeliveryEo>> sceneMap) {
        int scene = 0;
        List<OrderDeliveryEo> orderDeliveryEos = new ArrayList<OrderDeliveryEo>();
        for (Map.Entry<Integer, List<OrderDeliveryEo>> entry : sceneMap.entrySet()) {
            scene = entry.getKey();
            orderDeliveryEos = entry.getValue();
        }
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            if (!DeliveryStatusEnum.INIT.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) continue;
            throw new BizException("\u53d1\u8d27\u5355\u72b6\u6001\u3010\u5df2\u63a5\u5355\u3011\uff0c\u4e0d\u652f\u6301\u4fee\u6539");
        }
        this.handleScene123(deliveryAddress, orderEo, orderNo, scene, orderDeliveryEos);
    }

    private void handleScene123(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo, int scene, List<OrderDeliveryEo> orderDeliveryEos) {
        if (scene == 1) {
            this.handleScene1(deliveryAddress, orderEo, orderNo, orderDeliveryEos);
        } else if (scene == 2) {
            this.handleScene2(deliveryAddress, orderEo, orderNo, orderDeliveryEos);
        } else if (scene == 3) {
            this.handleScene3(deliveryAddress, orderEo, orderNo, orderDeliveryEos);
        }
    }

    private void handleScene2(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo, List<OrderDeliveryEo> orderDeliveryEos) {
        this.cancelOrderDelivery(orderNo, orderDeliveryEos);
        this.modifyAddress4OrderAddress(deliveryAddress, orderEo, orderNo);
        this.reCreateDeliveryOrder4Current(orderNo, orderDeliveryEos, deliveryAddress);
        this.reCreateDeliveryOrder4Other(orderNo, orderDeliveryEos);
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            String desc = String.format("\u4fee\u6539\u6536\u8d27\u5730\u5740\uff1a\u5355\u4e2a\u53d1\u8d27\u5355-\u5408\u5e76\u5176\u4ed6\u5355\uff0c\u8ba2\u5355\u53f7\uff1a%s\uff0c\u53d1\u8d27\u5355\u53f7\uff1a%s", orderNo, orderDeliveryEo.getDeliveryNo());
            this.deliveryService.assembleMessage2Inventory(orderDeliveryEo, DeliveryStatusEnum.CANCELED.getStatus(), DeliveryRouteOptEnum.CANCEL.getOptCode(), desc);
        }
    }

    @Override
    public void reCreateDeliveryOrder4Other(String orderNo, List<OrderDeliveryEo> orderDeliveryEos) {
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            List<RefDeliveryOrderEo> refDeliveryOrderEos = this.orderDeliveryInfoService.queryRefDeliveryOrderEosByDeliveryNo(orderDeliveryEo.getDeliveryNo());
            for (RefDeliveryOrderEo refDeliveryOrderEo : refDeliveryOrderEos) {
                String orderNoOther = refDeliveryOrderEo.getOrderNo();
                if (orderNoOther.equals(orderNo)) continue;
                this.doReCreateDeliveryOrder4Other(orderDeliveryEo, orderNoOther);
            }
        }
    }

    private void doReCreateDeliveryOrder4Other(OrderDeliveryEo orderDeliveryEo, String orderNo) {
        String deliveryNoOld = orderDeliveryEo.getDeliveryNo();
        String deliveryNoNew = TradeUtil.generateTradeNo();
        String deliveryEoJson = JSONObject.toJSONString((Object)orderDeliveryEo);
        OrderDeliveryEo orderDeliveryEoNew = (OrderDeliveryEo)JSONObject.parseObject((String)deliveryEoJson, OrderDeliveryEo.class);
        orderDeliveryEoNew.setId(null);
        orderDeliveryEoNew.setDeliveryNo(deliveryNoNew);
        orderDeliveryEoNew.setIfMerge(IfMergeEnum.NO_MERGE.getCode());
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEoNew);
        RefDeliveryOrderEo refDeliveryOrderEoSelect = new RefDeliveryOrderEo();
        refDeliveryOrderEoSelect.setOrderNo(orderNo);
        refDeliveryOrderEoSelect.setDeliveryNo(deliveryNoOld);
        RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)refDeliveryOrderEoSelect);
        this.refDeliveryOrderDas.logicDeleteByExample((BaseEo)refDeliveryOrderEoSelect);
        refDeliveryOrderEo.setDeliveryNo(deliveryNoNew);
        refDeliveryOrderEo.setId(null);
        this.refDeliveryOrderDas.insert((BaseEo)refDeliveryOrderEo);
        DeliveryItemEo deliveryItemEoSelect = new DeliveryItemEo();
        deliveryItemEoSelect.setTradeNo(orderNo);
        deliveryItemEoSelect.setDeliveryNo(deliveryNoOld);
        List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemEoSelect);
        deliveryItemEos.forEach(deliveryItemEo -> this.deliveryItemDas.logicDeleteByExample((BaseEo)deliveryItemEo));
        deliveryItemEos.forEach(deliveryItemEo -> {
            deliveryItemEo.setDeliveryNo(deliveryNoNew);
            deliveryItemEo.setId(null);
            this.deliveryItemDas.insert((BaseEo)deliveryItemEo);
        });
    }

    private void reCreateDeliveryOrder4Current(String orderNo, List<OrderDeliveryEo> orderDeliveryEos, OrderAddressReqDto deliveryAddress) {
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            String deliveryNoOld = orderDeliveryEo.getDeliveryNo();
            String deliveryNoNew = TradeUtil.generateTradeNo();
            String deliveryEoJson = JSONObject.toJSONString((Object)orderDeliveryEo);
            OrderDeliveryEo orderDeliveryEoNew = (OrderDeliveryEo)JSONObject.parseObject((String)deliveryEoJson, OrderDeliveryEo.class);
            orderDeliveryEoNew.setDeliveryNo(deliveryNoNew);
            orderDeliveryEoNew.setIfMerge(IfMergeEnum.NO_MERGE.getCode());
            this.saveOrderDelivery(deliveryAddress, orderDeliveryEoNew);
            RefDeliveryOrderEo refDeliveryOrderEoSelect = new RefDeliveryOrderEo();
            refDeliveryOrderEoSelect.setOrderNo(orderNo);
            refDeliveryOrderEoSelect.setDeliveryNo(deliveryNoOld);
            RefDeliveryOrderEo refDeliveryOrderEo = (RefDeliveryOrderEo)this.refDeliveryOrderDas.selectOne((BaseEo)refDeliveryOrderEoSelect);
            this.refDeliveryOrderDas.logicDeleteByExample((BaseEo)refDeliveryOrderEoSelect);
            refDeliveryOrderEo.setDeliveryNo(deliveryNoNew);
            refDeliveryOrderEo.setId(null);
            this.refDeliveryOrderDas.insert((BaseEo)refDeliveryOrderEo);
            DeliveryItemEo deliveryItemEoSelect = new DeliveryItemEo();
            deliveryItemEoSelect.setTradeNo(orderNo);
            deliveryItemEoSelect.setDeliveryNo(deliveryNoOld);
            List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemEoSelect);
            deliveryItemEos.forEach(deliveryItemEo -> this.deliveryItemDas.logicDeleteByExample((BaseEo)deliveryItemEo));
            deliveryItemEos.forEach(deliveryItemEo -> {
                deliveryItemEo.setDeliveryNo(deliveryNoNew);
                deliveryItemEo.setId(null);
                this.deliveryItemDas.insert((BaseEo)deliveryItemEo);
            });
        }
    }

    private void saveOrderDelivery(OrderAddressReqDto deliveryAddress, OrderDeliveryEo orderDeliveryEo) {
        orderDeliveryEo.setId(null);
        orderDeliveryEo.setDeliveryName(deliveryAddress.getDeliveryName());
        orderDeliveryEo.setDeliveryMobile(deliveryAddress.getDeliveryMobile());
        orderDeliveryEo.setAddress(deliveryAddress.getAddress());
        orderDeliveryEo.setProvinceCode(deliveryAddress.getProvinceCode());
        orderDeliveryEo.setProvinceName(deliveryAddress.getProvinceName());
        orderDeliveryEo.setCityCode(deliveryAddress.getCityCode());
        orderDeliveryEo.setCityName(deliveryAddress.getCityName());
        orderDeliveryEo.setAreaCode(deliveryAddress.getAreaCode());
        orderDeliveryEo.setAreaName(deliveryAddress.getAreaName());
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
    }

    @Override
    public void cancelOrderDelivery(String orderNo, List<OrderDeliveryEo> orderDeliveryEos) {
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            OrderDeliveryEo deliveryEo = new OrderDeliveryEo();
            deliveryEo.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            this.orderDeliveryDas.logicDeleteByExample((BaseEo)deliveryEo);
        }
    }

    @Override
    public void createDeliveryOrder4OtherOrder(String orderNo, List<OrderDeliveryEo> orderDeliveryEos) {
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            List<RefDeliveryOrderEo> refDeliveryOrderEos = this.orderDeliveryInfoService.queryRefDeliveryOrderEosByDeliveryNo(orderDeliveryEo.getDeliveryNo());
            for (RefDeliveryOrderEo refDeliveryOrderEo : refDeliveryOrderEos) {
                String orderNoOther = refDeliveryOrderEo.getOrderNo();
                if (orderNoOther.equals(orderNo)) continue;
                this.createDeliveryOrder(orderNoOther);
            }
        }
    }

    private void createDeliveryOrder(String orderNo) {
        CreateOrderDeliveryOrderBo createOrderDeliveryOrderBo = new CreateOrderDeliveryOrderBo();
        createOrderDeliveryOrderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), orderNo);
        this.orderFlowAction.createDeliveryOrder(createOrderDeliveryOrderBo);
    }

    private void handleScene3(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo, List<OrderDeliveryEo> orderDeliveryEos) {
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            this.modifyAddress4OrderDelivery(deliveryAddress, orderDeliveryEo);
        }
        this.modifyAddress4OrderAddress(deliveryAddress, orderEo, orderNo);
    }

    private void handleScene1(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo, List<OrderDeliveryEo> deliveryRespDtos) {
        for (OrderDeliveryEo orderDeliveryEo : deliveryRespDtos) {
            this.modifyAddress4OrderDelivery(deliveryAddress, orderDeliveryEo);
            this.modifyAddress4OrderAddress(deliveryAddress, orderEo, orderNo);
        }
    }

    private void modifyOrderAddress4MultiSceneByDownStream(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo, Map<Integer, List<OrderDeliveryEo>> sceneMap) {
        int scene = 0;
        List<OrderDeliveryEo> orderDeliveryEos = new ArrayList<OrderDeliveryEo>();
        for (Map.Entry<Integer, List<OrderDeliveryEo>> entry : sceneMap.entrySet()) {
            scene = entry.getKey();
            orderDeliveryEos = entry.getValue();
        }
        this.handleScene123(deliveryAddress, orderEo, orderNo, scene, orderDeliveryEos);
    }

    @Transactional(rollbackFor={Exception.class, RuntimeException.class})
    public void modifyAddress4OrderAddress(OrderAddressReqDto deliveryAddress, OrderEo orderEo, String orderNo) {
        OrderAddressEo addressEo = new OrderAddressEo();
        addressEo.setOrderNo(orderNo);
        this.orderAddressDas.logicDeleteByExample((BaseEo)addressEo);
        OrderAddressEo orderAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)deliveryAddress, OrderAddressEo.class);
        orderAddressEo.setOrderNo(orderNo);
        this.orderAddressDas.insert((BaseEo)orderAddressEo);
        orderEo.setDeliveryAddress(JSON.toJSONString((Object)orderAddressEo));
        this.orderDas.updateSelective((BaseEo)orderEo);
    }

    private void modifyAddress4OrderDelivery(OrderAddressReqDto deliveryAddress, OrderDeliveryEo orderDeliveryEo) {
        OrderDeliveryEo deliveryEo = new OrderDeliveryEo();
        deliveryEo.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        this.orderDeliveryDas.logicDeleteByExample((BaseEo)deliveryEo);
        orderDeliveryEo.setId(null);
        orderDeliveryEo.setDeliveryName(deliveryAddress.getDeliveryName());
        orderDeliveryEo.setDeliveryMobile(deliveryAddress.getDeliveryMobile());
        orderDeliveryEo.setAddress(deliveryAddress.getAddress());
        orderDeliveryEo.setProvinceCode(deliveryAddress.getProvinceCode());
        orderDeliveryEo.setProvinceName(deliveryAddress.getProvinceName());
        orderDeliveryEo.setCityCode(deliveryAddress.getCityCode());
        orderDeliveryEo.setCityName(deliveryAddress.getCityName());
        orderDeliveryEo.setAreaCode(deliveryAddress.getAreaCode());
        orderDeliveryEo.setAreaName(deliveryAddress.getAreaName());
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
    }

    @Override
    public OrderEo queryByOrderNo(String orderNo) {
        return (OrderEo)this.orderDas.selectByLogicKey((Object)orderNo);
    }

    @Override
    public OrderEo getByOrderNo(String tradeNo) {
        OrderEo orderEo = new OrderEo();
        orderEo.setOrderNo(tradeNo);
        return (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
    }

    @Override
    public List<OrderEo> getByParentOrderNo(String parentOrderNo) {
        OrderEo orderEo = new OrderEo();
        orderEo.setParentOrderNo(parentOrderNo);
        return this.orderDas.select((BaseEo)orderEo);
    }

    @Override
    public void cancel(String tradeNo, CancelReqDto cancelOrder) {
        Assert.notNull((Object)cancelOrder, "\u53d6\u6d88\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        OrderEo orderEo = this.getByOrderNo(tradeNo);
        OrderEo updateOrder = OrderEo.newInstance();
        updateOrder.setId(orderEo.getId());
        updateOrder.setCancelDesc(cancelOrder.getCancelDesc());
        updateOrder.setCancelTime(new Date());
        updateOrder.setOrderStatus(OrderStatusEnum.CANCEL.getCode());
        updateOrder.setCancelType(cancelOrder.getCancelType());
        this.orderDas.updateSelective((BaseEo)updateOrder);
    }

    @Override
    public void cancelAndUpdateOrder(OrderEo orderEo, String cancelType, String cancelDesc) {
        Assert.notNull((Object)orderEo.getId(), "\u53d6\u6d88\u7684\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        orderEo.setCancelDesc(cancelType);
        orderEo.setCancelTime(new Date());
        orderEo.setCancelType(cancelDesc);
        orderEo.setOrderStatus(OrderStatusEnum.CANCEL.getCode());
        orderEo.setOrderTradeStatus(OrderStatusEnum.CANCEL.getCode());
        this.orderDas.updateSelective((BaseEo)orderEo);
        this.orderStatusChangeProducer.sendOrderStatusMqMessage(orderEo.getId(), OrderStatusEnum.CANCEL.getCode());
    }

    @Override
    public PageInfo<OrderEo> queryByPage(OrderEo orderEo, Integer pageNum, Integer pageSize) {
        orderEo.setOrderByDesc("id");
        return this.orderDas.selectPage((BaseEo)orderEo, pageNum, pageSize);
    }

    @Override
    public void fillDeliveryInfo(List<OrderBizRespDto> orderRepDtoList) {
        Set<String> orderNos = orderRepDtoList.stream().map(OrderRespDto::getOrderNo).collect(Collectors.toSet());
        List<OrderDeliveryRespDto> orderDeliveryRespDtos = this.orderDeliveryService.queryByOrderNos(orderNos);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderDeliveryRespDtos)) {
            return;
        }
        Map<String, List<OrderDeliveryRespDto>> orderMap = orderDeliveryRespDtos.stream().collect(Collectors.groupingBy(OrderDeliveryRespDto::getOrderNo));
        for (OrderBizRespDto orderRespDto : orderRepDtoList) {
            List<OrderDeliveryRespDto> orderDeliverys = orderMap.get(orderRespDto.getOrderNo());
            if (CollectionUtils.isEmpty(orderDeliverys)) continue;
            orderRespDto.setDeliveryInfo(orderDeliverys.get(0));
        }
    }

    @Override
    public PageInfo<OrderEo> queryByPage(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        OrderEo orderEo = OrderEo.newInstance();
        PageInfo pageInfo = this.buildCommonQueryForCountAndPage(orderQueryReq, orderEo, pageNum, pageSize);
        if (ObjectUtils.isNotEmpty((Object)pageInfo)) {
            return pageInfo;
        }
        PageInfo orderEoPageInfo = this.orderDas.selectPage((BaseEo)orderEo, pageNum, pageSize, Boolean.valueOf(false));
        return orderEoPageInfo;
    }

    private PageInfo buildCommonQueryForCountAndPage(OrderQueryReqDto orderQueryReq, OrderEo orderEo, Integer pageNum, Integer pageSize) {
        DtoHelper.dto2Eo((BaseVo)orderQueryReq, (BaseEo)orderEo, (String[])new String[]{"offlineAmount"});
        orderEo.setInstanceId(orderQueryReq.getInstanceId());
        orderEo.setTenantId(orderQueryReq.getTenantId());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getSqlFilterList())) {
            sqlFilters.addAll(orderQueryReq.getSqlFilterList());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (orderQueryReq.getDataType() == null || orderQueryReq.getDataType().equals(1)) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 2) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 3) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"delivery_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"delivery_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 4) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"receive_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"receive_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        }
        if (orderQueryReq.getSearchLimitBySeller() != null && 1 == orderQueryReq.getSearchLimitBySeller() && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderQueryReq.getSellerIds())) {
            sqlFilters.add(SqlFilter.isNull((String)"seller_id"));
        } else if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderQueryReq.getSellerIds())) {
            sqlFilters.add(SqlFilter.in((String)"seller_id", (Object)orderQueryReq.getSellerIds()));
        }
        if (orderQueryReq.getPayStartTime() != null && orderQueryReq.getPayEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"change_time", (Object)format.format(orderQueryReq.getPayEndTime())));
            sqlFilters.add(SqlFilter.gt((String)"change_time", (Object)format.format(orderQueryReq.getPayStartTime())));
        }
        if (orderQueryReq.getInstanceId() != null) {
            sqlFilters.add(SqlFilter.in((String)"instant_id", (Object)orderQueryReq.getInstanceId()));
        }
        if (orderQueryReq.getTenantId() != null) {
            sqlFilters.add(SqlFilter.in((String)"tenant_id", (Object)orderQueryReq.getTenantId()));
        }
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getReferrerIds())) {
            sqlFilters.add(SqlFilter.in((String)"referrer_id", (Object)orderQueryReq.getReferrerIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getTradeNos())) {
            sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)orderQueryReq.getTradeNos()));
        }
        if (orderQueryReq.getDeliveryAddress() != null) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getDeliveryAddress().getDeliveryName())) {
                sqlFilters.add(SqlFilter.like((String)"delivery_address", (Object)("%" + orderQueryReq.getDeliveryAddress().getDeliveryName() + "%")));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getDeliveryAddress().getDeliveryMobile())) {
                sqlFilters.add(SqlFilter.like((String)"delivery_address", (Object)("%" + orderQueryReq.getDeliveryAddress().getDeliveryMobile() + "%")));
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"order_no", (Object)("%" + orderQueryReq.getOrderNo() + "%")));
            orderEo.setOrderNo(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getThirdOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"third_order_no", (Object)("%" + orderQueryReq.getThirdOrderNo() + "%")));
            orderEo.setThirdOrderNo(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getThirdParentOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"third_parent_order_no", (Object)("%" + orderQueryReq.getThirdParentOrderNo() + "%")));
            orderEo.setThirdParentOrderNo(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getSaleChannelOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"sale_channel_order_no", (Object)("%" + orderQueryReq.getSaleChannelOrderNo() + "%")));
            orderEo.setSaleChannelOrderNo(null);
        }
        if (orderQueryReq.getPlaceStartTime() != null && orderQueryReq.getPlaceEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"place_time", (Object)format.format(orderQueryReq.getPlaceEndTime())));
            sqlFilters.add(SqlFilter.gt((String)"place_time", (Object)format.format(orderQueryReq.getPlaceStartTime())));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getOrderTradeStatus())) {
            String[] statusArray = orderQueryReq.getOrderTradeStatus().split(",");
            sqlFilters.add(SqlFilter.in((String)"order_trade_status", Arrays.asList(statusArray)));
            orderEo.setOrderTradeStatus(null);
        }
        orderEo.setEndTime(null);
        if (orderQueryReq.getOrderTradeStatus() == null) {
            sqlFilters.add(SqlFilter.in((String)"order_trade_status", OrderTradeStatusEnum.TCBJ_STATUS));
        }
        if (StringUtils.isNotBlank((CharSequence)orderQueryReq.getKeyword()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderQueryReq.getCustomerIds())) {
            Set tradeNos = this.tradeItemDas.queryTradeNoByKeywordAndCustomerIds(orderQueryReq.getKeyword(), orderQueryReq.getCustomerIds());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)tradeNos)) {
                return new PageInfo();
            }
            sqlFilters.add(SqlFilter.in((String)"order_no", (Object)tradeNos));
        } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderQueryReq.getCustomerIds())) {
            sqlFilters.add(SqlFilter.in((String)"customer_id", orderQueryReq.getCustomerIds().stream().filter(StringUtils::isNotBlank).map(Long::valueOf).sorted().map(String::valueOf).collect(Collectors.toList())));
        }
        orderEo.setDr(0);
        orderEo.setSqlFilters(sqlFilters);
        orderEo.setOrderByDesc("id, user_id");
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getTradeNo())) {
            orderEo.setOrderNo(orderQueryReq.getTradeNo());
            orderEo.setEndTime(null);
            List resultList = this.orderDas.select((BaseEo)orderEo);
            PageInfo pageInfo = new PageInfo(resultList);
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                pageInfo.setTotal(0L);
            } else {
                pageInfo.setTotal(1L);
            }
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            pageInfo.setIsFirstPage(true);
            pageInfo.setIsLastPage(true);
            return pageInfo;
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderQueryReq.getItemCodes()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderQueryReq.getItemNames()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderQueryReq.getBatchNos())) {
            Set itemEos;
            List likeBatchNos = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderQueryReq.getBatchNos())) {
                likeBatchNos = orderQueryReq.getBatchNos().stream().map(e -> "%" + e + "%").collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(itemEos = this.tradeItemDas.qyeryTradeNoByItemAndBatchNo(orderQueryReq.getItemCodes(), orderQueryReq.getItemNames(), likeBatchNos)))) {
                return new PageInfo();
            }
            sqlFilters.add(SqlFilter.in((String)"order_no", (Object)itemEos));
        }
        return null;
    }

    @Override
    public List<OrderEo> queryExportByPage(OrderQueryReqDto orderQueryReq, Long maxOrderId, Integer pageSize) {
        OrderEo orderEo = OrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderQueryReq, (BaseEo)orderEo);
        orderEo.setInstanceId(orderQueryReq.getInstanceId());
        orderEo.setTenantId(orderQueryReq.getTenantId());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getSqlFilterList())) {
            sqlFilters.addAll(orderQueryReq.getSqlFilterList());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (orderQueryReq.getDataType() == null || orderQueryReq.getDataType().equals(1)) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"create_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 2) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"update_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 3) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"delivery_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"delivery_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        } else if (orderQueryReq.getDataType() == 4) {
            if (orderQueryReq.getStartTime() != null) {
                sqlFilters.add(SqlFilter.ge((String)"receive_time", (Object)format.format(orderQueryReq.getStartTime())));
            }
            if (orderQueryReq.getEndTime() != null) {
                sqlFilters.add(SqlFilter.le((String)"receive_time", (Object)format.format(orderQueryReq.getEndTime())));
            }
        }
        if (orderQueryReq.getPayStartTime() != null && orderQueryReq.getPayEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"change_time", (Object)format.format(orderQueryReq.getPayEndTime())));
            sqlFilters.add(SqlFilter.gt((String)"change_time", (Object)format.format(orderQueryReq.getPayStartTime())));
        }
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getReferrerIds())) {
            sqlFilters.add(SqlFilter.in((String)"referrer_id", (Object)orderQueryReq.getReferrerIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)orderQueryReq.getTradeNos())) {
            sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)orderQueryReq.getTradeNos()));
        }
        if (orderQueryReq.getDeliveryAddress() != null) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getDeliveryAddress().getDeliveryName())) {
                sqlFilters.add(SqlFilter.like((String)"delivery_address", (Object)("%" + orderQueryReq.getDeliveryAddress().getDeliveryName() + "%")));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getDeliveryAddress().getDeliveryMobile())) {
                sqlFilters.add(SqlFilter.like((String)"delivery_address", (Object)("%" + orderQueryReq.getDeliveryAddress().getDeliveryMobile() + "%")));
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"order_no", (Object)("%" + orderQueryReq.getOrderNo() + "%")));
            orderEo.setOrderNo(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getThirdOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"third_order_no", (Object)("%" + orderQueryReq.getThirdOrderNo() + "%")));
            orderEo.setThirdOrderNo(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getThirdParentOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"third_parent_order_no", (Object)("%" + orderQueryReq.getThirdParentOrderNo() + "%")));
            orderEo.setThirdParentOrderNo(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getSaleChannelOrderNo())) {
            sqlFilters.add(SqlFilter.like((String)"sale_channel_order_no", (Object)("%" + orderQueryReq.getSaleChannelOrderNo() + "%")));
            orderEo.setSaleChannelOrderNo(null);
        }
        if (orderQueryReq.getPlaceStartTime() != null && orderQueryReq.getPlaceEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"place_time", (Object)format.format(orderQueryReq.getPlaceEndTime())));
            sqlFilters.add(SqlFilter.gt((String)"place_time", (Object)format.format(orderQueryReq.getPlaceStartTime())));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)orderQueryReq.getOrderTradeStatus())) {
            String[] statusArray = orderQueryReq.getOrderTradeStatus().split(",");
            sqlFilters.add(SqlFilter.in((String)"order_trade_status", Arrays.asList(statusArray)));
            orderEo.setOrderTradeStatus(null);
        }
        orderEo.setEndTime(null);
        if (orderQueryReq.getOrderTradeStatus() == null) {
            sqlFilters.add(SqlFilter.ne((String)"order_trade_status", (Object)OrderStatusEnum.INIT.getCode()));
        }
        sqlFilters.add(SqlFilter.gt((String)"id", (Object)maxOrderId));
        orderEo.setSqlFilters(sqlFilters);
        orderEo.setOrderBy("id");
        logger.info("\u67e5\u8be2\u5bfc\u51fa\u7684\u8bf7\u6c42\u53c2\u6570tr_order={}", (Object)JSON.toJSONString((Object)orderEo));
        return this.orderDas.selectList((BaseEo)orderEo, Integer.valueOf(1), pageSize);
    }

    @Override
    public List<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> queryByPageForExportResp(OrderQueryReqDto orderQueryReq, Long maxOrderId, Integer pageSize) {
        if (null == orderQueryReq.getOrderType()) {
            orderQueryReq.setIsSplit(DefaultValue.NO);
        } else if (OrderTypeEnum.CHILDREN_ORDER.getType().equals(orderQueryReq.getOrderType()) || OrderTypeEnum.PARENT_ORDER.getType().equals(orderQueryReq.getOrderType())) {
            orderQueryReq.setIsSplit(orderQueryReq.getOrderType());
        }
        List<Object> orderRepDtoList = Lists.newArrayList();
        List<OrderEo> orderEos = this.queryExportByPage(orderQueryReq, maxOrderId, pageSize);
        CubeBeanUtils.copyCollection((Collection)orderRepDtoList, orderEos, com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto.class);
        if (!CollectionUtils.isEmpty(orderEos)) {
            orderRepDtoList = this.getOrderRespDto(orderEos, orderQueryReq.getIsContainItem(), orderQueryReq.getIfExport());
        }
        return orderRepDtoList;
    }

    @Override
    public List<OrderBizRespDto> queryByPageForExportBizResp(OrderQueryReqDto orderQueryReq, Long maxOrderId, Integer pageSize) {
        List<com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto> orderRespDtoList = this.orderService.queryByPageForExportResp(orderQueryReq, maxOrderId, pageSize);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderRespDtoList)) {
            return null;
        }
        ArrayList<OrderBizRespDto> bizRespDtos = new ArrayList<OrderBizRespDto>();
        CubeBeanUtils.copyCollection(bizRespDtos, orderRespDtoList, OrderBizRespDto.class);
        if (Boolean.TRUE.equals(orderQueryReq.getIfExport())) {
            this.orderService.fillDeliveryInfo(bizRespDtos);
        }
        return bizRespDtos;
    }

    @Override
    public OrderCountRespDto queryOrderCount(OrderQueryReqDto orderQueryReq) {
        OrderCountRespDto orderCountRespDto = new OrderCountRespDto();
        OrderQueryVo orderQueryVo = new OrderQueryVo();
        orderQueryVo.setUserId(orderQueryReq.getUserId());
        orderQueryVo.setInstanceId(orderQueryReq.getInstanceId());
        orderQueryVo.setTenantId(orderQueryReq.getTenantId());
        orderQueryVo.setOrderTradeStatus(orderQueryReq.getOrderTradeStatus());
        List list = this.orderDas.countOrderByStatus(orderQueryVo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(vo -> {
                Integer num = vo.getNum();
                if ("WAIT_PAY".equals(vo.getOrderTradeStatus())) {
                    orderCountRespDto.setWaitPayCount(num);
                }
                if ("WAIT_DELIVERY".equals(vo.getOrderTradeStatus())) {
                    orderCountRespDto.setWaitDeliveryCount(num);
                }
                if ("DELIVERY".equals(vo.getOrderTradeStatus())) {
                    orderCountRespDto.setDeliveryCount(num);
                }
            });
        }
        return orderCountRespDto;
    }

    @Override
    public OrderCountTobRespDto queryOrderCountTob(OrderQueryReqDto orderQueryReq) {
        OrderCountTobRespDto orderCountTobRespDto = new OrderCountTobRespDto();
        OrderQueryVo orderQueryVo = new OrderQueryVo();
        orderQueryVo.setUserId(orderQueryReq.getUserId());
        orderQueryVo.setUserIds(orderQueryReq.getUserIds());
        orderQueryVo.setInstanceId(orderQueryReq.getInstanceId());
        orderQueryVo.setTenantId(orderQueryReq.getTenantId());
        orderQueryVo.setShopId(orderQueryReq.getShopId());
        orderQueryVo.setOrderTradeStatus(orderQueryReq.getOrderTradeStatus());
        List list = this.orderDas.countOrderByStatusTob(orderQueryVo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            int deliveryCount = 0;
            for (OrderStatusCountVo vo : list) {
                Integer num = vo.getNum();
                if (OrderBizStatusTobEnum.WAIT_CS_AUDIT.getCode().equals(vo.getOrderTradeStatus())) {
                    orderCountTobRespDto.setWaitCsAuditCount(num);
                }
                if (OrderBizStatusTobEnum.WAIT_FINANCE_AUDIT.getCode().equals(vo.getOrderTradeStatus())) {
                    orderCountTobRespDto.setWaitFinanceAuditCount(num);
                }
                if (OrderBizStatusTobEnum.CONFIRM.getCode().equals(vo.getOrderTradeStatus())) {
                    orderCountTobRespDto.setConfirmCount(num);
                }
                if (OrderBizStatusTobEnum.PART_DELIVERY.getCode().equals(vo.getOrderTradeStatus()) || OrderBizStatusTobEnum.ALL_DELIVERY.getCode().equals(vo.getOrderTradeStatus()) || OrderBizStatusTobEnum.PART_OUT_STORAGE.getCode().equals(vo.getOrderTradeStatus()) || OrderBizStatusTobEnum.ALL_OUT_STORAGE.getCode().equals(vo.getOrderTradeStatus()) || OrderBizStatusTobEnum.PART_CONFIRM.getCode().equals(vo.getOrderTradeStatus())) {
                    deliveryCount += num.intValue();
                }
                if (OrderBizStatusTobEnum.WAIT_OUT_STORAGE.getCode().equals(vo.getOrderTradeStatus())) {
                    orderCountTobRespDto.setWaitOutStorageCount(num);
                }
                if (!OrderBizStatusTobEnum.DRAFT.getCode().equals(vo.getOrderTradeStatus())) continue;
                orderCountTobRespDto.setDraftCount(num);
            }
            orderCountTobRespDto.setDeliveryCount(Integer.valueOf(deliveryCount));
        }
        OrderStatusCountVo afterSalesCountVo = this.orderDas.countAfterSalesTob(orderQueryVo);
        orderCountTobRespDto.setRefundCount(afterSalesCountVo.getNum());
        OrderEo orderEo = new OrderEo();
        ArrayList<SqlFilter> sqlFilter = new ArrayList<SqlFilter>();
        sqlFilter.add(SqlFilter.in((String)"customer_id", (Object)orderQueryVo.getUserIds()));
        sqlFilter.add(SqlFilter.eq((String)"is_split", (Object)YesNoEnum.NO.getValue()));
        sqlFilter.add(SqlFilter.ne((String)"pay_status", (Object)OrderTradeStatusEnum.PAYED.getCode()));
        sqlFilter.add(SqlFilter.ne((String)"order_trade_status", (Object)OrderTradeStatusEnum.CLOSE.getCode()));
        sqlFilter.add(SqlFilter.ne((String)"order_trade_status", (Object)OrderTradeStatusEnum.CANCEL.getCode()));
        sqlFilter.add(SqlFilter.ne((String)"order_trade_status", (Object)OrderTradeStatusEnum.DRAFT.getCode()));
        if (StringUtils.isNotBlank((CharSequence)orderQueryReq.getShopId())) {
            sqlFilter.add(SqlFilter.eq((String)"shop_id", (Object)orderQueryReq.getShopId()));
        }
        orderEo.setSqlFilters(sqlFilter);
        orderEo.setInstanceId(orderQueryVo.getInstanceId());
        orderEo.setTenantId(orderQueryVo.getTenantId());
        int waitPayCount = this.orderDas.count((BaseEo)orderEo);
        orderCountTobRespDto.setWaitPayCount(Integer.valueOf(waitPayCount));
        return orderCountTobRespDto;
    }

    @Override
    public void modifyOrderBizStatus(String tradeNo, String status) {
        OrderEo orderEo = new OrderEo();
        orderEo.setBizStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        orderEo.setSqlFilters(sqlFilters);
        this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
    }

    @Override
    public void modifyOrder(OrderModReqDto order) {
        OrderEo orderEo = new OrderEo();
        orderEo.setBizStatus(order.getBizStatus());
        orderEo.setBizType(order.getBizType());
        orderEo.setSellerRemark(order.getSellerRemark());
        if (StringUtils.isNotBlank((CharSequence)order.getExtension())) {
            orderEo.setExtension(order.getExtension());
        }
        orderEo.setOrderTags(order.getOrderTags());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)order.getTradeNo()));
        sqlFilters.add(SqlFilter.eq((String)"tenant_id", (Object)order.getTenantId()));
        orderEo.setSqlFilters(sqlFilters);
        this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
    }

    @Override
    public OrderCreateBo updateOrder(OrderCreateBo orderBo) {
        com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReq = orderBo.getOrderReqDto();
        orderReq = (com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto)EoUtil.transformExtFieldsToDto((BaseVo)orderReq, (Class)this.orderCreateActionExtPt.getDtoClass());
        orderBo.setOrderReqDto(orderReq);
        orderReq = this.orderCreateActionExtPt.validate(orderReq);
        orderBo = this.packOrderBaseDetailInfoForUpdate(orderBo);
        orderBo = this.orderCreateActionExtPt.packBo_update(orderBo, orderReq);
        this.orderService.saveOrderBaseDetailInfoForUpdate(orderBo);
        orderBo = this.orderCreateActionExtPt.save_update(orderBo, orderReq);
        return orderBo;
    }

    @Override
    public OrderEo queryExpireOrder(String tradeNo, Date expireTime) {
        OrderEo orderEo = OrderEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        orderEo.setSqlFilters(sqlFilters);
        List orderEos = this.orderDas.select((BaseEo)orderEo);
        return orderEos == null || orderEos.isEmpty() ? null : (OrderEo)orderEos.get(0);
    }

    @Override
    public Boolean checkOrderExpireAndCloseTime(String tradeNo, Date expireTime, Date closeTime) {
        OrderEo orderEo = OrderEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        sqlFilters.add(SqlFilter.eq((String)"order_status", (Object)OrderStatusEnum.INIT.getCode()));
        orderEo.setSqlFilters(sqlFilters);
        List orderEos = this.orderDas.select((BaseEo)orderEo);
        if (orderEos != null && !orderEos.isEmpty()) {
            if (((OrderEo)orderEos.get(0)).getCloseTime() != null) {
                logger.info("\u5f53\u524d\u65f6\u95f4{}\u8fc7\u671f\u65f6\u95f4{}", (Object)DateUtil.getDateFormat((Date)expireTime, (String)"yyyy-MM-dd HH:mm:ss"), (Object)DateUtil.getDateFormat((Date)((OrderEo)orderEos.get(0)).getCloseTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (((OrderEo)orderEos.get(0)).getCloseTime().before(expireTime)) {
                    // empty if block
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void modifyOrderCloseTime(String tradeNo, Date closeTime) {
        TradeEo tradeEo = this.iTradeService.getPayTrade(tradeNo);
        if (tradeEo == null) {
            logger.info("\u627e\u4e0d\u5230\u8ba2\u5355\u7684\u4ea4\u6613\u6d41\u7a0b");
            throw new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg());
        }
        OrderEo orderEo = OrderEo.newInstance();
        orderEo.setCloseTime(closeTime);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        orderEo.setSqlFilters(sqlFilters);
        this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
        this.scheduleService.addPayTask(tradeNo, tradeEo.getTradeNo(), closeTime, tradeEo.getTenantId(), tradeEo.getInstanceId());
    }

    @Override
    public void validateCompPay(List<SubOrderPayReqDto> subOrderPayReqDtoList) {
        ArrayList discountOrderNoList = new ArrayList();
        subOrderPayReqDtoList.forEach(subOrderPayReqDto -> {
            if (!discountOrderNoList.contains(subOrderPayReqDto.getTradeNo())) {
                OrderEo orderEo = this.getByOrderNo(subOrderPayReqDto.getTradeNo());
                if (null == orderEo) {
                    throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
                }
                if (OrderStatusEnum.CANCEL.getCode().equals(orderEo.getOrderStatus())) {
                    throw new BizException(TradeExceptionCode.ORDER_CANCELED.getCode(), TradeExceptionCode.ORDER_CANCELED.getMsg());
                }
                if (!OrderStatusEnum.INIT.getCode().equals(orderEo.getOrderStatus())) {
                    throw new BizException(TradeExceptionCode.ORDER_PAYED.getCode(), TradeExceptionCode.ORDER_PAYED.getMsg());
                }
                if (DefaultValue.YES.equals(orderEo.getIsSplit())) {
                    throw new BizException(TradeExceptionCode.COMP_PAY_ORDER_NO_ERROR.getCode(), TradeExceptionCode.COMP_PAY_ORDER_NO_ERROR.getMsg());
                }
                if (!"0".equals(orderEo.getParentOrderNo())) {
                    List<OrderEo> orderEoList = this.getByParentOrderNo(orderEo.getParentOrderNo());
                    boolean hasDiscountSubOrder = false;
                    ArrayList<String> list = new ArrayList<String>();
                    for (OrderEo order : orderEoList) {
                        if (order.getPayAmount().compareTo(order.getTotalAmount()) != 0) {
                            hasDiscountSubOrder = true;
                        }
                        list.add(order.getTradeNo());
                    }
                    if (hasDiscountSubOrder) {
                        discountOrderNoList.addAll(list);
                    }
                }
            }
        });
        for (String discountOrderNo : discountOrderNoList) {
            boolean exist = false;
            for (SubOrderPayReqDto subOrderPayReqDto2 : subOrderPayReqDtoList) {
                if (!discountOrderNo.equals(subOrderPayReqDto2.getTradeNo())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            throw new BizException(TradeExceptionCode.DISCOUNT_SUB_ORDER_MUST_BE_ALL_PAY.getCode(), TradeExceptionCode.DISCOUNT_SUB_ORDER_MUST_BE_ALL_PAY.getMsg());
        }
    }

    @Override
    public Set<String> validateCancel(String tradeNo) {
        OrderEo orderEo = this.getByOrderNo(tradeNo);
        if (null == orderEo) {
            throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
        }
        if (DefaultValue.NO.equals(orderEo.getIsSplit()) && "0".equals(orderEo.getParentOrderNo())) {
            return null;
        }
        if (OrderDeviceType.CHIMEN.getCode().equals(orderEo.getDeviceType())) {
            return null;
        }
        if (DefaultValue.YES.equals(orderEo.getIsSplit())) {
            List<OrderEo> orderEoList = this.getByParentOrderNo(orderEo.getOrderNo());
            Set<String> orderNos = orderEoList.stream().filter(order -> !OrderStatusEnum.CANCEL.getCode().equals(order.getOrderStatus())).map(o -> o.getOrderNo()).collect(Collectors.toSet());
            HashSet<String> tradeTypes = new HashSet<String>();
            tradeTypes.add("PAY");
            tradeTypes.add("INTEGRAL_PAY");
            tradeTypes.add("SUB_ORDER_PAY");
            List<TradeEo> tradeEos = this.tradeService.getChildrenTrade(orderNos, tradeTypes);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(tradeEos)) {
                return orderNos;
            }
            Map<String, List<TradeEo>> tradeEoMap = tradeEos.stream().collect(Collectors.groupingBy(StdTradeEo::getParentTradeNo));
            Set<String> payNos = tradeEos.stream().map(o -> o.getTradeNo()).collect(Collectors.toSet());
            List<PayRecordRespDto> payRecordRespDtos = this.payService.getPaySuccessRecords(payNos);
            Map<String, List<PayRecordRespDto>> tradePayMap = payRecordRespDtos.stream().collect(Collectors.groupingBy(PayRecordRespDto::getTradeNo));
            orderEoList.forEach(order -> {
                List orderTradeList = (List)tradeEoMap.get(order.getTradeNo());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderTradeList)) {
                    orderTradeList.forEach(orderTrade -> {
                        List payRecordRespDtoList = (List)tradePayMap.get(orderTrade.getTradeNo());
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)payRecordRespDtoList)) {
                            throw new BizException(TradeExceptionCode.ORDER_CAN_NOT_CANCEL_SUB_ORDER_PAYED.getCode(), TradeExceptionCode.ORDER_CAN_NOT_CANCEL_SUB_ORDER_PAYED.getMsg());
                        }
                    });
                }
            });
            return orderNos;
        }
        if (orderEo.getCustomerId() == null) {
            List<OrderEo> orderEoList = this.getByParentOrderNo(orderEo.getParentOrderNo());
            orderEoList.forEach(order -> {
                if (order.getPayAmount().compareTo(order.getTotalAmount()) < 0) {
                    throw new BizException(TradeExceptionCode.DISCOUNT_SUB_ORDER_MUST_BE_ALL_CANCEL.getCode(), TradeExceptionCode.DISCOUNT_SUB_ORDER_MUST_BE_ALL_CANCEL.getMsg());
                }
            });
        }
        return null;
    }

    @Override
    public Integer count(String filter) {
        OrderQueryVo orderQueryVo = (OrderQueryVo)JSON.parseObject((String)filter, OrderQueryVo.class);
        return this.orderDas.countRefererIdOrderNum(orderQueryVo);
    }

    @Override
    public List<TradeItemRespDto> countItem(OrderItemReqDto orderItemReqDto) {
        OrderQueryVo orderQueryVo = new OrderQueryVo();
        List select = this.orderDas.select(SqlFilterBuilder.create(OrderEo.class).isNotNull("pay_time").ge("update_time", (Object)orderItemReqDto.getUpdateStartTime()).le("update_time", (Object)new Date()).eo());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)select)) {
            return null;
        }
        List orderNos = select.stream().map(StdOrderEo::getTradeNo).collect(Collectors.toList());
        orderNos.addAll(select.stream().map(StdOrderEo::getOrderNo).collect(Collectors.toList()));
        orderQueryVo.setOrderNos(orderNos.stream().distinct().collect(Collectors.toList()));
        orderQueryVo.setCargoCodes(orderItemReqDto.getCargoCodes());
        List tradeItemEos = this.orderDas.countItem(orderQueryVo);
        return EoUtil.eoListToDtoList((Collection)tradeItemEos, TradeItemRespDto.class);
    }

    @Override
    public BigDecimal sumPayAmount(String filter) {
        OrderQueryVo orderQueryVo = (OrderQueryVo)JSON.parseObject((String)filter, OrderQueryVo.class);
        return this.orderDas.sumPayAmount(orderQueryVo);
    }

    @Override
    public Set<String> queryRefererIdNoReply(String filter) {
        OrderQueryVo orderQueryVo = (OrderQueryVo)JSON.parseObject((String)filter, OrderQueryVo.class);
        Set orderEos = this.orderDas.queryRefererIdNoReply(orderQueryVo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderEos)) {
            return orderEos.stream().filter(orderEo -> null != orderEo).map(orderEo -> orderEo.getReferrerId()).collect(Collectors.toSet());
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrderCreateRespDto addOrder(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderBo, boolean saveDetail) {
        OrderEo order = this.packOrderEoWithDetailSaved(orderBo, saveDetail);
        this.orderDas.insert((BaseEo)order);
        OrderCreateRespDto respDto = new OrderCreateRespDto();
        respDto = BeanCopierUtils.copyWithReturn(orderBo, respDto);
        respDto.setOrderNo(order.getOrderNo());
        return respDto;
    }

    @Override
    public OrderCreateBo packOrderBaseDetailInfo(OrderCreateBo baseInfoBo) {
        com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto = baseInfoBo.getOrderReqDto();
        OrderEo order = OrderEo.newInstance();
        baseInfoBo.setOrderEo(order);
        if (baseInfoBo.ifUseFlow()) {
            String orderNo = StringUtils.isBlank((CharSequence)orderReqDto.getOrderNo()) ? baseInfoBo.getCurrentFlowNo() : orderReqDto.getOrderNo();
            order.setTradeNo(orderNo);
            order.setOrderNo(orderNo);
            order.setFlowDefId(baseInfoBo.getCurrentFlowDefId());
            orderReqDto.setOrderNo(orderNo);
            orderReqDto.setTradeNo(orderNo);
        } else if (StringUtils.isEmpty((CharSequence)orderReqDto.getTradeNo())) {
            orderReqDto.setTradeNo(TradeUtil.generateTradeNo());
        }
        DtoHelper.dto2Eo((BaseVo)orderReqDto, (BaseEo)order);
        order.setOrderNo(orderReqDto.getTradeNo());
        if (StringUtils.isEmpty((CharSequence)order.getFrozenStatus())) {
            order.setFrozenStatus(FreezeStatusEnum.DEFAULT.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)order.getOrderStatus())) {
            order.setOrderStatus(OrderStatusEnum.INIT.getCode());
        }
        order.setOrderTradeStatus(orderReqDto.getOrderTradeStatus() == null ? OrderStatusEnum.INIT.getCode() : orderReqDto.getOrderTradeStatus());
        if (orderReqDto.getIsSplit() != null) {
            order.setIsSplit(orderReqDto.getIsSplit());
        } else {
            order.setIsSplit(DefaultValue.NO);
        }
        if (order.getPlaceTime() == null) {
            order.setPlaceTime(new Date());
        }
        baseInfoBo.setOrderEo(order);
        List tradeItems = orderReqDto.getOrderItems();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeItems)) {
            List tradeItemEos = tradeItems.stream().map(t -> {
                TradeItemEo tradeItemEo = (TradeItemEo)EoUtil.dtoToEo((BaseVo)t, TradeItemEo.class);
                tradeItemEo.setTradeItemNo(TradeUtil.generateTradeNo(orderReqDto.getTradeNo()));
                tradeItemEo.setTradeNo(orderReqDto.getTradeNo());
                tradeItemEo.setUserId(orderReqDto.getUserId());
                tradeItemEo.setGift(t.getGift());
                tradeItemEo.setExchangeActivityId(t.getExchangeActivityId());
                tradeItemEo.setCustomerId(order.getCustomerId());
                if (Objects.isNull(tradeItemEo.getItemMarketPrice())) {
                    tradeItemEo.setItemMarketPrice(tradeItemEo.getItemPrice());
                }
                this.checkNullParams(tradeItemEo);
                return tradeItemEo;
            }).collect(Collectors.toList());
            baseInfoBo.setTradeItemEoList(tradeItemEos);
        }
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(Long.valueOf(order.getShopId()).longValue(), new String[0]).getData();
        orderReqDto.getDeliveryAddress().setPickupType(orderReqDto.getPickupType());
        orderReqDto.getDeliveryAddress().setShippingType(orderReqDto.getShippingType());
        orderReqDto.getDeliveryAddress().setWarehouseSerial(orderReqDto.getWarehouseSerial());
        order.setDeliveryAddress(JSON.toJSONString((Object)orderReqDto.getDeliveryAddress()));
        OrderAddressEo orderAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)orderReqDto.getDeliveryAddress(), OrderAddressEo.class);
        if (null != orderReqDto.getShippingType() && ShippingTypeEnum.getByType((String)orderReqDto.getShippingType()) != null) {
            orderAddressEo.setDeliveryType(Integer.valueOf(ShippingTypeEnum.getByType((String)orderReqDto.getShippingType()).getCode()));
        }
        orderAddressEo.setOrderNo(order.getOrderNo());
        orderAddressEo.setId(null);
        if (orderReqDto.getDeliveryAddress() != null && orderReqDto.getDeliveryAddress().getId() != null) {
            AddressDto addressDto = (AddressDto)RestResponseHelper.extractData((RestResponse)this.userInfoQueryApi.queryAddressById(orderReqDto.getDeliveryAddress().getId(), "{}"));
            addressDto = addressDto == null ? new AddressDto() : addressDto;
            orderAddressEo.setProvinceCode(addressDto.getProvinceCode());
            orderAddressEo.setProvinceName(addressDto.getProvince());
            orderAddressEo.setCityCode(addressDto.getCityCode());
            orderAddressEo.setCityName(addressDto.getCity());
            orderAddressEo.setAreaCode(addressDto.getDistrictCode());
            orderAddressEo.setAreaName(addressDto.getDistrict());
            if (addressDto.getLocationX() != null) {
                orderAddressEo.setLongitude(addressDto.getLocationX());
            }
            if (addressDto.getLocationY() != null) {
                orderAddressEo.setLatitude(addressDto.getLocationY());
            }
            orderAddressEo.setAddressId(orderReqDto.getDeliveryAddress().getId());
        }
        if (ShippingTypeEnum.PICKUP.getType().equals(orderReqDto.getShippingType())) {
            ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
            if (null != shopDeliveryDto) {
                orderAddressEo.setProvinceCode(shopDeliveryDto.getAddressProvince());
                orderAddressEo.setCityCode(shopDeliveryDto.getAddressCity());
                orderAddressEo.setAreaCode(shopDeliveryDto.getAddressRegion());
                orderAddressEo.setProvinceName(shopDeliveryDto.getAddressProvinceName());
                orderAddressEo.setCityName(shopDeliveryDto.getAddressCityName());
                orderAddressEo.setAreaName(shopDeliveryDto.getAddressRegionName());
                orderAddressEo.setDetailed(shopDeliveryDto.getDetailAddress());
            } else {
                logger.warn("\u81ea\u63d0\u8ba2\u5355\uff1a{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e97\u94fa\uff1a{}\u5730\u5740\u4fe1\u606f", (Object)order.getOrderNo(), (Object)order.getShopId());
            }
        }
        baseInfoBo.setOrderAddressEo(orderAddressEo);
        if (Objects.nonNull(shopDto)) {
            order.setOrganizationId(Long.valueOf(Objects.nonNull(shopDto.getOrganizationId()) ? Long.valueOf(shopDto.getOrganizationId()) : 0L));
            order.setOrganizationName(Objects.nonNull(shopDto.getOrganizationName()) ? shopDto.getOrganizationName() : "\u9ed8\u8ba4\u7ec4\u7ec7");
            order.setShopBusinessForm(Objects.nonNull(shopDto.getBusinessForm()) ? shopDto.getBusinessForm() : null);
            order.setShopCode(shopDto.getCode());
        }
        Integer itemType = ((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)tradeItems.stream().findFirst().get()).getItemType();
        order.setItemType(itemType);
        Integer busType = ((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)tradeItems.stream().findFirst().get()).getBusType();
        if (busType != null && ItemBusTypeEnum.INTEGRAL.getType().intValue() == busType.intValue()) {
            order.setBizType(OrderBizTypeEnum.INTEGRALORDER.getType().toString());
        }
        baseInfoBo.setOrderEo(order);
        return baseInfoBo;
    }

    @Override
    @Transactional
    public void saveOrderBaseDetailInfo(OrderCreateBo orderCreateBo) {
        if (orderCreateBo.getOrderEo() != null) {
            this.orderDas.insert((BaseEo)orderCreateBo.getOrderEo());
        }
        if (orderCreateBo.getOrderAddressEo() != null) {
            OrderAddressEo orderAddressEo = orderCreateBo.getOrderAddressEo();
            orderAddressEo.setAddress(orderAddressEo.getAddress() + orderAddressEo.getStreetName());
            this.orderAddressDas.insert((BaseEo)orderAddressEo);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderCreateBo.getTradeItemEoList())) {
            this.tradeItemService.setCatalogNames(orderCreateBo.getTradeItemEoList());
            this.tradeItemDas.insertBatch(orderCreateBo.getTradeItemEoList());
        }
        Map extFields = orderCreateBo.getOrderReqDto().getExtFields();
        if (orderCreateBo.getOrderReqDto().getExtFields().get("origOrderId") != null) {
            this.orderDas.deleteById(Long.valueOf((String)extFields.get("origOrderId")));
        }
    }

    @Deprecated
    private OrderEo packOrderEoWithDetailSaved(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderBo, boolean saveDetail) {
        ShopBaseDto shopDto;
        OrderEo order = OrderEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderBo, (BaseEo)order);
        order.setOrderNo(orderBo.getTradeNo());
        order.setFrozenStatus(FreezeStatusEnum.DEFAULT.getCode());
        order.setOrderStatus(OrderStatusEnum.INIT.getCode());
        order.setOrderTradeStatus(orderBo.getOrderTradeStatus() == null ? OrderStatusEnum.INIT.getCode() : orderBo.getOrderTradeStatus());
        if (orderBo.getIsSplit() != null) {
            order.setIsSplit(orderBo.getIsSplit());
        } else {
            order.setIsSplit(DefaultValue.NO);
        }
        order.setPlaceTime(new Date());
        orderBo.getDeliveryAddress().setPickupType(orderBo.getPickupType());
        orderBo.getDeliveryAddress().setShippingType(orderBo.getShippingType());
        orderBo.getDeliveryAddress().setWarehouseSerial(orderBo.getWarehouseSerial());
        order.setDeliveryAddress(JSON.toJSONString((Object)orderBo.getDeliveryAddress()));
        OrderAddressEo orderAddressEo = (OrderAddressEo)EoUtil.dtoToEo((BaseVo)orderBo.getDeliveryAddress(), OrderAddressEo.class);
        if (ShippingTypeEnum.getByType((String)orderBo.getShippingType()) != null) {
            orderAddressEo.setDeliveryType(Integer.valueOf(ShippingTypeEnum.getByType((String)orderBo.getShippingType()).getCode()));
        }
        orderAddressEo.setOrderNo(order.getOrderNo());
        orderAddressEo.setId(null);
        this.orderAddressDas.insert((BaseEo)orderAddressEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderBo.getExtInfos())) {
            for (OrderExtInfoDto extInfoDto : orderBo.getExtInfos()) {
                if (!order.getShopId().equals(extInfoDto.getShopId().toString())) continue;
                order.setBuyerRemark(extInfoDto.getBuyerRemark());
                JSONObject extenJson = null;
                extenJson = StringUtils.isEmpty((CharSequence)order.getExtension()) ? new JSONObject() : JSONObject.parseObject((String)order.getExtension());
                if (StringUtils.isNotBlank((CharSequence)extInfoDto.getInvoice())) {
                    extenJson.put("invoice", (Object)Long.valueOf(extInfoDto.getInvoice()));
                }
                order.setExtension(extenJson.toJSONString());
                break;
            }
        }
        List tradeItems = orderBo.getOrderItems();
        List giftItems = orderBo.getGiftItems();
        if (saveDetail && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeItems)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tradeItems)) {
                tradeItems.addAll(giftItems);
            }
            List<TradeItemEo> tradeItemEos = tradeItems.stream().map(t -> {
                TradeItemEo tradeItemEo = (TradeItemEo)EoUtil.dtoToEo((BaseVo)t, TradeItemEo.class);
                tradeItemEo.setCycleBuy(Boolean.valueOf(t.getCycleType() != null));
                if (ArrayUtils.isNotEmpty((Object[])t.getCycleValue())) {
                    tradeItemEo.setCycleValue(StringUtils.join((Object[])t.getCycleValue(), (String)","));
                }
                tradeItemEo.setTradeItemNo(TradeUtil.generateTradeNo(orderBo.getTradeNo()));
                tradeItemEo.setTradeNo(orderBo.getTradeNo());
                tradeItemEo.setUserId(orderBo.getUserId());
                this.checkNullParams(tradeItemEo);
                return tradeItemEo;
            }).collect(Collectors.toList());
            this.orderService.setCargoCodeBySkuId(tradeItemEos);
            this.tradeItemService.addItems(tradeItemEos);
        }
        long sumIntegral = tradeItems.stream().filter(tradeItem -> tradeItem.getIntegral() != null && tradeItem.getIntegral() > 0).mapToLong(com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto::getIntegral).sum();
        orderBo.setIntegral(Integer.valueOf((int)sumIntegral));
        order.setIntegral(Integer.valueOf((int)sumIntegral));
        Integer itemType = ((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)tradeItems.stream().findFirst().get()).getItemType();
        order.setItemType(itemType);
        Integer busType = ((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)tradeItems.stream().findFirst().get()).getBusType();
        if (busType != null && ItemBusTypeEnum.INTEGRAL.getType().intValue() == busType.intValue()) {
            order.setBizType(OrderBizTypeEnum.INTEGRALORDER.getType().toString());
        }
        if (Objects.nonNull(shopDto = (ShopBaseDto)this.shopQueryApi.queryBaseById(Long.valueOf(order.getShopId())).getData())) {
            order.setOrganizationId(shopDto.getOrganizationId());
            order.setOrganizationName(shopDto.getOrganizationName());
        }
        return order;
    }

    @Override
    public void setCargoCodeBySkuCode(List<TradeItemEo> tradeItemEos) {
        try {
            List skuCodes = tradeItemEos.stream().filter(tradeItem -> StringUtils.isNotEmpty((CharSequence)tradeItem.getSkuCode())).map(tradeItem -> tradeItem.getSkuCode()).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuCodes)) {
                Object warehouseEoMap = new HashedMap();
                List itemSkus = (List)this.itemSkuQueryApi.queryBySkuCode(skuCodes).getData();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkus)) {
                    warehouseEoMap = itemSkus.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, w -> w));
                }
                if (!warehouseEoMap.isEmpty()) {
                    for (TradeItemEo tradeItemEo : tradeItemEos) {
                        ItemSkuRespDto itemSkuRespDto;
                        if (StringUtils.isEmpty((CharSequence)tradeItemEo.getSkuCode()) || null == (itemSkuRespDto = (ItemSkuRespDto)warehouseEoMap.get(tradeItemEo.getSkuCode()))) continue;
                        tradeItemEo.setCargoSerial(itemSkuRespDto.getCargoCode());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u5546\u54c1\u8bbe\u7f6e\u8d27\u54c1\u7f16\u7801\u51fa\u73b0\u5f02\u5e38.e:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void setCargoCodeBySkuId(List<TradeItemEo> tradeItemEos) {
        try {
            List skuCodes = tradeItemEos.stream().map(tradeItem -> tradeItem.getSkuCode()).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuCodes)) {
                Map<Object, Object> warehouseEoMap = new HashMap();
                List itemSkus = (List)this.itemSkuQueryApi.queryBySkuCode(skuCodes).getData();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkus)) {
                    warehouseEoMap = itemSkus.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, v -> v));
                }
                if (!warehouseEoMap.isEmpty()) {
                    for (TradeItemEo tradeItemEo : tradeItemEos) {
                        ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)warehouseEoMap.get(tradeItemEo.getSkuCode());
                        if (null == itemSkuRespDto) continue;
                        tradeItemEo.setCargoSerial(itemSkuRespDto.getCargoCode());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u5546\u54c1\u8bbe\u7f6e\u8d27\u54c1\u7f16\u7801\u51fa\u73b0\u5f02\u5e38.e:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void checkNullParams(TradeItemEo tradeItemEo) {
        tradeItemEo.setItemPrice((BigDecimal)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemPrice(), (Object)BigDecimal.ZERO));
        tradeItemEo.setItemOrigPrice((BigDecimal)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemOrigPrice(), (Object)BigDecimal.ZERO));
        tradeItemEo.setShopType((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getShopType(), (CharSequence)"online"));
        tradeItemEo.setCatalogSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getCatalogSerial(), (CharSequence)"0"));
        tradeItemEo.setBrandSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getBrandSerial(), (CharSequence)"0"));
        tradeItemEo.setItemType((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemType(), (Object)1));
        tradeItemEo.setItemSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getItemSerial(), (CharSequence)"0"));
        tradeItemEo.setItemVer((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getItemVer(), (CharSequence)"0"));
        tradeItemEo.setShopId((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getShopId(), (CharSequence)"0"));
        tradeItemEo.setSkuSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getSkuSerial(), (CharSequence)"0"));
        tradeItemEo.setThirdSkuSerial((String)StringUtils.defaultIfBlank((CharSequence)tradeItemEo.getThirdSkuSerial(), (CharSequence)"0"));
        tradeItemEo.setCargoSrc(StringUtils.defaultString((String)tradeItemEo.getCargoSrc()));
        tradeItemEo.setCargoSerial(StringUtils.defaultString((String)tradeItemEo.getCargoSerial()));
        tradeItemEo.setItemName(StringUtils.defaultString((String)tradeItemEo.getItemName()));
        tradeItemEo.setItemNum((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getItemNum(), (Object)0));
        tradeItemEo.setPriceType((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getPriceType(), (Object)0));
        tradeItemEo.setPayTotalAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)tradeItemEo.getPayTotalAmount(), (Object)BigDecimal.ZERO));
        tradeItemEo.setSkuDesc(StringUtils.defaultString((String)tradeItemEo.getSkuDesc()));
        tradeItemEo.setDiscounted((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getDiscounted(), (Object)0));
        tradeItemEo.setIsNotCondition((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getIsNotCondition(), (Object)0));
        tradeItemEo.setDr((Integer)ObjectUtils.defaultIfNull((Object)tradeItemEo.getDr(), (Object)0));
    }

    @Override
    public com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto recoverOrderReq(OrderEo orderEo) {
        com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto = new com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto();
        BeanUtils.copyProperties((Object)orderEo, (Object)orderReqDto);
        OrderAddressReqDto orderAddressReqDto = (OrderAddressReqDto)JSON.parseObject((String)orderEo.getDeliveryAddress(), OrderAddressReqDto.class);
        orderReqDto.setDeliveryAddress(orderAddressReqDto);
        List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(orderEo.getOrderNo());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tradeItemEos)) {
            List items = tradeItemEos.stream().map(tradeItemEo -> {
                com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto tradeItemReqDto = new com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto();
                BeanUtils.copyProperties((Object)tradeItemEo, (Object)tradeItemReqDto);
                return tradeItemReqDto;
            }).collect(Collectors.toList());
            orderReqDto.setOrderItems(items);
        }
        return orderReqDto;
    }

    @Override
    public OrderPreviewRespDto countAndPreviewOrderAmount(OrderPreviewReqDto order) {
        com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto2;
        OrderPreviewRespDto orderPreviewRespDto = new OrderPreviewRespDto();
        if (order.getActivity() == null || CollectionUtils.isEmpty((Collection)order.getActivity().getActivityList())) {
            logger.info("\u8ba1\u7b97\u8ba2\u5355\u91d1\u989d(\u4e0d\u53c2\u4e0e\u6d3b\u52a8) order.totalAmount: {}", (Object)order.getTotalAmount());
            orderReqDto2 = this.orderService.countOrderAmount((com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto)order, true);
            orderPreviewRespDto.setTotalAmount(order.getTotalAmount());
            orderPreviewRespDto.setPayAmount(orderReqDto2.getPayAmount());
            orderPreviewRespDto.setTotalIntegral(order.getTotalIntegral());
        } else {
            logger.info("\u8ba1\u7b97\u8ba2\u5355\u91d1\u989d(\u53c2\u4e0e\u6d3b\u52a8) order.totalAmount: {}", (Object)order.getTotalAmount());
            orderPreviewRespDto = this.extlOrderActivityService.viewActivity(order);
        }
        logger.info("orderPreviewRespDto.totalAmount: {}", (Object)orderPreviewRespDto.getTotalAmount());
        if (this.orderService.isSplitOrder((com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto)order).booleanValue() && "Y".equalsIgnoreCase(order.getIsSplitBySys())) {
            OrderSplitReqDto orderSplitReqDto = this.orderService.splitOrderAndCountFreight((com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto)order);
            orderPreviewRespDto.setOrderSplit(orderSplitReqDto);
            List childrenOrderList = orderSplitReqDto.getChildrenOrderList();
            if (!CollectionUtils.isEmpty((Collection)childrenOrderList) && childrenOrderList.size() > 1) {
                List splitOrderRespDtos = childrenOrderList.stream().map(orderReqDto -> {
                    SplitOrderRespDto splitOrderRespDto = new SplitOrderRespDto();
                    List<TradeItemRespDto> orderItems = BeanUtil.copyList(orderReqDto.getOrderItems(), TradeItemRespDto.class);
                    splitOrderRespDto.setOrderItems(orderItems);
                    orderReqDto.setTotalAmount(orderReqDto.getTotalAmount());
                    splitOrderRespDto.setPayAmount(orderReqDto.getPayAmount());
                    splitOrderRespDto.setFreightAmount(orderReqDto.getFreightAmount());
                    Integer presentPoint = this.sumPresentPoint(orderReqDto.getOrderItems());
                    splitOrderRespDto.setPresentPoint(presentPoint);
                    splitOrderRespDto.setStartingPric(orderReqDto.getStartingPric());
                    return splitOrderRespDto;
                }).collect(Collectors.toList());
                orderPreviewRespDto.setPayAmount(order.getPayAmount());
                orderPreviewRespDto.setDiscountAmount(order.getDiscountAmount());
                orderPreviewRespDto.setStartingPric(order.getStartingPric());
                orderPreviewRespDto.setSplitList(splitOrderRespDtos);
            }
        } else {
            boolean isIntegralOrder;
            orderReqDto2 = this.orderService.countFreight((com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto)order);
            boolean bl = isIntegralOrder = orderReqDto2.getTotalIntegral() != null && orderReqDto2.getTotalIntegral() >= 0L;
            if (!isIntegralOrder && orderReqDto2.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                orderReqDto2.setPayAmount(BigDecimal.valueOf(0.0));
            }
            Integer presentPoint = this.sumPresentPoint(orderReqDto2.getOrderItems());
            orderPreviewRespDto.setPayAmount(orderReqDto2.getPayAmount());
            orderPreviewRespDto.setStartingPric(order.getStartingPric());
            orderPreviewRespDto.setTotalAmount(orderReqDto2.getTotalAmount());
            orderPreviewRespDto.setDiscountAmount(orderReqDto2.getDiscountAmount());
            orderPreviewRespDto.setFreightAmount(orderReqDto2.getFreightAmount());
            orderPreviewRespDto.setFreightRuleDes(orderReqDto2.getFreightDes());
            orderPreviewRespDto.setPresentPoint(presentPoint);
            logger.info("orderReqDto.totalAmount: {}", (Object)orderReqDto2.getTotalAmount());
            order.setShopId(((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)order.getOrderItems().get(0)).getShopId());
            this.buildRebate(order, orderPreviewRespDto);
            logger.info("totalAmount: {}, buildRebate: {}, {}", new Object[]{orderPreviewRespDto.getTotalAmount(), JSON.toJSONString((Object)order), JSON.toJSONString((Object)orderPreviewRespDto)});
        }
        ArrayList tradeItemRespDtos = Lists.newArrayList();
        List tradeItemReqDtos = order.getOrderItems();
        CubeBeanUtils.copyCollection((Collection)tradeItemRespDtos, (Collection)tradeItemReqDtos, TradeItemRespDto.class);
        orderPreviewRespDto.setOrderItems((List)tradeItemRespDtos);
        orderPreviewRespDto.setTotalAmount(orderPreviewRespDto.getTotalAmount().add(null != orderPreviewRespDto.getFreightAmount() ? orderPreviewRespDto.getFreightAmount() : BigDecimal.ZERO));
        orderPreviewRespDto.setDeduction(order.isDeduction());
        logger.info("totalAmount: {}, buildRebate_1: {}", (Object)orderPreviewRespDto.getTotalAmount(), (Object)JSON.toJSONString((Object)orderPreviewRespDto));
        return orderPreviewRespDto;
    }

    @Override
    public OrderPreviewRespDto countAndPreviewSeckillOrderAmount(OrderPreviewReqDto order) {
        OrderPreviewRespDto orderPreviewRespDto = new OrderPreviewRespDto();
        BigDecimal marketPriceAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        for (com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto tradeItemReqDto : order.getOrderItems()) {
            if (tradeItemReqDto.getItemOrigPrice() == null) {
                tradeItemReqDto.setItemOrigPrice(BigDecimal.ZERO);
            }
            if (tradeItemReqDto.getItemPrice() == null) {
                tradeItemReqDto.setItemPrice(BigDecimal.ZERO);
            }
            if (tradeItemReqDto.getItemMarketPrice() == null) {
                tradeItemReqDto.setItemMarketPrice(BigDecimal.ZERO);
            }
            tradeItemReqDto.setPayTotalAmount(tradeItemReqDto.getItemPrice().multiply(new BigDecimal(tradeItemReqDto.getItemNum())));
            if (tradeItemReqDto.getPayTotalAmount() == null) {
                tradeItemReqDto.setPayTotalAmount(BigDecimal.ZERO);
            }
            BigDecimal itemTotalAmount = tradeItemReqDto.getItemOrigPrice().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()));
            totalAmount = totalAmount.add(itemTotalAmount);
            payAmount = payAmount.add(tradeItemReqDto.getPayTotalAmount());
            marketPriceAmount = tradeItemReqDto.getItemMarketPrice().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()));
            BigDecimal subtract = tradeItemReqDto.getItemMarketPrice().subtract(tradeItemReqDto.getItemOrigPrice());
            BigDecimal discountTotalAmount = subtract.multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()));
            if (BigDecimal.ZERO.compareTo(discountTotalAmount) >= 0) continue;
            tradeItemReqDto.setDiscountTotalAmount(discountTotalAmount);
            totalDiscountAmount = tradeItemReqDto.getDiscountTotalAmount();
        }
        orderPreviewRespDto.setTotalAmount(marketPriceAmount);
        orderPreviewRespDto.setPayAmount(payAmount);
        orderPreviewRespDto.setDiscountAmount(totalDiscountAmount);
        orderPreviewRespDto.setTotalDiscountAmount(totalDiscountAmount);
        orderPreviewRespDto.setFreightAmount(BigDecimal.ZERO);
        order.setShopId(((com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto)order.getOrderItems().get(0)).getShopId());
        this.buildRebate(order, orderPreviewRespDto);
        logger.info("buildRebate: {}, {}", (Object)JSON.toJSONString((Object)order), (Object)JSON.toJSONString((Object)orderPreviewRespDto));
        ArrayList tradeItemRespDtos = Lists.newArrayList();
        List tradeItemReqDtos = order.getOrderItems();
        CubeBeanUtils.copyCollection((Collection)tradeItemRespDtos, (Collection)tradeItemReqDtos, TradeItemRespDto.class);
        orderPreviewRespDto.setOrderItems((List)tradeItemRespDtos);
        orderPreviewRespDto.setDeduction(order.isDeduction());
        logger.info("buildRebate_1: {}", (Object)JSON.toJSONString((Object)orderPreviewRespDto));
        return orderPreviewRespDto;
    }

    private void buildRebate(OrderPreviewReqDto order, OrderPreviewRespDto orderPreviewRespDto) {
        BigDecimal totalRebateAmount;
        logger.info("buildRebate_\u539f\u59cb: {}", (Object)JSON.toJSONString((Object)order));
        BigDecimal releaseRebateAmount = totalRebateAmount = order.getTotalRebateAmount();
        if (totalRebateAmount != null && totalRebateAmount.compareTo(BigDecimal.ZERO) > 0) {
            logger.info("order_rebate_ruleId: {}", (Object)order.getRuleId());
            if (order.getRuleId() != null) {
                RestResponse ruleRespDtoRestResponse = this.rebateRuleQueryApi.queryRuleById(order.getRuleId());
                RuleRespDto ruleRespDto = (RuleRespDto)RestResponseHelper.extractData((RestResponse)ruleRespDtoRestResponse);
                ArrayList ruleObjectType = new ArrayList();
                ruleRespDto.getRuleContent().forEach(ruleUseRuleContentReqDto -> ruleObjectType.add(ruleUseRuleContentReqDto.getType().toCode()));
                ArrayList blacklistItem = ruleRespDto.getBlacklistItem();
                if (blacklistItem == null) {
                    blacklistItem = new ArrayList();
                }
                List blackSkuId = blacklistItem.stream().map(ItemBaseDto::getSkuId).collect(Collectors.toList());
                ArrayList<com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto> newOrderItem = new ArrayList<com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto>();
                for (com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto orderItem : order.getOrderItems()) {
                    if (ruleObjectType.contains("ALL") || ruleObjectType.contains(RebateHelper.subTypeInteger2String(orderItem.getSubType())) && !blackSkuId.contains(Long.parseLong(orderItem.getSkuSerial()))) {
                        if (orderItem.getGift() == 0) {
                            newOrderItem.add(orderItem);
                            continue;
                        }
                        orderItem.setRebateAmount(BigDecimal.ZERO);
                        continue;
                    }
                    orderItem.setRebateAmount(BigDecimal.ZERO);
                }
                logger.info("newOrderItem\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(newOrderItem));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(newOrderItem)) {
                    this.rebateHelper.apportionmentAmount(order, totalRebateAmount, newOrderItem);
                }
                BigDecimal payAmount = orderPreviewRespDto.getPayAmount().subtract(totalRebateAmount);
                orderPreviewRespDto.setPayAmount(BigDecimal.ZERO.max(payAmount));
                orderPreviewRespDto.setTotalRebateAmount(totalRebateAmount);
            } else {
                BigDecimal totalAmount = order.getOrderItems().stream().filter(item -> item.getGift() == 0).map(item -> item.getPayTotalAmount() == null ? BigDecimal.ZERO : item.getPayTotalAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
                List<com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto> joinApportionmentItems = order.getOrderItems().stream().filter(e -> e.getGift() == 0).collect(Collectors.toList());
                this.rebateHelper.apportionmentAmount(order, totalRebateAmount, joinApportionmentItems);
                BigDecimal shareTotalAmount = order.getOrderItems().stream().filter(e -> e.getRebateAmount() != null).map(com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto::getRebateAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                logger.info("\u65e0\u6298\u6263\u89c4\u5219_\u603b\u5206\u644a\u91d1\u989d\u5927\u4e8e\u5206\u644a\u91d1\u989d[{},{}]", (Object)shareTotalAmount, (Object)totalRebateAmount);
                BigDecimal payAmount = orderPreviewRespDto.getPayAmount().subtract(totalRebateAmount);
                orderPreviewRespDto.setPayAmount(BigDecimal.ZERO.max(payAmount));
                orderPreviewRespDto.setTotalRebateAmount(totalRebateAmount);
            }
        }
    }

    @Deprecated
    protected static BigDecimal getTotalPrice(com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto f) {
        return f.getItemMarketPrice().multiply(BigDecimal.valueOf(f.getItemNum().intValue())).subtract(Optional.ofNullable(f.getDiscountTotalAmount()).orElse(BigDecimal.ZERO));
    }

    private Integer sumPresentPoint(List<com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto> orderItems) {
        return orderItems.stream().mapToInt(tradeItem -> tradeItem.getPresentPoint() == null ? 0 : tradeItem.getPresentPoint()).sum();
    }

    @Override
    public com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto countOrderAmountAndFreight(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto order) {
        com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto = this.countOrderAmount(order);
        return this.countFreight(orderReqDto);
    }

    @Override
    public com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto countOrderAmount(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto, boolean isCountTotalPay) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        long totalIntegral = 0L;
        for (com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto tradeItemReqDto : orderReqDto.getOrderItems()) {
            if (tradeItemReqDto.getItemOrigPrice() == null) {
                tradeItemReqDto.setItemOrigPrice(BigDecimal.ZERO);
            }
            if (tradeItemReqDto.getItemPrice() == null) {
                tradeItemReqDto.setItemPrice(BigDecimal.ZERO);
            }
            tradeItemReqDto.setItemMarketPrice(tradeItemReqDto.getItemPrice());
            if (isCountTotalPay) {
                tradeItemReqDto.setPayTotalAmount(tradeItemReqDto.getItemPrice().multiply(new BigDecimal(tradeItemReqDto.getItemNum())));
            }
            if (tradeItemReqDto.getPayTotalAmount() == null) {
                tradeItemReqDto.setPayTotalAmount(BigDecimal.ZERO);
            }
            logger.info("itemId={}, itemCode={}, itemOrigPrice={}, itemNum={}", new Object[]{tradeItemReqDto.getId(), tradeItemReqDto.getItemCode(), tradeItemReqDto.getItemOrigPrice(), tradeItemReqDto.getItemNum()});
            BigDecimal itemTotalAmount = tradeItemReqDto.getItemOrigPrice().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()));
            totalAmount = totalAmount.add(itemTotalAmount);
            if (tradeItemReqDto.getBusType() != null && ItemBusTypeEnum.INTEGRAL.getType().intValue() == tradeItemReqDto.getBusType().intValue()) {
                if (tradeItemReqDto.getCashType() != null && 2 == tradeItemReqDto.getCashType()) {
                    payAmount = payAmount.add(tradeItemReqDto.getCashAmount().multiply(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue())));
                }
                totalIntegral += (long)tradeItemReqDto.getItemNum().intValue() * tradeItemReqDto.getCashIntegral();
                continue;
            }
            payAmount = payAmount.add(tradeItemReqDto.getPayTotalAmount());
        }
        orderReqDto.setTotalAmount(totalAmount);
        orderReqDto.setPayAmount(payAmount);
        orderReqDto.setTotalIntegral(Long.valueOf(totalIntegral));
        return orderReqDto;
    }

    @Override
    public com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto countOrderAmount(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto) {
        return this.countOrderAmount(orderReqDto, false);
    }

    @Override
    public OrderEo queryDetailByThirdOrderNo(String thirdOrderNo, String parentThirdOrderNo) {
        List orderEos;
        OrderEo orderEo = new OrderEo();
        if (!org.springframework.util.StringUtils.isEmpty((Object)thirdOrderNo)) {
            orderEo.setThirdOrderNo(thirdOrderNo);
        }
        if (!StringUtils.isEmpty((CharSequence)parentThirdOrderNo)) {
            orderEo.setThirdParentOrderNo(parentThirdOrderNo);
        }
        return org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(orderEos = this.orderDas.select((BaseEo)orderEo))) ? null : (OrderEo)orderEos.get(0);
    }

    @Override
    public Boolean ifSubVirtualStock(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto) {
        if (orderReqDto.getActivity() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderReqDto.getActivity().getActivityList())) {
            for (OrderActivityInfoReqDto orderActivityBizReqDto : orderReqDto.getActivity().getActivityList()) {
                if (orderActivityBizReqDto.getType() == null || !orderActivityBizReqDto.getType().equals(1)) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean checkIfSkill(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReq) {
        if (orderReq.getActivity() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList())) {
            for (OrderActivityInfoReqDto orderActivityInfoReqDto : orderReq.getActivity().getActivityList()) {
                if (!ActivityConstant.SECKILL_ACTIVITY.equals(orderActivityInfoReqDto.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkIfSkill(OrderEo orderEo) {
        List<OrderActivityEo> orderActivityEos = this.orderActivityService.queryActivityByOrderNo(orderEo.getOrderNo());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderActivityEos)) {
            return false;
        }
        for (OrderActivityEo orderActivityEo : orderActivityEos) {
            if (!ActivityConstant.SECKILL_ACTIVITY.equals(orderActivityEo.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void subOrderStock(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto) {
        this.extlOrderStockService.subVirStock(orderReqDto);
    }

    @Override
    public void rollbackOrderStock(OrderEo orderEo) {
        this.extlOrderStockService.rollbackVirStock(orderEo);
    }

    @Override
    public void rollbackOrderStockByActivity(OrderEo orderEo) {
        this.extlOrderStockService.rollbackVirStockByActivity(orderEo);
    }

    @Override
    public void rollbackOrderStock(com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto orderReqDto) {
        this.extlOrderStockService.rollbackVirStock(orderReqDto);
    }

    private void sendConfirmReceiptDeliveryMq(String orderNo) {
        logger.info("\u7528\u6237\u786e\u8ba4\u6536\u8d27\uff0c\u53d1\u9001\u66f4\u65b0\u53d1\u8d27\u5355\u72b6\u6001MQ\uff0corderNo\uff1a{}", (Object)orderNo);
        ConfirmOrderReqDto confirmOrderReqDto = new ConfirmOrderReqDto();
        confirmOrderReqDto.setTradeNo(orderNo);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${CONFIRM_RECEIPT_DELIVERY_TOPIC:CONFIRM_RECEIPT_DELIVERY_TOPIC}"), this.environment.resolvePlaceholders("CONFIRM_RECEIPT_DELIVERY_TAG"), (Object)confirmOrderReqDto);
    }

    private Map<String, Integer> getItemRefundMap(String tradeNo, String userId) {
        ReturnQueryReqDto returnQueryReqDto = new ReturnQueryReqDto();
        returnQueryReqDto.setOrderTradeNo(tradeNo);
        returnQueryReqDto.setUserId(userId);
        PageInfo<ReturnRespDto> pageInfo = this.afterSalesService.queryReturnByPage(returnQueryReqDto, (Integer)1, (Integer)1000);
        HashMap itemRefundNumMap = Maps.newHashMap();
        if (null != pageInfo && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(afterSalesRespDto -> {
                if (!ReturnStatusEnum.CLOSE.getName().equals(afterSalesRespDto.getReturnStatus()) && !ReturnStatusEnum.CANCEL.getName().equals(afterSalesRespDto.getReturnStatus()) && !ReturnStatusEnum.REJECT.getName().equals(afterSalesRespDto.getReturnStatus()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)afterSalesRespDto.getReturnOmniItemRespDtoList())) {
                    afterSalesRespDto.getReturnOmniItemRespDtoList().stream().forEach(bean -> {
                        Integer itemRefundNum = (Integer)itemRefundNumMap.get(bean.getTradeItemId() + "_" + bean.getSkuSerial());
                        itemRefundNum = null == itemRefundNum ? bean.getReturnNum() : Integer.valueOf(itemRefundNum + bean.getReturnNum());
                        itemRefundNumMap.put(bean.getTradeItemId() + "_" + bean.getSkuSerial(), itemRefundNum);
                    });
                }
            });
        }
        return itemRefundNumMap;
    }

    private void setRefundNum(List<TradeItemRespDto> tradeItemRepDtos, String orderNo, String userId) {
        Map<String, Integer> itemRefundNumMap = this.getItemRefundMap(orderNo, userId);
        for (TradeItemRespDto tradeItemRespDto : tradeItemRepDtos) {
            if (Integer.valueOf(1).equals(tradeItemRespDto.getGift()) || null == itemRefundNumMap.get(tradeItemRespDto.getId() + "_" + tradeItemRespDto.getSkuSerial())) continue;
            tradeItemRespDto.setRefundNum(itemRefundNumMap.get(tradeItemRespDto.getId() + "_" + tradeItemRespDto.getSkuSerial()));
        }
    }

    @Override
    public OrderDetailRespDto getDetail(String orderNo, String attrs) {
        OrderEo orderEo = this.orderService.getByOrderNo(orderNo);
        if (null == orderEo) {
            return null;
        }
        OrderDetailRespDto orderDetailRespDto = new OrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderDetailRespDto);
        orderDetailRespDto.setDeliveryInfo(orderEo.getDeliveryInfo());
        orderDetailRespDto.setTotalRebateAmount(orderEo.getTotalRebateAmount());
        if (StringUtils.isBlank((CharSequence)attrs)) {
            return orderDetailRespDto;
        }
        String[] attrArr = StringUtils.split((String)attrs, (String)",");
        ArrayList orderQueryEnums = Lists.newArrayList();
        for (String attr : attrArr) {
            OrderQueryEnum queryEnum = OrderQueryEnum.getOrderQueryEnum((String)attr);
            if (null == queryEnum) continue;
            orderQueryEnums.add(queryEnum);
            if (!OrderQueryEnum.ALL.equals((Object)queryEnum)) continue;
            orderQueryEnums = Lists.newArrayList((Object[])OrderQueryEnum.values());
            break;
        }
        for (OrderQueryEnum queryEnum : orderQueryEnums) {
            switch (queryEnum) {
                case PAY_RECORD: {
                    List<PayRecordRespDto> payRecordRespDtos = this.payService.getPayRecordRespSuccessByOrderNo(orderEo.getOrderNo());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(payRecordRespDtos)) {
                        orderDetailRespDto.setPayRecord(payRecordRespDtos.get(0));
                    }
                    orderDetailRespDto.setPayRecordList(payRecordRespDtos);
                    break;
                }
                case ADDRESS: {
                    List<OrderDeliveryRespDto> orderDeliveryRespDtos;
                    List<OrderAddressRespDto> orderAddressRespDtos = this.orderAddressService.queryDtoByTradeNo(orderNo);
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(orderAddressRespDtos)) break;
                    OrderAddressRespDto orderAddress = orderAddressRespDtos.get(0);
                    String shippingType = orderAddress.getShippingType();
                    if (StringUtils.isNotBlank((CharSequence)shippingType) && ShippingTypeEnum.PICKUP.getType().equals(shippingType) && org.apache.commons.collections.CollectionUtils.isNotEmpty(orderDeliveryRespDtos = this.orderDeliveryService.queryOrderDeliveryByOrderNo(orderDetailRespDto.getOrderNo()))) {
                        orderAddress.setPickUpCode(orderDeliveryRespDtos.get(0).getPickUpCode());
                    }
                    orderDetailRespDto.setOrderAddress(orderAddress);
                    orderDetailRespDto.setDeliveryAddress(JSON.toJSONString((Object)orderAddress));
                    break;
                }
                case INVOICE: {
                    List<OrderInvoiceRespDto> orderInvoiceRespDtos = this.orderInvoiceService.queryDtoByOrderNo(orderEo.getThirdParentOrderNo());
                    orderDetailRespDto.setOrderInvoiceRespDtos(orderInvoiceRespDtos);
                    break;
                }
                case ITEM: {
                    List<TradeItemRespDto> tradeItemRepDtos = this.tradeItemService.queryDtoByTradeNo(orderEo.getOrderNo());
                    this.setRefundNum(tradeItemRepDtos, orderNo, orderDetailRespDto.getUserId());
                    orderDetailRespDto.setOrderItems(tradeItemRepDtos);
                    break;
                }
                case CHANNEL: {
                    ChannelEo channelEo = this.channelService.queryByCode(orderEo.getSaleChannel());
                    orderDetailRespDto.setSaleChannel(channelEo != null ? channelEo.getName() : orderEo.getSaleChannel());
                    break;
                }
                case ACTIVITY: {
                    OrderActivityReqDto reqDto = new OrderActivityReqDto();
                    reqDto.setOrderNo(orderNo);
                    List<OrderActivityRespDto> activityList = this.orderActivityService.queryList(reqDto);
                    orderDetailRespDto.setActivityList(activityList);
                    break;
                }
                case FACTORY_DELIVERY: {
                    FactoryDeliveryOrderRespDto factoryDeliveryOrderRespDto = this.deliveryOrderService.queryDeliveryByOrderNo(orderNo);
                    orderDetailRespDto.setFactoryDeliveryOrderRespDto(factoryDeliveryOrderRespDto);
                    break;
                }
            }
        }
        return orderDetailRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importExcelOrder(String filePath) {
        logger.info("\u5bfc\u5165excel\u6570\u636e\u6587\u4ef6\u8def\u5f84\u4e3a:{}", (Object)filePath);
        try {
            List<OrderExcelDto> list = ExcelParseObjectUtil.parseImportFile(filePath, OrderExcelDto.class);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
                throw new BizException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            logger.info("\u5bfc\u5165excel\u7684\u6570\u636e\u4e3a{}", (Object)JSON.toJSONString(list));
            Map<String, List<OrderExcelDto>> groupByChannelOrderNo = list.stream().collect(Collectors.groupingBy(OrderExcelDto::getSaleChannelOrderNo));
            groupByChannelOrderNo.forEach((k, v) -> {
                if (IsBillingEnum.YES.getValue().equals(((OrderExcelDto)v.get(0)).getIsBilling())) {
                    this.verificationInvoiceInfo((List<OrderExcelDto>)v);
                    this.verificationItemInfo((List<OrderExcelDto>)v);
                    this.verificationOrderInfo((String)k, (List<OrderExcelDto>)v);
                }
                ShopQueryReqDto shopQueryDto = new ShopQueryReqDto();
                ArrayList codes = Lists.newArrayList((Object[])new String[]{((OrderExcelDto)v.get(0)).getShopCode()});
                shopQueryDto.setCodes((List)codes);
                RestResponse shopList = this.shopQueryApi.queryShopByCode(shopQueryDto);
                ShopDto shopDto = (ShopDto)((List)shopList.getData()).get(0);
                OrderEo orderEo = OrderEo.newInstance();
                orderEo.setShopId(String.valueOf(shopDto.getSelfId()));
                orderEo.setSaleChannelOrderNo(k);
                orderEo.setPlaceTime(((OrderExcelDto)v.get(0)).getPlaceTime());
                String orderNo = TradeUtil.generateTradeNo();
                orderEo.setOrderNo(orderNo);
                orderEo.setBuyerRemark(((OrderExcelDto)v.get(0)).getBuyerRemark());
                orderEo.setSellerRemark(((OrderExcelDto)v.get(0)).getSellerRemark());
                OrderAddressEo orderAddressEo = OrderAddressEo.newInstance();
                BeanUtils.copyProperties(v.get(0), (Object)orderAddressEo);
                orderAddressEo.setOrderNo(orderNo);
                String deliceryAddress = JSONObject.toJSONString((Object)orderAddressEo);
                orderEo.setDeliveryAddress(deliceryAddress);
                ArrayList orderInvoiceEos = new ArrayList();
                DtoHelper.dtoList2EoList((Collection)v, orderInvoiceEos, OrderInvoiceEo.class);
                OrderInvoiceEo orderInvoiceEo = (OrderInvoiceEo)orderInvoiceEos.get(0);
                String invoiceNo = TradeUtil.generateTradeNo();
                orderInvoiceEo.setInvoiceNo(invoiceNo);
                ArrayList<TradeItemEo> tradeItemEos = new ArrayList<TradeItemEo>();
                DtoHelper.dtoList2EoList((Collection)v, tradeItemEos, TradeItemEo.class);
                tradeItemEos.forEach(tradeItemEo -> {
                    String tradeItemNo = TradeUtil.generateTradeNo();
                    tradeItemEo.setTradeItemNo(tradeItemNo);
                });
                this.saveOrderInfo(orderAddressEo, orderInvoiceEo, tradeItemEos, orderEo);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void verificationInvoiceInfo(List<OrderExcelDto> orderExcelDtoLists) {
        if (StringUtils.isBlank((CharSequence)orderExcelDtoLists.get(0).getInvoiceTitle())) {
            throw new BizException("\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderExcelDtoLists.get(0).getInvoiceTitleType()) {
            throw new BizException("\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)orderExcelDtoLists.get(0).getTaxCode())) {
            throw new BizException("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)orderExcelDtoLists.get(0).getReceiverEmail())) {
            throw new BizException("\u7535\u5b50\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)orderExcelDtoLists.get(0).getBuyerRemark())) {
            throw new BizException("\u4e70\u5bb6\u7559\u8a00");
        }
        if (StringUtils.isBlank((CharSequence)orderExcelDtoLists.get(0).getSellerRemark())) {
            throw new BizException("\u5356\u5bb6\u7559\u8a00");
        }
    }

    private void verificationItemInfo(List<OrderExcelDto> orderExcelDtos) {
        orderExcelDtos.forEach(orderExcelDto -> {
            BigDecimal itemPayTotalAmount = orderExcelDto.getItemOrigPrice().multiply(new BigDecimal(orderExcelDto.getItemNum())).add(orderExcelDto.getAdjustAmount());
            if (!itemPayTotalAmount.equals(orderExcelDto.getPayTotalAmount())) {
                throw new BizException(String.format("\u7b2c%d\u884c\uff0c\u5546\u54c1\u552e\u4ef7*\u5546\u54c1\u6570\u91cf+\u8c03\u6574\u91d1\u989d\u2260\u5546\u54c1\u603b\u5b9e\u4ed8", orderExcelDto.getIndex()));
            }
        });
        BigDecimal reduce = new BigDecimal(0);
        BigDecimal orderAmount = orderExcelDtos.stream().map(OrderExcelDto::getPayTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!orderAmount.equals(orderExcelDtos.get(0).getAllAmount())) {
            throw new BizException(String.format("\u7b2c%d\u884c\u6240\u6709\u5546\u54c1\u603b\u5b9e\u4ed8\u4e4b\u548c\u9700\u7b49\u4e8e\u8ba2\u5355\u91d1\u989d", orderExcelDtos.get(0).getIndex()));
        }
        if (orderExcelDtos.size() > 1) {
            for (int i = 1; i < orderExcelDtos.size(); ++i) {
                if (!orderExcelDtos.get(i).getPlaceTime().equals(orderExcelDtos.get(0).getPlaceTime())) {
                    throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u4e0b\u5355\u65f6\u95f4"));
                }
                if (!orderExcelDtos.get(i).getDeliveryName().equals(orderExcelDtos.get(0).getDeliveryName())) {
                    throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u6536\u8d27\u4eba\u59d3\u540d"));
                }
                if (!orderExcelDtos.get(i).getDeliveryMobile().equals(orderExcelDtos.get(0).getDeliveryMobile())) {
                    throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u6536\u8d27\u4eba\u624b\u673a\u53f7"));
                }
                if (!orderExcelDtos.get(i).getProvinceName().equals(orderExcelDtos.get(0).getProvinceName())) {
                    throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u7701\u540d\u79f0"));
                }
                if (!orderExcelDtos.get(i).getCityName().equals(orderExcelDtos.get(0).getCityName())) {
                    throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u5e02\u540d\u79f0"));
                }
                if (!orderExcelDtos.get(i).getAreaName().equals(orderExcelDtos.get(0).getAreaName())) {
                    throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u533a\u540d\u79f0"));
                }
                if (orderExcelDtos.get(i).getDetailed().equals(orderExcelDtos.get(0).getDetailed())) continue;
                throw new BizException(this.getExceptionMsg(orderExcelDtos, i, "\u8be6\u7ec6\u5730\u5740"));
            }
        }
    }

    private void verificationOrderInfo(String saleChannelOrderNo, List<OrderExcelDto> orderExcelDtos) {
        OrderEo orderEo = OrderEo.newInstance();
        orderEo.setSaleChannelOrderNo(saleChannelOrderNo);
        OrderEo selectOne = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
        if (null != selectOne) {
            throw new BizException(String.format("\u3010\u6e20\u9053\u5355\u53f7%s\u4e0e\u73b0\u6709\u5355\u53f7\u91cd\u590d\u3011", saleChannelOrderNo));
        }
        if (orderExcelDtos.size() > 5000) {
            throw new BizException("\u5bfc\u5165\u9650\u5236\u4e0d\u80fd\u8d85\u8fc75000\u6761");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrderInfo(OrderAddressEo orderAddressEo, OrderInvoiceEo orderInvoiceEo, List<TradeItemEo> tradeItemEos, OrderEo orderEo) {
        this.orderAddressDas.insert((BaseEo)orderAddressEo);
        this.orderInvoiceDas.insert((BaseEo)orderInvoiceEo);
        this.tradeItemDas.insertBatch(tradeItemEos);
        this.orderDas.insert((BaseEo)orderEo);
    }

    private String getExceptionMsg(List<OrderExcelDto> orderExcelDtos, int i, String msg) {
        return String.format("\u3010\u7b2c%d\u3001%d\u884c\uff0c%s\u4e0d\u4e00\u81f4\u3011", orderExcelDtos.get(0).getIndex(), orderExcelDtos.get(i).getIndex(), msg);
    }

    @Override
    public void batchRemarkOrderTags(RemarkOrderTagsReqDto remarkOrderTagsReqDto) {
        List orderNos = remarkOrderTagsReqDto.getOrderNos();
        String remark = remarkOrderTagsReqDto.getRemark();
        String orderTags = remarkOrderTagsReqDto.getOrderTags();
        OrderEo orderEo = new OrderEo();
        orderEo.setSellerRemark(remark);
        orderEo.setOrderTags(orderTags);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"order_no", (Object)orderNos));
        orderEo.setSqlFilters(sqlFilters);
        this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
    }

    @Override
    public List<OrderCompareVo> selectCompareVos(OrderCompareQueryReqDto dto) {
        ArrayList<OrderCompareVo> list = new ArrayList<OrderCompareVo>(20);
        OrderEo orderEo = new OrderEo();
        ArrayList sqlFilters = Lists.newArrayList();
        if (dto.getStartTime() != null) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)dto.getStartTime()));
        }
        if (dto.getEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)dto.getEndTime()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getChannelCodes())) {
            sqlFilters.add(SqlFilter.in((String)"sale_channel", (Object)dto.getChannelCodes()));
        }
        orderEo.setOrderTradeStatus(OrderStatusEnum.COMPLETE.getCode());
        orderEo.setParentOrderNo(YesNoEnum.NO.getValue().toString());
        orderEo.setSqlFilters((List)sqlFilters);
        List orderEos = this.orderDas.select((BaseEo)orderEo);
        ReturnEo returnEo = new ReturnEo();
        returnEo.setSqlFilters((List)sqlFilters);
        List returnEos = this.returnDas.select((BaseEo)returnEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderEos)) {
            orderEos.forEach(o -> {
                OrderCompareVo vo = new OrderCompareVo();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)returnEos)) {
                    returnEos.forEach(eo -> {
                        if (o.getOrderNo().equals(eo.getOrderTradeNo())) {
                            vo.setPaidAmount(eo.getRefundAmount());
                        }
                    });
                }
                list.add(vo);
            });
        }
        return list;
    }

    @Override
    @Transactional
    public void logicDeleteOrder(Long orderId) {
        OrderEo orderEo = (OrderEo)this.orderDas.selectByPrimaryKey(orderId);
        Assert.notNull((Object)orderEo, TradeExceptionCode.ORDER_NO_EXIT);
        Assert.isTrue(OrderBizStatusTobEnum.DRAFT.getCode().equals(orderEo.getOrderTradeStatus()), "\u4ec5\u9650\u8349\u7a3f\u72b6\u6001\u8ba2\u5355\u53ef\u5220\u9664");
        this.orderDas.logicDeleteById(orderId);
    }

    @Override
    @Transactional
    public Long addStockBatch(OrderStockBatchDto order) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)order.getOrderItemStockBatchDtos())) {
            return order.getOrderId();
        }
        OrderEo orderEo = (OrderEo)this.orderDas.selectByPrimaryKey(order.getOrderId());
        Assert.notNull((Object)orderEo, "\u8be5\u503c\u4e3a\u7a7a:" + order.getOrderId());
        TradeItemEo eo = new TradeItemEo();
        eo.setTradeItemNo(order.getTradeItemNo());
        List<TradeItemEo> eoList = this.tradeItemService.queryByTradeItemEo(eo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(eoList)) {
            throw new BizException("\u672a\u627e\u5230\u4ea4\u6613\u5546\u54c1\u6d41\u6c34\u53f7");
        }
        Integer itemSum = eoList.get(0).getItemNum();
        int reduceNum = order.getOrderItemStockBatchDtos().stream().mapToInt(OrderItemStockBatchDto::getNum).reduce(0, Integer::sum);
        if (reduceNum > itemSum) {
            throw new BizException("\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u6570");
        }
        List orderItemStockBatchDtos = order.getOrderItemStockBatchDtos();
        Map group = orderItemStockBatchDtos.stream().collect(Collectors.groupingBy(OrderItemStockBatchDto::getSkuId, Collectors.toList()));
        HashMap<String, String> batchForSku = new HashMap<String, String>();
        for (Map.Entry longListEntry : group.entrySet()) {
            StringBuilder stringBuilder = this.getStringSort(longListEntry.getValue());
            batchForSku.put(String.valueOf(longListEntry.getKey()), stringBuilder.toString());
        }
        TradeItemEo selectItemTradeItem = new TradeItemEo();
        selectItemTradeItem.setTradeNo(orderEo.getOrderNo());
        selectItemTradeItem.setDr(0);
        List tradeItemEos = this.tradeItemDas.select((BaseEo)selectItemTradeItem);
        for (TradeItemEo tradeItemEo : tradeItemEos) {
            if (!batchForSku.containsKey(tradeItemEo.getSkuSerial()) || !tradeItemEo.getTradeItemNo().equals(order.getTradeItemNo())) continue;
            tradeItemEo.setBatchNo((String)batchForSku.get(tradeItemEo.getSkuSerial()));
            this.tradeItemDas.updateSelective((BaseEo)tradeItemEo);
        }
        return order.getOrderId();
    }

    private List<TradeItemRespDto> getEosToResp(List<TradeItemEo> tradeItemEos) {
        return tradeItemEos.stream().map(eo -> {
            TradeItemRespDto dto = new TradeItemRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto, (String[])new String[]{"cycleValue"});
            if (StringUtils.isNotBlank((CharSequence)eo.getCycleValue())) {
                Integer[] cycleValue = (Integer[])Stream.of(StringUtils.split((String)eo.getCycleValue(), (String)",")).map(Integer::valueOf).toArray(Integer[]::new);
                dto.setCycleValue(cycleValue);
            }
            if (StringUtils.isNotEmpty((CharSequence)eo.getRemark())) {
                dto.setRemark(eo.getRemark());
            }
            int completeDeliveryNum = dto.getCompleteDeliveryNum() != null ? dto.getCompleteDeliveryNum() : 0;
            dto.setCompleteDeliveryNum(Integer.valueOf(completeDeliveryNum));
            if (dto.getItemNum() != null) {
                dto.setIncompleteDeliveryNum(Integer.valueOf(dto.getItemNum() - completeDeliveryNum));
            }
            ArrayList<Long> skuId = new ArrayList<Long>();
            skuId.add(Long.valueOf(eo.getSkuSerial()));
            List itemSkuRespDtoList = (List)this.itemSkuQueryApi.queryBySkuId(skuId).getData();
            if (!CollectionUtils.isEmpty((Collection)itemSkuRespDtoList)) {
                dto.setItemCostPrice(((ItemSkuRespDto)itemSkuRespDtoList.get(0)).getCostPrice());
            }
            return dto;
        }).collect(Collectors.toList());
    }

    private StringBuilder getStringSort(List<OrderItemStockBatchDto> longListEntry) {
        Comparator<OrderItemStockBatchDto> byTimeASC = Comparator.comparing(OrderItemStockBatchDto::getTime);
        Comparator<OrderItemStockBatchDto> byBatchASC = Comparator.comparing(OrderItemStockBatchDto::getBatch);
        Comparator<OrderItemStockBatchDto> finalComparator = byTimeASC.thenComparing(byBatchASC);
        List result = longListEntry.stream().sorted(finalComparator).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        for (OrderItemStockBatchDto data : result) {
            if (!StringUtils.isBlank((CharSequence)stringBuilder)) {
                stringBuilder.append(",");
            }
            stringBuilder.append(data.getBatch()).append("#").append(data.getNum());
        }
        return stringBuilder;
    }

    @Override
    public Date getFirstPlaceOrderByCustomerId(Long customerId) {
        return this.orderDas.getFirstPlaceOrderByCustomerId(customerId);
    }

    @Override
    public void clearTradeItemBatch(String orderNo) {
        this.orderDas.clearTradeItemBatch(orderNo);
    }
}

