/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayConfigTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayConfigUseTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.PayMethodTobEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.pay.config.PayConfigMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.pay.config.PayConfigSortUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.pay.config.PayConfigSwitchUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.pay.config.PayConfigUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.pay.config.PayMutexRuleSaveReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.pay.config.PayConfigRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.pay.config.PayMutexRuleItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.pay.config.PayMutexRuleRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.pay.config.PayTypeListRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.pay.config.PayTypeRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayConfigService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayConfigDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayConfigEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PayConfigServiceImpl
implements IPayConfigService {
    @Resource
    private PayConfigDas payConfigDas;

    @Override
    public void modifyPaperWork(PayConfigUpdateReqDto updateReqDto) {
        PayConfigEo eo = new PayConfigEo();
        eo.setId(updateReqDto.getId());
        eo.setPaperWork(updateReqDto.getPaperWork());
        this.payConfigDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void modifySort(PayConfigSortUpdateReqDto updateReqDto) {
        if (CollectionUtils.isEmpty((Collection)updateReqDto.getIds())) {
            return;
        }
        List ids = updateReqDto.getIds();
        for (int i = 0; i < ids.size(); ++i) {
            PayConfigEo eo = new PayConfigEo();
            eo.setUseType(updateReqDto.getUseType());
            eo.setId((Long)ids.get(i));
            eo.setSort(Integer.valueOf(i));
            this.payConfigDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void modifySwitch(PayConfigSwitchUpdateReqDto updateReqDto) {
        PayConfigEo eo = new PayConfigEo();
        eo.setUseType(updateReqDto.getUseType());
        eo.setMainData(updateReqDto.getChecked());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"use_type", (Object)updateReqDto.getUseType()));
        eo.setSqlFilters(sqlFilters);
        this.payConfigDas.updateSelectiveSqlFilter((BaseEo)eo);
    }

    @Override
    public List<PayConfigRespDto> queryPayConfigList() {
        return this.payConfigDas.queryPayConfigList();
    }

    @Override
    public List<PayConfigMethodReqDto> queryPayConfigDropdown() {
        return this.payConfigDas.queryPayConfigDropdown();
    }

    @Override
    public void saveMutexRule(PayMutexRuleSaveReqDto updateReqDto) {
        PayConfigEo eo = new PayConfigEo();
        eo.setUseType("PAY_MUTEX_RULES");
        eo.setMainData(JSON.toJSONString((Object)updateReqDto.getTypes()));
        if (updateReqDto.getId() == null) {
            this.payConfigDas.insert((BaseEo)eo);
        } else {
            eo.setId(updateReqDto.getId());
            this.payConfigDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void deleteMutexRule(Long id) {
        PayConfigEo eo = new PayConfigEo();
        eo.setId(id);
        eo.setUseType("PAY_MUTEX_RULES");
        this.payConfigDas.logicDelete((BaseEo)eo);
    }

    @Override
    public List<PayMutexRuleRespDto> queryPayMutexRuleList() {
        List list = this.payConfigDas.queryPayMutexRuleList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        list.forEach(payMutexRuleRespDto -> {
            if (StringUtils.isNotBlank((String)payMutexRuleRespDto.getMainDate())) {
                List types = JSON.parseArray((String)payMutexRuleRespDto.getMainDate(), String.class);
                ArrayList typeList = new ArrayList();
                types.forEach(s -> {
                    String name = PayConfigTypeEnum.valueOf((String)s).getDesc();
                    PayMutexRuleItemRespDto itemRespDto = new PayMutexRuleItemRespDto();
                    itemRespDto.setName(name);
                    itemRespDto.setType(s);
                    typeList.add(itemRespDto);
                });
                payMutexRuleRespDto.setTypeList(typeList);
            }
        });
        return list;
    }

    @Override
    public PayTypeRefundRespDto queryRefundOrderList() {
        PayTypeRefundRespDto refundRespDto = new PayTypeRefundRespDto();
        PayConfigEo payConfigEo = this.payConfigDas.selectOneByUseType(PayConfigUseTypeEnum.PAY_TYPE_REFUND_FLAG.code());
        if (payConfigEo != null) {
            refundRespDto.setPayTypeRefundFlag(payConfigEo.getMainData());
        }
        List sysDefault = this.payConfigDas.queryRefundOrderList(PayConfigUseTypeEnum.PAY_TYPE_REFUND_DEFAULT_SORT.code());
        refundRespDto.setSysDefault(sysDefault);
        List customize = this.payConfigDas.queryRefundOrderList(PayConfigUseTypeEnum.PAY_TYPE_REFUND_SORT.code());
        refundRespDto.setCustomize(customize);
        return refundRespDto;
    }

    @Override
    public String querySwitchStatus(String type) {
        PayConfigEo payConfigEo = this.payConfigDas.selectOneByUseType(type);
        if (payConfigEo != null) {
            return payConfigEo.getMainData();
        }
        return "false";
    }

    @Override
    public List<PayTypeListRespDto> queryPayTypeList() {
        ArrayList<PayTypeListRespDto> result = new ArrayList<PayTypeListRespDto>();
        List typeList = this.payConfigDas.queryPayConfigDropdown();
        for (PayConfigMethodReqDto method : typeList) {
            PayTypeListRespDto typeListRespDto = new PayTypeListRespDto();
            typeListRespDto.setType(method.getType());
            typeListRespDto.setPayTypeName(method.getName());
            StringBuilder sb = new StringBuilder();
            PayConfigEo query = new PayConfigEo();
            query.setType(method.getType());
            List configEoList = this.payConfigDas.select((BaseEo)query);
            if (CollectionUtils.isNotEmpty((Collection)configEoList)) {
                configEoList.forEach(payConfigEo -> {
                    sb.append(PayMethodTobEnum.fromCode((String)payConfigEo.getMainData()).getName());
                    sb.append("\u3001");
                });
            }
            String payMethodListName = sb.toString();
            typeListRespDto.setPayMethodListName(payMethodListName.substring(0, payMethodListName.length() - 1));
            result.add(typeListRespDto);
        }
        return result;
    }
}

