/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.payment.api.query.IQueryTradeService;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayOrderQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayOrderQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.AttachInfo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OutPayOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayIntegralOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SubOrderPayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.config.PayConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.FlowInstance;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.impl.MemberServiceImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ContextUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.NetUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngineUtil;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PayServiceImpl
implements IPayService {
    private static Logger logger = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private PayConfig payConfig;
    @Autowired
    PayRecordDas payRecordDas;
    @Autowired
    RefundDas refundDas;
    @Autowired
    ReturnDas returnDas;
    @Autowired
    ICreateTradeService createTradeService;
    @Autowired
    ITradeService tradeService;
    @Autowired
    IQueryTradeService queryTradeService;
    @Value(value="${yundt.cube.center.trade.config.pay.refundScale:2}")
    private Integer refundScale;
    @Value(value="${yundt.cube.center.payment.appvo.apiSecret}")
    public String apiSecret;
    @Value(value="${trade.flow.mock:false}")
    public boolean tradeMock;
    @Resource
    private TradeDas tradeDas;
    @Resource
    private MemberServiceImpl memberService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private IContext context;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private RefundItemDas refundItemDas;

    @Override
    public PayRecordEo saveInitPayRecord(PayRecordEo payRecordEo) {
        Optional.ofNullable(this.payRecordDas.selectByTradeNo(payRecordEo.getTradeNo())).ifPresent(p -> {
            throw new BizException(TradeExceptionCode.PAY_RECORD_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_EXIST.getMsg());
        });
        if (StringUtils.isEmpty((CharSequence)payRecordEo.getPayStatus())) {
            payRecordEo.setPayStatus(PayStatusEnum.INIT.getName());
        }
        this.payRecordDas.insert((BaseEo)payRecordEo);
        return payRecordEo;
    }

    @Override
    public PayMethodBo packCombinePay(PayMethodBo payMethodBo, PayMethodReqDto payMethodReqDto) {
        List<OrderEo> orderEoList = this.orderService.getByParentOrderNo(payMethodReqDto.getOrderNo());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderEoList)) {
            ArrayList<SubOrderPayReqDto> subOrderPayReqDtoList = new ArrayList<SubOrderPayReqDto>(orderEoList.size());
            for (OrderEo orderEo : orderEoList) {
                SubOrderPayReqDto subOrderPayReqDto = new SubOrderPayReqDto();
                subOrderPayReqDto.setTradeNo(orderEo.getTradeNo());
                subOrderPayReqDto.setCloseTime(payMethodReqDto.getCloseTime());
                subOrderPayReqDtoList.add(subOrderPayReqDto);
            }
            payMethodReqDto.setSubOrderPayReqDtos(subOrderPayReqDtoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)payMethodReqDto.getSubOrderPayReqDtos())) {
            BigDecimal payAmount = BigDecimal.ZERO;
            Integer integral = 0;
            this.orderService.validateCompPay(payMethodReqDto.getSubOrderPayReqDtos());
            for (SubOrderPayReqDto subOrderPayReqDto : payMethodReqDto.getSubOrderPayReqDtos()) {
                if (!this.orderService.checkOrderExpireAndCloseTime(subOrderPayReqDto.getTradeNo(), new Date(), subOrderPayReqDto.getCloseTime()).booleanValue()) continue;
                throw new BizException(TradeExceptionCode.ORDER_EXPIRE.getCode(), TradeExceptionCode.ORDER_EXPIRE.getMsg());
            }
            List list = payMethodReqDto.getSubOrderPayReqDtos();
            StringBuilder orderNos = new StringBuilder();
            for (SubOrderPayReqDto subOrderPayReqDto : list) {
                orderNos.append("'").append(subOrderPayReqDto.getTradeNo()).append("'").append(",");
            }
            OrderEo orderQuery = OrderEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"order_no", (Object)orderNos.substring(0, orderNos.length() - 1)));
            orderQuery.setSqlFilters(sqlFilterList);
            List orders = this.orderDas.select((BaseEo)orderQuery);
            for (OrderEo order : orders) {
                payAmount = payAmount.add(order.getPayAmount());
                integral = integral + order.getIntegral();
            }
            payAmount.setScale(2);
            payMethodBo.getPayRecordEo().setPayAmount(payAmount);
            payMethodBo.getPayRecordEo().setIntegral(integral);
            if (!PayTypeEnum.INTEGRAL.getCode().equals(payMethodReqDto.getPayMethod())) {
                payMethodBo.getPayRequest().setOrderAmt(payAmount);
            } else {
                payMethodBo.getPayRequest().setOrderAmt(new BigDecimal(integral).setScale(2));
            }
        }
        return payMethodBo;
    }

    @Override
    public List<PayRecordRespDto> getPaySuccessRecords(Set<String> tradeNos) {
        PayRecordEo payRecordEo = PayRecordEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isEmpty(tradeNos)) {
            return new ArrayList<PayRecordRespDto>();
        }
        sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)StringUtils.join(tradeNos, (String)",")));
        sqlFilters.add(SqlFilter.eq((String)"pay_status", (Object)PayStatusEnum.SUCCESS.getName()));
        payRecordEo.setSqlFilters(sqlFilters);
        List results = this.payRecordDas.select((BaseEo)payRecordEo);
        ArrayList<PayRecordRespDto> payRecordRespDtos = new ArrayList<PayRecordRespDto>();
        if (!CollectionUtils.isEmpty((Collection)results)) {
            DtoHelper.eoList2DtoList((Collection)results, payRecordRespDtos, PayRecordRespDto.class);
        }
        return payRecordRespDtos;
    }

    @Override
    public List<PayRecordRespDto> getPaySuccessRecord(Set<String> orderNos) {
        PayRecordEo payRecordEo = PayRecordEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"order_no", (Object)StringUtils.join(orderNos, (String)",")));
        sqlFilters.add(SqlFilter.eq((String)"pay_status", (Object)PayStatusEnum.SUCCESS.getName()));
        payRecordEo.setSqlFilters(sqlFilters);
        List results = this.payRecordDas.select((BaseEo)payRecordEo);
        if (!CollectionUtils.isEmpty((Collection)results)) {
            ArrayList<PayRecordRespDto> payRecordRespDtos = new ArrayList<PayRecordRespDto>();
            PayRecordRespDto payRecordRespDto = new PayRecordRespDto();
            DtoHelper.eoList2DtoList((Collection)results, payRecordRespDtos, PayRecordRespDto.class);
            return payRecordRespDtos;
        }
        return null;
    }

    @Override
    public PayMethodBo packPayInfo(PayMethodBo payMethodBo, PayMethodReqDto payMethodReqDto) {
        OrderEo orderEo = payMethodBo.getOrderEo();
        String orderNo = payMethodReqDto.getOrderNo();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            if (orderEo == null) {
                orderEo = this.orderService.queryByOrderNo(payMethodReqDto.getOrderNo());
            }
            payMethodReqDto.setInstanceId(orderEo.getInstanceId());
            payMethodReqDto.setTenantId(orderEo.getTenantId());
            if (payMethodReqDto.getIsAgent() == null) {
                payMethodReqDto.setIsAgent(Integer.valueOf(0));
            }
            if (StringUtils.isEmpty((CharSequence)payMethodReqDto.getUserId())) {
                if (payMethodReqDto.getIsAgent().equals(0)) {
                    payMethodReqDto.setUserId(orderEo.getUserId());
                } else {
                    payMethodReqDto.setUserId("");
                }
                if (StringUtils.isEmpty((CharSequence)payMethodReqDto.getUserSrc())) {
                    if (payMethodReqDto.getIsAgent().equals(0)) {
                        payMethodReqDto.setUserSrc(orderEo.getUserSrc());
                    } else {
                        payMethodReqDto.setUserSrc("");
                    }
                }
            }
        }
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setFlowDefId(orderEo.getFlowDefId());
        payRecordEo.setTenantId(payMethodReqDto.getTenantId());
        payRecordEo.setSellerId(orderEo.getSellerId());
        payRecordEo.setInstanceId(payMethodReqDto.getInstanceId());
        payRecordEo.setPayStartTime(new Date());
        payRecordEo.setPayStatus(payMethodReqDto.getPayStatus());
        payRecordEo.setTradeNo(payMethodReqDto.getTradeNo());
        payRecordEo.setOrderNo(payMethodReqDto.getOrderNo());
        payRecordEo.setPayNo(payMethodReqDto.getTradeNo());
        payRecordEo.setPayMethod(payMethodReqDto.getPayMethod());
        if (payMethodBo.getPayMethodReqDto().getPayAmount() == null) {
            payRecordEo.setPayAmount(orderEo.getPayAmount().setScale(2));
        } else {
            payRecordEo.setPayAmount(payMethodBo.getPayMethodReqDto().getPayAmount().setScale(2));
        }
        payRecordEo.setIntegral(orderEo.getIntegral());
        payRecordEo.setRefundAmount(BigDecimal.ZERO);
        payRecordEo.setUserSrc(payMethodReqDto.getUserSrc());
        payRecordEo.setUserId(payMethodReqDto.getUserId());
        payRecordEo.setIsAgent(payMethodReqDto.getIsAgent());
        payRecordEo.setMemberId(payMethodReqDto.getMemberId());
        payRecordEo.setExtlPayAccount(payMethodReqDto.getGiftCardCode());
        payRecordEo.setExtension(JSON.toJSONString((Object)payMethodReqDto));
        payRecordEo.setDeviceType(payMethodReqDto.getDeviceType());
        if (payMethodBo.ifUseFlow()) {
            payRecordEo.setPayNo(payMethodBo.getCurrentFlowNo());
            payRecordEo.setTradeNo(payMethodBo.getCurrentFlowNo());
            payRecordEo.setFlowDefId(payMethodBo.getCurrentFlowDefId());
            payMethodReqDto.setTradeNo(payMethodBo.getCurrentFlowNo());
        } else {
            payRecordEo.setPayNo(TradeUtil.generateTradeNo());
            payRecordEo.setTradeNo(payRecordEo.getPayNo());
            payRecordEo.setFlowDefId(null);
            payMethodReqDto.setTradeNo(payRecordEo.getPayNo());
        }
        payMethodBo.setPayRecordEo(payRecordEo);
        payMethodBo.getPayMethodReqDto().setIntegral(orderEo.getIntegral());
        if (payMethodBo.getPayMethodReqDto().getPayAmount() == null) {
            payMethodBo.getPayMethodReqDto().setPayAmount(payRecordEo.getPayAmount());
        }
        return payMethodBo;
    }

    @Override
    public List<PayRecordRespDto> getPayRecord(Set<String> tradeNos) {
        return this.queryList(tradeNos, null);
    }

    @Override
    public void modifyPayRecord(String tradeNo, PayRecordEo payRecordEo) {
        String extensionStr;
        PayRecordEo oldPayRecordEo = this.payRecordDas.selectByTradeNo(tradeNo);
        if (null != payRecordEo.getPayStatus()) {
            String newStatus = payRecordEo.getPayStatus();
            if (!oldPayRecordEo.getPayStatus().equals(newStatus)) {
                if (PayStatusEnum.getByName((String)newStatus).getCode() < PayStatusEnum.getByName((String)oldPayRecordEo.getPayStatus()).getCode()) {
                    throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getMsg());
                }
                if (newStatus.equals(PayStatusEnum.ACCEPTED.getName())) {
                    payRecordEo.setPayAcceptTime(new Date());
                } else if (newStatus.equals(PayStatusEnum.SUCCESS.getName()) || newStatus.equals(PayStatusEnum.FAIL.getName())) {
                    payRecordEo.setPayFinishTime(new Date());
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)payRecordEo.getExtension()) && StringUtils.isNotEmpty((CharSequence)(extensionStr = oldPayRecordEo.getExtension()))) {
            JSONObject json = JSON.parseObject((String)extensionStr);
            json.putAll(JSONObject.parseObject((String)payRecordEo.getExtension()).getInnerMap());
            extensionStr = JSON.toJSONString((Object)json);
            payRecordEo.setExtension(extensionStr);
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        payRecordEo.setSqlFilters(sqlFilters);
        this.payRecordDas.updateSelectiveSqlFilter((BaseEo)payRecordEo);
    }

    @Override
    public PayRecordEo modifyPayStatus(String tradeNo, String oldStatus, String newStatus) {
        return Optional.ofNullable(this.payRecordDas.selectByTradeNo(tradeNo)).map(payRecordEo -> {
            if (!payRecordEo.getPayStatus().equals(oldStatus)) {
                throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_DIFFER.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_DIFFER.getMsg());
            }
            if (!payRecordEo.getPayStatus().equals(newStatus)) {
                if (PayStatusEnum.getByName((String)newStatus).getCode() < PayStatusEnum.getByName((String)payRecordEo.getPayStatus()).getCode()) {
                    throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getMsg());
                }
                if (newStatus.equals(PayStatusEnum.ACCEPTED.getName())) {
                    payRecordEo.setPayAcceptTime(new Date());
                } else if (newStatus.equals(PayStatusEnum.SUCCESS.getName()) || newStatus.equals(PayStatusEnum.FAIL.getName())) {
                    payRecordEo.setPayFinishTime(new Date());
                }
                payRecordEo.setPayStatus(newStatus);
                this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            }
            return payRecordEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
    }

    @Override
    public PayRecordEo modifyPayStatusWithLog(String tradeNo, String oldStatus, String newStatus, String auditDesc) {
        return this.modifyPayStatus(tradeNo, oldStatus, newStatus);
    }

    @Override
    public PayRecordEo modifyPayMethod(String tradeNo, String payMethod) {
        return Optional.ofNullable(this.payRecordDas.selectByTradeNo(tradeNo)).map(payRecordEo -> {
            if (!payRecordEo.getPayStatus().equals(PayStatusEnum.INIT.getName()) || ObjectHelper.isNotEmpty((Object)payRecordEo.getPayMethod())) {
                throw new BizException(TradeExceptionCode.PAY_RECORD_METHOD_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_METHOD_ERROR.getMsg());
            }
            payRecordEo.setPayMethod(payMethod);
            payRecordEo.setPayStatus(PayStatusEnum.SETTED.getName());
            this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            return payRecordEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
    }

    @Override
    public PayRecordEo getByRootPayLog(String rootTradeNo) {
        TradeEo tradeEo = this.tradeService.getPayTrade(rootTradeNo);
        if (tradeEo == null) {
            return null;
        }
        return this.getPayRecordByTradeNo(tradeEo.getTradeNo());
    }

    @Override
    public List<PayRecordEo> getPayRecordsByOrderNo(String tradeNo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(tradeNo);
        return this.payRecordDas.select((BaseEo)payRecordEo);
    }

    @Override
    public PayRecordEo getPayRecordByTradeNo(String tradeNo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setTradeNo(tradeNo);
        return (PayRecordEo)this.payRecordDas.selectOne((BaseEo)payRecordEo);
    }

    @Override
    public List<PayRecordEo> getPayRecordSuccessByOrderNo(String orderNo) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(orderNo);
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        return this.payRecordDas.select((BaseEo)payRecordEo);
    }

    @Override
    public List<PayRecordRespDto> getPayRecordRespSuccessByOrderNo(String orderNo) {
        List<PayRecordEo> payRecords = this.getPayRecordSuccessByOrderNo(orderNo);
        ArrayList<PayRecordRespDto> payRecordRespDtos = new ArrayList<PayRecordRespDto>();
        if (!CollectionUtils.isEmpty(payRecords)) {
            DtoHelper.eoList2DtoList(payRecords, payRecordRespDtos, PayRecordRespDto.class);
        }
        return payRecordRespDtos;
    }

    @Override
    public PayRecordEo modifyPayAmount(String tradeNo, BigDecimal oldAmount, BigDecimal newAmount) {
        return Optional.ofNullable(this.payRecordDas.selectByTradeNo(tradeNo)).map(payRecordEo -> {
            if (payRecordEo.getPayAmount().compareTo(oldAmount) != 0) {
                throw new BizException(TradeExceptionCode.PAY_RECORD_AMOUNT_DIFFER.getCode(), TradeExceptionCode.PAY_RECORD_AMOUNT_DIFFER.getMsg());
            }
            if (payRecordEo.getPayAmount().compareTo(newAmount) != 0) {
                payRecordEo.setPayAmount(newAmount);
                this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            }
            return payRecordEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
    }

    @Override
    public PayRecordEo modifyPayAmountWithLog(String tradeNo, BigDecimal oldAmount, BigDecimal newAmount, String auditDesc) {
        return this.modifyPayAmount(tradeNo, oldAmount, newAmount);
    }

    @Override
    public Boolean checkPayStatus(PayReqDto payReqDto) {
        PayOrderQueryRequest request = new PayOrderQueryRequest();
        String apiSecret = this.payConfig.getApiSecret();
        if (payReqDto.getIsDefined() == null || payReqDto.getIsDefined().equals("1")) {
            request.setStoreId(this.payConfig.getStoreId());
            request.setAppId(this.payConfig.getAppId());
        } else {
            apiSecret = this.apiSecret;
            request.setStoreId(payReqDto.getStoreId());
            request.setAppId(payReqDto.getAppId());
        }
        request.setStoreOrderId(payReqDto.getTradeNo());
        try {
            request.doEncrypt(apiSecret);
            PayOrderQueryResponse response = this.queryTradeService.queryPayOrder(request);
            try {
                response.verifySign(apiSecret);
            }
            catch (Exception e) {
                response.verifyGlobalSign(apiSecret);
            }
            if (response.getOrderStatus() != null && response.getOrderStatus().equals(PayResultEnum.S.getName())) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            throw new BizException(e.getMessage());
        }
    }

    @Override
    @Deprecated
    public String doPay(PayReqDto payReqDto) {
        String tradeNo = payReqDto.getTradeNo();
        PayRequest request = new PayRequest();
        PayResponse response = this.sendPayRequest(payReqDto, request);
        PayRecordEo payRecordEo = PayRecordEo.newInstance();
        payRecordEo.setExtlPaySerial(response.getTradeId());
        JSONObject json = new JSONObject();
        json.put("storeId", (Object)request.getStoreId());
        json.put("appId", (Object)request.getAppId());
        json.put("appName", (Object)request.getAppName());
        payRecordEo.setExtension(json.toJSONString());
        switch (PayResultEnum.getByName((String)response.getResult())) {
            case ACCEPT: {
                payRecordEo.setPayStatus(PayStatusEnum.ACCEPTED.getName());
                break;
            }
            case SUCCESS: {
                break;
            }
            case FAIL: {
                payRecordEo.setPayStatus(PayStatusEnum.FAIL.getName());
                break;
            }
            case ERROR: {
                payRecordEo.setPayStatus(PayStatusEnum.FAIL.getName());
            }
        }
        this.modifyPayRecord(tradeNo, payRecordEo);
        return ObjectHelper.bean2Json((Object)response);
    }

    @Override
    @Deprecated
    public String doPay4flow(PayReqDto payReqDto, String payNo, String curActionNode) {
        PayRecordEo payRecordEo = (PayRecordEo)this.payRecordDas.selectByLogicKey((Object)payNo);
        PayRequest request = new PayRequest();
        request.setStoreOrderId(payRecordEo.getPayNo());
        PayResponse response = this.sendPayRequest(payReqDto, request);
        payRecordEo.setExtlPaySerial(response.getTradeId());
        JSONObject json = new JSONObject();
        json.put("storeId", (Object)request.getStoreId());
        json.put("appId", (Object)request.getAppId());
        json.put("appName", (Object)request.getAppName());
        payRecordEo.setExtension(json.toJSONString());
        PayResultEnum payResult = PayResultEnum.getByName((String)response.getResult());
        if (PayResultEnum.ACCEPT == payResult) {
            payRecordEo.setPayAcceptTime(new Date());
        } else if (PayResultEnum.SUCCESS == payResult) {
            Date now = new Date();
            payRecordEo.setPayAcceptTime(now);
            payRecordEo.setPayFinishTime(now);
        }
        TradeEngine.setFlowStatus(payRecordEo, payResult.getName(), curActionNode);
        payRecordEo.setUpdateTime(null);
        this.payRecordDas.updateSelective((BaseEo)payRecordEo);
        return ObjectHelper.bean2Json((Object)response);
    }

    @Override
    public PayResponse doPay4Integral(String payNo) {
        PayRecordEo payRecordEo = (PayRecordEo)this.payRecordDas.selectByLogicKey((Object)payNo);
        PayRequest request = new PayRequest();
        request.setStoreId(this.payConfig.getStoreId());
        request.setAppId(this.payConfig.getAppId());
        request.setAppName(this.payConfig.getAppName());
        if (PayTypeEnum.INTEGRAL.getCode().equals(payRecordEo.getPayMethod()) && payRecordEo.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            request.setStoreOrderId(payNo);
        } else {
            request.setStoreOrderId(payRecordEo.getOrderNo());
        }
        logger.info("\u79ef\u5206\u652f\u4ed8\u5546\u6237\u5355\u53f7: {}", (Object)request.getStoreOrderId());
        request.setOrderAmt(new BigDecimal(payRecordEo.getIntegral()));
        request.setPayTypeId(PayTypeEnum.INTEGRAL.getCode());
        request.setUserId(payRecordEo.getUserId());
        request.setNotifyUrl(this.payConfig.getNotifyUrl() + payRecordEo.getOrderNo());
        PayResponse payResponse = this.sendPayRequest(new PayReqDto(), request);
        logger.info("\u79ef\u5206\u8ba2\u5355\u7684\u79ef\u5206\u652f\u4ed8\u4e0b\u5355\u8fd4\u56de: payNo={}, response={}", (Object)payNo, (Object)JSON.toJSONString((Object)payResponse));
        return payResponse;
    }

    private PayResponse sendPayRequest(PayReqDto payReqDto, PayRequest request) {
        PayResponse response;
        String apiSecret = payReqDto.getIsDefined() == null || payReqDto.getIsDefined().equals("1") ? this.payConfig.getApiSecret() : this.apiSecret;
        try {
            request.doEncrypt(apiSecret);
            logger.info("\u652f\u4ed8\u4e2d\u5fc3\u6e20\u9053\u4e0b\u5355\u8bf7\u6c42: {}", (Object)JSON.toJSONString((Object)request));
            response = this.createTradeService.createPayOrder(request);
            logger.info("\u652f\u4ed8\u4e2d\u5fc3\u6e20\u9053\u4e0b\u5355\u54cd\u5e94: {}", (Object)JSON.toJSONString((Object)response));
            try {
                response.verifySign(apiSecret);
            }
            catch (Exception e) {
                response.verifyGlobalSign(apiSecret);
            }
        }
        catch (Exception ex) {
            logger.error("\u53d1\u8d77\u652f\u4ed8\u5f02\u5e38", (Throwable)ex);
            throw new BizException(ex.getMessage());
        }
        return response;
    }

    @Override
    public PayRequest packPayRequest(PayMethodReqDto payMethodReqDto) {
        PayRequest request = new PayRequest();
        if (payMethodReqDto.getIsDefined() == null || payMethodReqDto.getIsDefined().equals("1")) {
            request.setStoreId(this.payConfig.getStoreId());
            request.setAppId(this.payConfig.getAppId());
            request.setAppName(this.payConfig.getAppName());
        } else {
            if (StringUtils.isBlank((CharSequence)payMethodReqDto.getStoreId())) {
                throw new BizException("\u672a\u4f7f\u7528\u652f\u4ed8\u4e2d\u5fc3\u9ed8\u8ba4\u5546\u6237,\u4e5f\u672a\u6307\u5b9a!");
            }
            request.setStoreId(payMethodReqDto.getStoreId());
            request.setAppId(payMethodReqDto.getAppId());
            request.setAppName(payMethodReqDto.getAppName());
        }
        logger.info("\u652f\u4ed8\u4ea4\u6613\u53f7" + payMethodReqDto.getTradeNo());
        request.setStoreOrderId(payMethodReqDto.getTradeNo());
        if (!PayTypeEnum.INTEGRAL.getCode().equals(payMethodReqDto.getPayMethod())) {
            request.setOrderAmt(payMethodReqDto.getPayAmount());
        } else {
            request.setOrderAmt(new BigDecimal(payMethodReqDto.getIntegral()).setScale(2));
        }
        request.setPayTypeId(payMethodReqDto.getPayMethod());
        request.setUserId(payMethodReqDto.getUserId());
        request.setNotifyUrl(this.payConfig.getNotifyUrl() + payMethodReqDto.getTradeNo() + "/" + ContextUtil.getInstanceId());
        logger.info("\u652f\u4ed8{}\u8bbe\u7f6e\u901a\u77e5url={}", (Object)payMethodReqDto.getTradeNo(), (Object)request.getNotifyUrl());
        request.setBackUrl(payMethodReqDto.getBackUrl());
        if (payMethodReqDto.getSceneInfo() != null) {
            AttachInfo info = new AttachInfo();
            info.setSceneInfo(payMethodReqDto.getSceneInfo());
            info.setGoodsTag(payMethodReqDto.getGoodsTag());
            request.setAttachInfo(ObjectHelper.bean2Json((Object)info));
        }
        request.setIp(payMethodReqDto.getUserDeviceIp());
        request.setPtUserId(payMethodReqDto.getOpenId());
        if (ObjectHelper.isNotEmpty((Object)payMethodReqDto.getCloseTime())) {
            request.setExpireTime(Integer.valueOf((int)DateUtil.getMiniteDiff((Date)new Date(), (Date)payMethodReqDto.getCloseTime())));
        }
        if (StringUtils.isNotBlank((CharSequence)payMethodReqDto.getGiftCardCode())) {
            request.setPartnerAccount(payMethodReqDto.getGiftCardCode());
            request.setPtUserId(payMethodReqDto.getMemberId() == null ? null : payMethodReqDto.getMemberId().toString());
        }
        return request;
    }

    private void modifyPayRecordExtensionByTradeNo(String tradeNo, JSONObject extension) {
        Optional.ofNullable(this.payRecordDas.selectByTradeNo(tradeNo)).map(payRecordEo -> {
            String extensionStr = payRecordEo.getExtension();
            if (StringUtils.isNotEmpty((CharSequence)extensionStr)) {
                JSONObject json = JSON.parseObject((String)extensionStr);
                json.putAll(extension.getInnerMap());
                extensionStr = JSON.toJSONString((Object)json);
            } else {
                extensionStr = JSON.toJSONString((Object)extension);
            }
            payRecordEo.setExtension(extensionStr);
            this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            return payRecordEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
    }

    @Override
    public PayRecordEo queryPayRecordByTradeNo(String tradeNo) {
        return this.payRecordDas.selectByTradeNo(tradeNo);
    }

    @Override
    public RefundEo saveInitRefund(RefundEo refundEo) {
        Assert.notNull((Object)refundEo.getInstanceId(), "\u4fdd\u5b58\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)refundEo.getTenantId(), "\u4fdd\u5b58\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Optional.ofNullable(this.refundDas.selectByTradeNo(refundEo.getTradeNo())).ifPresent(p -> {
            throw new BizException(TradeExceptionCode.REFUND_EXIST.getCode(), TradeExceptionCode.REFUND_EXIST.getMsg());
        });
        if (refundEo.getRefundStatus() == null) {
            refundEo.setRefundStatus(RefundStatusEnum.INIT.getName());
        }
        this.refundDas.insert((BaseEo)refundEo);
        return refundEo;
    }

    @Override
    public void saveInitRefund(RefundEo refundEo, OrderEo orderEo) {
        this.saveInitRefund(refundEo);
        ArrayList refundItems = new ArrayList();
        List<TradeItemEo> tradeItems = this.tradeItemService.queryByTradeNo(orderEo.getOrderNo());
        tradeItems.forEach(tradeItemEo -> {
            RefundItemEo refundItemEo = RefundItemEo.newInstance();
            BeanUtils.copyProperties((Object)tradeItemEo, (Object)refundItemEo, (String[])new String[]{"id", "createTime", "updateTime", "createPerson", "updatePerson", "lineNum"});
            refundItemEo.setBrandId(tradeItemEo.getBrandSerial());
            refundItemEo.setItemId(tradeItemEo.getItemSerial());
            refundItemEo.setPayNo(refundEo.getPayNo());
            if (null != tradeItemEo.getLineNum()) {
                refundItemEo.setLineNum(Long.valueOf(tradeItemEo.getLineNum().intValue()));
            }
            refundItemEo.setReturnNum(tradeItemEo.getReturnedNum());
            refundItemEo.setItemAmount(tradeItemEo.getPayTotalAmount());
            refundItemEo.setRefundAmount(tradeItemEo.getPayTotalAmount());
            refundItemEo.setReturnFreightAmount(tradeItemEo.getFreightAmount());
            if (null != tradeItemEo.getFreightAmount() && tradeItemEo.getFreightAmount().compareTo(BigDecimal.ZERO) > 0) {
                refundItemEo.setIsRefund(YesNoEnum.YES.getValue());
            } else {
                refundItemEo.setIsRefund(YesNoEnum.NO.getValue());
            }
            refundItems.add(refundItemEo);
        });
        this.refundItemDas.insertBatch(refundItems);
    }

    @Override
    public RefundEo saveInitRefund4Flow(RefundEo refundEo, String curActionNode, String result, Long flowDefId) {
        Assert.notNull((Object)refundEo.getInstanceId(), "\u4fdd\u5b58\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)refundEo.getTenantId(), "\u4fdd\u5b58\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Optional.ofNullable(this.refundDas.selectByTradeNo(refundEo.getTradeNo())).ifPresent(p -> {
            throw new BizException(TradeExceptionCode.REFUND_EXIST.getCode(), TradeExceptionCode.REFUND_EXIST.getMsg());
        });
        refundEo.setRefundStatus(RefundStatusEnum.INIT.getName());
        refundEo.setFlowDefId(flowDefId);
        TradeEngine.setFlowStatus(refundEo, result, curActionNode);
        this.refundDas.insert((BaseEo)refundEo);
        return refundEo;
    }

    @Override
    public RefundEo modifyRefundStatus(String tradeNo, String oldStatus, String newStatus) {
        return Optional.ofNullable(this.refundDas.selectByTradeNo(tradeNo)).map(refundEo -> {
            if (!refundEo.getRefundStatus().equals(oldStatus)) {
                throw new BizException(TradeExceptionCode.REFUND_STATUS_DIFFER.getCode(), TradeExceptionCode.REFUND_STATUS_DIFFER.getMsg());
            }
            if (!refundEo.getRefundStatus().equals(newStatus)) {
                if (RefundStatusEnum.getByName((String)newStatus).getCode() < RefundStatusEnum.getByName((String)refundEo.getRefundStatus()).getCode()) {
                    throw new BizException(TradeExceptionCode.REFUND_STATUS_ERROR.getCode(), TradeExceptionCode.REFUND_STATUS_ERROR.getMsg());
                }
                refundEo.setRefundStatus(newStatus);
                this.refundDas.updateSelective((BaseEo)refundEo);
            }
            return refundEo;
        }).orElseThrow(() -> new BizException(TradeExceptionCode.REFUND_NOT_EXIST.getCode(), TradeExceptionCode.REFUND_NOT_EXIST.getMsg()));
    }

    @Override
    public String doRefund(PayRefundReqDto payRefundReqDto) {
        String tradeNo = payRefundReqDto.getTradeNo();
        try {
            RefundResponse response = this.createRefundOrder(payRefundReqDto);
            RefundEo refundEo = this.refundDas.selectByTradeNo(tradeNo);
            switch (PayResultEnum.getByName((String)response.getResult())) {
                case ACCEPT: {
                    this.modifyRefundStatus(tradeNo, refundEo.getRefundStatus(), RefundStatusEnum.REFUNING.getName());
                    break;
                }
                case SUCCESS: {
                    break;
                }
                case FAIL: {
                    this.modifyRefundStatus(tradeNo, refundEo.getRefundStatus(), RefundStatusEnum.FAIL.getName());
                    return RefundStatusEnum.FAIL.getName();
                }
                case ERROR: {
                    this.modifyRefundStatus(tradeNo, refundEo.getRefundStatus(), RefundStatusEnum.FAIL.getName());
                    return RefundStatusEnum.FAIL.getName();
                }
            }
            return ObjectHelper.bean2Json((Object)response);
        }
        catch (Exception ex) {
            logger.error("\u53d1\u8d77\u9000\u6b3e\u5f02\u5e38", (Throwable)ex);
            throw new BizException(ex.getMessage());
        }
    }

    @Override
    public RefundResponse doRefund4Flow(PayRefundReqDto payRefundReqDto, String curActionNode) {
        String tradeNo = payRefundReqDto.getTradeNo();
        try {
            RefundEo refundEo = this.refundDas.selectByTradeNo(tradeNo);
            RefundResponse response = this.createRefundOrder(payRefundReqDto);
            PayResultEnum payResult = PayResultEnum.getByName((String)response.getResult());
            if (payResult == null) {
                throw new BizException(response.getResultMsg());
            }
            TradeEngine.setFlowStatus(refundEo, payResult.getName().toLowerCase(), curActionNode);
            TradeEngineUtil.setFlowDefId(refundEo.getFlowDefId());
            this.refundDas.updateSelective((BaseEo)refundEo);
            return response;
        }
        catch (Exception ex) {
            logger.error("\u53d1\u8d77\u9000\u6b3e\u5f02\u5e38", (Throwable)ex);
            throw new BizException(ex.getMessage());
        }
    }

    @Override
    public RefundResponse createRefundOrder(PayRefundReqDto payRefundReqDto) throws Exception {
        RefundRequest request = this.buildRefundRequest(payRefundReqDto);
        RefundResponse response = this.createTradeService.createRefundOrder(request);
        return response;
    }

    @Override
    public RefundRequest buildRefundRequest(PayRefundReqDto payRefundReqDto) {
        String tradeNo = payRefundReqDto.getTradeNo();
        RefundRequest request = new RefundRequest();
        request.setStoreRefundId(tradeNo);
        request.setStoreOrderId(payRefundReqDto.getPayNo());
        request.setTradeId(payRefundReqDto.getExtlPaySerial());
        request.setRefundAmt(payRefundReqDto.getAmount().setScale((int)this.refundScale, 1));
        request.setUserId(payRefundReqDto.getUserId());
        request.setNotifyUrl(this.payConfig.getRefundNotifyUrl() + tradeNo + "/" + ContextUtil.getInstanceId());
        logger.info("\u9000\u6b3e{}\u901a\u77e5\u7684url{}", (Object)tradeNo, (Object)request.getNotifyUrl());
        String storeId = payRefundReqDto.getStoreId();
        String appId = payRefundReqDto.getAppId();
        String appName = payRefundReqDto.getAppName();
        if (StringUtils.isEmpty((CharSequence)storeId) || StringUtils.isEmpty((CharSequence)storeId) || StringUtils.isEmpty((CharSequence)storeId)) {
            storeId = this.payConfig.getStoreId();
            appId = this.payConfig.getAppId();
            appName = this.payConfig.getAppName();
        }
        request.setStoreId(storeId);
        request.setAppId(appId);
        request.setAppName(appName);
        request.setIp(NetUtil.getLocalHostLANAddress().getHostAddress());
        String apiSecret = this.apiSecret;
        if (StringUtils.isBlank((CharSequence)apiSecret)) {
            apiSecret = this.payConfig.getApiSecret();
        }
        try {
            request.doEncrypt(apiSecret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return request;
    }

    @Override
    public PageInfo<PayRecordEo> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PayRecordEo payRecordEo = (PayRecordEo)JSON.parseObject((String)filter, PayRecordEo.class);
        payRecordEo.setOrderByDesc("createTime");
        return this.payRecordDas.selectPage((BaseEo)payRecordEo, pageNum, pageSize);
    }

    @Override
    public PageInfo<String> querySuccessPayParentTradeNos(String sellerId, Date startTime, Date endTime, Integer pageNum, Integer pageSize) {
        PayRecordEo payRecordEo = PayRecordEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"seller_id", (Object)sellerId));
        sqlFilters.add(SqlFilter.eq((String)"pay_status", (Object)PayStatusEnum.SUCCESS.getName()));
        sqlFilters.add(SqlFilter.gt((String)"pay_finish_time", (Object)DateUtil.getDateFormat((Date)startTime, (String)"yyyy-MM-dd HH:mm:ss")));
        sqlFilters.add(SqlFilter.le((String)"pay_finish_time", (Object)DateUtil.getDateFormat((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss")));
        payRecordEo.setSqlFilters(sqlFilters);
        PageInfo payRecordEoPageInfo = this.payRecordDas.selectPage((BaseEo)payRecordEo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        if (payRecordEoPageInfo == null) {
            return pageInfo;
        }
        BeanUtils.copyProperties((Object)payRecordEoPageInfo, (Object)pageInfo);
        if (CollectionUtils.isEmpty((Collection)payRecordEoPageInfo.getList())) {
            return pageInfo;
        }
        Set<String> payTradeNos = payRecordEoPageInfo.getList().stream().map(payRecord -> payRecord.getTradeNo()).collect(Collectors.toSet());
        Set<String> parentNosByTradeNos = this.tradeService.getParentNosByTradeNos(payTradeNos);
        if (!CollectionUtils.isEmpty(parentNosByTradeNos)) {
            pageInfo.setList(new ArrayList<String>(parentNosByTradeNos));
        }
        return pageInfo;
    }

    @Override
    public PageInfo<PayRecordEo> queryPayByPage(String filter, Integer pageNum, Integer pageSize) {
        PayRecordEo payRecordEo = (PayRecordEo)JSON.parseObject((String)filter, PayRecordEo.class);
        List sqlFilters = payRecordEo.getSqlFilters();
        if (null == sqlFilters) {
            sqlFilters = Lists.newArrayList();
        }
        payRecordEo.setSqlFilters(sqlFilters);
        payRecordEo.setOrderByDesc("payFinishTime");
        return this.payRecordDas.selectPage((BaseEo)payRecordEo, pageNum, pageSize);
    }

    @Override
    public List<PayRecordRespDto> queryList(Set<String> tradeNos, String filter) {
        PayRecordEo payRecordEo = new PayRecordEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isEmpty(tradeNos)) {
            return new ArrayList<PayRecordRespDto>();
        }
        sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)StringUtils.join(tradeNos, (String)",")));
        payRecordEo.setSqlFilters(sqlFilters);
        List results = this.payRecordDas.select((BaseEo)payRecordEo);
        ArrayList<PayRecordRespDto> payRecordRespDtos = new ArrayList<PayRecordRespDto>();
        if (!CollectionUtils.isEmpty((Collection)results)) {
            DtoHelper.eoList2DtoList((Collection)results, payRecordRespDtos, PayRecordRespDto.class);
        }
        return payRecordRespDtos;
    }

    @Override
    public void modifyRefund(String tradeNo, RefundEo refundEo) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        refundEo.setSqlFilters(sqlFilters);
        this.refundDas.updateSelectiveSqlFilter((BaseEo)refundEo);
    }

    @Override
    public PayRecordEo savePayRecord(PayRecordEo payRecordEo) {
        Optional.ofNullable(this.payRecordDas.selectByTradeNo(payRecordEo.getTradeNo())).ifPresent(p -> {
            throw new BizException(TradeExceptionCode.PAY_RECORD_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_EXIST.getMsg());
        });
        this.payRecordDas.insert((BaseEo)payRecordEo);
        return payRecordEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowInstance payIntegralOrder(String tradeNo, PayIntegralOrderReqDto payIntegralOrderReqDto, FlowInstance context) {
        return context;
    }

    @Override
    public PayRecordEo lockByPayNo(String payNo) {
        PayRecordEo queryEo = this.payRecordDas.selectByPayNo(payNo);
        return this.payRecordDas.lockById(queryEo.getId());
    }

    @Override
    public PayRecordEo queryByPayNo(String payNo) {
        return this.payRecordDas.selectByPayNo(payNo);
    }

    @Override
    public List<PayOrderNotifyRequest> getCheckOrderPayResult(String orderNo) {
        ArrayList<PayOrderNotifyRequest> payOrderNotifyRequests = new ArrayList<PayOrderNotifyRequest>();
        String apiSecret = this.payConfig.getApiSecret();
        PayRecordEo queryEo = new PayRecordEo();
        queryEo.setOrderNo(orderNo);
        List payRecordEos = this.payRecordDas.selectList((BaseEo)queryEo);
        if (!CollectionUtils.isEmpty((Collection)payRecordEos)) {
            for (PayRecordEo payRecordEo : payRecordEos) {
                if (payRecordEo.getPayStatus().equals(PayStatusEnum.FAIL.getCode()) || payRecordEo.getPayStatus().equals(PayStatusEnum.SUCCESS.getCode())) continue;
                PayOrderQueryRequest payOrderQueryRequest = new PayOrderQueryRequest();
                payOrderQueryRequest.setStoreOrderId(payRecordEo.getPayNo());
                payOrderQueryRequest.setTradeId(payRecordEo.getExtlPaySerial());
                payOrderQueryRequest.setStoreId(this.payConfig.getStoreId());
                payOrderQueryRequest.setAppId(this.payConfig.getAppId());
                try {
                    payOrderQueryRequest.doEncrypt(apiSecret);
                    PayOrderQueryResponse response = this.queryTradeService.queryPayOrder(payOrderQueryRequest);
                    if (!OutPayOrderStatus.FAIL.getStatus().equals(response.getOrderStatus()) && !OutPayOrderStatus.SUCCESS.getStatus().equals(response.getOrderStatus())) continue;
                    PayOrderNotifyRequest payOrderNotifyRequest = new PayOrderNotifyRequest();
                    BeanUtils.copyProperties((Object)response, (Object)payOrderNotifyRequest);
                    payOrderNotifyRequests.add(payOrderNotifyRequest);
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return payOrderNotifyRequests;
    }
}

