/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.center.message.api.IMessageApi;
import com.dtyunxi.yundt.center.message.api.constants.MsgConstants;
import com.dtyunxi.yundt.center.message.api.dto.request.MessageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PickupEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupCodeModifyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupCodeReplyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupCodeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PickupCodeRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPickupCodeService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PickupCodeDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PickupRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PickupCodeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PickupRecordEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PickupCodeServiceImpl
implements IPickupCodeService {
    private static Logger logger = LoggerFactory.getLogger(PickupCodeServiceImpl.class);
    @Resource
    IMessageApi messageApi;
    @Autowired
    PickupCodeDas pickupCodeDas;
    @Autowired
    PickupRecordDas pickupRecordDas;
    @Resource
    private ICacheService cacheService;
    private static final Integer ADD_TIME = 2592000;
    @Value(value="${yundt.cube.center.trade.config.pickup.add.valid.time}")
    private Integer addValidTime;

    @Override
    public String createPickUpCode(PickupCodeReqDto pickupCodeReqDto) {
        Assert.notEmptyParam(pickupCodeReqDto.getPhone(), "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmptyParam(pickupCodeReqDto.getWarehouseSerial(), "\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmptyParam(pickupCodeReqDto.getPickupRecordNo(), "\u81ea\u63d0\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNullParam(pickupCodeReqDto.getValidTime(), "\u9a8c\u8bc1\u7801\u6709\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        String cacheKey = pickupCodeReqDto.getPickupRecordNo() + this.getClass();
        Boolean isSuccess = this.cacheService.add(cacheKey, (Object)"1", 3);
        if (isSuccess.booleanValue()) {
            this.checkPickupRecordStatus(pickupCodeReqDto.getPickupRecordNo());
            PickupCodeEo pickupCodeEo = PickupCodeEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            HashSet<String> status = new HashSet<String>();
            status.add(PickupEnum.EFFECTIVE.getName());
            sqlFilters.add(SqlFilter.eq((String)"pickup_record_no", (Object)pickupCodeReqDto.getPickupRecordNo()));
            sqlFilters.add(SqlFilter.in((String)"status", (Object)StringUtils.join(status, (String)",")));
            pickupCodeEo.setSqlFilters(sqlFilters);
            List pickupCodeEos = this.pickupCodeDas.select((BaseEo)pickupCodeEo);
            if (pickupCodeEos != null && !pickupCodeEos.isEmpty()) {
                throw new BizException("\u8be5\u6d41\u6c34\u53f7\u5df2\u7ecf\u521b\u5efa\u8fc7\u63d0\u53d6\u7801\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
            }
            DtoHelper.dto2Eo((BaseVo)pickupCodeReqDto, (BaseEo)pickupCodeEo);
            pickupCodeEo.setStatus(PickupEnum.EFFECTIVE.getName());
            this.generatePickupCode(pickupCodeEo);
            this.cacheService.delCache(cacheKey);
            return pickupCodeEo.getCode();
        }
        throw new BizException("\u4f60\u7684\u70b9\u51fb\u6b21\u6570\u592a\u5feb\u4e86");
    }

    @Override
    public String savePickUpCode(String phone, String pickupRecordNo, String warehouseSerial, Integer addValidTime) {
        PickupCodeReqDto pickupCodeReqDto = new PickupCodeReqDto();
        pickupCodeReqDto.setPhone(phone);
        pickupCodeReqDto.setWarehouseSerial(warehouseSerial);
        pickupCodeReqDto.setPickupRecordNo(pickupRecordNo);
        if (addValidTime != null && this.addValidTime != 0) {
            pickupCodeReqDto.setValidTime(DateUtil.addSeconds((Date)new Date(), (int)addValidTime));
        } else {
            if (this.addValidTime == null || this.addValidTime == 0) {
                this.addValidTime = ADD_TIME;
            }
            pickupCodeReqDto.setValidTime(DateUtil.addSeconds((Date)new Date(), (int)this.addValidTime));
        }
        String code = this.createPickUpCode(pickupCodeReqDto);
        return code;
    }

    @Override
    public String sendPickUpCode(String phone, String pickupRecordNo, String warehouseSerial, Integer addValidTime) throws InterruptedException {
        String code = this.savePickUpCode(phone, pickupRecordNo, warehouseSerial, addValidTime);
        this.sendPickUpCodeBySms(phone, code);
        return code;
    }

    @Override
    @Transactional
    public PickupCodeRespDto rewirePickUpCode(PickupCodeReplyReqDto pickupCodeReqDto) {
        String cacheKey = pickupCodeReqDto.getPickupRecordNo() + this.getClass();
        Boolean isSuccess = this.cacheService.add(cacheKey, (Object)"1", 3);
        if (isSuccess.booleanValue()) {
            this.checkPickupRecordStatus(pickupCodeReqDto.getPickupRecordNo());
            PickupCodeEo oldPickupCode = this.getPickupCode(pickupCodeReqDto.getPickupRecordNo(), PickupEnum.EFFECTIVE.getName());
            oldPickupCode.setStatus(PickupEnum.INVALID.getName());
            this.pickupCodeDas.update((BaseEo)oldPickupCode);
            PickupCodeEo pickupCodeEo = new PickupCodeEo();
            BeanUtils.copyProperties((Object)oldPickupCode, (Object)pickupCodeEo);
            if (!StringUtils.isEmpty((CharSequence)pickupCodeReqDto.getPhone())) {
                pickupCodeEo.setPhone(pickupCodeReqDto.getPhone());
            }
            if (pickupCodeReqDto.getAddValidTime() != null && pickupCodeReqDto.getAddValidTime() != 0) {
                pickupCodeEo.setPickupTime(DateUtil.addSeconds((Date)new Date(), (int)pickupCodeReqDto.getAddValidTime()));
            } else {
                if (this.addValidTime == null || this.addValidTime == 0) {
                    this.addValidTime = ADD_TIME;
                }
                pickupCodeEo.setValidTime(DateUtil.addSeconds((Date)new Date(), (int)this.addValidTime));
            }
            pickupCodeEo.setId(null);
            pickupCodeEo.setPickupTime(null);
            pickupCodeEo.setStatus(PickupEnum.EFFECTIVE.getName());
            this.generatePickupCode(pickupCodeEo);
            PickupCodeRespDto pickupCodeRespDto = new PickupCodeRespDto();
            DtoHelper.eo2Dto((BaseEo)pickupCodeEo, (BaseVo)pickupCodeRespDto);
            this.sendPickUpCodeBySms(pickupCodeEo.getPhone(), pickupCodeEo.getCode());
            this.cacheService.delCache(cacheKey);
            return pickupCodeRespDto;
        }
        throw new BizException("\u4f60\u7684\u70b9\u51fb\u6b21\u6570\u592a\u5feb\u4e86");
    }

    @Override
    public Long cancelAfterVerification(String pickupRecordNo, String pickupCode, String checkPerson) {
        if (StringUtils.isEmpty((CharSequence)pickupRecordNo) || StringUtils.isEmpty((CharSequence)pickupCode)) {
            throw new BizException("\u81ea\u63d0\u6d41\u6c34\u53f7\u548c\u81ea\u63d0\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        PickupCodeEo pickupCodeEo = this.getPickupCode(pickupRecordNo, pickupCode, PickupEnum.EFFECTIVE.getName());
        PickupCodeEo pic = (PickupCodeEo)this.pickupCodeDas.selectOne((BaseEo)pickupCodeEo);
        if (pic == null || pic.getValidTime() != null && pic.getValidTime().before(new Date())) {
            throw new BizException("\u8be5\u81ea\u63d0\u7801\u65e0\u6548");
        }
        PickupCodeEo updatEo = PickupCodeEo.newInstance();
        updatEo.setId(pic.getId());
        updatEo.setStatus(PickupEnum.HAVE_PICKED_UP.getName());
        updatEo.setCheckPerson(checkPerson);
        this.pickupCodeDas.updateSelective((BaseEo)updatEo);
        return pic.getId();
    }

    private PickupCodeEo getPickupCode(String pickupRecordNo, String pickupCode, String status) {
        PickupCodeEo pickupCodeEo = PickupCodeEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"pickup_record_no", (Object)pickupRecordNo));
        sqlFilters.add(SqlFilter.eq((String)"virtual", (Object)pickupCode));
        sqlFilters.add(SqlFilter.eq((String)"status", (Object)status));
        pickupCodeEo.setSqlFilters(sqlFilters);
        return pickupCodeEo;
    }

    private PickupCodeEo getPickupCode(String pickupRecordNo, String status) {
        PickupCodeEo pickupCodeEo = PickupCodeEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"pickup_record_no", (Object)pickupRecordNo));
        sqlFilters.add(SqlFilter.eq((String)"status", (Object)status));
        pickupCodeEo.setSqlFilters(sqlFilters);
        return (PickupCodeEo)this.pickupCodeDas.selectOne((BaseEo)pickupCodeEo);
    }

    @Override
    public void pickcodeBecomeInvalid(String pickupRecordNo, String pickupCode, String checkPerson) {
        if (StringUtils.isEmpty((CharSequence)pickupRecordNo) || StringUtils.isEmpty((CharSequence)pickupCode)) {
            throw new BizException("\u81ea\u63d0\u6d41\u6c34\u53f7\u548c\u81ea\u63d0\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        PickupCodeEo pickupCodeEo = PickupCodeEo.newInstance();
        pickupCodeEo.setCode(pickupCode);
        pickupCodeEo.setPickupRecordNo(pickupRecordNo);
        PickupCodeEo pic = (PickupCodeEo)this.pickupCodeDas.selectOne((BaseEo)pickupCodeEo);
        if (pic == null || !PickupEnum.EFFECTIVE.getName().equals(pic.getStatus())) {
            throw new BizException("\u81ea\u63d0\u7801\u8bb0\u5f55\u4e3a\u7a7a\u6216\u8005\u8be5\u81ea\u63d0\u7801\u4e0d\u662f\u751f\u6548\u72b6\u6001");
        }
        PickupRecordEo pickupRecordEo = PickupRecordEo.newInstance();
        pickupRecordEo.setPickupRecordNo(pickupRecordNo);
        PickupRecordEo result = (PickupRecordEo)this.pickupRecordDas.selectOne((BaseEo)pickupRecordEo);
        if (result == null) {
            throw new BizException("\u6ca1\u6709\u8be5\u81ea\u63d0\u5355\u8bb0\u5f55");
        }
        PickupCodeEo eo = PickupCodeEo.newInstance();
        eo.setId(pic.getId());
        eo.setCheckPerson(checkPerson);
        this.pickupCodeDas.updateSelective((BaseEo)eo);
    }

    @Override
    public PickupCodeRespDto queryPickupCodeDetail(String pickupCode, String warehouseSerial) {
        if (StringUtils.isEmpty((CharSequence)pickupCode) || StringUtils.isEmpty((CharSequence)warehouseSerial)) {
            throw new BizException("\u4ed3\u5e93id\u548c\u81ea\u63d0\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        PickupCodeEo pickupCodeEo = PickupCodeEo.newInstance();
        pickupCodeEo.setCode(pickupCode);
        pickupCodeEo.setWarehouseSerial(warehouseSerial);
        pickupCodeEo.setStatus(PickupEnum.EFFECTIVE.getName());
        PickupCodeEo eo = (PickupCodeEo)this.pickupCodeDas.selectOne((BaseEo)pickupCodeEo);
        if (eo == null) {
            throw new BizException("\u901a\u8fc7\u4ed3\u5e93id\u548c\u81ea\u63d0\u7801\u67e5\u8be2\u4e0d\u5230\u8bb0\u5f55");
        }
        PickupCodeRespDto pickupCodeRespDto = new PickupCodeRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)pickupCodeRespDto);
        return pickupCodeRespDto;
    }

    private void checkPickupRecordStatus(String pickupRecordNo) {
        PickupRecordEo pickupRecordEo = PickupRecordEo.newInstance();
        pickupRecordEo.setPickupRecordNo(pickupRecordNo);
        PickupRecordEo recordEo = (PickupRecordEo)this.pickupRecordDas.selectOne((BaseEo)pickupRecordEo);
        if (recordEo == null || PickupEnum.PICK_RECORD_SUCCESS.equals((Object)recordEo.getStatus())) {
            throw new BizException("\u81ea\u63d0\u8868\u6ca1\u6709\u8be5\u81ea\u63d0\u8bb0\u5f55\u6216\u8005\u8be5\u81ea\u63d0\u6d41\u6c34\u53f7\u5df2\u7ecf\u662f\u6210\u529f\u72b6\u6001");
        }
    }

    @Override
    public void sendPickUpCodeBySms(String phone, String pickUpCode) {
        MessageReqDto messageReqDto = new MessageReqDto();
        messageReqDto.setContent("");
        messageReqDto.setMsgType(MsgConstants.MsgType.SMS.getCode());
        messageReqDto.setTargets(phone);
        messageReqDto.setTemplateCode("PickupCode");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("code", pickUpCode);
        messageReqDto.setTemplateParam(paramMap);
        try {
            RestResponse restResponse = this.messageApi.sendSms(messageReqDto);
            if (restResponse == null || !RestResponse.SUCCESS.getResultMsg().equals(restResponse.getResultMsg())) {
                logger.info("\u901a\u8fc7\u6d88\u606f\u4e2d\u5fc3\u53d1\u9001\u77ed\u4fe1\u51fa\u9519" + JSON.toJSONString((Object)restResponse));
                throw new BizException("\u901a\u8fc7\u6d88\u606f\u4e2d\u5fc3\u53d1\u9001\u77ed\u4fe1\u51fa\u9519" + JSON.toJSONString((Object)restResponse));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BizException("\u901a\u8fc7\u6d88\u606f\u4e2d\u5fc3\u53d1\u9001\u77ed\u4fe1\u51fa\u9519" + e.getMessage());
        }
    }

    private void generatePickupCode(PickupCodeEo pickupCodeEo) {
        int i;
        String pickupRecordNo = pickupCodeEo.getPickupRecordNo();
        for (i = 20; i > 0; --i) {
            String code = RandomCodeUtil.generateTextCode((int)0, (int)4) + pickupRecordNo.substring(pickupRecordNo.length() - 4);
            String cacheKey = pickupCodeEo.getWarehouseSerial() + code + this.getClass();
            Boolean isSuccess = this.cacheService.add(cacheKey, (Object)"1", 3);
            if (!isSuccess.booleanValue()) continue;
            PickupCodeEo select = PickupCodeEo.newInstance();
            select.setCode(code);
            select.setWarehouseSerial(pickupCodeEo.getWarehouseSerial());
            select.setStatus(PickupEnum.EFFECTIVE.getName());
            List eo = this.pickupCodeDas.select((BaseEo)select);
            if (eo == null || eo.isEmpty()) {
                pickupCodeEo.setCode(code);
                this.pickupCodeDas.insert((BaseEo)pickupCodeEo);
                this.cacheService.delCache(cacheKey);
                break;
            }
            this.cacheService.delCache(cacheKey);
        }
        if (i == 0) {
            throw new BizException("\u751f\u6210\u81ea\u63d0\u7801\u5931\u8d25");
        }
    }

    @Override
    public void modify(PickupCodeModifyReqDto pickupCodeReqDto) {
        PickupCodeEo pickupCodeEo = PickupCodeEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)pickupCodeReqDto, (BaseEo)pickupCodeEo);
        this.pickupCodeDas.updateSelective((BaseEo)pickupCodeEo);
    }

    @Override
    public List<PickupCodeRespDto> queryList(PickupCodeReqDto pickupCodeReqDto) {
        PickupCodeEo pickupCodeEo = new PickupCodeEo();
        DtoHelper.dto2Eo((BaseVo)pickupCodeReqDto, (BaseEo)pickupCodeEo);
        List resultList = this.pickupCodeDas.select((BaseEo)pickupCodeEo);
        ArrayList<PickupCodeRespDto> pickupCodeRespDtos = new ArrayList<PickupCodeRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, pickupCodeRespDtos, PickupCodeRespDto.class);
        }
        return pickupCodeRespDtos;
    }

    @Override
    public PageInfo<PickupCodeRespDto> queryList(PickupCodeReqDto pickupCodeReqDto, Integer pageNum, Integer pageSize) {
        PickupCodeEo pickupCodeEo = new PickupCodeEo();
        DtoHelper.dto2Eo((BaseVo)pickupCodeReqDto, (BaseEo)pickupCodeEo);
        PageInfo pageInfo = this.pickupCodeDas.selectPage((BaseEo)pickupCodeEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList pickupCodeRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, pickupCodeRespDtos, PickupCodeRespDto.class);
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(pickupCodeRespDtos);
        return pageInfoDto;
    }

    @Override
    public PickupCodeRespDto queryById(String filter, Long id) {
        PickupCodeEo pickupCodeEo = (PickupCodeEo)JSON.parseObject((String)filter, PickupCodeEo.class);
        pickupCodeEo.setId(id);
        PickupCodeEo result = (PickupCodeEo)this.pickupCodeDas.selectOne((BaseEo)pickupCodeEo);
        PickupCodeRespDto pickupCodeRespDto = new PickupCodeRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)pickupCodeRespDto);
        return pickupCodeRespDto;
    }
}

