/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.rebate.SubTypeRelApportionContentEnums;
import com.dtyunxi.yundt.cube.center.trade.api.dto.rebate.RebateApportionContenDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.rebate.api.dto.response.DiscountApportionConfigRespDto;
import com.yx.tcbj.center.rebate.api.enums.ApportionPriorityEnum;
import com.yx.tcbj.center.rebate.api.enums.ApportionTypeEnum;
import com.yx.tcbj.center.rebate.api.query.IDiscountApportionConfigQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RebateHelper {
    private static Logger logger = LoggerFactory.getLogger(RebateHelper.class);
    @Autowired
    private IDiscountApportionConfigQueryApi discountApportionConfigQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;

    public void apportionmentAmount(OrderPreviewReqDto order, BigDecimal totalRebateAmount, List<TradeItemReqDto> joinApportionmentItems) {
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(order.getShopId())));
        if (shopBaseDto == null) {
            throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a\uff1a" + order.getShopId());
        }
        DiscountApportionConfigRespDto discountApportionConfigRespDto = (DiscountApportionConfigRespDto)RestResponseHelper.extractData((RestResponse)this.discountApportionConfigQueryApi.queryByOrgId(shopBaseDto.getOrganizationId()));
        logger.info("\u6298\u6263\u5206\u644a\u91d1\u989d\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)discountApportionConfigRespDto));
        if (discountApportionConfigRespDto == null) {
            throw new BizException("\u6298\u6263\u5206\u644a\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (ApportionTypeEnum.SCALE.getType().equals(discountApportionConfigRespDto.getApportionType())) {
            this.calculateApportionmentByScale(totalRebateAmount, joinApportionmentItems, discountApportionConfigRespDto);
        } else {
            this.calculateApportionmentByPriority(totalRebateAmount, joinApportionmentItems, discountApportionConfigRespDto);
        }
    }

    private void calculateApportionmentByScale(BigDecimal totalRebateAmount, List<TradeItemReqDto> joinApportionmentItems, DiscountApportionConfigRespDto discountApportionConfigRespDto) {
        if (ApportionPriorityEnum.PRIORITY_PROPORTION.getType().equals(discountApportionConfigRespDto.getApportionPriority())) {
            List<Integer> subTypes = this.parseApportionContents(discountApportionConfigRespDto.getApportionContents());
            Map<Integer, List<TradeItemReqDto>> orderItemGroup = joinApportionmentItems.stream().collect(Collectors.groupingBy(TradeItemReqDto::getSubType));
            for (Integer subType : subTypes) {
                List<TradeItemReqDto> tradeItemReqDtos = orderItemGroup.get(subType);
                if (CollectionUtils.isNotEmpty(tradeItemReqDtos)) {
                    BigDecimal totalAmount = tradeItemReqDtos.stream().map(this::getTotalPrice).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                    BigDecimal canUseMaxRebateAmount = totalRebateAmount.min(totalAmount);
                    this.calculateBySacle(canUseMaxRebateAmount, totalAmount, tradeItemReqDtos);
                    totalRebateAmount = totalRebateAmount.subtract(canUseMaxRebateAmount);
                }
                if (BigDecimal.ZERO.compareTo(totalRebateAmount) < 0) continue;
                return;
            }
        } else {
            BigDecimal totalAmount = joinApportionmentItems.stream().map(this::getTotalPrice).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            this.calculateBySacle(totalRebateAmount, totalAmount, joinApportionmentItems);
        }
    }

    private void calculateBySacle(BigDecimal totalRebateAmount, BigDecimal totalAmount, List<TradeItemReqDto> joinApportionmentItems) {
        BigDecimal sumRebateAmount = BigDecimal.ZERO;
        for (int i = 0; i < joinApportionmentItems.size(); ++i) {
            TradeItemReqDto tradeItemReqDto = joinApportionmentItems.get(i);
            BigDecimal rebateAmount = BigDecimal.ZERO;
            if (i == joinApportionmentItems.size() - 1) {
                rebateAmount = totalRebateAmount.subtract(sumRebateAmount);
            } else {
                BigDecimal itemTotalPrice = this.getTotalPrice(tradeItemReqDto);
                rebateAmount = totalRebateAmount.multiply(itemTotalPrice).divide(totalAmount, 2, 5);
            }
            tradeItemReqDto.setRebateAmount(rebateAmount);
            sumRebateAmount = sumRebateAmount.add(tradeItemReqDto.getRebateAmount());
            tradeItemReqDto.setPayTotalAmount(BigDecimal.ZERO.max(tradeItemReqDto.getPayTotalAmount().subtract(tradeItemReqDto.getRebateAmount())));
            BigDecimal unitPrice = tradeItemReqDto.getPayTotalAmount().divide(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()), 2, 1);
            tradeItemReqDto.setItemPrice(unitPrice);
            logger.info("new_unitPrice_after: {}", (Object)JSON.toJSONString((Object)tradeItemReqDto));
        }
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 3});
        for (int i = 0; i < list.size(); ++i) {
            if (i != list.size() - 1) continue;
            System.out.println(list.get(i));
        }
    }

    private void calculateApportionmentByPriority(BigDecimal totalRebateAmount, List<TradeItemReqDto> joinApportionmentItems, DiscountApportionConfigRespDto discountApportionConfigRespDto) {
        List<Integer> subTypes = this.parseApportionContents(discountApportionConfigRespDto.getApportionContents());
        Map<Integer, List<TradeItemReqDto>> orderItemGroup = joinApportionmentItems.stream().collect(Collectors.groupingBy(TradeItemReqDto::getSubType));
        block0: for (Integer subType : subTypes) {
            List<TradeItemReqDto> tradeItemReqDtos = orderItemGroup.get(subType);
            if (!CollectionUtils.isNotEmpty(tradeItemReqDtos)) continue;
            for (TradeItemReqDto tradeItemReqDto : tradeItemReqDtos) {
                if (BigDecimal.ZERO.compareTo(totalRebateAmount) >= 0) break block0;
                BigDecimal rebateAmount = totalRebateAmount.min(this.getTotalPrice(tradeItemReqDto));
                tradeItemReqDto.setRebateAmount(rebateAmount);
                totalRebateAmount = totalRebateAmount.subtract(rebateAmount);
                tradeItemReqDto.setPayTotalAmount(BigDecimal.ZERO.max(tradeItemReqDto.getPayTotalAmount().subtract(rebateAmount)));
                BigDecimal unitPrice = tradeItemReqDto.getPayTotalAmount().divide(BigDecimal.valueOf(tradeItemReqDto.getItemNum().intValue()), 2, 1);
                tradeItemReqDto.setItemPrice(unitPrice);
                logger.info("new_unitPrice_after: {}", (Object)JSON.toJSONString((Object)tradeItemReqDto));
            }
        }
    }

    private List<Integer> parseApportionContents(String apportionContents) {
        if (StringUtils.isBlank((CharSequence)apportionContents)) {
            throw new BizException("\u6298\u6263\u5206\u644a\u914d\u7f6e\u4e3a\u7a7a");
        }
        Map apportionContentMap = (Map)JSON.parseObject((String)apportionContents, TreeMap.class);
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : apportionContentMap.entrySet()) {
            RebateApportionContenDto rebateApportionContenDto = new RebateApportionContenDto();
            rebateApportionContenDto.setRebateContenType((String)entry.getKey());
            rebateApportionContenDto.setLevel((Integer)entry.getValue());
            rebateApportionContenDto.setSubType(SubTypeRelApportionContentEnums.toSubType((String)((String)entry.getKey())));
            list.add(rebateApportionContenDto);
        }
        List<Integer> subTypeSortedList = list.stream().sorted(new Comparator<RebateApportionContenDto>(){

            @Override
            public int compare(RebateApportionContenDto o1, RebateApportionContenDto o2) {
                return o1.getLevel().compareTo(o2.getLevel());
            }
        }).map(RebateApportionContenDto::getSubType).collect(Collectors.toList());
        logger.info("\u6298\u6263\u5206\u644a\u914d\u7f6e\u6392\u5e8f\u540e\u4f18\u5148\u7ea7\uff1a{}", subTypeSortedList);
        return subTypeSortedList;
    }

    private void recalculateItemPrice(OrderPreviewReqDto order, List<TradeItemReqDto> succApportionmentItems) {
        Map<String, TradeItemReqDto> skuItemMap = succApportionmentItems.stream().filter(e -> e.getIfExchange() == 0 && e.getIsCombinedPackage() == 0).collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuSerial() + "#" + e.getGift(), item -> item, (v1, v2) -> v2));
        Map<String, TradeItemReqDto> exchangeSkuItemMap = succApportionmentItems.stream().filter(e -> e.getIfExchange() == 1).collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuSerial() + "#" + e.getGift() + "#" + e.getIfExchange() + "#" + e.getExchangeActivityId(), item -> item, (v1, v2) -> v2));
        Map<String, TradeItemReqDto> combinationSkuMap = succApportionmentItems.stream().filter(e -> e.getIsCombinedPackage() == 1).collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuSerial() + "#" + e.getGift() + "#" + e.getIsCombinedPackage() + "#" + e.getCombinedPackageActivityId(), item -> item, (v1, v2) -> v2));
        for (TradeItemReqDto orderItem : order.getOrderItems()) {
            TradeItemReqDto itemReqDto = null;
            itemReqDto = orderItem.getIfExchange() == 1 ? exchangeSkuItemMap.get(orderItem.getShopId() + "#" + orderItem.getSkuSerial() + "#" + orderItem.getGift() + "#" + orderItem.getIfExchange() + "#" + orderItem.getExchangeActivityId()) : (orderItem.getIsCombinedPackage() == 1 ? combinationSkuMap.get(orderItem.getShopId() + "#" + orderItem.getSkuSerial() + "#" + orderItem.getGift() + "#" + orderItem.getIsCombinedPackage() + "#" + orderItem.getCombinedPackageActivityId()) : skuItemMap.get(orderItem.getShopId() + "#" + orderItem.getSkuSerial() + "#" + orderItem.getGift()));
            if (!Objects.nonNull(itemReqDto) || itemReqDto.getRebateAmount() == null || BigDecimal.ZERO.compareTo(itemReqDto.getRebateAmount()) > 0) continue;
            orderItem.setRebateAmount(itemReqDto.getRebateAmount());
            orderItem.setPayTotalAmount(BigDecimal.ZERO.max(orderItem.getPayTotalAmount().subtract(orderItem.getRebateAmount())));
            BigDecimal unitPrice = orderItem.getPayTotalAmount().divide(BigDecimal.valueOf(orderItem.getItemNum().intValue()), 2, 1);
            orderItem.setItemPrice(unitPrice);
            logger.info("new_unitPrice_after: {}", (Object)JSON.toJSONString((Object)orderItem));
        }
    }

    private BigDecimal getTotalPrice(TradeItemReqDto f) {
        return f.getItemMarketPrice().multiply(BigDecimal.valueOf(f.getItemNum().intValue())).subtract(Optional.ofNullable(f.getDiscountTotalAmount()).orElse(BigDecimal.ZERO));
    }

    public static String subTypeInteger2String(Integer type) {
        if (type == 1) {
            return "PRODUCT";
        }
        if (type == 2) {
            return "GIFT";
        }
        if (type == 3) {
            return "MATERIAL";
        }
        return "ALL";
    }
}

