/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CompareDiffStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReconciliationOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TaskTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderCompareQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReconciliationExcelDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReconciliationTaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReconciliationTaskReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReconciliationTaskRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.scheduler.task.OrderCompareDiffTask;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IReconciliationTaskService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.impl.RefundServiceImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.biz.util.BeanUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ExcelParseObjectUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ChannelDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderCompareDiffDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReconciliationOrderRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReconciliationTaskDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderCompareDiffEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReconciliationOrderRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReconciliationTaskEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderCompareDiffEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdReconciliationOrderRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.vo.OrderCompareVo;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TwoTuple;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReconciliationTaskServiceImpl
implements IReconciliationTaskService {
    private static Logger logger = LoggerFactory.getLogger(RefundServiceImpl.class);
    @Resource
    private ReconciliationTaskDas reconciliationTaskDas;
    @Resource
    private ReconciliationOrderRecordDas reconciliationOrderRecordDas;
    @Resource
    private OrderCompareDiffDas orderCompareDiffDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private ChannelDas channelDas;
    @Resource
    private OrderCompareDiffTask orderCompareDiffTask;
    @Resource
    private IOrderService orderService;
    @Value(value="#{${order.compare.diff.enableChannel: 'TB,TM,JD'}.split(',')}")
    private List<String> enableChannels;

    @Override
    public Long addReconciliationTask(ReconciliationTaskReqDto addReqDto) {
        ReconciliationTaskEo reconciliationTaskEo = new ReconciliationTaskEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reconciliationTaskEo);
        this.reconciliationTaskDas.insert((BaseEo)reconciliationTaskEo);
        return reconciliationTaskEo.getId();
    }

    @Override
    public void modifyReconciliationTask(ReconciliationTaskReqDto modifyReqDto) {
        ReconciliationTaskEo reconciliationTaskEo = new ReconciliationTaskEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reconciliationTaskEo);
        this.reconciliationTaskDas.updateSelective((BaseEo)reconciliationTaskEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReconciliationTask(Long id) {
        String num;
        Assert.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a");
        ReconciliationTaskEo reconciliationTaskEo = (ReconciliationTaskEo)this.reconciliationTaskDas.selectByPrimaryKey(id);
        Assert.isTrue(reconciliationTaskEo != null, "\u65e0\u6548id");
        if (!TaskTypeEnum.MANUAL_IMPORT.getCode().equals(reconciliationTaskEo.getTaskType())) {
            throw new BizException("\u975e\u624b\u52a8\u5bfc\u5165\u7c7b\u578b\u4e0d\u80fd\u5220\u9664");
        }
        String reconciliationResult = reconciliationTaskEo.getReconciliationResult();
        String string = StringUtils.isNotEmpty((CharSequence)reconciliationResult) ? (reconciliationResult.contains("\u5bf9\u5e73") ? reconciliationResult.substring(reconciliationResult.indexOf("\u5bf9\u5e73") + 7, reconciliationResult.indexOf("\u5dee") - 1).trim() : "0") : (num = "0");
        if (!YesNoEnum.NO.getValue().toString().equals(num)) {
            throw new BizException("\u5b58\u5728\u5bf9\u5e73\u6570\u636e,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.reconciliationTaskDas.logicDeleteById(id);
        OrderCompareDiffEo diffEo = new OrderCompareDiffEo();
        diffEo.setReconciliationTaskId(reconciliationTaskEo.getId());
        this.orderCompareDiffDas.delete((BaseEo)diffEo);
    }

    @Override
    public ReconciliationTaskRespDto queryById(Long id) {
        ReconciliationTaskEo reconciliationTaskEo = (ReconciliationTaskEo)this.reconciliationTaskDas.selectByPrimaryKey(id);
        ReconciliationTaskRespDto reconciliationTaskRespDto = new ReconciliationTaskRespDto();
        DtoHelper.eo2Dto((BaseEo)reconciliationTaskEo, (BaseVo)reconciliationTaskRespDto);
        return reconciliationTaskRespDto;
    }

    @Override
    public PageInfo<ReconciliationTaskRespDto> queryByPage(ReconciliationTaskQueryReqDto dto, Integer pageNum, Integer pageSize) {
        ReconciliationTaskEo reconciliationTaskEo = new ReconciliationTaskEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)reconciliationTaskEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(dto.getChannelCode()))) {
            sqlFilters.add(SqlFilter.eq((String)"channel_code", (Object)dto.getChannelCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(dto.getTaskType()))) {
            sqlFilters.add(SqlFilter.eq((String)"task_type", (Object)dto.getTaskType()));
        }
        if (dto.getStartTime() != null) {
            sqlFilters.add(SqlFilter.ge((String)"update_time", (Object)dto.getStartTime()));
        }
        if (dto.getEndTime() != null) {
            sqlFilters.add(SqlFilter.le((String)"update_time", (Object)dto.getEndTime()));
        }
        reconciliationTaskEo.setSqlFilters(sqlFilters);
        reconciliationTaskEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.reconciliationTaskDas.selectPage((BaseEo)reconciliationTaskEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ReconciliationTaskRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addReconciliationByExcelImportExcel(String filePath) {
        logger.info("\u5bfc\u5165excel\u6570\u636e\u6587\u4ef6\u8def\u5f84\u4e3a:{}", (Object)filePath);
        try {
            List<ReconciliationExcelDto> list = ExcelParseObjectUtil.parseImportFile(filePath, ReconciliationExcelDto.class);
            if (CollectionUtils.isEmpty(list)) {
                throw new BizException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            logger.info("\u5bfc\u5165excel\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString(list));
            List<ReconciliationOrderRecordEo> eoList = BeanUtil.copyList(list, ReconciliationOrderRecordEo.class);
            if (CollectionUtils.isNotEmpty(eoList)) {
                List channelNames = eoList.stream().map(StdReconciliationOrderRecordEo::getChannelName).distinct().collect(Collectors.toList());
                List channelEos = this.channelDas.select(SqlFilterBuilder.create(ChannelEo.class).eq("status", (Object)YesNoEnum.YES.getValue()).in("name", channelNames).eo());
                if (CollectionUtils.isEmpty((Collection)channelEos) || CollectionUtils.isEmpty(channelEos = channelEos.stream().filter(o -> this.enableChannels.contains(o.getCode())).collect(Collectors.toList()))) {
                    throw new BizException("\u65e0\u53ef\u7528\u6e20\u9053");
                }
                Map<String, String> channelMap = channelEos.stream().collect(Collectors.groupingBy(StdChannelEo::getCode, Collectors.mapping(StdChannelEo::getName, Collectors.joining(","))));
                eoList.forEach(o -> {
                    channelMap.forEach((k, v) -> {
                        String name = (String)channelMap.get(k);
                        if (name.equals(o.getChannelName())) {
                            o.setChannelCode(k);
                        }
                    });
                    if (o.getChannelActualPrice() != null) {
                        o.setOrderType(ReconciliationOrderTypeEnum.PAY.getCode());
                    } else if (o.getChannelPaidPrice() != null) {
                        o.setOrderType(ReconciliationOrderTypeEnum.PAID.getCode());
                    }
                });
                this.reconciliationOrderRecordDas.insertBatch(eoList);
                List<String> repetitions = null;
                List compareDiffEos = this.orderCompareDiffDas.select(SqlFilterBuilder.create(OrderCompareDiffEo.class).eq("status", (Object)CompareDiffStatusEnum.MORE.getCode()).eo());
                if (!CollectionUtils.isEmpty((Collection)compareDiffEos)) {
                    repetitions = compareDiffEos.stream().map(StdOrderCompareDiffEo::getSourceOrderNo).collect(Collectors.toList());
                }
                OrderCompareQueryReqDto dto = new OrderCompareQueryReqDto();
                dto.setChannelCodes(channelEos.stream().map(StdChannelEo::getCode).distinct().collect(Collectors.toList()));
                List<OrderCompareVo> orderCompares = this.orderService.selectCompareVos(dto);
                this.orderCompareDiffTask.compareDiffProcess(channelMap, orderCompares, eoList, repetitions, (TwoTuple<Integer, Map<String, ReconciliationTaskEo>>)new TwoTuple((Object)TaskTypeEnum.MANUAL_IMPORT.getCode(), null));
            }
        }
        catch (Exception e) {
            throw new BizException(e.getMessage() + "\u5bfc\u5165excel\u65b0\u589e\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public void recaptureReconciliationById(Long id) {
        String date;
        Assert.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a");
        ReconciliationTaskEo reconciliationTaskEo = (ReconciliationTaskEo)this.reconciliationTaskDas.selectByPrimaryKey(id);
        Assert.isTrue(reconciliationTaskEo != null, "\u65e0\u6548id");
        if (!TaskTypeEnum.PLAN_IMPORT.getCode().equals(reconciliationTaskEo.getTaskType())) {
            throw new BizException("\u975e\u8ba1\u5212\u4efb\u52a1\u5bfc\u5165\u7c7b\u578b\u4e0d\u80fd\u91cd\u65b0\u83b7\u53d6\u8d26\u5355");
        }
        String name = reconciliationTaskEo.getName();
        int length = name.length();
        String string = StringUtils.isNotEmpty((CharSequence)name) ? (name.contains("\u5bf9\u8d26") ? name.substring(name.indexOf("\u5bf9\u8d26") + 2, length).trim() : null) : (date = null);
        if (date == null) {
            throw new BizException("\u5bf9\u8d26\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = Convert.toDate(date);
        Date endDate = DateUtil.getDayEnd((Date)startDate);
        Map<String, String> channelMap = this.getChannelMap(reconciliationTaskEo.getChannelCode());
        List<String> repetitions = null;
        List compareDiffEos = this.orderCompareDiffDas.select(SqlFilterBuilder.create(OrderCompareDiffEo.class).le("pay_time", (Object)startDate).ge("pay_time", (Object)endDate).eq("status", (Object)CompareDiffStatusEnum.MORE.getCode()).eo());
        if (!CollectionUtils.isEmpty((Collection)compareDiffEos)) {
            repetitions = compareDiffEos.stream().map(StdOrderCompareDiffEo::getSourceOrderNo).collect(Collectors.toList());
        }
        OrderCompareQueryReqDto dto = new OrderCompareQueryReqDto();
        dto.setStartTime(startDate);
        dto.setEndTime(endDate);
        List<OrderCompareVo> orderCompares = this.orderService.selectCompareVos(dto);
        ArrayList<ReconciliationOrderRecordEo> reconciliationOrderRecordEos = new ArrayList<ReconciliationOrderRecordEo>(10);
        this.orderCompareDiffTask.compareDiffProcess(channelMap, orderCompares, reconciliationOrderRecordEos, repetitions, (TwoTuple<Integer, Map<String, ReconciliationTaskEo>>)new TwoTuple((Object)TaskTypeEnum.PLAN_IMPORT.getCode(), null));
    }

    private Map<String, String> getChannelMap(String channelCode) {
        if (StringUtils.isBlank((CharSequence)channelCode)) {
            return null;
        }
        List channelEos = this.channelDas.select(SqlFilterBuilder.create(ChannelEo.class).eq("status", (Object)YesNoEnum.YES.getValue()).eq("code", (Object)channelCode).eo());
        if (CollectionUtils.isEmpty((Collection)channelEos) || CollectionUtils.isEmpty(channelEos = channelEos.stream().filter(o -> this.enableChannels.contains(o.getCode())).collect(Collectors.toList()))) {
            throw new BizException("\u65e0\u53ef\u7528\u6e20\u9053");
        }
        return channelEos.stream().collect(Collectors.groupingBy(StdChannelEo::getCode, Collectors.mapping(StdChannelEo::getName, Collectors.joining(","))));
    }
}

