/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundModifyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IRefundService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RefundServiceImpl
implements IRefundService {
    private static Logger logger = LoggerFactory.getLogger(RefundServiceImpl.class);
    @Resource
    private RefundDas refundDas;
    @Resource
    private RefundDetailDas refundDetailDas;

    @Override
    public Long add(RefundReqDto refundReqDto) {
        RefundEo refundEo = RefundEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)refundReqDto, (BaseEo)refundEo);
        this.refundDas.insert((BaseEo)refundEo);
        return refundEo.getId();
    }

    @Override
    public void modify(RefundModifyReqDto refundReqDto) {
        RefundEo refundEo = RefundEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)refundReqDto, (BaseEo)refundEo);
        this.refundDas.update((BaseEo)refundEo);
    }

    @Override
    public List<RefundRespDto> queryList(RefundReqDto refundReqDto) {
        RefundEo refundEo = RefundEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)refundReqDto, (BaseEo)refundEo);
        List resultList = this.refundDas.select((BaseEo)refundEo);
        ArrayList<RefundRespDto> refundRespDtos = new ArrayList<RefundRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, refundRespDtos, RefundRespDto.class);
        }
        return refundRespDtos;
    }

    @Override
    public PageInfo<RefundRespDto> queryList(RefundReqDto refundReqDto, Integer pageNum, Integer pageSize) {
        RefundEo refundEo = RefundEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)refundReqDto, (BaseEo)refundEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (null != refundReqDto.getRefundTimeStart()) {
            sqlFilters.add(SqlFilter.ge((String)"refundTime", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)refundReqDto.getRefundTimeStart())));
        }
        if (null != refundReqDto.getRefundTimeEnd()) {
            sqlFilters.add(SqlFilter.le((String)"refundTime", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)refundReqDto.getRefundTimeEnd())));
        }
        refundEo.setSqlFilters((List)sqlFilters);
        refundEo.setOrderByDesc("createTime");
        PageInfo pageInfo = this.refundDas.selectPage((BaseEo)refundEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList refundRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            Map<String, List<RefundDetailEo>> refundDetailMap;
            DtoHelper.eoList2DtoList((Collection)resultList, refundRespDtos, RefundRespDto.class);
            List refundNos = resultList.stream().map(StdRefundEo::getRefundNo).distinct().collect(Collectors.toList());
            RefundDetailEo queryDetailEo = RefundDetailEo.newInstance();
            ArrayList<SqlFilter> detailSqlFilters = new ArrayList<SqlFilter>();
            detailSqlFilters.add(SqlFilter.in((String)"refund_no", refundNos));
            queryDetailEo.setSqlFilters(detailSqlFilters);
            List refundDetailEos = this.refundDetailDas.select((BaseEo)queryDetailEo);
            if (CollectionUtils.isNotEmpty((Collection)refundDetailEos) && null != (refundDetailMap = refundDetailEos.stream().collect(Collectors.groupingBy(StdRefundDetailEo::getRefundNo))) && refundDetailMap.size() > 0) {
                refundRespDtos.stream().forEach(bean -> {
                    List detailEos = (List)refundDetailMap.get(bean.getRefundNo());
                    if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                        ArrayList refundDetailRespDtos = new ArrayList();
                        DtoHelper.eoList2DtoList((Collection)detailEos, refundDetailRespDtos, RefundDetailRespDto.class);
                        bean.setRefundDetailRespDtos(refundDetailRespDtos);
                    }
                });
            }
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(refundRespDtos);
        return pageInfoDto;
    }

    @Override
    public List<RefundRespDto> queryRevertByPayNo(Set<String> payNos) {
        RefundEo refundEo = RefundEo.newInstance();
        refundEo.setRefundType(RefundTypeEnum.REFUND_REVERT.getName());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"pay_no", (Object)StringUtils.join(payNos, (String)",")));
        refundEo.setSqlFilters(sqlFilters);
        List resultList = this.refundDas.select((BaseEo)refundEo);
        ArrayList<RefundRespDto> refundRespDtos = new ArrayList<RefundRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, refundRespDtos, RefundRespDto.class);
        }
        return refundRespDtos;
    }

    @Override
    public RefundRespDto queryById(Long id, Long instanceId, Long tenantId) {
        RefundEo refundEo = RefundEo.newInstance();
        refundEo.setId(id);
        RefundEo result = (RefundEo)this.refundDas.selectOne((BaseEo)refundEo);
        RefundRespDto refundRespDto = new RefundRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)refundRespDto);
        return refundRespDto;
    }
}

