/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShareTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributionItemAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShareItemRecordDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShareItemRecordModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShareItemRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DistributionItemAddRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ShareItemRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareItemRecordService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareItemRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareItemRecordDetailDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ShareItemRecordDetailEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ShareItemRecordEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShareItemRecordServiceImpl
implements IShareItemRecordService {
    private static final Logger logger = LoggerFactory.getLogger(ShareItemRecordServiceImpl.class);
    @Resource
    private ShareItemRecordDas shareItemRecordDas;
    @Resource
    private ShareItemRecordDetailDas shareItemRecordDetailDas;

    @Override
    public Long addShareItemRecord(ShareItemRecordReqDto shareItemRecordReqDto) {
        logger.info("===>\u5206\u4eab\u5546\u54c1\u4fdd\u5b58\u8bb0\u5f55\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)shareItemRecordReqDto));
        ShareItemRecordEo shareItemRecordEo = new ShareItemRecordEo();
        shareItemRecordEo.setShareItemQuantity(shareItemRecordReqDto.getShareItemQuantity());
        shareItemRecordEo.setShareType(shareItemRecordReqDto.getShareType());
        shareItemRecordEo.setUserId(shareItemRecordReqDto.getUserId());
        this.shareItemRecordDas.insert((BaseEo)shareItemRecordEo);
        List shareItemRecordDetailReqDtos = shareItemRecordReqDto.getShareItemRecordDetailReqDtos();
        ArrayList shareItemRecordDetailEos = new ArrayList();
        DtoHelper.dtoList2EoList((Collection)shareItemRecordDetailReqDtos, shareItemRecordDetailEos, ShareItemRecordDetailEo.class);
        shareItemRecordDetailEos.forEach(shareItemRecordDetailEo -> {
            shareItemRecordDetailEo.setShareItemRecordId(shareItemRecordEo.getId());
            shareItemRecordDetailEo.setShareUserId(shareItemRecordEo.getUserId());
            if (shareItemRecordDetailEo.getShareType() == null) {
                shareItemRecordDetailEo.setShareType(shareItemRecordEo.getShareType());
            }
        });
        this.shareItemRecordDetailDas.insertBatch(shareItemRecordDetailEos);
        return shareItemRecordEo.getId();
    }

    @Override
    public void addShareItemRecordTradeCount(@Valid ShareItemRecordModReqDto shareItemRecordReqDto) {
        ShareItemRecordEo shareItemRecordEo = (ShareItemRecordEo)this.shareItemRecordDas.selectByPrimaryKey(shareItemRecordReqDto.getId());
        if (shareItemRecordEo == null) {
            return;
        }
        if (shareItemRecordEo.getShareItemOrderQuantity() == null) {
            shareItemRecordEo.setShareItemOrderQuantity(Integer.valueOf(0));
        }
        ShareItemRecordEo shareItemRecordUpdateEo = new ShareItemRecordEo();
        shareItemRecordUpdateEo.setId(shareItemRecordReqDto.getId());
        shareItemRecordUpdateEo.setShareItemOrderQuantity(Integer.valueOf(shareItemRecordEo.getShareItemOrderQuantity() + shareItemRecordReqDto.getNum()));
        this.shareItemRecordDas.updateSelective((BaseEo)shareItemRecordUpdateEo);
    }

    @Override
    public ShareItemRecordRespDto getShareItemRecordDetail(String id) {
        ShareItemRecordEo shareItemRecordEo = (ShareItemRecordEo)this.shareItemRecordDas.selectByPrimaryKey(Long.valueOf(id));
        if (Objects.isNull(shareItemRecordEo)) {
            throw new BizException(TradeExceptionCode.SHARE_ITEM_RECORD_NO_EXIT.getCode(), TradeExceptionCode.SHARE_ITEM_RECORD_NO_EXIT.getMsg());
        }
        ShareItemRecordRespDto dto = new ShareItemRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)shareItemRecordEo, (BaseVo)dto);
        ShareItemRecordDetailEo shareItemRecordDetailEo = new ShareItemRecordDetailEo();
        shareItemRecordDetailEo.setShareItemRecordId(Long.valueOf(id));
        List shareItemRecordDetailEos = this.shareItemRecordDetailDas.select((BaseEo)shareItemRecordDetailEo);
        ArrayList shareItemRecordDetailReqDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)shareItemRecordDetailEos, shareItemRecordDetailReqDtos, ShareItemRecordDetailReqDto.class);
        dto.setShareItemRecordDetailReqDtos(shareItemRecordDetailReqDtos);
        return dto;
    }

    @Override
    public PageInfo<ShareItemRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Long userId = JSON.parseObject((String)filter).getLong("userId");
        ShareItemRecordEo shareItemRecordEo = new ShareItemRecordEo();
        shareItemRecordEo.setUserId(userId);
        shareItemRecordEo.setOrderByDesc("id");
        PageInfo shareItemRecordEoPageInfo = this.shareItemRecordDas.selectPage((BaseEo)shareItemRecordEo, pageNum, pageSize);
        ArrayList shareItemRecordRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)shareItemRecordEoPageInfo.getList(), shareItemRecordRespDtoList, ShareItemRecordRespDto.class);
        shareItemRecordEoPageInfo.setList(shareItemRecordRespDtoList);
        return shareItemRecordEoPageInfo;
    }

    @Override
    public DistributionItemAddRespDto saveShareItemRecord(DistributionItemAddReqDto distributionItemAddReqDto) {
        Long shareItemRecordId;
        Long shareUserId = distributionItemAddReqDto.getShareUserId();
        Long shopId = distributionItemAddReqDto.getShopId();
        Long itemId = distributionItemAddReqDto.getItemId();
        DistributionItemAddRespDto distributionItemAddRespDto = new DistributionItemAddRespDto();
        ShareItemRecordEo shareItemRecordEoParam = ShareItemRecordEo.newInstance();
        shareItemRecordEoParam.setUserId(shareUserId);
        shareItemRecordEoParam.setShareType(Integer.valueOf(ShareTypeEnum.DISTRIBUTION.getCode()));
        ShareItemRecordEo shareItemRecordEo = (ShareItemRecordEo)this.shareItemRecordDas.selectOne((BaseEo)shareItemRecordEoParam);
        if (shareItemRecordEo == null) {
            shareItemRecordEo = new ShareItemRecordEo();
            shareItemRecordEo.setUserId(shareUserId);
            shareItemRecordEo.setShareType(Integer.valueOf(ShareTypeEnum.DISTRIBUTION.getCode()));
            this.shareItemRecordDas.insert((BaseEo)shareItemRecordEo);
        }
        if ((shareItemRecordId = shareItemRecordEo.getId()) != null) {
            ShareItemRecordDetailEo shareItemRecordDetailEoParam = ShareItemRecordDetailEo.newInstance();
            shareItemRecordDetailEoParam.setShareItemRecordId(shareItemRecordId);
            shareItemRecordDetailEoParam.setShareType(Integer.valueOf(ShareTypeEnum.DISTRIBUTION.getCode()));
            shareItemRecordDetailEoParam.setShopId(shopId);
            shareItemRecordDetailEoParam.setItemSerial(String.valueOf(itemId));
            ShareItemRecordDetailEo shareItemRecordDetailEo = (ShareItemRecordDetailEo)this.shareItemRecordDetailDas.selectOne((BaseEo)shareItemRecordDetailEoParam);
            if (shareItemRecordDetailEo == null) {
                shareItemRecordDetailEo = new ShareItemRecordDetailEo();
                shareItemRecordDetailEo.setShareItemRecordId(shareItemRecordId);
                shareItemRecordDetailEo.setItemSerial(String.valueOf(itemId));
                shareItemRecordDetailEo.setShopId(shopId);
                shareItemRecordDetailEo.setShareType(Integer.valueOf(ShareTypeEnum.DISTRIBUTION.getCode()));
                shareItemRecordDetailEo.setShareUserId(shareUserId);
                shareItemRecordDetailEo.setShareUserName(distributionItemAddReqDto.getShareUserName());
                shareItemRecordDetailEo.setShareUserMobile(distributionItemAddReqDto.getShareUserName());
                this.shareItemRecordDetailDas.insert((BaseEo)shareItemRecordDetailEo);
            }
            distributionItemAddRespDto.setShareItemDetailId(shareItemRecordDetailEo.getId());
        }
        return distributionItemAddRespDto;
    }
}

