/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShareTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributionShopAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShareShopRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DistributionShopAddRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ShareShopRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareShopRecordService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareShopRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ShareShopRecordEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareShopRecordServiceImpl
implements IShareShopRecordService {
    @Resource
    private ShareShopRecordDas shareShopRecordDas;

    @Override
    public Long addShareShopRecord(ShareShopRecordReqDto addReqDto) {
        ShareShopRecordEo shareShopRecordEo = new ShareShopRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shareShopRecordEo);
        this.shareShopRecordDas.insert((BaseEo)shareShopRecordEo);
        return shareShopRecordEo.getId();
    }

    @Override
    public void modifyShareShopRecord(ShareShopRecordReqDto modifyReqDto) {
        ShareShopRecordEo shareShopRecordEo = new ShareShopRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shareShopRecordEo);
        this.shareShopRecordDas.updateSelective((BaseEo)shareShopRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShareShopRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.shareShopRecordDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ShareShopRecordRespDto queryById(Long id) {
        ShareShopRecordEo shareShopRecordEo = (ShareShopRecordEo)this.shareShopRecordDas.selectByPrimaryKey(id);
        ShareShopRecordRespDto shareShopRecordRespDto = new ShareShopRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)shareShopRecordEo, (BaseVo)shareShopRecordRespDto);
        return shareShopRecordRespDto;
    }

    @Override
    public PageInfo<ShareShopRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ShareShopRecordReqDto shareShopRecordReqDto = (ShareShopRecordReqDto)JSON.parseObject((String)filter, ShareShopRecordReqDto.class);
        ShareShopRecordEo shareShopRecordEo = new ShareShopRecordEo();
        DtoHelper.dto2Eo((BaseVo)shareShopRecordReqDto, (BaseEo)shareShopRecordEo);
        PageInfo eoPageInfo = this.shareShopRecordDas.selectPage((BaseEo)shareShopRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ShareShopRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public DistributionShopAddRespDto saveShareShopRecord(DistributionShopAddReqDto distributionShopAddReqDto) {
        Long shareUserId = distributionShopAddReqDto.getShareUserId();
        Long shopId = distributionShopAddReqDto.getShopId();
        DistributionShopAddRespDto distributionShopAddRespDto = new DistributionShopAddRespDto();
        ShareShopRecordEo queryEo = new ShareShopRecordEo();
        queryEo.setShareUserId(shareUserId);
        queryEo.setShopId(shopId);
        queryEo.setShareType(Integer.valueOf(ShareTypeEnum.DISTRIBUTION.getCode()));
        ShareShopRecordEo shareShopRecordEo = (ShareShopRecordEo)this.shareShopRecordDas.selectOne((BaseEo)queryEo);
        if (shareShopRecordEo == null) {
            shareShopRecordEo = new ShareShopRecordEo();
            shareShopRecordEo.setShareUserId(shareUserId);
            shareShopRecordEo.setShopId(shopId);
            shareShopRecordEo.setShareType(Integer.valueOf(ShareTypeEnum.DISTRIBUTION.getCode()));
            shareShopRecordEo.setShareUserName(distributionShopAddReqDto.getShareUserName());
            shareShopRecordEo.setShareUserMobile(distributionShopAddReqDto.getShareUserName());
            this.shareShopRecordDas.insert((BaseEo)shareShopRecordEo);
        }
        distributionShopAddRespDto.setShareShopId(shareShopRecordEo.getId());
        return distributionShopAddRespDto;
    }

    @Override
    public ShareShopRecordRespDto queryByShareUserId(Long shareUserId) {
        ShareShopRecordEo queryEo = new ShareShopRecordEo();
        queryEo.setShareUserId(shareUserId);
        List select = this.shareShopRecordDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            ShareShopRecordRespDto dto = new ShareShopRecordRespDto();
            ShareShopRecordEo shareShopRecordEo = (ShareShopRecordEo)select.get(0);
            DtoHelper.eo2Dto((BaseEo)shareShopRecordEo, (BaseVo)dto);
            return dto;
        }
        return null;
    }
}

