/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.channel.shipping.beans.ShippingInfo;
import com.dtyunxi.cube.starter.shipping.kidiniao.bean.KuaiDiNiaoShippingInfo;
import com.dtyunxi.cube.utils.codec.Coder;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingCompanyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShippingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ShippingRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.config.KuaidiNiaoChannelConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShippingService;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShippingServiceImpl
implements IShippingService {
    private Logger logger = LoggerFactory.getLogger(ShippingServiceImpl.class);
    @Autowired
    private KuaidiNiaoChannelConfig kuaidiNiaoChannelConfig;

    @Override
    public List<ShippingRespDto> listLogistics(ShippingReqDto shippingReqDto) {
        this.logger.info("\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u5165\u53c2shippingReqDto\uff1a{}", (Object)JSON.toJSONString((Object)shippingReqDto));
        ArrayList<ShippingRespDto> shippingRespDtos = new ArrayList<ShippingRespDto>();
        StringBuilder requestData = new StringBuilder("{'OrderCode':'','ShipperCode':'" + shippingReqDto.getShippingNo() + "','LogisticCode':'" + shippingReqDto.getShippingCode() + "'");
        if (ShippingCompanyEnum.SF.getCode().equals(shippingReqDto.getShippingNo()) || ShippingCompanyEnum.JD.getCode().equals(shippingReqDto.getShippingNo())) {
            if (StringUtils.isEmpty((CharSequence)shippingReqDto.getCustomerName())) {
                // empty if block
            }
            requestData.append(",'CustomerName':'" + shippingReqDto.getCustomerName() + "'");
        }
        requestData.append("}");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("RequestData", URLEncoder.encode(requestData.toString(), "UTF-8"));
            params.put("EBusinessID", this.kuaidiNiaoChannelConfig.geteBusinessID());
            params.put("RequestType", this.kuaidiNiaoChannelConfig.getRequestType());
            String dataSign = Coder.base64Encode((String)Coder.md5Hex((String)(requestData + this.kuaidiNiaoChannelConfig.getAppKey())));
            params.put("DataSign", URLEncoder.encode(dataSign, "UTF-8"));
            params.put("DataType", "2");
            String result = HttpUtil.sendPostHttps((String)this.kuaidiNiaoChannelConfig.getReqURL(), params, (String)"UTF-8");
            this.logger.info("\u5feb\u9012\u9e1f\u67e5\u8be2\u5feb\u9012\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            JSONObject kuaiDiNiaoJson = JSON.parseObject((String)String.valueOf(result));
            KuaiDiNiaoShippingInfo kuaiDiNiaoShippingInfo = (KuaiDiNiaoShippingInfo)JSONObject.toJavaObject((JSON)kuaiDiNiaoJson, KuaiDiNiaoShippingInfo.class);
            ShippingInfo shippingInfo = new ShippingInfo();
            shippingInfo.setShippingCode(shippingReqDto.getShippingNo());
            shippingInfo.setShippingNo(shippingReqDto.getShippingCode());
            shippingInfo.setState(kuaiDiNiaoShippingInfo.getState());
            kuaiDiNiaoShippingInfo.getTraces().stream().forEach(trace -> {
                ShippingRespDto shippingRespDto = new ShippingRespDto();
                if (StringUtils.isNotBlank((CharSequence)trace.getAcceptStation())) {
                    shippingRespDto.setProgressDesc(trace.getAcceptStation());
                } else {
                    shippingRespDto.setProgressDesc("");
                }
                shippingRespDto.setProgressTime(trace.getAcceptTime());
                if (StringUtils.isNotBlank((CharSequence)trace.getRemark())) {
                    shippingRespDto.setRemark(trace.getRemark());
                } else {
                    shippingRespDto.setRemark("");
                }
                shippingRespDtos.add(shippingRespDto);
            });
            this.logger.info("\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u51fa\u53c2shippingRespDtos\uff1a{}", (Object)JSON.toJSONString(shippingRespDtos));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u51fa\u73b0\u5f02\u5e38e\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return shippingRespDtos;
    }
}

