/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CountQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeCountRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeCountService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeCountDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.CountQueryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayCountEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundCountEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnCountEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TradeCountServiceImpl
implements ITradeCountService {
    @Resource
    private TradeCountDas tradeCountDas;

    @Override
    public TradeCountRespDto queryByCount(CountQueryReqDto countQueryReqDto) {
        TradeCountRespDto tradeCountRespDto = new TradeCountRespDto();
        Assert.notNull((Object)countQueryReqDto.getDate(), "\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)countQueryReqDto.getTenantId(), "\u67e5\u8be2\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Date startTime = DateUtil.getDayBegin((Date)countQueryReqDto.getDate());
        Date endTime = DateUtil.addDays((Date)startTime, (int)1);
        CountQueryEo countQueryEo = new CountQueryEo();
        countQueryEo.setStartTime(startTime);
        countQueryEo.setEndTime(endTime);
        countQueryEo.setInstanceId(countQueryReqDto.getInstanceId());
        countQueryEo.setTenantId(countQueryReqDto.getTenantId());
        List payCountList = this.tradeCountDas.queryCountPayInfo(countQueryEo);
        Long completeOrderCount = this.tradeCountDas.queryCountCompleteOrderInfo(countQueryEo);
        Long createOrderCount = this.tradeCountDas.queryCountCreateOrderInfo(countQueryEo);
        List refundCountList = this.tradeCountDas.queryCountCompleteRefundInfo(countQueryEo);
        ReturnCountEo returnCount = this.tradeCountDas.queryCountCompleteReturnInfo(countQueryEo);
        tradeCountRespDto.setCompleteOrderTotalCount(completeOrderCount);
        tradeCountRespDto.setCreateOrderTotalCount(createOrderCount);
        tradeCountRespDto.setReturnTotalCount(returnCount.getTotalCount());
        tradeCountRespDto.setReturnOrderTotalCount(returnCount.getOrderCount());
        Long integralPayCount = 0L;
        Long integralBuyCount = 0L;
        BigDecimal integerPaySum = BigDecimal.ZERO;
        Long pointPayCount = 0L;
        Long pointBuyCount = 0L;
        BigDecimal pointPaySum = BigDecimal.ZERO;
        BigDecimal cashPayTotalAmount = BigDecimal.ZERO;
        Long cashPayCount = 0L;
        Long cashBuyCount = 0L;
        Long totalPayCount = 0L;
        for (PayCountEo payCountEo : payCountList) {
            if (PayTypeEnum.INTEGRAL.getCode().equals(payCountEo.getPayMethod())) {
                integerPaySum = integerPaySum.add(payCountEo.getPayTotalAmount());
                integralPayCount = integralPayCount + payCountEo.getPayCount();
                integralBuyCount = integralBuyCount + payCountEo.getBuyCount();
            } else if (PayTypeEnum.POINT_COUPON.getCode().equals(payCountEo.getPayMethod())) {
                pointPaySum = pointPaySum.add(payCountEo.getPayTotalAmount());
                pointPayCount = pointPayCount + payCountEo.getPayCount();
                pointBuyCount = pointBuyCount + payCountEo.getBuyCount();
            } else {
                cashPayTotalAmount = cashPayTotalAmount.add(payCountEo.getPayTotalAmount());
                cashPayCount = cashPayCount + payCountEo.getPayCount();
                cashBuyCount = cashBuyCount + payCountEo.getBuyCount();
            }
            totalPayCount = totalPayCount + payCountEo.getPayCount();
        }
        tradeCountRespDto.setCashBuyCount(cashBuyCount);
        tradeCountRespDto.setIntegralBuyCount(integralBuyCount);
        tradeCountRespDto.setPointBuyCount(pointBuyCount);
        tradeCountRespDto.setTotalPayCount(totalPayCount);
        tradeCountRespDto.setIntegerPaySum(Long.valueOf(integerPaySum.longValue()));
        tradeCountRespDto.setIntegralPayCount(integralPayCount);
        tradeCountRespDto.setPointPaySum(Long.valueOf(pointPaySum.longValue()));
        tradeCountRespDto.setPointPayCount(pointPayCount);
        tradeCountRespDto.setCashPayTotalAmount(cashPayTotalAmount);
        tradeCountRespDto.setCashPayCount(cashPayCount);
        Long refundIntegralPayCount = 0L;
        BigDecimal refundIntegerPaySum = BigDecimal.ZERO;
        Long refundPointPayCount = 0L;
        BigDecimal refundPointPaySum = BigDecimal.ZERO;
        Long refundCashPayCount = 0L;
        BigDecimal refundCashPayTotalAmount = BigDecimal.ZERO;
        Long totalRefundCount = 0L;
        for (RefundCountEo refundCount : refundCountList) {
            if (PayTypeEnum.INTEGRAL.getCode().equals(refundCount.getPayMethod())) {
                refundIntegerPaySum = refundIntegerPaySum.add(refundCount.getRefundTotalAmount());
                refundIntegralPayCount = refundIntegralPayCount + refundCount.getRefundCount();
            } else if (PayTypeEnum.POINT_COUPON.getCode().equals(refundCount.getPayMethod())) {
                refundPointPaySum = refundPointPaySum.add(refundCount.getRefundTotalAmount());
                refundPointPayCount = refundPointPayCount + refundCount.getRefundCount();
            } else {
                refundCashPayTotalAmount = refundCashPayTotalAmount.add(refundCount.getRefundTotalAmount());
                refundCashPayCount = refundCashPayCount + refundCount.getRefundCount();
            }
            totalRefundCount = totalRefundCount + refundCount.getRefundCount();
        }
        tradeCountRespDto.setRefundTotalCount(totalRefundCount);
        tradeCountRespDto.setRefundIntegerPaySum(Long.valueOf(refundIntegerPaySum.longValue()));
        tradeCountRespDto.setRefundIntegralPayCount(refundIntegralPayCount);
        tradeCountRespDto.setRefundPointPaySum(Long.valueOf(refundPointPaySum.longValue()));
        tradeCountRespDto.setRefundPointPayCount(refundPointPayCount);
        tradeCountRespDto.setRefundCashPayTotalAmount(refundCashPayTotalAmount);
        tradeCountRespDto.setRefundCashPayCount(refundCashPayCount);
        tradeCountRespDto.setTenantId(countQueryReqDto.getTenantId());
        tradeCountRespDto.setInstanceId(countQueryReqDto.getInstanceId());
        return tradeCountRespDto;
    }

    private String getTenantLockKey(Long tenantId) {
        return this.getClass() + "_query_" + tenantId;
    }
}

