/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemNumCountVo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.CountItemSalesReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.CountItemSalesRespDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TradeItemServiceImpl
implements ITradeItemService {
    private static Logger logger = LoggerFactory.getLogger(TradeItemServiceImpl.class);
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;

    @Override
    public void addItems(List<TradeItemEo> itemEos) {
        Assert.notEmpty(itemEos, (String)"\u63d2\u5165\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.setCatalogNames(itemEos);
        this.tradeItemDas.insertBatch(itemEos);
    }

    @Override
    public List<TradeItemEo> queryByTradeNo(String tradeNo) {
        TradeItemEo tradeItemEo = new TradeItemEo();
        tradeItemEo.setTradeNo(tradeNo);
        tradeItemEo.setOrderBy("gift");
        return this.tradeItemDas.select((BaseEo)tradeItemEo);
    }

    @Override
    public List<TradeItemEo> queryByNos(String tradeNo, Set<String> tradeItemNos) {
        TradeItemEo tradeItemEo = new TradeItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_item_no", (Object)String.join((CharSequence)",", tradeItemNos)));
        sqlFilters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        tradeItemEo.setSqlFilters(sqlFilters);
        return this.tradeItemDas.select((BaseEo)tradeItemEo);
    }

    @Override
    public List<TradeItemRespDto> queryByOrderNos(Set<String> orderNos) {
        TradeItemEo tradeItemEo = new TradeItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)StringUtils.join(orderNos, (String)",")));
        tradeItemEo.setSqlFilters(sqlFilters);
        List itemEos = this.tradeItemDas.select((BaseEo)tradeItemEo);
        if (!CollectionUtils.isEmpty((Collection)itemEos)) {
            return this.getEosToResp(itemEos);
        }
        return null;
    }

    @Override
    public List<TradeItemRespDto> queryDtoByTradeNo(String tradeNo) {
        ArrayList list = null;
        List<TradeItemEo> tradeItemEos = this.queryByTradeNo(tradeNo);
        if (!CollectionUtils.isEmpty(tradeItemEos)) {
            list = this.getEosToResp(tradeItemEos);
        }
        return !CollectionUtils.isEmpty(list) ? list : Lists.newArrayList();
    }

    @Override
    public List<TradeItemEo> queryByTradeItemEo(TradeItemEo tradeItemEo) {
        return this.tradeItemDas.select((BaseEo)tradeItemEo);
    }

    private List<TradeItemRespDto> getEosToResp(List<TradeItemEo> tradeItemEos) {
        return tradeItemEos.stream().map(eo -> {
            TradeItemRespDto dto = new TradeItemRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto, (String[])new String[]{"cycleValue"});
            if (StringUtils.isNotEmpty((CharSequence)eo.getRemark())) {
                dto.setRemark(eo.getRemark());
            }
            int completeDeliveryNum = dto.getCompleteDeliveryNum() != null ? dto.getCompleteDeliveryNum() : 0;
            dto.setCompleteDeliveryNum(Integer.valueOf(completeDeliveryNum));
            if (dto.getItemNum() != null) {
                dto.setIncompleteDeliveryNum(Integer.valueOf(dto.getItemNum() - completeDeliveryNum));
            }
            dto.setItemCostPrice(BigDecimal.ZERO);
            if (StringUtils.isNotBlank((CharSequence)dto.getExtension())) {
                try {
                    BigDecimal brandSuggestPrice = (BigDecimal)JSONObject.parseObject((String)dto.getExtension()).getObject("brandReatilPrice", BigDecimal.class);
                    if (brandSuggestPrice != null) {
                        dto.setBrandSuggestedRetailPrice(brandSuggestPrice);
                    }
                }
                catch (Exception e) {
                    logger.info("\u4e3b\u952eID\u4e3a:{},\u8ba2\u5355\u53f7\u4e3a:{},\u7684\u8ba2\u5355\u5efa\u8bae\u96f6\u552e\u4ef7\u8f6c\u6362\u5931\u8d25\uff0c\u6570\u636e\u5185\u5bb9extension\u4e3a:{}", new Object[]{dto.getId(), dto.getTradeNo(), dto.getExtension()});
                }
            }
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public TradeItemEo queryByTradeNoAndTradeItemNo(String tradeNo, String tradeItemNo) {
        TradeItemEo tradeItemEo = new TradeItemEo();
        tradeItemEo.setTradeNo(tradeNo);
        tradeItemEo.setTradeItemNo(tradeItemNo);
        return (TradeItemEo)this.tradeItemDas.selectOne((BaseEo)tradeItemEo);
    }

    @Override
    public TradeItemEo queryByTradeItemNo(String tradeItemNo) {
        TradeItemEo tradeItemEo = new TradeItemEo();
        tradeItemEo.setTradeItemNo(tradeItemNo);
        return (TradeItemEo)this.tradeItemDas.selectOne((BaseEo)tradeItemEo);
    }

    @Override
    public void modifyByTradeItemNo(List<TradeItemEo> tradeItemEos) {
        tradeItemEos.forEach(tradeItemEo -> {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.eq((String)"trade_item_no", (Object)tradeItemEo.getTradeItemNo()));
            tradeItemEo.setSqlFilters(sqlFilters);
            this.setCatalogName((TradeItemEo)tradeItemEo);
            this.tradeItemDas.updateSelectiveSqlFilter((BaseEo)tradeItemEo);
        });
    }

    @Override
    public List<TradeItemEo> queryByTradeNoList(List<String> tradeNoList) {
        if (CollectionUtils.isEmpty(tradeNoList)) {
            return null;
        }
        return this.tradeItemDas.queryByTradeNoList(tradeNoList);
    }

    @Override
    public List<CountItemSalesRespDto> countItemSales(CountItemSalesReqDto countItemSalesReqDto) {
        TradeItemNumCountVo itemNumCountVo = new TradeItemNumCountVo();
        CubeBeanUtils.copyProperties((Object)itemNumCountVo, (Object)countItemSalesReqDto, (String[])new String[]{"userId,userIdList"});
        List countVos = this.tradeItemDas.countItemNum(itemNumCountVo);
        ArrayList itemSalesRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSalesRespDtos, (Collection)countVos, CountItemSalesRespDto.class);
        return itemSalesRespDtos;
    }

    @Override
    public List<CountItemSalesRespDto> countItemSalesForUser(CountItemSalesReqDto countItemSalesReqDto) {
        TradeItemNumCountVo itemNumCountVo = new TradeItemNumCountVo();
        CubeBeanUtils.copyProperties((Object)itemNumCountVo, (Object)countItemSalesReqDto, (String[])new String[]{"userId,userIdList"});
        if (Objects.nonNull(countItemSalesReqDto.getUserId())) {
            itemNumCountVo.setUserId(String.valueOf(countItemSalesReqDto.getUserId()));
        }
        if (!CollectionUtils.isEmpty((Collection)countItemSalesReqDto.getUserIdList())) {
            ArrayList customerIdsStr = Lists.newArrayList();
            countItemSalesReqDto.getUserIdList().stream().forEach(userId -> customerIdsStr.add(String.valueOf(userId)));
            itemNumCountVo.setUserIdList((List)customerIdsStr);
        }
        List countVos = Lists.newArrayList();
        countVos = "1".equals(itemNumCountVo.getCountType()) ? this.tradeItemDas.countItemNumForUser(itemNumCountVo) : this.tradeItemDas.countSkuNumForUser(itemNumCountVo);
        ArrayList itemSalesRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSalesRespDtos, (Collection)countVos, CountItemSalesRespDto.class);
        return itemSalesRespDtos;
    }

    @Override
    public void modifyTradeItem(TradeItemEo tradeItemEo) {
        if (tradeItemEo.getId() != null) {
            this.setCatalogName(tradeItemEo);
            this.tradeItemDas.updateSelective((BaseEo)tradeItemEo);
        }
    }

    @Override
    public List<OrderItemRespDto> queryUserOrderItem(OrderItemReqDto orderItemReqDto) {
        List tradeItemEoList;
        List<Object> list = Lists.newArrayList();
        TradeItemEo tradeItemEoQuery = new TradeItemEo();
        tradeItemEoQuery.setUserId(orderItemReqDto.getUserId());
        if (orderItemReqDto.getShopId() != null) {
            tradeItemEoQuery.setShopId(String.valueOf(orderItemReqDto.getShopId()));
        }
        if (orderItemReqDto.getItemId() != null) {
            tradeItemEoQuery.setItemSerial(String.valueOf(orderItemReqDto.getItemId()));
        }
        if (orderItemReqDto.getSkuId() != null) {
            tradeItemEoQuery.setSkuSerial(String.valueOf(orderItemReqDto.getSkuId()));
        }
        if (!CollectionUtils.isEmpty((Collection)(tradeItemEoList = this.tradeItemDas.selectList((BaseEo)tradeItemEoQuery)))) {
            list = tradeItemEoList.stream().map(eo -> {
                OrderItemRespDto dto = new OrderItemRespDto();
                dto.setUserId(eo.getUserId());
                dto.setOrderNo(eo.getTradeNo());
                dto.setShopId(Long.valueOf(eo.getShopId()));
                dto.setSkuId(Long.valueOf(eo.getSkuSerial()));
                dto.setItemNum(eo.getItemNum());
                dto.setItemId(Long.valueOf(eo.getItemSerial()));
                return dto;
            }).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public TradeItemEo setCatalogName(TradeItemEo itemEo) {
        try {
            DirectoryItemRespDto directoryItem = (DirectoryItemRespDto)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryDirById(Long.valueOf(Long.parseLong(itemEo.getCatalogSerial()))));
            if (directoryItem != null) {
                itemEo.setCatalogName(directoryItem.getName());
            }
        }
        catch (Exception e) {
            logger.warn("\u540e\u7aef\u57cb\u70b9\uff0c\u6dfb\u52a0\u7c7b\u76ee\u540d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return itemEo;
    }

    @Override
    public List<TradeItemEo> setCatalogNames(List<TradeItemEo> itemEos) {
        try {
            for (TradeItemEo itemEo : itemEos) {
                DirectoryItemRespDto directoryItem = (DirectoryItemRespDto)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryDirById(Long.valueOf(Long.parseLong(itemEo.getCatalogSerial()))));
                if (directoryItem == null) continue;
                itemEo.setCatalogName(directoryItem.getName());
            }
        }
        catch (Exception e) {
            logger.warn("\u540e\u7aef\u57cb\u70b9\uff0c\u6dfb\u52a0\u7c7b\u76ee\u540d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return itemEos;
    }
}

